/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.reports;

import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.jaxb.detailedreport.XmlBasicBuildingBlocks;
import eu.europa.esig.dss.jaxb.detailedreport.XmlCertificate;
import eu.europa.esig.dss.jaxb.detailedreport.XmlChainItem;
import eu.europa.esig.dss.jaxb.detailedreport.XmlConstraint;
import eu.europa.esig.dss.jaxb.detailedreport.XmlConstraintsConclusion;
import eu.europa.esig.dss.jaxb.detailedreport.XmlName;
import eu.europa.esig.dss.jaxb.detailedreport.XmlSignature;
import eu.europa.esig.dss.jaxb.detailedreport.XmlSubXCV;
import eu.europa.esig.dss.jaxb.detailedreport.XmlValidationCertificateQualification;
import eu.europa.esig.dss.jaxb.detailedreport.XmlValidationProcessTimestamps;
import eu.europa.esig.dss.jaxb.detailedreport.XmlValidationSignatureQualification;
import eu.europa.esig.dss.jaxb.detailedreport.XmlXCV;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.CertificateQualification;
import eu.europa.esig.dss.validation.SignatureQualification;
import eu.europa.esig.dss.validation.ValidationTime;
import eu.europa.esig.dss.validation.policy.Context;
import eu.europa.esig.dss.validation.policy.rules.Indication;
import eu.europa.esig.dss.validation.policy.rules.SubIndication;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class DetailedReport {
    private final eu.europa.esig.dss.jaxb.detailedreport.DetailedReport jaxbDetailedReport;

    public DetailedReport(eu.europa.esig.dss.jaxb.detailedreport.DetailedReport jaxbDetailedReport) {
        this.jaxbDetailedReport = jaxbDetailedReport;
    }

    public Indication getBasicBuildingBlocksIndication(String tokenId) {
        XmlBasicBuildingBlocks bbb = this.getBasicBuildingBlockById(tokenId);
        if (bbb != null) {
            return bbb.getConclusion().getIndication();
        }
        return null;
    }

    public SubIndication getBasicBuildingBlocksSubIndication(String tokenId) {
        XmlBasicBuildingBlocks bbb = this.getBasicBuildingBlockById(tokenId);
        if (bbb != null) {
            return bbb.getConclusion().getSubIndication();
        }
        return null;
    }

    public List<String> getBasicBuildingBlocksCertChain(String tokenId) {
        List chainItems;
        LinkedList<String> certIds = new LinkedList<String>();
        XmlBasicBuildingBlocks bbb = this.getBasicBuildingBlockById(tokenId);
        if (bbb != null && Utils.isCollectionNotEmpty((Collection)(chainItems = bbb.getCertificateChain().getChainItem()))) {
            for (XmlChainItem chainItem : chainItems) {
                certIds.add(chainItem.getId());
            }
        }
        return certIds;
    }

    public XmlBasicBuildingBlocks getBasicBuildingBlockById(String tokenId) {
        List basicBuildingBlocks = this.jaxbDetailedReport.getBasicBuildingBlocks();
        if (Utils.isCollectionNotEmpty((Collection)basicBuildingBlocks)) {
            for (XmlBasicBuildingBlocks xmlBasicBuildingBlocks : basicBuildingBlocks) {
                if (!Utils.areStringsEqual((String)xmlBasicBuildingBlocks.getId(), (String)tokenId)) continue;
                return xmlBasicBuildingBlocks;
            }
        }
        return null;
    }

    public int getBasicBuildingBlocksNumber() {
        return this.jaxbDetailedReport.getBasicBuildingBlocks().size();
    }

    public String getBasicBuildingBlocksSignatureId(int index) {
        XmlBasicBuildingBlocks bbb;
        List bbbs = this.jaxbDetailedReport.getBasicBuildingBlocks();
        if (Utils.collectionSize((Collection)bbbs) >= index && (bbb = (XmlBasicBuildingBlocks)this.jaxbDetailedReport.getBasicBuildingBlocks().get(index)) != null) {
            return bbb.getId();
        }
        return null;
    }

    public List<String> getSignatureIds() {
        ArrayList<String> result = new ArrayList<String>();
        List bbbs = this.jaxbDetailedReport.getBasicBuildingBlocks();
        for (XmlBasicBuildingBlocks bbb : bbbs) {
            if (Context.SIGNATURE != bbb.getType() && Context.COUNTER_SIGNATURE != bbb.getType()) continue;
            result.add(bbb.getId());
        }
        return result;
    }

    public List<String> getTimestampIds() {
        ArrayList<String> result = new ArrayList<String>();
        List bbbs = this.jaxbDetailedReport.getBasicBuildingBlocks();
        for (XmlBasicBuildingBlocks bbb : bbbs) {
            if (Context.TIMESTAMP != bbb.getType()) continue;
            result.add(bbb.getId());
        }
        return result;
    }

    public List<String> getRevocationIds() {
        ArrayList<String> result = new ArrayList<String>();
        List bbbs = this.jaxbDetailedReport.getBasicBuildingBlocks();
        for (XmlBasicBuildingBlocks bbb : bbbs) {
            if (Context.REVOCATION != bbb.getType()) continue;
            result.add(bbb.getId());
        }
        return result;
    }

    public Date getBestSignatureTime(String signatureId) {
        XmlSignature xmlSignature = this.getXmlSignatureById(signatureId);
        if (xmlSignature != null) {
            if (xmlSignature.getValidationProcessArchivalData() != null && xmlSignature.getValidationProcessArchivalData().getBestSignatureTime() != null) {
                return xmlSignature.getValidationProcessArchivalData().getBestSignatureTime();
            }
            if (xmlSignature.getValidationProcessLongTermData() != null && xmlSignature.getValidationProcessLongTermData().getBestSignatureTime() != null) {
                return xmlSignature.getValidationProcessLongTermData().getBestSignatureTime();
            }
            if (xmlSignature.getValidationProcessBasicSignatures() != null && xmlSignature.getValidationProcessBasicSignatures().getBestSignatureTime() != null) {
                return xmlSignature.getValidationProcessBasicSignatures().getBestSignatureTime();
            }
        }
        return null;
    }

    public Indication getBasicValidationIndication(String signatureId) {
        XmlSignature signature = this.getXmlSignatureById(signatureId);
        if (signature != null && signature.getValidationProcessBasicSignatures() != null && signature.getValidationProcessBasicSignatures().getConclusion() != null) {
            return signature.getValidationProcessBasicSignatures().getConclusion().getIndication();
        }
        return null;
    }

    public SubIndication getBasicValidationSubIndication(String signatureId) {
        XmlSignature signature = this.getXmlSignatureById(signatureId);
        if (signature != null && signature.getValidationProcessBasicSignatures() != null && signature.getValidationProcessBasicSignatures().getConclusion() != null) {
            return signature.getValidationProcessBasicSignatures().getConclusion().getSubIndication();
        }
        return null;
    }

    public Indication getTimestampValidationIndication(String timestampId) {
        XmlValidationProcessTimestamps timestampValidationById = this.getTimestampValidationById(timestampId);
        if (timestampValidationById != null && timestampValidationById.getConclusion() != null) {
            return timestampValidationById.getConclusion().getIndication();
        }
        return null;
    }

    public SubIndication getTimestampValidationSubIndication(String timestampId) {
        XmlValidationProcessTimestamps timestampValidationById = this.getTimestampValidationById(timestampId);
        if (timestampValidationById != null && timestampValidationById.getConclusion() != null) {
            return timestampValidationById.getConclusion().getSubIndication();
        }
        return null;
    }

    public Indication getLongTermValidationIndication(String signatureId) {
        XmlSignature signature = this.getXmlSignatureById(signatureId);
        if (signature != null && signature.getValidationProcessLongTermData() != null && signature.getValidationProcessLongTermData().getConclusion() != null) {
            return signature.getValidationProcessLongTermData().getConclusion().getIndication();
        }
        return null;
    }

    public SubIndication getLongTermValidationSubIndication(String signatureId) {
        XmlSignature signature = this.getXmlSignatureById(signatureId);
        if (signature != null && signature.getValidationProcessLongTermData() != null && signature.getValidationProcessLongTermData().getConclusion() != null) {
            return signature.getValidationProcessLongTermData().getConclusion().getSubIndication();
        }
        return null;
    }

    public Indication getArchiveDataValidationIndication(String signatureId) {
        XmlSignature signature = this.getXmlSignatureById(signatureId);
        if (signature != null && signature.getValidationProcessArchivalData() != null && signature.getValidationProcessArchivalData().getConclusion() != null) {
            return signature.getValidationProcessArchivalData().getConclusion().getIndication();
        }
        return null;
    }

    public SubIndication getArchiveDataValidationSubIndication(String signatureId) {
        XmlSignature signature = this.getXmlSignatureById(signatureId);
        if (signature != null && signature.getValidationProcessArchivalData() != null && signature.getValidationProcessArchivalData().getConclusion() != null) {
            return signature.getValidationProcessArchivalData().getConclusion().getSubIndication();
        }
        return null;
    }

    public SignatureQualification getSignatureQualification(String signatureId) {
        XmlSignature signature = this.getXmlSignatureById(signatureId);
        if (signature != null && signature.getValidationSignatureQualification() != null) {
            return signature.getValidationSignatureQualification().getSignatureQualification();
        }
        return null;
    }

    public XmlSignature getXmlSignatureById(String signatureId) {
        List signatures = this.jaxbDetailedReport.getSignatures();
        if (Utils.isCollectionNotEmpty((Collection)signatures)) {
            for (XmlSignature xmlSignature : signatures) {
                if (!Utils.areStringsEqual((String)signatureId, (String)xmlSignature.getId())) continue;
                return xmlSignature;
            }
        }
        return null;
    }

    private XmlValidationProcessTimestamps getTimestampValidationById(String timestampId) {
        List signatures = this.jaxbDetailedReport.getSignatures();
        if (Utils.isCollectionNotEmpty((Collection)signatures)) {
            for (XmlSignature xmlSignature : signatures) {
                List validationTimestamps = xmlSignature.getValidationProcessTimestamps();
                if (!Utils.isCollectionNotEmpty((Collection)validationTimestamps)) continue;
                for (XmlValidationProcessTimestamps tspValidation : validationTimestamps) {
                    if (!Utils.areStringsEqual((String)tspValidation.getId(), (String)timestampId)) continue;
                    return tspValidation;
                }
            }
        }
        return null;
    }

    public eu.europa.esig.dss.jaxb.detailedreport.DetailedReport getJAXBModel() {
        return this.jaxbDetailedReport;
    }

    public CertificateQualification getCertificateQualificationAtIssuance() {
        return this.getCertificateQualification(ValidationTime.CERTIFICATE_ISSUANCE_TIME);
    }

    public CertificateQualification getCertificateQualificationAtValidation() {
        return this.getCertificateQualification(ValidationTime.VALIDATION_TIME);
    }

    private CertificateQualification getCertificateQualification(ValidationTime validationTime) {
        List validationCertificateQualifications;
        XmlCertificate certificate = this.jaxbDetailedReport.getCertificate();
        if (certificate != null && Utils.isCollectionNotEmpty((Collection)(validationCertificateQualifications = certificate.getValidationCertificateQualification()))) {
            for (XmlValidationCertificateQualification validationCertificateQualification : validationCertificateQualifications) {
                if (validationTime != validationCertificateQualification.getValidationTime()) continue;
                return validationCertificateQualification.getCertificateQualification();
            }
        }
        return CertificateQualification.NA;
    }

    public Indication getCertificateXCVIndication(String certificateId) {
        if (this.jaxbDetailedReport.getCertificate() == null) {
            throw new DSSException("Only supported in report for certificate");
        }
        List basicBuildingBlocks = this.jaxbDetailedReport.getBasicBuildingBlocks();
        for (XmlBasicBuildingBlocks xmlBasicBuildingBlocks : basicBuildingBlocks) {
            XmlXCV xcv = xmlBasicBuildingBlocks.getXCV();
            if (xcv == null) continue;
            List subXCV = xcv.getSubXCV();
            for (XmlSubXCV xmlSubXCV : subXCV) {
                if (!Utils.areStringsEqual((String)certificateId, (String)xmlSubXCV.getId())) continue;
                return xmlSubXCV.getConclusion().getIndication();
            }
        }
        return null;
    }

    public Indication getHighestIndication(String signatureId) {
        return this.getHighestConclusion(signatureId).getConclusion().getIndication();
    }

    public SubIndication getHighestSubIndication(String signatureId) {
        return this.getHighestConclusion(signatureId).getConclusion().getSubIndication();
    }

    private XmlConstraintsConclusion getHighestConclusion(String signatureId) {
        XmlSignature xmlSignature = this.getXmlSignatureById(signatureId);
        if (xmlSignature.getValidationProcessArchivalData() != null) {
            return xmlSignature.getValidationProcessArchivalData();
        }
        if (xmlSignature.getValidationProcessLongTermData() != null) {
            return xmlSignature.getValidationProcessLongTermData();
        }
        return xmlSignature.getValidationProcessBasicSignatures();
    }

    public Set<String> getErrors(String signatureId) {
        return this.collect(MessageType.ERROR, signatureId);
    }

    public Set<String> getWarnings(String signatureId) {
        return this.collect(MessageType.WARN, signatureId);
    }

    public Set<String> getInfos(String signatureId) {
        return this.collect(MessageType.INFO, signatureId);
    }

    public Set<String> collect(MessageType type, String signatureId) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        XmlSignature signatureById = this.getXmlSignatureById(signatureId);
        XmlValidationSignatureQualification validationSignatureQualification = signatureById.getValidationSignatureQualification();
        if (validationSignatureQualification != null) {
            List validationCertificateQualifications = validationSignatureQualification.getValidationCertificateQualification();
            for (XmlValidationCertificateQualification validationCertificateQualification : validationCertificateQualifications) {
                this.collect(type, result, (XmlConstraintsConclusion)validationCertificateQualification);
            }
            this.collect(type, result, (XmlConstraintsConclusion)validationSignatureQualification);
        }
        if (MessageType.ERROR == type) {
            this.collect(type, result, this.getHighestConclusion(signatureId));
            this.collectTimestamps(type, result, signatureById);
        } else {
            this.collect(type, result, (XmlConstraintsConclusion)signatureById.getValidationProcessBasicSignatures());
            this.collectTimestamps(type, result, signatureById);
            this.collect(type, result, (XmlConstraintsConclusion)signatureById.getValidationProcessLongTermData());
            this.collect(type, result, (XmlConstraintsConclusion)signatureById.getValidationProcessArchivalData());
        }
        return result;
    }

    private void collectTimestamps(MessageType type, Set<String> result, XmlSignature signatureById) {
        List validationProcessTimestamps = signatureById.getValidationProcessTimestamps();
        for (XmlValidationProcessTimestamps xmlValidationProcessTimestamp : validationProcessTimestamps) {
            this.collect(type, result, (XmlConstraintsConclusion)xmlValidationProcessTimestamp);
        }
    }

    private void collect(MessageType type, Set<String> result, XmlConstraintsConclusion constraintConclusion) {
        if (constraintConclusion != null && Utils.isCollectionNotEmpty((Collection)constraintConclusion.getConstraint())) {
            for (XmlConstraint constraint : constraintConclusion.getConstraint()) {
                XmlName message = this.getMessage(type, constraint);
                if (message != null) {
                    result.add(message.getValue());
                }
                if (!Utils.isStringNotBlank((String)constraint.getId())) continue;
                this.collect(type, result, this.getBasicBuildingBlockById(constraint.getId()));
            }
        }
    }

    private void collect(MessageType type, Set<String> result, XmlBasicBuildingBlocks bbb) {
        if (bbb != null) {
            this.collect(type, result, (XmlConstraintsConclusion)bbb.getFC());
            this.collect(type, result, (XmlConstraintsConclusion)bbb.getISC());
            this.collect(type, result, (XmlConstraintsConclusion)bbb.getCV());
            this.collect(type, result, (XmlConstraintsConclusion)bbb.getSAV());
            XmlXCV xcv = bbb.getXCV();
            if (xcv != null) {
                this.collect(type, result, (XmlConstraintsConclusion)xcv);
                List subXCV = xcv.getSubXCV();
                if (Utils.isCollectionNotEmpty((Collection)subXCV)) {
                    for (XmlSubXCV xmlSubXCV : subXCV) {
                        this.collect(type, result, (XmlConstraintsConclusion)xmlSubXCV);
                    }
                }
            }
            this.collect(type, result, (XmlConstraintsConclusion)bbb.getVCI());
        }
    }

    private XmlName getMessage(MessageType type, XmlConstraint constraint) {
        XmlName message = null;
        switch (type) {
            case ERROR: {
                message = constraint.getError();
                break;
            }
            case WARN: {
                message = constraint.getWarning();
                break;
            }
            case INFO: {
                message = constraint.getInfo();
                break;
            }
        }
        return message;
    }

    static enum MessageType {
        INFO,
        WARN,
        ERROR;

    }
}

