/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.validation.scope;

import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.scope.SignatureScope;
import eu.europa.esig.dss.pades.PAdESUtils;
import eu.europa.esig.dss.pades.validation.scope.FullPdfByteRangeSignatureScope;
import eu.europa.esig.dss.pades.validation.scope.PartialPdfByteRangeSignatureScope;
import eu.europa.esig.dss.pdf.PdfCMSRevision;
import eu.europa.esig.dss.validation.scope.AbstractSignatureScopeFinder;

public abstract class PdfRevisionScopeFinder
extends AbstractSignatureScopeFinder {
    protected PdfRevisionScopeFinder() {
    }

    protected SignatureScope findSignatureScope(PdfCMSRevision pdfRevision) {
        if (pdfRevision.areAllOriginalBytesCovered()) {
            return new FullPdfByteRangeSignatureScope(pdfRevision.getByteRange(), this.getOriginalPdfRevision(pdfRevision));
        }
        return new PartialPdfByteRangeSignatureScope(pdfRevision.getByteRange(), this.getOriginalPdfRevision(pdfRevision));
    }

    private DSSDocument getOriginalPdfRevision(PdfCMSRevision pdfRevision) {
        return PAdESUtils.getOriginalPDF(pdfRevision);
    }
}

