/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.validation.dss;

import eu.europa.esig.dss.crl.CRLBinary;
import eu.europa.esig.dss.enumerations.RevocationOrigin;
import eu.europa.esig.dss.model.identifier.EncapsulatedRevocationTokenIdentifier;
import eu.europa.esig.dss.model.x509.revocation.crl.CRL;
import eu.europa.esig.dss.pdf.PdfDssDict;
import eu.europa.esig.dss.pdf.PdfVriDict;
import eu.europa.esig.dss.spi.x509.revocation.RevocationToken;
import eu.europa.esig.dss.spi.x509.revocation.crl.OfflineCRLSource;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PdfCompositeDssDictCRLSource
extends OfflineCRLSource {
    private final Map<Long, Set<CRLBinary>> crlBinaryByIdMap = new HashMap<Long, Set<CRLBinary>>();
    private final Map<EncapsulatedRevocationTokenIdentifier<CRL>, Set<Long>> crlBinaryByObjectMap = new HashMap<EncapsulatedRevocationTokenIdentifier<CRL>, Set<Long>>();
    private final Map<RevocationToken<CRL>, Set<Long>> crlTokenMap = new HashMap<RevocationToken<CRL>, Set<Long>>();

    public void populateFromDssDictionary(PdfDssDict dssDictionary) {
        this.extractDSSCRLs(dssDictionary);
        this.extractVRICRLs(dssDictionary);
    }

    protected void extractDSSCRLs(PdfDssDict dssDictionary) {
        Map<Long, CRLBinary> dssCrlMap = dssDictionary.getCRLs();
        this.populateObjectsMap(dssCrlMap);
        for (CRLBinary crl : dssCrlMap.values()) {
            this.addBinary((EncapsulatedRevocationTokenIdentifier)crl, RevocationOrigin.DSS_DICTIONARY);
        }
    }

    protected void extractVRICRLs(PdfDssDict dssDictionary) {
        if (dssDictionary != null) {
            List<PdfVriDict> vriDictList = dssDictionary.getVRIs();
            for (PdfVriDict vriDict : vriDictList) {
                this.populateObjectsMap(vriDict.getCRLs());
                this.extractVRICRLs(vriDict);
            }
        }
    }

    private void populateObjectsMap(Map<Long, CRLBinary> crlMap) {
        for (Map.Entry<Long, CRLBinary> entry : crlMap.entrySet()) {
            this.populateMapById(entry.getKey(), entry.getValue());
            this.populateMapByObject(entry.getKey(), entry.getValue());
        }
    }

    private void populateMapById(Long objectId, CRLBinary crlBinary) {
        Set<CRLBinary> crlBinaries = this.crlBinaryByIdMap.get(objectId);
        if (crlBinaries == null) {
            crlBinaries = new HashSet<CRLBinary>();
        }
        crlBinaries.add(crlBinary);
        this.crlBinaryByIdMap.put(objectId, crlBinaries);
    }

    private void populateMapByObject(Long objectId, CRLBinary crlBinary) {
        Set<Long> objectIds = this.crlBinaryByObjectMap.get(crlBinary);
        if (objectIds == null) {
            objectIds = new HashSet<Long>();
        }
        objectIds.add(objectId);
        this.crlBinaryByObjectMap.put((EncapsulatedRevocationTokenIdentifier<CRL>)crlBinary, objectIds);
    }

    protected void extractVRICRLs(PdfVriDict vriDictionary) {
        if (vriDictionary != null) {
            for (Map.Entry<Long, CRLBinary> crlEntry : vriDictionary.getCRLs().entrySet()) {
                this.addBinary((EncapsulatedRevocationTokenIdentifier)crlEntry.getValue(), RevocationOrigin.VRI_DICTIONARY);
            }
        }
    }

    protected Set<CRLBinary> getCRLBinariesByObjectId(Long objectId) {
        return this.crlBinaryByIdMap.get(objectId);
    }

    protected Set<Long> getRevocationTokenIds(RevocationToken<CRL> crlToken) {
        return this.crlTokenMap.get(crlToken);
    }

    public void addRevocation(RevocationToken<CRL> token, EncapsulatedRevocationTokenIdentifier<CRL> binary) {
        super.addRevocation(token, binary);
        Set<Long> tokenBinaryObjectIds = this.getTokenBinaryObjectIds(binary);
        this.crlTokenMap.put(token, tokenBinaryObjectIds);
    }

    protected Set<Long> getTokenBinaryObjectIds(EncapsulatedRevocationTokenIdentifier<CRL> binary) {
        return this.crlBinaryByObjectMap.get(binary);
    }
}

