/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades;

import eu.europa.esig.dss.enumerations.ImageScaling;
import eu.europa.esig.dss.enumerations.VisualSignatureAlignmentHorizontal;
import eu.europa.esig.dss.enumerations.VisualSignatureAlignmentVertical;
import eu.europa.esig.dss.enumerations.VisualSignatureRotation;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.pades.SignatureFieldParameters;
import eu.europa.esig.dss.pades.SignatureImageTextParameters;
import eu.europa.esig.dss.pdf.visible.DPIUtils;
import java.awt.Color;
import java.io.Serializable;
import java.util.Objects;

public class SignatureImageParameters
implements Serializable {
    private static final long serialVersionUID = -327971057134928889L;
    private static final int NO_SCALING = 100;
    private DSSDocument image;
    private SignatureFieldParameters fieldParameters;
    private int zoom = 100;
    private Color backgroundColor;
    private Integer dpi;
    private VisualSignatureAlignmentHorizontal alignmentHorizontal = VisualSignatureAlignmentHorizontal.NONE;
    private VisualSignatureAlignmentVertical alignmentVertical = VisualSignatureAlignmentVertical.NONE;
    private ImageScaling imageScaling = ImageScaling.STRETCH;
    private SignatureImageTextParameters textParameters;

    public DSSDocument getImage() {
        return this.image;
    }

    public void setImage(DSSDocument image) {
        this.image = image;
    }

    public SignatureFieldParameters getFieldParameters() {
        if (this.fieldParameters == null) {
            this.fieldParameters = new SignatureFieldParameters();
        }
        return this.fieldParameters;
    }

    public void setFieldParameters(SignatureFieldParameters fieldParameters) {
        this.fieldParameters = fieldParameters;
    }

    public int getZoom() {
        return this.zoom;
    }

    public void setZoom(int zoom) {
        this.zoom = zoom;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public Integer getDpi() {
        return DPIUtils.getDpi(this.dpi);
    }

    public void setDpi(Integer dpi) {
        this.dpi = dpi;
    }

    public SignatureImageTextParameters getTextParameters() {
        if (this.textParameters == null) {
            this.textParameters = new SignatureImageTextParameters();
        }
        return this.textParameters;
    }

    public void setTextParameters(SignatureImageTextParameters textParameters) {
        this.textParameters = textParameters;
    }

    @Deprecated
    public VisualSignatureRotation getRotation() {
        return this.getFieldParameters().getRotation();
    }

    @Deprecated
    public void setRotation(VisualSignatureRotation rotation) {
        this.getFieldParameters().setRotation(rotation);
    }

    public VisualSignatureAlignmentHorizontal getVisualSignatureAlignmentHorizontal() {
        return this.alignmentHorizontal;
    }

    public void setAlignmentHorizontal(VisualSignatureAlignmentHorizontal alignmentHorizontal) {
        this.alignmentHorizontal = alignmentHorizontal;
    }

    public VisualSignatureAlignmentVertical getVisualSignatureAlignmentVertical() {
        return this.alignmentVertical;
    }

    public void setAlignmentVertical(VisualSignatureAlignmentVertical alignmentVertical) {
        this.alignmentVertical = alignmentVertical;
    }

    public ImageScaling getImageScaling() {
        return this.imageScaling;
    }

    public void setImageScaling(ImageScaling imageScaling) {
        Objects.requireNonNull(imageScaling, "ImageScaling parameter cannot be null!");
        this.imageScaling = imageScaling;
    }

    public boolean isEmpty() {
        return this.image == null && this.getTextParameters().isEmpty();
    }

    public String toString() {
        return "SignatureImageParameters [image=" + this.image + ", zoom=" + this.zoom + ", backgroundColor=" + this.backgroundColor + ", dpi=" + this.dpi + ", alignmentHorizontal=" + this.alignmentHorizontal + ", alignmentVertical=" + this.alignmentVertical + ", fieldParameters=" + this.getFieldParameters() + ", textParameters=" + this.getTextParameters() + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SignatureImageParameters)) {
            return false;
        }
        SignatureImageParameters that = (SignatureImageParameters)o;
        if (this.zoom != that.zoom) {
            return false;
        }
        if (!Objects.equals(this.image, that.image)) {
            return false;
        }
        if (!Objects.equals(this.fieldParameters, that.fieldParameters)) {
            return false;
        }
        if (!Objects.equals(this.backgroundColor, that.backgroundColor)) {
            return false;
        }
        if (!Objects.equals(this.dpi, that.dpi)) {
            return false;
        }
        if (this.alignmentHorizontal != that.alignmentHorizontal) {
            return false;
        }
        if (this.alignmentVertical != that.alignmentVertical) {
            return false;
        }
        if (this.imageScaling != that.imageScaling) {
            return false;
        }
        return Objects.equals(this.textParameters, that.textParameters);
    }

    public int hashCode() {
        int result = this.image != null ? this.image.hashCode() : 0;
        result = 31 * result + (this.fieldParameters != null ? this.fieldParameters.hashCode() : 0);
        result = 31 * result + this.zoom;
        result = 31 * result + (this.backgroundColor != null ? this.backgroundColor.hashCode() : 0);
        result = 31 * result + (this.dpi != null ? this.dpi.hashCode() : 0);
        result = 31 * result + (this.alignmentHorizontal != null ? this.alignmentHorizontal.hashCode() : 0);
        result = 31 * result + (this.alignmentVertical != null ? this.alignmentVertical.hashCode() : 0);
        result = 31 * result + (this.imageScaling != null ? this.imageScaling.hashCode() : 0);
        result = 31 * result + (this.textParameters != null ? this.textParameters.hashCode() : 0);
        return result;
    }
}

