/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.validation;

import eu.europa.esig.dss.crl.CRLBinary;
import eu.europa.esig.dss.enumerations.RevocationOrigin;
import eu.europa.esig.dss.model.identifier.EncapsulatedRevocationTokenIdentifier;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.revocation.crl.CRL;
import eu.europa.esig.dss.pades.validation.PdfCmsCRLSource;
import eu.europa.esig.dss.pades.validation.dss.PdfDssDictCRLSource;
import eu.europa.esig.dss.pdf.PdfSignatureRevision;
import eu.europa.esig.dss.spi.x509.revocation.RevocationToken;
import eu.europa.esig.dss.spi.x509.revocation.crl.OfflineCRLSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.bouncycastle.asn1.cms.AttributeTable;

public class PAdESCRLSource
extends OfflineCRLSource {
    private final PdfCmsCRLSource cmsCrlSource;
    private final PdfDssDictCRLSource dssDictCrlSource;

    public PAdESCRLSource(PdfSignatureRevision pdfSignatureRevision, String vriDictionaryName, AttributeTable signedAttributes) {
        Objects.requireNonNull(vriDictionaryName, "vriDictionaryName cannot be null!");
        this.cmsCrlSource = new PdfCmsCRLSource(signedAttributes);
        this.dssDictCrlSource = new PdfDssDictCRLSource(pdfSignatureRevision.getCompositeDssDictionary().getCrlSource(), pdfSignatureRevision.getDssDictionary(), vriDictionaryName);
    }

    public List<RevocationToken<CRL>> getRevocationTokens(CertificateToken certificateToken, CertificateToken issuerToken) {
        ArrayList<RevocationToken<CRL>> revocationTokens = new ArrayList<RevocationToken<CRL>>();
        revocationTokens.addAll(this.cmsCrlSource.getRevocationTokens(certificateToken, issuerToken));
        revocationTokens.addAll(this.dssDictCrlSource.getRevocationTokens(certificateToken, issuerToken));
        return revocationTokens;
    }

    public Map<Long, CRLBinary> getCrlMap() {
        return this.dssDictCrlSource.getCrlMap();
    }

    public List<EncapsulatedRevocationTokenIdentifier<CRL>> getDSSDictionaryBinaries() {
        return this.dssDictCrlSource.getDSSDictionaryBinaries();
    }

    public List<RevocationToken<CRL>> getDSSDictionaryTokens() {
        return this.dssDictCrlSource.getDSSDictionaryTokens();
    }

    public List<EncapsulatedRevocationTokenIdentifier<CRL>> getVRIDictionaryBinaries() {
        return this.dssDictCrlSource.getVRIDictionaryBinaries();
    }

    public List<RevocationToken<CRL>> getVRIDictionaryTokens() {
        return this.dssDictCrlSource.getVRIDictionaryTokens();
    }

    public List<EncapsulatedRevocationTokenIdentifier<CRL>> getADBERevocationValuesBinaries() {
        return this.cmsCrlSource.getADBERevocationValuesBinaries();
    }

    public List<RevocationToken<CRL>> getADBERevocationValuesTokens() {
        return this.dssDictCrlSource.getADBERevocationValuesTokens();
    }

    public Map<EncapsulatedRevocationTokenIdentifier<CRL>, Set<RevocationOrigin>> getAllRevocationBinariesWithOrigins() {
        HashMap<EncapsulatedRevocationTokenIdentifier<CRL>, Set<RevocationOrigin>> result = new HashMap<EncapsulatedRevocationTokenIdentifier<CRL>, Set<RevocationOrigin>>();
        this.populateMapWithSet(result, this.cmsCrlSource.getAllRevocationBinariesWithOrigins());
        this.populateMapWithSet(result, this.dssDictCrlSource.getAllRevocationBinariesWithOrigins());
        return result;
    }

    public Map<RevocationToken<CRL>, Set<RevocationOrigin>> getAllRevocationTokensWithOrigins() {
        HashMap<RevocationToken<CRL>, Set<RevocationOrigin>> result = new HashMap<RevocationToken<CRL>, Set<RevocationOrigin>>();
        this.populateMapWithSet(result, this.cmsCrlSource.getAllRevocationTokensWithOrigins());
        this.populateMapWithSet(result, this.dssDictCrlSource.getAllRevocationTokensWithOrigins());
        return result;
    }

    private <R> void populateMapWithSet(Map<R, Set<RevocationOrigin>> mapToPopulate, Map<R, Set<RevocationOrigin>> mapToAdd) {
        for (Map.Entry<R, Set<RevocationOrigin>> entry : mapToAdd.entrySet()) {
            Set<RevocationOrigin> revocationOrigins = mapToPopulate.get(entry.getKey());
            if (revocationOrigins == null) {
                revocationOrigins = new HashSet<RevocationOrigin>();
            }
            revocationOrigins.addAll((Collection<RevocationOrigin>)entry.getValue());
            mapToPopulate.put(entry.getKey(), revocationOrigins);
        }
    }
}

