/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.validation;

import eu.europa.esig.dss.pades.validation.ByteRange;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;

public class ByteRangeInputStream
extends FilterInputStream {
    private final ByteRange byteRange;
    private int position = 0;

    public ByteRangeInputStream(InputStream is, ByteRange byteRange) {
        super(is);
        Objects.requireNonNull(is, "InputStream cannot be null!");
        Objects.requireNonNull(byteRange, "ByteRange cannot be null!");
        this.byteRange = byteRange;
    }

    @Override
    public int read() throws IOException {
        this.skipPerRange();
        int b = -1;
        if (this.position == this.byteRange.getFirstPartEnd()) {
            int offset = this.byteRange.getSecondPartStart() - this.byteRange.getFirstPartEnd();
            long skipped = super.skip(offset);
            this.position = (int)((long)this.position + skipped);
        } else if (this.position < this.byteRange.getFirstPartStart()) {
            int offset = this.byteRange.getFirstPartStart() - this.position;
            long skipped = super.skip(offset);
            this.position = (int)((long)this.position + skipped);
        }
        if (this.isPositionWithinRange(this.position + 1) && (b = super.read()) != -1) {
            ++this.position;
        }
        return b;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.position += off;
        this.skipPerRange();
        int readBytes = 0;
        if (this.isPositionWithinFirstPart(this.position)) {
            int toRead = this.byteRange.getFirstPartStart() + this.byteRange.getFirstPartEnd() - this.position;
            readBytes = super.read(b, off, Math.min(len, toRead));
            this.position += readBytes;
        } else if (this.isPositionWithinSecondPart(this.position)) {
            int toRead = this.byteRange.getSecondPartStart() + this.byteRange.getSecondPartEnd() - this.position;
            int readBytesSecondPart = super.read(b, off + readBytes, Math.min(len - readBytes, toRead));
            readBytes += readBytesSecondPart;
            this.position += readBytesSecondPart;
        }
        if (readBytes < 1) {
            return -1;
        }
        return readBytes;
    }

    private void skipPerRange() throws IOException {
        if (this.position == this.byteRange.getFirstPartEnd()) {
            int offset = this.byteRange.getSecondPartStart() - this.byteRange.getFirstPartEnd();
            long skipped = this.skip(offset);
            this.position = (int)((long)this.position + skipped);
        } else if (this.position < this.byteRange.getFirstPartStart()) {
            int offset = this.byteRange.getFirstPartStart() - this.position;
            long skipped = this.skip(offset);
            this.position = (int)((long)this.position + skipped);
        }
    }

    private boolean isPositionWithinRange(int position) {
        return this.isPositionWithinFirstPart(position) || this.isPositionWithinSecondPart(position);
    }

    private boolean isPositionWithinFirstPart(int position) {
        return position >= this.byteRange.getFirstPartStart() && position <= this.byteRange.getFirstPartStart() + this.byteRange.getFirstPartEnd();
    }

    private boolean isPositionWithinSecondPart(int position) {
        return position >= this.byteRange.getSecondPartStart() && position <= this.byteRange.getSecondPartStart() + this.byteRange.getSecondPartEnd();
    }
}

