/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.signature;

import eu.europa.esig.dss.AbstractSignatureParameters;
import eu.europa.esig.dss.enumerations.SignatureAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.DSSMessageDigest;
import eu.europa.esig.dss.model.DigestDocument;
import eu.europa.esig.dss.model.SignatureValue;
import eu.europa.esig.dss.model.TimestampBinary;
import eu.europa.esig.dss.model.ToBeSigned;
import eu.europa.esig.dss.pades.PAdESSignatureParameters;
import eu.europa.esig.dss.pades.PAdESTimestampParameters;
import eu.europa.esig.dss.pades.SignatureFieldParameters;
import eu.europa.esig.dss.pades.signature.ExternalCMSService;
import eu.europa.esig.dss.pades.signature.PAdESExtensionService;
import eu.europa.esig.dss.pades.signature.PAdESLevelBaselineLT;
import eu.europa.esig.dss.pades.signature.PAdESLevelBaselineLTA;
import eu.europa.esig.dss.pades.signature.PAdESLevelBaselineT;
import eu.europa.esig.dss.pades.timestamp.PAdESTimestampService;
import eu.europa.esig.dss.pdf.IPdfObjFactory;
import eu.europa.esig.dss.pdf.PDFSignatureService;
import eu.europa.esig.dss.pdf.ServiceLoaderPdfObjFactory;
import eu.europa.esig.dss.signature.AbstractSignatureService;
import eu.europa.esig.dss.signature.SignatureExtension;
import eu.europa.esig.dss.signature.SigningOperation;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.x509.tsp.TSPSource;
import eu.europa.esig.dss.spi.x509.tsp.TimestampToken;
import eu.europa.esig.dss.validation.CertificateVerifier;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.tsp.TSPException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PAdESService
extends AbstractSignatureService<PAdESSignatureParameters, PAdESTimestampParameters> {
    private static final long serialVersionUID = -6518552348520127617L;
    private static final Logger LOG = LoggerFactory.getLogger(PAdESService.class);
    private final ExternalCMSService cmsForPAdESGenerationService;
    private IPdfObjFactory pdfObjFactory = new ServiceLoaderPdfObjFactory();

    public PAdESService(CertificateVerifier certificateVerifier) {
        super(certificateVerifier);
        this.cmsForPAdESGenerationService = new ExternalCMSService(certificateVerifier);
        LOG.debug("+ PAdESService created");
    }

    public void setPdfObjFactory(IPdfObjFactory pdfObjFactory) {
        Objects.requireNonNull(pdfObjFactory, "PdfObjFactory is null");
        this.pdfObjFactory = pdfObjFactory;
    }

    public void setTspSource(TSPSource tspSource) {
        super.setTspSource(tspSource);
        this.cmsForPAdESGenerationService.setTspSource(tspSource);
    }

    private SignatureExtension<PAdESSignatureParameters> getExtensionProfile(SignatureLevel signatureLevel) {
        Objects.requireNonNull(signatureLevel, "SignatureLevel must be defined!");
        switch (signatureLevel) {
            case PAdES_BASELINE_B: {
                return null;
            }
            case PAdES_BASELINE_T: {
                return new PAdESLevelBaselineT(this.tspSource, this.certificateVerifier, this.pdfObjFactory);
            }
            case PAdES_BASELINE_LT: {
                return new PAdESLevelBaselineLT(this.tspSource, this.certificateVerifier, this.pdfObjFactory);
            }
            case PAdES_BASELINE_LTA: {
                return new PAdESLevelBaselineLTA(this.tspSource, this.certificateVerifier, this.pdfObjFactory);
            }
        }
        throw new UnsupportedOperationException(String.format("Unsupported signature format '%s' for extension.", signatureLevel));
    }

    public TimestampToken getContentTimestamp(DSSDocument toSignDocument, PAdESSignatureParameters parameters) {
        Objects.requireNonNull(toSignDocument, "toSignDocument cannot be null!");
        Objects.requireNonNull(parameters, "SignatureParameters cannot be null!");
        this.assertSignaturePossible(toSignDocument);
        this.assertContentTimestampParametersValid(parameters);
        PDFSignatureService pdfSignatureService = this.getContentTimestampService();
        DSSMessageDigest messageDigest = pdfSignatureService.messageDigest(toSignDocument, parameters);
        TimestampBinary timeStampResponse = this.tspSource.getTimeStampResponse(parameters.getDigestAlgorithm(), messageDigest.getValue());
        try {
            return new TimestampToken(timeStampResponse.getBytes(), TimestampType.CONTENT_TIMESTAMP);
        }
        catch (IOException | CMSException | TSPException e) {
            throw new DSSException("Cannot obtain the content timestamp", e);
        }
    }

    private void assertContentTimestampParametersValid(PAdESSignatureParameters parameters) {
        if (parameters.getDigestAlgorithm() != parameters.getContentTimestampParameters().getDigestAlgorithm()) {
            throw new UnsupportedOperationException("DigestAlgorithm for content timestamp creation shall be the same as the one defined in PAdESSignatureParameters!");
        }
    }

    public DSSDocument previewPageWithVisualSignature(DSSDocument toSignDocument, PAdESSignatureParameters parameters) {
        Objects.requireNonNull(toSignDocument, "toSignDocument cannot be null!");
        Objects.requireNonNull(parameters, "SignatureParameters cannot be null!");
        PDFSignatureService pdfSignatureService = this.getPAdESSignatureService();
        return pdfSignatureService.previewPageWithVisualSignature(toSignDocument, parameters);
    }

    public DSSDocument previewSignatureField(DSSDocument toSignDocument, PAdESSignatureParameters parameters) {
        Objects.requireNonNull(toSignDocument, "toSignDocument cannot be null!");
        Objects.requireNonNull(parameters, "SignatureParameters cannot be null!");
        PDFSignatureService pdfSignatureService = this.getPAdESSignatureService();
        return pdfSignatureService.previewSignatureField(toSignDocument, parameters);
    }

    public ToBeSigned getDataToSign(DSSDocument toSignDocument, PAdESSignatureParameters parameters) throws DSSException {
        Objects.requireNonNull(toSignDocument, "toSignDocument cannot be null!");
        Objects.requireNonNull(parameters, "SignatureParameters cannot be null!");
        this.assertSignaturePossible(toSignDocument);
        this.assertSigningCertificateValid((AbstractSignatureParameters)parameters);
        DSSMessageDigest messageDigest = this.computeDocumentDigest(toSignDocument, parameters);
        return this.cmsForPAdESGenerationService.buildToBeSignedData(messageDigest, parameters);
    }

    protected DSSMessageDigest computeDocumentDigest(DSSDocument toSignDocument, PAdESSignatureParameters parameters) {
        PDFSignatureService pdfSignatureService = this.getPAdESSignatureService();
        return pdfSignatureService.messageDigest(toSignDocument, parameters);
    }

    public DSSDocument signDocument(DSSDocument toSignDocument, PAdESSignatureParameters parameters, SignatureValue signatureValue) {
        Objects.requireNonNull(toSignDocument, "toSignDocument cannot be null!");
        Objects.requireNonNull(parameters, "SignatureParameters cannot be null!");
        this.assertSignaturePossible(toSignDocument);
        this.assertSigningCertificateValid((AbstractSignatureParameters)parameters);
        signatureValue = this.ensureSignatureValue(parameters.getSignatureAlgorithm(), signatureValue);
        SignatureLevel signatureLevel = parameters.getSignatureLevel();
        byte[] cmsSignedData = this.generateCMSSignedData(toSignDocument, parameters, signatureValue);
        PDFSignatureService pdfSignatureService = this.getPAdESSignatureService();
        DSSDocument signature = pdfSignatureService.sign(toSignDocument, cmsSignedData, parameters);
        SignatureExtension<PAdESSignatureParameters> extension = this.getExtensionProfile(signatureLevel);
        if (signatureLevel != SignatureLevel.PAdES_BASELINE_B && signatureLevel != SignatureLevel.PAdES_BASELINE_T && extension != null) {
            signature = extension.extendSignatures(signature, (AbstractSignatureParameters)parameters);
        }
        parameters.reinit();
        signature.setName(this.getFinalFileName(toSignDocument, SigningOperation.SIGN, parameters.getSignatureLevel()));
        return signature;
    }

    private void assertSignaturePossible(DSSDocument toSignDocument) {
        if (toSignDocument instanceof DigestDocument) {
            throw new IllegalArgumentException("DigestDocument cannot be used for PAdES!");
        }
    }

    protected byte[] generateCMSSignedData(DSSDocument toSignDocument, PAdESSignatureParameters parameters, SignatureValue signatureValue) {
        SignatureAlgorithm signatureAlgorithm = parameters.getSignatureAlgorithm();
        SignatureLevel signatureLevel = parameters.getSignatureLevel();
        Objects.requireNonNull(signatureAlgorithm, "SignatureAlgorithm cannot be null!");
        Objects.requireNonNull(signatureLevel, "SignatureLevel must be defined!");
        DSSMessageDigest messageDigest = this.computeDocumentDigest(toSignDocument, parameters);
        CMSSignedData cmsSignedData = this.cmsForPAdESGenerationService.buildCMSSignedData(messageDigest, parameters, signatureValue);
        return DSSASN1Utils.getDEREncoded((CMSSignedData)cmsSignedData);
    }

    public DSSDocument extendDocument(DSSDocument toExtendDocument, PAdESSignatureParameters parameters) throws DSSException {
        Objects.requireNonNull(toExtendDocument, "toExtendDocument is not defined!");
        Objects.requireNonNull(parameters, "Cannot extend the signature. SignatureParameters are not defined!");
        if (SignatureLevel.PAdES_BASELINE_B.equals((Object)parameters.getSignatureLevel())) {
            throw new UnsupportedOperationException(String.format("Unsupported signature format '%s' for extension.", parameters.getSignatureLevel()));
        }
        SignatureExtension<PAdESSignatureParameters> extension = this.getExtensionProfile(parameters.getSignatureLevel());
        if (extension != null) {
            DSSDocument extended = extension.extendSignatures(toExtendDocument, (AbstractSignatureParameters)parameters);
            extended.setName(this.getFinalFileName(toExtendDocument, SigningOperation.EXTEND, parameters.getSignatureLevel()));
            return extended;
        }
        return toExtendDocument;
    }

    public List<String> getAvailableSignatureFields(DSSDocument document) {
        return this.getAvailableSignatureFields(document, null);
    }

    public List<String> getAvailableSignatureFields(DSSDocument document, char[] passwordProtection) {
        PDFSignatureService pdfSignatureService = this.getPAdESSignatureService();
        return pdfSignatureService.getAvailableSignatureFields(document, passwordProtection);
    }

    public DSSDocument addNewSignatureField(DSSDocument document, SignatureFieldParameters parameters) {
        return this.addNewSignatureField(document, parameters, null);
    }

    public DSSDocument addNewSignatureField(DSSDocument document, SignatureFieldParameters parameters, char[] passwordProtection) {
        PDFSignatureService pdfSignatureService = this.getPAdESSignatureService();
        return pdfSignatureService.addNewSignatureField(document, parameters, passwordProtection);
    }

    public DSSDocument timestamp(DSSDocument toTimestampDocument, PAdESTimestampParameters parameters) {
        PAdESExtensionService extensionService = new PAdESExtensionService(this.certificateVerifier, this.pdfObjFactory);
        DSSDocument extendedDocument = extensionService.incorporateValidationData(toTimestampDocument, parameters.getPasswordProtection());
        PAdESTimestampService timestampService = new PAdESTimestampService(this.tspSource, this.getSignatureTimestampService());
        DSSDocument timestampedDocument = timestampService.timestampDocument(extendedDocument, parameters);
        timestampedDocument.setName(this.getFinalFileName(toTimestampDocument, SigningOperation.TIMESTAMP, null));
        return timestampedDocument;
    }

    protected PDFSignatureService getPAdESSignatureService() {
        return this.pdfObjFactory.newPAdESSignatureService();
    }

    protected PDFSignatureService getContentTimestampService() {
        return this.pdfObjFactory.newContentTimestampService();
    }

    protected PDFSignatureService getSignatureTimestampService() {
        return this.pdfObjFactory.newSignatureTimestampService();
    }
}

