/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf.visible;

import eu.europa.esig.dss.enumerations.VisualSignatureRotation;
import eu.europa.esig.dss.pdf.AnnotationBox;

public class ImageRotationUtils {
    public static final String SUPPORTED_ANGLES_ERROR_MESSAGE = "rotation angle must be 90, 180, 270 or 360 (0)";
    public static final int ANGLE_0 = 0;
    public static final int ANGLE_90 = 90;
    public static final int ANGLE_180 = 180;
    public static final int ANGLE_270 = 270;
    public static final int ANGLE_360 = 360;

    private ImageRotationUtils() {
    }

    private static boolean needRotation(VisualSignatureRotation visualSignatureRotation) {
        return visualSignatureRotation != null && !VisualSignatureRotation.NONE.equals((Object)visualSignatureRotation);
    }

    public static int getRotation(VisualSignatureRotation visualSignatureRotation) {
        return ImageRotationUtils.getRotation(visualSignatureRotation, 0);
    }

    public static int getRotation(VisualSignatureRotation visualSignatureRotation, int pageRotation) {
        int rotate = 360;
        if (ImageRotationUtils.needRotation(visualSignatureRotation)) {
            switch (visualSignatureRotation) {
                case AUTOMATIC: {
                    rotate = 360 - pageRotation;
                    break;
                }
                case ROTATE_90: {
                    rotate = 90;
                    break;
                }
                case ROTATE_180: {
                    rotate = 180;
                    break;
                }
                case ROTATE_270: {
                    rotate = 270;
                    break;
                }
                default: {
                    throw new IllegalStateException(SUPPORTED_ANGLES_ERROR_MESSAGE);
                }
            }
        }
        return rotate;
    }

    public static boolean isSwapOfDimensionsRequired(int rotation) {
        return 90 == rotation || 270 == rotation;
    }

    public static boolean isSwapOfDimensionsRequired(VisualSignatureRotation rotation) {
        return VisualSignatureRotation.ROTATE_90 == rotation || VisualSignatureRotation.ROTATE_270 == rotation;
    }

    public static AnnotationBox swapDimensions(AnnotationBox annotationBox) {
        return new AnnotationBox(annotationBox.getMinY(), annotationBox.getMinX(), annotationBox.getMaxY(), annotationBox.getMaxX());
    }

    public static AnnotationBox rotateRelativelyWrappingBox(AnnotationBox annotationBox, AnnotationBox wrappingBox, int rotation) {
        switch (rotation) {
            case 90: {
                return new AnnotationBox(annotationBox.getMinY(), wrappingBox.getWidth() - annotationBox.getMaxX(), annotationBox.getMaxY(), wrappingBox.getWidth() - annotationBox.getMinX());
            }
            case 180: {
                return new AnnotationBox(wrappingBox.getWidth() - annotationBox.getMaxX(), wrappingBox.getHeight() - annotationBox.getMaxY(), wrappingBox.getWidth() - annotationBox.getMinX(), wrappingBox.getHeight() - annotationBox.getMinY());
            }
            case 270: {
                return new AnnotationBox(wrappingBox.getHeight() - annotationBox.getMaxY(), annotationBox.getMinX(), wrappingBox.getHeight() - annotationBox.getMinY(), annotationBox.getMaxX());
            }
            case 0: 
            case 360: {
                return annotationBox;
            }
        }
        throw new IllegalStateException(SUPPORTED_ANGLES_ERROR_MESSAGE);
    }

    public static AnnotationBox ensureNoRotate(AnnotationBox annotationBox, int pageRotation) {
        switch (pageRotation) {
            case 90: {
                return new AnnotationBox(annotationBox.getMinX(), annotationBox.getMaxY(), annotationBox.getMinX() + annotationBox.getHeight(), annotationBox.getMaxY() + annotationBox.getWidth());
            }
            case 180: {
                return new AnnotationBox(annotationBox.getMinX() - annotationBox.getWidth(), annotationBox.getMaxY(), annotationBox.getMinX(), annotationBox.getMaxY() + annotationBox.getHeight());
            }
            case 270: {
                return new AnnotationBox(annotationBox.getMinX() - annotationBox.getHeight(), annotationBox.getMaxY() - annotationBox.getWidth(), annotationBox.getMinX(), annotationBox.getMaxY());
            }
            case 0: 
            case 360: {
                return annotationBox;
            }
        }
        throw new UnsupportedOperationException(String.format("The rotation degree '%s' is not supported!", pageRotation));
    }
}

