/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.validation;

import eu.europa.esig.dss.cades.validation.CAdESDiagnosticDataBuilder;
import eu.europa.esig.dss.diagnostic.jaxb.XmlByteRange;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDocMDP;
import eu.europa.esig.dss.diagnostic.jaxb.XmlModification;
import eu.europa.esig.dss.diagnostic.jaxb.XmlModificationDetection;
import eu.europa.esig.dss.diagnostic.jaxb.XmlObjectModification;
import eu.europa.esig.dss.diagnostic.jaxb.XmlObjectModifications;
import eu.europa.esig.dss.diagnostic.jaxb.XmlOrphanTokens;
import eu.europa.esig.dss.diagnostic.jaxb.XmlPDFLockDictionary;
import eu.europa.esig.dss.diagnostic.jaxb.XmlPDFRevision;
import eu.europa.esig.dss.diagnostic.jaxb.XmlPDFSignatureDictionary;
import eu.europa.esig.dss.diagnostic.jaxb.XmlPDFSignatureField;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSignature;
import eu.europa.esig.dss.diagnostic.jaxb.XmlTimestamp;
import eu.europa.esig.dss.enumerations.CertificationPermission;
import eu.europa.esig.dss.model.identifier.EncapsulatedRevocationTokenIdentifier;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.pades.validation.ByteRange;
import eu.europa.esig.dss.pades.validation.PAdESSignature;
import eu.europa.esig.dss.pades.validation.PdfRevision;
import eu.europa.esig.dss.pades.validation.PdfSignatureDictionary;
import eu.europa.esig.dss.pades.validation.PdfSignatureField;
import eu.europa.esig.dss.pades.validation.timestamp.PdfTimestampToken;
import eu.europa.esig.dss.pdf.SigFieldPermissions;
import eu.europa.esig.dss.pdf.modifications.ObjectModification;
import eu.europa.esig.dss.pdf.modifications.PdfModification;
import eu.europa.esig.dss.pdf.modifications.PdfModificationDetection;
import eu.europa.esig.dss.pdf.modifications.PdfObjectModifications;
import eu.europa.esig.dss.spi.x509.tsp.TimestampToken;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class PAdESDiagnosticDataBuilder
extends CAdESDiagnosticDataBuilder {
    public XmlSignature buildDetachedXmlSignature(AdvancedSignature signature) {
        XmlSignature xmlSignature = super.buildDetachedXmlSignature(signature);
        PAdESSignature padesSignature = (PAdESSignature)signature;
        xmlSignature.setPDFRevision(this.getXmlPDFRevision(padesSignature.getPdfRevision()));
        xmlSignature.setVRIDictionaryCreationTime(padesSignature.getVRICreationTime());
        return xmlSignature;
    }

    protected XmlTimestamp buildDetachedXmlTimestamp(TimestampToken timestampToken) {
        XmlTimestamp xmlTimestamp = super.buildDetachedXmlTimestamp(timestampToken);
        if (timestampToken instanceof PdfTimestampToken) {
            PdfTimestampToken pdfTimestampToken = (PdfTimestampToken)timestampToken;
            xmlTimestamp.setPDFRevision(this.getXmlPDFRevision(pdfTimestampToken.getPdfRevision()));
        }
        return xmlTimestamp;
    }

    private XmlPDFRevision getXmlPDFRevision(PdfRevision pdfRevision) {
        if (pdfRevision != null) {
            XmlPDFRevision xmlPDFRevision = new XmlPDFRevision();
            List<PdfSignatureField> fields = pdfRevision.getFields();
            if (Utils.isCollectionNotEmpty(fields)) {
                for (PdfSignatureField field : fields) {
                    xmlPDFRevision.getFields().add(this.getXmlPDFSignatureField(field));
                }
            }
            xmlPDFRevision.setPDFSignatureDictionary(this.getXmlPDFSignatureDictionary(pdfRevision.getPdfSigDictInfo()));
            xmlPDFRevision.setModificationDetection(this.getXmlModificationDetection(pdfRevision.getModificationDetection()));
            return xmlPDFRevision;
        }
        return null;
    }

    private XmlPDFSignatureField getXmlPDFSignatureField(PdfSignatureField pdfSignatureField) {
        XmlPDFSignatureField xmlPdfSignatureField = new XmlPDFSignatureField();
        xmlPdfSignatureField.setName(pdfSignatureField.getFieldName());
        xmlPdfSignatureField.setSigFieldLock(this.getXmlPDFLockDictionary(pdfSignatureField.getLockDictionary()));
        return xmlPdfSignatureField;
    }

    private XmlPDFLockDictionary getXmlPDFLockDictionary(SigFieldPermissions lockDictionary) {
        if (lockDictionary != null) {
            XmlPDFLockDictionary xmlPDFLockDictionary = new XmlPDFLockDictionary();
            xmlPDFLockDictionary.setAction(lockDictionary.getAction());
            if (Utils.isCollectionNotEmpty(lockDictionary.getFields())) {
                xmlPDFLockDictionary.getFields().addAll(lockDictionary.getFields());
            }
            if (lockDictionary.getCertificationPermission() != null) {
                xmlPDFLockDictionary.setPermissions(lockDictionary.getCertificationPermission());
            }
            return xmlPDFLockDictionary;
        }
        return null;
    }

    private XmlPDFSignatureDictionary getXmlPDFSignatureDictionary(PdfSignatureDictionary pdfSigDict) {
        if (pdfSigDict != null) {
            XmlPDFSignatureDictionary pdfSignatureDictionary = new XmlPDFSignatureDictionary();
            pdfSignatureDictionary.setSignerName(this.emptyToNull(pdfSigDict.getSignerName()));
            pdfSignatureDictionary.setType(this.emptyToNull(pdfSigDict.getType()));
            pdfSignatureDictionary.setFilter(this.emptyToNull(pdfSigDict.getFilter()));
            pdfSignatureDictionary.setSubFilter(this.emptyToNull(pdfSigDict.getSubFilter()));
            pdfSignatureDictionary.setContactInfo(this.emptyToNull(pdfSigDict.getContactInfo()));
            pdfSignatureDictionary.setLocation(this.emptyToNull(pdfSigDict.getLocation()));
            pdfSignatureDictionary.setReason(this.emptyToNull(pdfSigDict.getReason()));
            pdfSignatureDictionary.setSignatureByteRange(this.getXmlByteRange(pdfSigDict.getByteRange()));
            pdfSignatureDictionary.setDocMDP(this.getXmlDocMDP(pdfSigDict.getDocMDP()));
            pdfSignatureDictionary.setFieldMDP(this.getXmlPDFLockDictionary(pdfSigDict.getFieldMDP()));
            pdfSignatureDictionary.setConsistent(pdfSigDict.isConsistent());
            return pdfSignatureDictionary;
        }
        return null;
    }

    private XmlByteRange getXmlByteRange(ByteRange byteRange) {
        XmlByteRange xmlByteRange = new XmlByteRange();
        xmlByteRange.getValue().addAll(byteRange.toBigIntegerList());
        xmlByteRange.setValid(byteRange.isValid());
        return xmlByteRange;
    }

    private XmlDocMDP getXmlDocMDP(CertificationPermission certificationPermission) {
        if (certificationPermission != null) {
            XmlDocMDP xmlDocMDP = new XmlDocMDP();
            xmlDocMDP.setPermissions(certificationPermission);
            return xmlDocMDP;
        }
        return null;
    }

    private XmlModificationDetection getXmlModificationDetection(PdfModificationDetection modificationDetection) {
        if (modificationDetection != null && modificationDetection.areModificationsDetected()) {
            PdfObjectModifications objectModifications;
            List<PdfModification> pageDifferences;
            List<PdfModification> visualDifferences;
            XmlModificationDetection xmlModificationDetection = new XmlModificationDetection();
            List<PdfModification> annotationOverlaps = modificationDetection.getAnnotationOverlaps();
            if (Utils.isCollectionNotEmpty(annotationOverlaps)) {
                xmlModificationDetection.getAnnotationOverlap().addAll(this.getXmlModifications(annotationOverlaps));
            }
            if (Utils.isCollectionNotEmpty(visualDifferences = modificationDetection.getVisualDifferences())) {
                xmlModificationDetection.getVisualDifference().addAll(this.getXmlModifications(visualDifferences));
            }
            if (Utils.isCollectionNotEmpty(pageDifferences = modificationDetection.getPageDifferences())) {
                xmlModificationDetection.getPageDifference().addAll(this.getXmlModifications(pageDifferences));
            }
            if (!(objectModifications = modificationDetection.getObjectModifications()).isEmpty()) {
                xmlModificationDetection.setObjectModifications(this.getXmlObjectModifications(objectModifications));
            }
            return xmlModificationDetection;
        }
        return null;
    }

    private List<XmlModification> getXmlModifications(List<PdfModification> modifications) {
        ArrayList<XmlModification> xmlModifications = new ArrayList<XmlModification>();
        if (Utils.isCollectionNotEmpty(modifications)) {
            for (PdfModification pdfModification : modifications) {
                xmlModifications.add(this.getXmlModification(pdfModification));
            }
        }
        return xmlModifications;
    }

    private XmlModification getXmlModification(PdfModification pdfModification) {
        XmlModification xmlModification = new XmlModification();
        xmlModification.setPage(BigInteger.valueOf(pdfModification.getPage()));
        return xmlModification;
    }

    private XmlObjectModifications getXmlObjectModifications(PdfObjectModifications objectModifications) {
        XmlObjectModifications xmlObjectModifications = new XmlObjectModifications();
        for (ObjectModification modification : objectModifications.getSecureChanges()) {
            xmlObjectModifications.getExtensionChanges().add(this.getXmlObjectModification(modification));
        }
        for (ObjectModification modification : objectModifications.getFormFillInAndSignatureCreationChanges()) {
            xmlObjectModifications.getSignatureOrFormFill().add(this.getXmlObjectModification(modification));
        }
        for (ObjectModification modification : objectModifications.getAnnotCreationChanges()) {
            xmlObjectModifications.getAnnotationChanges().add(this.getXmlObjectModification(modification));
        }
        for (ObjectModification modification : objectModifications.getUndefinedChanges()) {
            xmlObjectModifications.getUndefined().add(this.getXmlObjectModification(modification));
        }
        return xmlObjectModifications;
    }

    private XmlObjectModification getXmlObjectModification(ObjectModification objectModification) {
        XmlObjectModification xmlObjectModification = new XmlObjectModification();
        xmlObjectModification.setValue(objectModification.getObjectTree().toString());
        xmlObjectModification.setAction(objectModification.getActionType());
        xmlObjectModification.setFieldName(objectModification.getFieldName());
        xmlObjectModification.setType(objectModification.getType());
        return xmlObjectModification;
    }

    protected XmlOrphanTokens buildXmlOrphanTokens() {
        this.buildOrphanTokensFromDocumentSources();
        return super.buildXmlOrphanTokens();
    }

    private void buildOrphanTokensFromDocumentSources() {
        String id;
        for (CertificateToken certificateToken : this.documentCertificateSource.getCertificates()) {
            id = certificateToken.getDSSIdAsString();
            if (this.xmlCertsMap.containsKey(id) || this.xmlOrphanCertificateTokensMap.containsKey(id)) continue;
            this.buildXmlOrphanCertificateToken(certificateToken);
        }
        for (EncapsulatedRevocationTokenIdentifier revocationIdentifier : this.documentCRLSource.getAllRevocationBinaries()) {
            id = revocationIdentifier.asXmlId();
            if (this.xmlRevocationsMap.containsKey(id) || this.xmlOrphanRevocationTokensMap.containsKey(id)) continue;
            this.createOrphanTokenFromRevocationIdentifier(revocationIdentifier);
        }
        for (EncapsulatedRevocationTokenIdentifier revocationIdentifier : this.documentOCSPSource.getAllRevocationBinaries()) {
            id = revocationIdentifier.asXmlId();
            if (this.xmlRevocationsMap.containsKey(id) || this.xmlOrphanRevocationTokensMap.containsKey(id)) continue;
            this.createOrphanTokenFromRevocationIdentifier(revocationIdentifier);
        }
    }
}

