/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.signature;

import eu.europa.esig.dss.AbstractSignatureParameters;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.exception.IllegalInputException;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.pades.PAdESSignatureParameters;
import eu.europa.esig.dss.pades.PAdESTimestampParameters;
import eu.europa.esig.dss.pades.PAdESUtils;
import eu.europa.esig.dss.pades.timestamp.PAdESTimestampService;
import eu.europa.esig.dss.pades.validation.PAdESSignature;
import eu.europa.esig.dss.pades.validation.PDFDocumentValidator;
import eu.europa.esig.dss.pdf.IPdfObjFactory;
import eu.europa.esig.dss.pdf.PDFSignatureService;
import eu.europa.esig.dss.signature.SignatureExtension;
import eu.europa.esig.dss.signature.SignatureRequirementsChecker;
import eu.europa.esig.dss.spi.x509.tsp.TSPSource;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.CertificateVerifier;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PAdESLevelBaselineT
implements SignatureExtension<PAdESSignatureParameters> {
    private static final Logger LOG = LoggerFactory.getLogger(PAdESLevelBaselineT.class);
    private final TSPSource tspSource;
    protected final CertificateVerifier certificateVerifier;
    protected final IPdfObjFactory pdfObjectFactory;

    protected PAdESLevelBaselineT(TSPSource tspSource, CertificateVerifier certificateVerifier, IPdfObjFactory pdfObjectFactory) {
        Objects.requireNonNull(tspSource, "TSPSource shall be defined!");
        Objects.requireNonNull(certificateVerifier, "CertificateVerifier shall be defined!");
        Objects.requireNonNull(pdfObjectFactory, "pdfObjectFactory shall be defined!");
        this.tspSource = tspSource;
        this.certificateVerifier = certificateVerifier;
        this.pdfObjectFactory = pdfObjectFactory;
    }

    public DSSDocument extendSignatures(DSSDocument document, PAdESSignatureParameters params) {
        this.assertExtensionPossible(document);
        PDFDocumentValidator pdfDocumentValidator = this.getPDFDocumentValidator(document, params);
        return this.extendSignatures(document, pdfDocumentValidator, params);
    }

    protected DSSDocument extendSignatures(DSSDocument document, PDFDocumentValidator documentValidator, PAdESSignatureParameters parameters) {
        List signatures = documentValidator.getSignatures();
        if (Utils.isCollectionEmpty((Collection)signatures)) {
            throw new IllegalInputException("No signatures found to be extended!");
        }
        boolean tLevelExtensionRequired = false;
        SignatureRequirementsChecker signatureRequirementsChecker = new SignatureRequirementsChecker(this.certificateVerifier, (AbstractSignatureParameters)parameters);
        for (AdvancedSignature signature : signatures) {
            PAdESSignature padesSignature = (PAdESSignature)signature;
            if (!this.requiresDocumentTimestamp(padesSignature, parameters)) continue;
            this.assertExtendSignatureToTPossible(padesSignature, parameters);
            signatureRequirementsChecker.assertSigningCertificateIsValid((AdvancedSignature)padesSignature);
            tLevelExtensionRequired = true;
        }
        if (tLevelExtensionRequired) {
            return this.timestampDocument(document, parameters.getSignatureTimestampParameters(), parameters.getPasswordProtection(), this.getSignatureTimestampService());
        }
        return document;
    }

    private PDFSignatureService getSignatureTimestampService() {
        return this.pdfObjectFactory.newSignatureTimestampService();
    }

    protected DSSDocument timestampDocument(DSSDocument document, PAdESTimestampParameters timestampParameters, char[] pwd, PDFSignatureService pdfSignatureService) {
        PAdESTimestampService padesTimestampService = new PAdESTimestampService(this.tspSource, pdfSignatureService);
        timestampParameters.setPasswordProtection(pwd);
        return padesTimestampService.timestampDocument(document, timestampParameters);
    }

    protected PDFDocumentValidator getPDFDocumentValidator(DSSDocument document, PAdESSignatureParameters parameters) {
        PDFDocumentValidator pdfDocumentValidator = new PDFDocumentValidator(document);
        pdfDocumentValidator.setCertificateVerifier(this.certificateVerifier);
        pdfDocumentValidator.setPasswordProtection(parameters.getPasswordProtection());
        pdfDocumentValidator.setPdfObjFactory(this.pdfObjectFactory);
        return pdfDocumentValidator;
    }

    protected void assertExtensionPossible(DSSDocument document) {
        if (!PAdESUtils.isPDFDocument(document)) {
            throw new IllegalInputException(String.format("Unable to extend the document with name '%s'. PDF document is expected!", document.getName()));
        }
    }

    private boolean requiresDocumentTimestamp(PAdESSignature signature, PAdESSignatureParameters signatureParameters) {
        return SignatureLevel.PAdES_BASELINE_T.equals((Object)signatureParameters.getSignatureLevel()) || !signature.hasTProfile();
    }

    private void assertExtendSignatureToTPossible(PAdESSignature signature, PAdESSignatureParameters parameters) {
        SignatureLevel signatureLevel = parameters.getSignatureLevel();
        if (SignatureLevel.PAdES_BASELINE_T.equals((Object)signatureLevel) || SignatureLevel.PAdES_BASELINE_LT.equals((Object)signatureLevel)) {
            if (signature.hasLTAProfile()) {
                throw new IllegalInputException(String.format("Cannot extend signature to '%s'. The signature is already extended with LTA level.", signatureLevel));
            }
            if (signature.hasLTProfile() && !signature.areAllSelfSignedCertificates()) {
                if (signature.hasTProfile()) {
                    throw new IllegalInputException(String.format("Cannot extend signature to '%s'. The signature is already extended with LT level.", signatureLevel));
                }
                LOG.info("Signature contains a DSS dictionary, but no associated timestamp. Extension may lead to LTA-level.");
            }
        }
    }
}

