/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf.pdfbox.visible.nativedrawer;

import eu.europa.esig.dss.enumerations.SignerTextHorizontalAlignment;
import eu.europa.esig.dss.enumerations.SignerTextVerticalAlignment;
import eu.europa.esig.dss.enumerations.VisualSignatureAlignmentHorizontal;
import eu.europa.esig.dss.enumerations.VisualSignatureAlignmentVertical;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.pades.SignatureFieldParameters;
import eu.europa.esig.dss.pades.SignatureImageParameters;
import eu.europa.esig.dss.pades.SignatureImageTextParameters;
import eu.europa.esig.dss.pdf.AnnotationBox;
import eu.europa.esig.dss.pdf.pdfbox.visible.ImageRotationUtils;
import eu.europa.esig.dss.pdf.pdfbox.visible.nativedrawer.PdfBoxFontMetrics;
import eu.europa.esig.dss.pdf.pdfbox.visible.nativedrawer.SignatureFieldDimensionAndPosition;
import eu.europa.esig.dss.pdf.visible.CommonDrawerUtils;
import eu.europa.esig.dss.pdf.visible.ImageAndResolution;
import eu.europa.esig.dss.pdf.visible.ImageUtils;
import java.io.IOException;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureFieldDimensionAndPositionBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(SignatureFieldDimensionAndPositionBuilder.class);
    private final SignatureImageParameters imageParameters;
    private final PDPage page;
    private final PDRectangle pageMediaBox;
    private final PDFont pdFont;
    private SignatureFieldDimensionAndPosition dimensionAndPosition;
    private static final String NOT_SUPPORTED_VERTICAL_ALIGNMENT_ERROR_MESSAGE = "not supported vertical alignment: ";
    private static final String NOT_SUPPORTED_HORIZONTAL_ALIGNMENT_ERROR_MESSAGE = "not supported horizontal alignment: ";

    public SignatureFieldDimensionAndPositionBuilder(SignatureImageParameters imageParameters, PDPage page, PDFont pdFont) {
        this.imageParameters = imageParameters;
        this.page = page;
        this.pageMediaBox = new PDRectangle(page.getMediaBox().getWidth(), page.getMediaBox().getHeight());
        this.pdFont = pdFont;
    }

    public SignatureFieldDimensionAndPosition build() throws IOException {
        this.dimensionAndPosition = new SignatureFieldDimensionAndPosition();
        this.initDpi();
        this.assignImageBoundaryBox();
        this.alignHorizontally();
        this.alignVertically();
        this.rotateSignatureField();
        return this.dimensionAndPosition;
    }

    private void initDpi() {
        if (this.imageParameters.getImage() != null) {
            ImageAndResolution imageAndResolution;
            try {
                imageAndResolution = ImageUtils.readDisplayMetadata((DSSDocument)this.imageParameters.getImage());
            }
            catch (Exception e) {
                LOG.warn("Cannot access the image metadata : {}. Returns default info.", (Object)e.getMessage());
                imageAndResolution = new ImageAndResolution(this.imageParameters.getImage(), this.imageParameters.getDpi().intValue(), this.imageParameters.getDpi().intValue());
            }
            this.dimensionAndPosition.setImageAndResolution(imageAndResolution);
            this.dimensionAndPosition.setImageDpi(this.imageParameters.getDpi());
        }
    }

    private void assignImageBoundaryBox() throws IOException {
        int rotation;
        AnnotationBox imageBoundaryBox = ImageUtils.getImageBoundaryBox((SignatureImageParameters)this.imageParameters);
        float imageWidth = imageBoundaryBox.getWidth();
        float imageHeight = imageBoundaryBox.getHeight();
        SignatureFieldParameters fieldParameters = this.imageParameters.getFieldParameters();
        if (fieldParameters.getWidth() == 0.0f) {
            imageWidth *= CommonDrawerUtils.getPageScaleFactor((Integer)this.dimensionAndPosition.getxDpi());
        }
        if (fieldParameters.getHeight() == 0.0f) {
            imageHeight *= CommonDrawerUtils.getPageScaleFactor((Integer)this.dimensionAndPosition.getyDpi());
        }
        float width = imageWidth;
        float height = imageHeight;
        SignatureImageTextParameters textParameters = this.imageParameters.getTextParameters();
        if (!textParameters.isEmpty()) {
            imageWidth = this.toDpiTextPoint(imageWidth, this.dimensionAndPosition.getxDpi());
            imageHeight = this.toDpiTextPoint(imageHeight, this.dimensionAndPosition.getyDpi());
            width = imageWidth;
            height = imageHeight;
            AnnotationBox textBox = this.computeTextDimension(textParameters);
            float textWidth = textBox.getWidth() * CommonDrawerUtils.getTextScaleFactor((Integer)this.imageParameters.getDpi());
            float textHeight = textBox.getHeight() * CommonDrawerUtils.getTextScaleFactor((Integer)this.imageParameters.getDpi());
            if (this.imageParameters.getImage() != null) {
                textWidth /= CommonDrawerUtils.getTextScaleFactor((Integer)this.dimensionAndPosition.getxDpi());
                textHeight /= CommonDrawerUtils.getTextScaleFactor((Integer)this.dimensionAndPosition.getyDpi());
            }
            switch (textParameters.getSignerTextPosition()) {
                case LEFT: {
                    if (fieldParameters.getWidth() == 0.0f) {
                        width += this.imageParameters.getImage() != null || width == 0.0f ? textWidth : 0.0f;
                    } else {
                        imageWidth -= this.imageParameters.getImage() != null || width == 0.0f ? textWidth : 0.0f;
                    }
                    if (fieldParameters.getHeight() == 0.0f) {
                        height = Math.max(height, textHeight);
                    }
                    this.dimensionAndPosition.setImageX(width - imageWidth);
                    this.textImageVerticalAlignment(height, imageHeight, textHeight);
                    break;
                }
                case RIGHT: {
                    if (fieldParameters.getWidth() == 0.0f) {
                        width += this.imageParameters.getImage() != null || width == 0.0f ? textWidth : 0.0f;
                    } else {
                        imageWidth -= this.imageParameters.getImage() != null || width == 0.0f ? textWidth : 0.0f;
                    }
                    if (fieldParameters.getHeight() == 0.0f) {
                        height = Math.max(height, textHeight);
                    }
                    this.dimensionAndPosition.setTextX(this.toDpiPagePoint(width - textWidth, this.dimensionAndPosition.getxDpi()));
                    this.textImageVerticalAlignment(height, imageHeight, textHeight);
                    break;
                }
                case TOP: {
                    if (fieldParameters.getWidth() == 0.0f) {
                        width = Math.max(width, textWidth);
                    }
                    if (fieldParameters.getHeight() == 0.0f) {
                        height += this.imageParameters.getImage() != null || height == 0.0f ? textHeight : 0.0f;
                    } else {
                        imageHeight -= this.imageParameters.getImage() != null || height == 0.0f ? textHeight : 0.0f;
                    }
                    this.dimensionAndPosition.setTextY(this.toDpiPagePoint(height - textHeight, this.dimensionAndPosition.getyDpi()));
                    this.textImageHorizontalAlignment(width, imageWidth, textWidth);
                    break;
                }
                case BOTTOM: {
                    if (fieldParameters.getWidth() == 0.0f) {
                        width = Math.max(width, textWidth);
                    }
                    if (fieldParameters.getHeight() == 0.0f) {
                        height += this.imageParameters.getImage() != null || height == 0.0f ? textHeight : 0.0f;
                    } else {
                        imageHeight -= this.imageParameters.getImage() != null || height == 0.0f ? textHeight : 0.0f;
                    }
                    this.dimensionAndPosition.setImageY(height - imageHeight);
                    this.textImageHorizontalAlignment(width, imageWidth, textWidth);
                    break;
                }
            }
            this.dimensionAndPosition.setTextWidth(this.toDpiPagePoint(textWidth, this.dimensionAndPosition.getxDpi()));
            this.dimensionAndPosition.setTextHeight(this.toDpiPagePoint(textHeight, this.dimensionAndPosition.getyDpi()));
            this.dimensionAndPosition.paddingShift(textParameters.getPadding());
            width = this.toDpiPagePoint(width, this.dimensionAndPosition.getxDpi());
            height = this.toDpiPagePoint(height, this.dimensionAndPosition.getyDpi());
        }
        if (ImageRotationUtils.isSwapOfDimensionsRequired(rotation = ImageRotationUtils.getRotation(this.imageParameters.getRotation(), this.page))) {
            float temp = width;
            width = height;
            height = temp;
            this.pageMediaBox.setUpperRightX(this.page.getMediaBox().getHeight());
            this.pageMediaBox.setUpperRightY(this.page.getMediaBox().getWidth());
        }
        this.dimensionAndPosition.setGlobalRotation(rotation);
        this.dimensionAndPosition.setImageWidth(imageWidth);
        this.dimensionAndPosition.setImageHeight(imageHeight);
        this.dimensionAndPosition.setBoxWidth(width);
        this.dimensionAndPosition.setBoxHeight(height);
    }

    private AnnotationBox computeTextDimension(SignatureImageTextParameters textParameters) throws IOException {
        float properSize = CommonDrawerUtils.computeProperSize((float)textParameters.getFont().getSize(), (float)this.imageParameters.getDpi().intValue());
        PdfBoxFontMetrics pdfBoxFontMetrics = new PdfBoxFontMetrics(this.pdFont);
        return pdfBoxFontMetrics.computeTextBoundaryBox(textParameters.getText(), properSize *= ImageUtils.getScaleFactor((int)this.imageParameters.getZoom()), textParameters.getPadding());
    }

    private void textImageVerticalAlignment(double height, double imageHeight, float textHeight) {
        SignerTextVerticalAlignment verticalAlignment = this.imageParameters.getTextParameters().getSignerTextVerticalAlignment();
        switch (verticalAlignment) {
            case TOP: {
                this.dimensionAndPosition.setTextY(this.toDpiPagePoint(height - (double)textHeight, this.dimensionAndPosition.getyDpi()));
                this.dimensionAndPosition.setImageY((float)(height - imageHeight));
                break;
            }
            case BOTTOM: {
                this.dimensionAndPosition.setTextY(0.0f);
                this.dimensionAndPosition.setImageY(0.0f);
                break;
            }
            case MIDDLE: {
                this.dimensionAndPosition.setTextY(this.toDpiPagePoint((height - (double)textHeight) / 2.0, this.dimensionAndPosition.getyDpi()));
                this.dimensionAndPosition.setImageY((float)(height - imageHeight) / 2.0f);
                break;
            }
            default: {
                throw new IllegalStateException(NOT_SUPPORTED_VERTICAL_ALIGNMENT_ERROR_MESSAGE + verticalAlignment);
            }
        }
    }

    private void textImageHorizontalAlignment(double width, double imageWidth, float textWidth) {
        SignerTextHorizontalAlignment horizontalAlignment = this.imageParameters.getTextParameters().getSignerTextHorizontalAlignment();
        switch (horizontalAlignment) {
            case LEFT: {
                this.dimensionAndPosition.setTextX(0.0f);
                this.dimensionAndPosition.setImageX(0.0f);
                break;
            }
            case RIGHT: {
                this.dimensionAndPosition.setTextX(this.toDpiPagePoint(width - (double)textWidth, this.dimensionAndPosition.getxDpi()));
                this.dimensionAndPosition.setImageX((float)(width - imageWidth));
                break;
            }
            case CENTER: {
                this.dimensionAndPosition.setTextX(this.toDpiPagePoint((width - (double)textWidth) / 2.0, this.dimensionAndPosition.getxDpi()));
                this.dimensionAndPosition.setImageX((float)(width - imageWidth) / 2.0f);
                break;
            }
            default: {
                throw new IllegalStateException(NOT_SUPPORTED_HORIZONTAL_ALIGNMENT_ERROR_MESSAGE + horizontalAlignment);
            }
        }
    }

    private void alignHorizontally() {
        float boxX;
        float boxWidth = this.dimensionAndPosition.getBoxWidth();
        if (ImageRotationUtils.isSwapOfDimensionsRequired(this.dimensionAndPosition.getGlobalRotation())) {
            boxWidth = this.dimensionAndPosition.getBoxHeight();
        }
        SignatureFieldParameters fieldParameters = this.imageParameters.getFieldParameters();
        VisualSignatureAlignmentHorizontal alignmentHorizontal = this.imageParameters.getVisualSignatureAlignmentHorizontal();
        switch (alignmentHorizontal) {
            case LEFT: 
            case NONE: {
                boxX = fieldParameters.getOriginX();
                break;
            }
            case CENTER: {
                boxX = (this.pageMediaBox.getWidth() - boxWidth) / 2.0f;
                break;
            }
            case RIGHT: {
                boxX = this.pageMediaBox.getWidth() - boxWidth - fieldParameters.getOriginX();
                break;
            }
            default: {
                throw new IllegalStateException(NOT_SUPPORTED_HORIZONTAL_ALIGNMENT_ERROR_MESSAGE + alignmentHorizontal);
            }
        }
        this.dimensionAndPosition.setBoxX(boxX);
    }

    private void alignVertically() {
        float boxY;
        float boxHeight = this.dimensionAndPosition.getBoxHeight();
        if (ImageRotationUtils.isSwapOfDimensionsRequired(this.dimensionAndPosition.getGlobalRotation())) {
            boxHeight = this.dimensionAndPosition.getBoxWidth();
        }
        SignatureFieldParameters fieldParameters = this.imageParameters.getFieldParameters();
        VisualSignatureAlignmentVertical alignmentVertical = this.imageParameters.getVisualSignatureAlignmentVertical();
        switch (alignmentVertical) {
            case TOP: 
            case NONE: {
                boxY = fieldParameters.getOriginY();
                break;
            }
            case MIDDLE: {
                boxY = (this.pageMediaBox.getHeight() - boxHeight) / 2.0f;
                break;
            }
            case BOTTOM: {
                boxY = this.pageMediaBox.getHeight() - boxHeight - fieldParameters.getOriginY();
                break;
            }
            default: {
                throw new IllegalStateException(NOT_SUPPORTED_VERTICAL_ALIGNMENT_ERROR_MESSAGE + alignmentVertical);
            }
        }
        this.dimensionAndPosition.setBoxY(boxY);
    }

    private void rotateSignatureField() {
        switch (this.dimensionAndPosition.getGlobalRotation()) {
            case 90: {
                float boxX = this.dimensionAndPosition.getBoxX();
                this.dimensionAndPosition.setBoxX(this.pageMediaBox.getHeight() - this.dimensionAndPosition.getBoxY() - this.dimensionAndPosition.getBoxWidth());
                this.dimensionAndPosition.setBoxY(boxX);
                break;
            }
            case 180: {
                this.dimensionAndPosition.setBoxX(this.pageMediaBox.getWidth() - this.dimensionAndPosition.getBoxX() - this.dimensionAndPosition.getBoxWidth());
                this.dimensionAndPosition.setBoxY(this.pageMediaBox.getHeight() - this.dimensionAndPosition.getBoxY() - this.dimensionAndPosition.getBoxHeight());
                break;
            }
            case 270: {
                float boxX = this.dimensionAndPosition.getBoxX();
                this.dimensionAndPosition.setBoxX(this.dimensionAndPosition.getBoxY());
                this.dimensionAndPosition.setBoxY(this.pageMediaBox.getWidth() - boxX - this.dimensionAndPosition.getBoxHeight());
                break;
            }
            case 360: {
                break;
            }
            default: {
                throw new IllegalStateException("rotation angle must be 90, 180, 270 or 360 (0)");
            }
        }
    }

    private float toDpiPagePoint(double x, Integer dpi) {
        return CommonDrawerUtils.toDpiAxisPoint((float)((float)x), (float)CommonDrawerUtils.getDpi((Integer)dpi));
    }

    private float toDpiTextPoint(double x, Integer dpi) {
        return CommonDrawerUtils.computeProperSize((float)((float)x), (float)CommonDrawerUtils.getDpi((Integer)dpi));
    }
}

