/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf.pdfbox.visible.nativedrawer;

import eu.europa.esig.dss.enumerations.VisualSignatureRotation;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.pades.DSSFileFont;
import eu.europa.esig.dss.pades.DSSFont;
import eu.europa.esig.dss.pades.PAdESUtils;
import eu.europa.esig.dss.pades.SignatureImageParameters;
import eu.europa.esig.dss.pades.SignatureImageTextParameters;
import eu.europa.esig.dss.pdf.pdfbox.PdfBoxUtils;
import eu.europa.esig.dss.pdf.pdfbox.visible.AbstractPdfBoxSignatureDrawer;
import eu.europa.esig.dss.pdf.pdfbox.visible.PdfBoxNativeFont;
import eu.europa.esig.dss.pdf.pdfbox.visible.nativedrawer.PdfBoxDSSFontMetrics;
import eu.europa.esig.dss.pdf.pdfbox.visible.nativedrawer.PdfBoxFontMapper;
import eu.europa.esig.dss.pdf.visible.DSSFontMetrics;
import eu.europa.esig.dss.pdf.visible.ImageRotationUtils;
import eu.europa.esig.dss.pdf.visible.SignatureFieldDimensionAndPosition;
import eu.europa.esig.dss.signature.resources.DSSResourcesHandler;
import eu.europa.esig.dss.signature.resources.DSSResourcesHandlerBuilder;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.pdmodel.graphics.state.PDExtendedGraphicsState;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceDictionary;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceStream;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureOptions;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDSignatureField;
import org.apache.pdfbox.util.Matrix;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativePdfBoxVisibleSignatureDrawer
extends AbstractPdfBoxSignatureDrawer {
    private static final Logger LOG = LoggerFactory.getLogger(NativePdfBoxVisibleSignatureDrawer.class);
    private PDFont pdFont;
    private static final float OPAQUE_VALUE = 255.0f;
    private DSSResourcesHandlerBuilder resourcesHandlerBuilder = PAdESUtils.DEFAULT_RESOURCES_HANDLER_BUILDER;

    @Deprecated
    public void setEmbedFontSubset(boolean embedFontSubset) {
        LOG.warn("Use of deprecated method! The use of the method will not take effect on processing. Please use DSSFileFont.setEmbedFontSubset(embedFontSubset) method.");
    }

    public void setResourcesHandlerBuilder(DSSResourcesHandlerBuilder resourcesHandlerBuilder) {
        this.resourcesHandlerBuilder = resourcesHandlerBuilder;
    }

    @Override
    public void init(SignatureImageParameters parameters, PDDocument document, SignatureOptions signatureOptions) throws IOException {
        super.init(parameters, document, signatureOptions);
        if (!parameters.getTextParameters().isEmpty()) {
            this.pdFont = this.initFont();
        }
    }

    private PDFont initFont() throws IOException {
        DSSFont dssFont = this.parameters.getTextParameters().getFont();
        if (dssFont instanceof PdfBoxNativeFont) {
            PdfBoxNativeFont nativeFont = (PdfBoxNativeFont)dssFont;
            return nativeFont.getFont();
        }
        if (dssFont instanceof DSSFileFont) {
            DSSFileFont fileFont = (DSSFileFont)dssFont;
            try (InputStream is = fileFont.getInputStream();){
                PDType0Font pDType0Font = PDType0Font.load((PDDocument)this.document, (InputStream)is, (boolean)fileFont.isEmbedFontSubset());
                return pDType0Font;
            }
        }
        return PdfBoxFontMapper.getPDFont(dssFont.getJavaFont());
    }

    @Override
    protected DSSFontMetrics getDSSFontMetrics() {
        return new PdfBoxDSSFontMetrics(this.pdFont);
    }

    public void draw() throws IOException {
        try (DSSResourcesHandler resourcesHandler = this.resourcesHandlerBuilder.createResourcesHandler();
             OutputStream os = resourcesHandler.createOutputStream();
             PDDocument doc = new PDDocument();){
            int pageNumber = this.parameters.getFieldParameters().getPage() - 1;
            PDPage originalPage = this.document.getPage(pageNumber);
            SignatureFieldDimensionAndPosition dimensionAndPosition = this.buildSignatureFieldBox();
            PDPage page = new PDPage(originalPage.getMediaBox());
            doc.addPage(page);
            PDAcroForm acroForm = new PDAcroForm(doc);
            doc.getDocumentCatalog().setAcroForm(acroForm);
            PDSignatureField signatureField = new PDSignatureField(acroForm);
            PDAnnotationWidget widget = (PDAnnotationWidget)signatureField.getWidgets().get(0);
            List acroFormFields = acroForm.getFields();
            acroForm.setSignaturesExist(true);
            acroForm.setAppendOnly(true);
            acroForm.getCOSObject().setDirect(true);
            acroFormFields.add(signatureField);
            PDRectangle rectangle = this.getPdRectangle(dimensionAndPosition, page);
            widget.setRectangle(rectangle);
            PDAppearanceDictionary appearance = PdfBoxUtils.createSignatureAppearanceDictionary(doc, rectangle);
            widget.setAppearance(appearance);
            PDAppearanceStream appearanceStream = appearance.getNormalAppearance().getAppearanceStream();
            try (PDPageContentStream cs = new PDPageContentStream(doc, appearanceStream);){
                this.rotateSignature(cs, rectangle, dimensionAndPosition);
                this.setFieldBackground(cs, this.parameters.getBackgroundColor());
                this.setText(cs, dimensionAndPosition, this.parameters);
                this.setImage(cs, doc, dimensionAndPosition, this.parameters.getImage());
            }
            doc.save(os);
            DSSDocument document = resourcesHandler.writeToDSSDocument();
            try (InputStream is = document.openStream();){
                this.signatureOptions.setVisualSignature(is);
                this.signatureOptions.setPage(pageNumber);
            }
        }
    }

    private void rotateSignature(PDPageContentStream cs, PDRectangle rectangle, SignatureFieldDimensionAndPosition dimensionAndPosition) throws IOException {
        switch (dimensionAndPosition.getGlobalRotation()) {
            case 90: {
                cs.transform(Matrix.getRotateInstance((double)Math.toRadians(270.0), (float)0.0f, (float)0.0f));
                cs.transform(Matrix.getTranslateInstance((float)(-rectangle.getHeight()), (float)0.0f));
                break;
            }
            case 180: {
                cs.transform(Matrix.getRotateInstance((double)Math.toRadians(180.0), (float)0.0f, (float)0.0f));
                cs.transform(Matrix.getTranslateInstance((float)(-rectangle.getWidth()), (float)(-rectangle.getHeight())));
                break;
            }
            case 270: {
                cs.transform(Matrix.getRotateInstance((double)Math.toRadians(90.0), (float)0.0f, (float)0.0f));
                cs.transform(Matrix.getTranslateInstance((float)0.0f, (float)(-rectangle.getWidth())));
                break;
            }
            case 0: 
            case 360: {
                break;
            }
            default: {
                throw new IllegalStateException("rotation angle must be 90, 180, 270 or 360 (0)");
            }
        }
    }

    private void setFieldBackground(PDPageContentStream cs, Color color) throws IOException {
        this.setBackground(cs, color, new PDRectangle(-5000.0f, -5000.0f, 10000.0f, 10000.0f));
    }

    private void setBackground(PDPageContentStream cs, Color color, PDRectangle rect) throws IOException {
        if (color != null) {
            this.setAlphaChannel(cs, color);
            this.setNonStrokingColor(cs, color);
            cs.addRect(rect.getLowerLeftX(), rect.getLowerLeftY(), rect.getWidth(), rect.getHeight());
            cs.fill();
            this.cleanTransparency(cs, color);
        }
    }

    private void setImage(PDPageContentStream cs, PDDocument doc, SignatureFieldDimensionAndPosition dimensionAndPosition, DSSDocument image) throws IOException {
        if (image != null) {
            try (InputStream is = image.openStream();){
                cs.saveGraphicsState();
                byte[] bytes = IOUtils.toByteArray((InputStream)is);
                PDImageXObject imageXObject = PDImageXObject.createFromByteArray((PDDocument)doc, (byte[])bytes, (String)image.getName());
                float xAxis = dimensionAndPosition.getImageX();
                float yAxis = dimensionAndPosition.getImageY();
                float width = dimensionAndPosition.getImageWidth();
                float height = dimensionAndPosition.getImageHeight();
                cs.drawImage(imageXObject, xAxis, yAxis, width, height);
                cs.transform(Matrix.getRotateInstance((double)(360.0 - (double)ImageRotationUtils.getRotation((VisualSignatureRotation)this.parameters.getRotation())), (float)width, (float)height));
                cs.restoreGraphicsState();
            }
        }
    }

    private void setText(PDPageContentStream cs, SignatureFieldDimensionAndPosition dimensionAndPosition, SignatureImageParameters parameters) throws IOException {
        SignatureImageTextParameters textParameters = parameters.getTextParameters();
        if (!textParameters.isEmpty()) {
            this.setTextBackground(cs, textParameters, dimensionAndPosition);
            float fontSize = dimensionAndPosition.getTextSize();
            cs.beginText();
            cs.setFont(this.pdFont, fontSize);
            this.setNonStrokingColor(cs, textParameters.getTextColor());
            this.setAlphaChannel(cs, textParameters.getTextColor());
            PdfBoxDSSFontMetrics pdfBoxFontMetrics = new PdfBoxDSSFontMetrics(this.pdFont);
            String text = dimensionAndPosition.getText();
            String[] strings = pdfBoxFontMetrics.getLines(text);
            float lineHeight = pdfBoxFontMetrics.getHeight(text, dimensionAndPosition.getTextSize());
            cs.setLeading(lineHeight);
            cs.newLineAtOffset(dimensionAndPosition.getTextX(), dimensionAndPosition.getTextHeight() + dimensionAndPosition.getTextY() - fontSize);
            float previousOffset = 0.0f;
            for (String str : strings) {
                float stringWidth = pdfBoxFontMetrics.getWidth(str, fontSize);
                float offsetX = 0.0f;
                switch (textParameters.getSignerTextHorizontalAlignment()) {
                    case RIGHT: {
                        offsetX = dimensionAndPosition.getTextWidth() - stringWidth - previousOffset;
                        break;
                    }
                    case CENTER: {
                        offsetX = (dimensionAndPosition.getTextWidth() - stringWidth) / 2.0f - previousOffset;
                        break;
                    }
                }
                previousOffset += offsetX;
                cs.newLineAtOffset(offsetX, 0.0f);
                cs.showText(str);
                cs.newLine();
            }
            cs.endText();
            this.cleanTransparency(cs, textParameters.getTextColor());
        }
    }

    private void setTextBackground(PDPageContentStream cs, SignatureImageTextParameters textParameters, SignatureFieldDimensionAndPosition dimensionAndPosition) throws IOException {
        if (textParameters.getBackgroundColor() != null) {
            PDRectangle rect = new PDRectangle(dimensionAndPosition.getTextBoxX(), dimensionAndPosition.getTextBoxY(), dimensionAndPosition.getTextBoxWidth(), dimensionAndPosition.getTextBoxHeight());
            this.setBackground(cs, textParameters.getBackgroundColor(), rect);
        }
    }

    private void setNonStrokingColor(PDPageContentStream cs, Color color) throws IOException {
        if (color != null) {
            cs.setNonStrokingColor(color);
        }
    }

    private void setAlphaChannel(PDPageContentStream cs, Color color) throws IOException {
        float alpha;
        if (color != null && (alpha = (float)color.getAlpha()) < 255.0f) {
            LOG.warn("Transparency detected and enabled (Be aware: not valid with PDF/A !)");
            this.setAlpha(cs, alpha);
        }
    }

    private void setAlpha(PDPageContentStream cs, float alpha) throws IOException {
        PDExtendedGraphicsState gs = new PDExtendedGraphicsState();
        gs.setNonStrokingAlphaConstant(Float.valueOf(alpha / 255.0f));
        cs.setGraphicsStateParameters(gs);
    }

    private void cleanTransparency(PDPageContentStream cs, Color color) throws IOException {
        float alpha;
        if (color != null && (alpha = (float)color.getAlpha()) < 255.0f) {
            this.setAlpha(cs, 255.0f);
        }
    }

    private PDRectangle getPdRectangle(SignatureFieldDimensionAndPosition dimensionAndPosition, PDPage page) {
        PDRectangle pageRect = page.getMediaBox();
        PDRectangle pdRectangle = new PDRectangle();
        pdRectangle.setLowerLeftX(dimensionAndPosition.getBoxX());
        pdRectangle.setLowerLeftY(pageRect.getHeight() - dimensionAndPosition.getBoxY() - dimensionAndPosition.getBoxHeight());
        pdRectangle.setUpperRightX(dimensionAndPosition.getBoxX() + dimensionAndPosition.getBoxWidth());
        pdRectangle.setUpperRightY(pageRect.getHeight() - dimensionAndPosition.getBoxY());
        return pdRectangle;
    }

    @Override
    protected String getExpectedColorSpaceName() throws IOException {
        if (this.parameters.getImage() != null) {
            try (InputStream is = this.parameters.getImage().openStream();){
                byte[] bytes = IOUtils.toByteArray((InputStream)is);
                PDImageXObject imageXObject = PDImageXObject.createFromByteArray((PDDocument)this.document, (byte[])bytes, (String)this.parameters.getImage().getName());
                PDColorSpace colorSpace = imageXObject.getColorSpace();
                String string = colorSpace.getName();
                return string;
            }
        }
        return COSName.DEVICERGB.getName();
    }
}

