/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class SignerLocation
implements Serializable {
    private List<String> postalAddress = new ArrayList<String>();
    private String postOfficeBoxNumber;
    private String postalCode;
    private String locality;
    private String stateOrProvince;
    private String country;
    private String streetAddress;

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getLocality() {
        return this.locality;
    }

    public void setLocality(String locality) {
        this.locality = locality;
    }

    public List<String> getPostalAddress() {
        return this.postalAddress;
    }

    public void setPostalAddress(List<String> postalAddress) {
        this.postalAddress = postalAddress;
    }

    public void addPostalAddress(String addressItem) {
        if (this.postalAddress == null) {
            this.postalAddress = new ArrayList<String>();
        }
        this.postalAddress.add(addressItem);
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public String getPostOfficeBoxNumber() {
        return this.postOfficeBoxNumber;
    }

    public void setPostOfficeBoxNumber(String postOfficeBoxNumber) {
        this.postOfficeBoxNumber = postOfficeBoxNumber;
    }

    public String getStateOrProvince() {
        return this.stateOrProvince;
    }

    public void setStateOrProvince(String stateOrProvince) {
        this.stateOrProvince = stateOrProvince;
    }

    public String getStreetAddress() {
        return this.streetAddress;
    }

    @Deprecated
    public void setStreet(String street) {
        this.streetAddress = street;
    }

    public void setStreetAddress(String streetAddress) {
        this.streetAddress = streetAddress;
    }

    public boolean isEmpty() {
        if (this.postalAddress != null && !this.postalAddress.isEmpty()) {
            return false;
        }
        if (this.postalCode != null && !this.postalCode.isEmpty()) {
            return false;
        }
        if (this.postOfficeBoxNumber != null && !this.postOfficeBoxNumber.isEmpty()) {
            return false;
        }
        if (this.locality != null && !this.locality.isEmpty()) {
            return false;
        }
        if (this.stateOrProvince != null && !this.stateOrProvince.isEmpty()) {
            return false;
        }
        if (this.country != null && !this.country.isEmpty()) {
            return false;
        }
        return this.streetAddress == null || this.streetAddress.isEmpty();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.country == null ? 0 : this.country.hashCode());
        result = 31 * result + (this.locality == null ? 0 : this.locality.hashCode());
        result = 31 * result + (this.postOfficeBoxNumber == null ? 0 : this.postOfficeBoxNumber.hashCode());
        result = 31 * result + (this.postalAddress == null ? 0 : this.postalAddress.hashCode());
        result = 31 * result + (this.postalCode == null ? 0 : this.postalCode.hashCode());
        result = 31 * result + (this.stateOrProvince == null ? 0 : this.stateOrProvince.hashCode());
        result = 31 * result + (this.streetAddress == null ? 0 : this.streetAddress.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SignerLocation other = (SignerLocation)obj;
        if (!Objects.equals(this.country, other.country)) {
            return false;
        }
        if (!Objects.equals(this.locality, other.locality)) {
            return false;
        }
        if (!Objects.equals(this.postOfficeBoxNumber, other.postOfficeBoxNumber)) {
            return false;
        }
        if (!Objects.equals(this.postalAddress, other.postalAddress)) {
            return false;
        }
        if (!Objects.equals(this.postalCode, other.postalCode)) {
            return false;
        }
        if (!Objects.equals(this.stateOrProvince, other.stateOrProvince)) {
            return false;
        }
        return Objects.equals(this.streetAddress, other.streetAddress);
    }

    public String toString() {
        return "SignerLocation [postalAddress=" + this.postalAddress + ", postOfficeBoxNumber=" + this.postOfficeBoxNumber + ", postalCode=" + this.postalCode + ", locality=" + this.locality + ", stateOrProvince=" + this.stateOrProvince + ", country=" + this.country + ", street=" + this.streetAddress + "]";
    }
}

