/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.model;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.enumerations.MaskGenerationFunction;
import eu.europa.esig.dss.enumerations.SignatureAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.enumerations.SignaturePackaging;
import eu.europa.esig.dss.model.BLevelParameters;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.SerializableSignatureParameters;
import eu.europa.esig.dss.model.SerializableTimestampParameters;
import java.util.Objects;

public abstract class AbstractSerializableSignatureParameters<TP extends SerializableTimestampParameters>
implements SerializableSignatureParameters {
    private boolean signWithExpiredCertificate = false;
    private boolean generateTBSWithoutCertificate = false;
    private SignatureLevel signatureLevel;
    private SignaturePackaging signaturePackaging;
    private SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.RSA_SHA256;
    private EncryptionAlgorithm encryptionAlgorithm = this.signatureAlgorithm.getEncryptionAlgorithm();
    private DigestAlgorithm digestAlgorithm = this.signatureAlgorithm.getDigestAlgorithm();
    private DigestAlgorithm referenceDigestAlgorithm;
    private MaskGenerationFunction maskGenerationFunction = this.signatureAlgorithm.getMaskGenerationFunction();
    private BLevelParameters bLevelParams = new BLevelParameters();
    protected TP contentTimestampParameters;
    protected TP signatureTimestampParameters;
    protected TP archiveTimestampParameters;

    @Override
    public boolean isSignWithExpiredCertificate() {
        return this.signWithExpiredCertificate;
    }

    public void setSignWithExpiredCertificate(boolean signWithExpiredCertificate) {
        this.signWithExpiredCertificate = signWithExpiredCertificate;
    }

    @Override
    public boolean isGenerateTBSWithoutCertificate() {
        return this.generateTBSWithoutCertificate;
    }

    public void setGenerateTBSWithoutCertificate(boolean generateTBSWithoutCertificate) {
        this.generateTBSWithoutCertificate = generateTBSWithoutCertificate;
    }

    public SignatureLevel getSignatureLevel() {
        return this.signatureLevel;
    }

    public void setSignatureLevel(SignatureLevel signatureLevel) {
        Objects.requireNonNull(signatureLevel, "Signature Level cannot be null");
        this.signatureLevel = signatureLevel;
    }

    public SignaturePackaging getSignaturePackaging() {
        return this.signaturePackaging;
    }

    public void setSignaturePackaging(SignaturePackaging signaturePackaging) {
        this.signaturePackaging = signaturePackaging;
    }

    @Override
    public DigestAlgorithm getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public void setDigestAlgorithm(DigestAlgorithm digestAlgorithm) {
        Objects.requireNonNull(digestAlgorithm, "DigestAlgorithm cannot be null!");
        this.digestAlgorithm = digestAlgorithm;
        if (this.encryptionAlgorithm != null) {
            this.signatureAlgorithm = SignatureAlgorithm.getAlgorithm((EncryptionAlgorithm)this.encryptionAlgorithm, (DigestAlgorithm)this.digestAlgorithm, (MaskGenerationFunction)this.maskGenerationFunction);
        }
    }

    public void setEncryptionAlgorithm(EncryptionAlgorithm encryptionAlgorithm) {
        this.encryptionAlgorithm = encryptionAlgorithm;
        if (this.digestAlgorithm != null) {
            this.signatureAlgorithm = SignatureAlgorithm.getAlgorithm((EncryptionAlgorithm)this.encryptionAlgorithm, (DigestAlgorithm)this.digestAlgorithm, (MaskGenerationFunction)this.maskGenerationFunction);
        }
    }

    public void setMaskGenerationFunction(MaskGenerationFunction maskGenerationFunction) {
        this.maskGenerationFunction = maskGenerationFunction;
        if (this.digestAlgorithm != null && this.encryptionAlgorithm != null) {
            this.signatureAlgorithm = SignatureAlgorithm.getAlgorithm((EncryptionAlgorithm)this.encryptionAlgorithm, (DigestAlgorithm)this.digestAlgorithm, (MaskGenerationFunction)this.maskGenerationFunction);
        }
    }

    public EncryptionAlgorithm getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public SignatureAlgorithm getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    @Override
    public MaskGenerationFunction getMaskGenerationFunction() {
        return this.maskGenerationFunction;
    }

    public DigestAlgorithm getReferenceDigestAlgorithm() {
        return this.referenceDigestAlgorithm;
    }

    public void setReferenceDigestAlgorithm(DigestAlgorithm referenceDigestAlgorithm) {
        this.referenceDigestAlgorithm = referenceDigestAlgorithm;
    }

    @Override
    public BLevelParameters bLevel() {
        return this.bLevelParams;
    }

    public void setBLevelParams(BLevelParameters bLevelParams) {
        Objects.requireNonNull(bLevelParams, "bLevelParams cannot be null!");
        this.bLevelParams = bLevelParams;
    }

    public TP getContentTimestampParameters() {
        throw new DSSException("Cannot extract ContentTimestampParameters! Not implemented by default.");
    }

    public void setContentTimestampParameters(TP contentTimestampParameters) {
        this.contentTimestampParameters = contentTimestampParameters;
    }

    public TP getSignatureTimestampParameters() {
        throw new DSSException("Cannot extract SignatureTimestampParameters! Not implemented by default.");
    }

    public void setSignatureTimestampParameters(TP signatureTimestampParameters) {
        this.signatureTimestampParameters = signatureTimestampParameters;
    }

    public TP getArchiveTimestampParameters() {
        throw new DSSException("Cannot extract ArchiveTimestampParameters! Not implemented by default.");
    }

    public void setArchiveTimestampParameters(TP archiveTimestampParameters) {
        this.archiveTimestampParameters = archiveTimestampParameters;
    }

    public String toString() {
        return "AbstractSerializableSignatureParameters [signWithExpiredCertificate=" + this.signWithExpiredCertificate + ", generateTBSWithoutCertificate=" + this.generateTBSWithoutCertificate + ", signatureLevel=" + this.signatureLevel + ", signaturePackaging=" + this.signaturePackaging + ", signatureAlgorithm=" + this.signatureAlgorithm + ", encryptionAlgorithm=" + this.encryptionAlgorithm + ", digestAlgorithm=" + this.digestAlgorithm + ", referenceDigestAlgorithm=" + this.referenceDigestAlgorithm + ", maskGenerationFunction=" + this.maskGenerationFunction + ", bLevelParams=" + this.bLevelParams + ", contentTimestampParameters=" + this.contentTimestampParameters + ", signatureTimestampParameters=" + this.signatureTimestampParameters + ", archiveTimestampParameters=" + this.archiveTimestampParameters + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.archiveTimestampParameters == null ? 0 : this.archiveTimestampParameters.hashCode());
        result = 31 * result + (this.bLevelParams == null ? 0 : this.bLevelParams.hashCode());
        result = 31 * result + (this.contentTimestampParameters == null ? 0 : this.contentTimestampParameters.hashCode());
        result = 31 * result + (this.digestAlgorithm == null ? 0 : this.digestAlgorithm.hashCode());
        result = 31 * result + (this.encryptionAlgorithm == null ? 0 : this.encryptionAlgorithm.hashCode());
        result = 31 * result + (this.generateTBSWithoutCertificate ? 1231 : 1237);
        result = 31 * result + (this.maskGenerationFunction == null ? 0 : this.maskGenerationFunction.hashCode());
        result = 31 * result + (this.referenceDigestAlgorithm == null ? 0 : this.referenceDigestAlgorithm.hashCode());
        result = 31 * result + (this.signWithExpiredCertificate ? 1231 : 1237);
        result = 31 * result + (this.signatureAlgorithm == null ? 0 : this.signatureAlgorithm.hashCode());
        result = 31 * result + (this.signatureLevel == null ? 0 : this.signatureLevel.hashCode());
        result = 31 * result + (this.signaturePackaging == null ? 0 : this.signaturePackaging.hashCode());
        result = 31 * result + (this.signatureTimestampParameters == null ? 0 : this.signatureTimestampParameters.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractSerializableSignatureParameters other = (AbstractSerializableSignatureParameters)obj;
        if (this.archiveTimestampParameters == null ? other.archiveTimestampParameters != null : !this.archiveTimestampParameters.equals(other.archiveTimestampParameters)) {
            return false;
        }
        if (this.bLevelParams == null ? other.bLevelParams != null : !this.bLevelParams.equals(other.bLevelParams)) {
            return false;
        }
        if (this.contentTimestampParameters == null ? other.contentTimestampParameters != null : !this.contentTimestampParameters.equals(other.contentTimestampParameters)) {
            return false;
        }
        if (this.digestAlgorithm != other.digestAlgorithm) {
            return false;
        }
        if (this.encryptionAlgorithm != other.encryptionAlgorithm) {
            return false;
        }
        if (this.generateTBSWithoutCertificate != other.generateTBSWithoutCertificate) {
            return false;
        }
        if (this.maskGenerationFunction != other.maskGenerationFunction) {
            return false;
        }
        if (this.referenceDigestAlgorithm != other.referenceDigestAlgorithm) {
            return false;
        }
        if (this.signWithExpiredCertificate != other.signWithExpiredCertificate) {
            return false;
        }
        if (this.signatureAlgorithm != other.signatureAlgorithm) {
            return false;
        }
        if (this.signatureLevel != other.signatureLevel) {
            return false;
        }
        if (this.signaturePackaging != other.signaturePackaging) {
            return false;
        }
        return !(this.signatureTimestampParameters == null ? other.signatureTimestampParameters != null : !this.signatureTimestampParameters.equals(other.signatureTimestampParameters));
    }
}

