/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss;

import eu.europa.esig.dss.DigestAlgorithm;
import java.io.Serializable;
import java.util.Arrays;
import javax.xml.bind.DatatypeConverter;

public final class Digest
implements Serializable {
    private DigestAlgorithm algorithm;
    private byte[] value;

    public Digest() {
    }

    public Digest(DigestAlgorithm algorithm, byte[] value) {
        this.algorithm = algorithm;
        this.value = value;
    }

    public String toString() {
        return this.algorithm.getName() + ":" + DatatypeConverter.printBase64Binary((byte[])this.value);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.algorithm == null ? 0 : this.algorithm.hashCode());
        result = 31 * result + Arrays.hashCode(this.value);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Digest other = (Digest)obj;
        if (this.algorithm != other.algorithm) {
            return false;
        }
        return Arrays.equals(this.value, other.value);
    }

    public DigestAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(DigestAlgorithm algorithm) {
        this.algorithm = algorithm;
    }

    public byte[] getValue() {
        return this.value;
    }

    public void setValue(byte[] value) {
        this.value = value;
    }
}

