/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.enumerations;

import eu.europa.esig.dss.enumerations.OidBasedEnum;
import java.security.Key;
import java.util.HashMap;
import java.util.Map;

public enum EncryptionAlgorithm implements OidBasedEnum
{
    RSA("RSA", "1.2.840.113549.1.1.1", "RSA/ECB/PKCS1Padding"),
    DSA("DSA", "1.2.840.10040.4.1", "DSA"),
    ECDSA("ECDSA", "1.2.840.10045.2.1", "ECDSA"),
    PLAIN_ECDSA("PLAIN-ECDSA", "0.4.0.127.0.7.1.1.4.1", "PLAIN-ECDSA"),
    X25519("X25519", "1.3.101.110", "X25519"),
    X448("X448", "1.3.101.111", "X448"),
    EDDSA("EdDSA", "", "EdDSA"),
    HMAC("HMAC", "", "");

    private String name;
    private String oid;
    private String padding;

    public static EncryptionAlgorithm forOID(String oid) {
        EncryptionAlgorithm algorithm = (EncryptionAlgorithm)Registry.OID_ALGORITHMS.get(oid);
        if (algorithm == null) {
            throw new IllegalArgumentException("Unsupported algorithm: " + oid);
        }
        return algorithm;
    }

    public static EncryptionAlgorithm forKey(Key key) {
        return EncryptionAlgorithm.forName(key.getAlgorithm());
    }

    public static EncryptionAlgorithm forName(String name) {
        if ("EC".equals(name) || "ECC".equals(name)) {
            return ECDSA;
        }
        if ("Ed25519".equals(name) || "Ed448".equals(name)) {
            return EDDSA;
        }
        if ("RSASSA-PSS".equals(name)) {
            return RSA;
        }
        for (EncryptionAlgorithm encryptionAlgo : EncryptionAlgorithm.values()) {
            if (!encryptionAlgo.getName().equals(name) && !encryptionAlgo.name().equals(name)) continue;
            return encryptionAlgo;
        }
        throw new IllegalArgumentException("Unsupported algorithm: " + name);
    }

    public static EncryptionAlgorithm forName(String name, EncryptionAlgorithm defaultValue) {
        try {
            return EncryptionAlgorithm.forName(name);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    private EncryptionAlgorithm(String name, String oid, String padding) {
        this.name = name;
        this.oid = oid;
        this.padding = padding;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getOid() {
        return this.oid;
    }

    public String getPadding() {
        return this.padding;
    }

    public boolean isEquivalent(EncryptionAlgorithm encryptionAlgorithm) {
        if (this == encryptionAlgorithm) {
            return true;
        }
        if (this.isEcDSAFamily() && encryptionAlgorithm.isEcDSAFamily()) {
            return true;
        }
        return this.isEdDSAFamily() && encryptionAlgorithm.isEdDSAFamily();
    }

    private boolean isEcDSAFamily() {
        return ECDSA == this || PLAIN_ECDSA == this;
    }

    private boolean isEdDSAFamily() {
        return X25519 == this || X448 == this || EDDSA == this;
    }

    private static class Registry {
        private static final Map<String, EncryptionAlgorithm> OID_ALGORITHMS = Registry.registerOIDAlgorithms();

        private Registry() {
        }

        private static Map<String, EncryptionAlgorithm> registerOIDAlgorithms() {
            HashMap<String, EncryptionAlgorithm> map = new HashMap<String, EncryptionAlgorithm>();
            for (EncryptionAlgorithm encryptionAlgorithm : EncryptionAlgorithm.values()) {
                map.put(encryptionAlgorithm.oid, encryptionAlgorithm);
            }
            return map;
        }
    }
}

