/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.diagnostic.jaxb.XmlDigestAlgoAndValue;
import eu.europa.esig.dss.diagnostic.jaxb.XmlPolicy;
import eu.europa.esig.dss.diagnostic.jaxb.XmlPolicyDigestAlgoAndValue;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSignaturePolicyStore;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.SignaturePolicyStore;
import eu.europa.esig.dss.model.SpDocSpecification;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.SignaturePolicy;
import eu.europa.esig.dss.validation.policy.SignaturePolicyValidationResult;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class XmlPolicyBuilder {
    private final SignaturePolicy signaturePolicy;
    private final SignaturePolicyValidationResult validationResult;
    private SignaturePolicyStore signaturePolicyStore;

    public XmlPolicyBuilder(SignaturePolicy signaturePolicy, SignaturePolicyValidationResult validationResult) {
        Objects.requireNonNull(signaturePolicy, "SignaturePolicy cannot be null!");
        Objects.requireNonNull(validationResult, "The result of a signature policy validation cannot be null!");
        this.signaturePolicy = signaturePolicy;
        this.validationResult = validationResult;
    }

    public XmlPolicyBuilder setSignaturePolicyStore(SignaturePolicyStore signaturePolicyStore) {
        this.signaturePolicyStore = signaturePolicyStore;
        return this;
    }

    public XmlPolicy build() {
        XmlPolicy xmlPolicy = new XmlPolicy();
        xmlPolicy.setId(this.signaturePolicy.getIdentifier());
        xmlPolicy.setUrl(DSSUtils.removeControlCharacters((String)this.signaturePolicy.getUrl()));
        xmlPolicy.setNotice(this.signaturePolicy.getNotice());
        xmlPolicy.setDocSpecification(this.signaturePolicy.getDocSpecification());
        xmlPolicy.setDescription(this.signaturePolicy.getDescription());
        xmlPolicy.setDocumentationReferences(this.signaturePolicy.getDocumentationReferences());
        List<String> transformsDescription = this.signaturePolicy.getTransformsDescription();
        if (Utils.isCollectionNotEmpty(transformsDescription)) {
            xmlPolicy.setTransformations(transformsDescription);
        }
        XmlPolicyDigestAlgoAndValue xmlPolicyDigestAlgoAndValue = new XmlPolicyDigestAlgoAndValue();
        if (this.signaturePolicy.isZeroHash()) {
            xmlPolicyDigestAlgoAndValue.setZeroHash(Boolean.valueOf(this.signaturePolicy.isZeroHash()));
        } else {
            xmlPolicyDigestAlgoAndValue.setDigestAlgorithmsEqual(Boolean.valueOf(this.validationResult.isDigestAlgorithmsEqual()));
        }
        Digest digest = this.signaturePolicy.getDigest();
        if (digest != null) {
            XmlDigestAlgoAndValue xmlDigestAlgoAndValue = this.getXmlDigestAlgoAndValue(digest);
            xmlPolicyDigestAlgoAndValue.setDigestMethod(xmlDigestAlgoAndValue.getDigestMethod());
            xmlPolicyDigestAlgoAndValue.setDigestValue(xmlDigestAlgoAndValue.getDigestValue());
        }
        xmlPolicyDigestAlgoAndValue.setMatch(Boolean.valueOf(this.validationResult.isDigestValid()));
        xmlPolicy.setDigestAlgoAndValue(xmlPolicyDigestAlgoAndValue);
        xmlPolicy.setAsn1Processable(Boolean.valueOf(this.validationResult.isAsn1Processable()));
        xmlPolicy.setIdentified(Boolean.valueOf(this.validationResult.isIdentified()));
        if (Utils.isStringNotBlank((String)this.validationResult.getProcessingErrors())) {
            xmlPolicy.setProcessingError(this.validationResult.getProcessingErrors());
        }
        return xmlPolicy;
    }

    public XmlSignaturePolicyStore buildSignaturePolicyStore() {
        DSSDocument signaturePolicyContent;
        if (this.signaturePolicyStore == null) {
            return null;
        }
        XmlSignaturePolicyStore xmlSignaturePolicyStore = new XmlSignaturePolicyStore();
        SpDocSpecification spDocSpecification = this.signaturePolicyStore.getSpDocSpecification();
        if (spDocSpecification != null) {
            xmlSignaturePolicyStore.setId(spDocSpecification.getId());
            xmlSignaturePolicyStore.setDescription(spDocSpecification.getDescription());
            Object[] documentationReferences = spDocSpecification.getDocumentationReferences();
            if (Utils.isArrayNotEmpty((Object[])documentationReferences)) {
                xmlSignaturePolicyStore.setDocumentationReferences(Arrays.asList(documentationReferences));
            }
        }
        if ((signaturePolicyContent = this.signaturePolicyStore.getSignaturePolicyContent()) != null) {
            Digest recalculatedDigest = this.validationResult.getDigest();
            xmlSignaturePolicyStore.setDigestAlgoAndValue(this.getXmlDigestAlgoAndValue(recalculatedDigest));
        }
        return xmlSignaturePolicyStore;
    }

    private XmlDigestAlgoAndValue getXmlDigestAlgoAndValue(Digest digest) {
        XmlDigestAlgoAndValue xmlDigestAlgAndValue = new XmlDigestAlgoAndValue();
        xmlDigestAlgAndValue.setDigestMethod(digest.getAlgorithm());
        xmlDigestAlgAndValue.setDigestValue(digest.getValue() == null ? DSSUtils.EMPTY_BYTE_ARRAY : digest.getValue());
        return xmlDigestAlgAndValue;
    }
}

