/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.ValidationData;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ValidationDataContainer {
    private final Map<AdvancedSignature, ValidationData> signatureValidationDataMap = new HashMap<AdvancedSignature, ValidationData>();
    private final Map<TimestampToken, ValidationData> timestampValidationDataMap = new HashMap<TimestampToken, ValidationData>();

    public void addValidationData(AdvancedSignature signature, ValidationData validationData) {
        this.signatureValidationDataMap.put(signature, validationData);
    }

    public void addValidationData(TimestampToken timestampToken, ValidationData validationData) {
        this.timestampValidationDataMap.put(timestampToken, validationData);
    }

    public ValidationData getValidationData(AdvancedSignature signature) {
        return this.signatureValidationDataMap.get(signature);
    }

    public ValidationData getValidationData(TimestampToken timestampToken) {
        return this.timestampValidationDataMap.get((Object)timestampToken);
    }

    public ValidationData getAllValidationData() {
        ValidationData result = new ValidationData();
        for (ValidationData validationData : this.signatureValidationDataMap.values()) {
            result.addValidationData(validationData);
        }
        for (ValidationData validationData : this.timestampValidationDataMap.values()) {
            result.addValidationData(validationData);
        }
        return result;
    }

    public Collection<AdvancedSignature> getSignatures() {
        return this.signatureValidationDataMap.keySet();
    }

    public boolean isEmpty() {
        for (ValidationData validationData : this.signatureValidationDataMap.values()) {
            if (validationData.isEmpty()) continue;
            return false;
        }
        for (ValidationData validationData : this.timestampValidationDataMap.values()) {
            if (validationData.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ValidationData getAllValidationDataForSignature(AdvancedSignature signature) {
        ValidationData validationDataForInclusion = new ValidationData();
        ValidationData signatureValidationData = this.getValidationData(signature);
        validationDataForInclusion.addValidationData(signatureValidationData);
        for (TimestampToken timestampToken : signature.getAllTimestamps()) {
            ValidationData timestampValidationData = this.getValidationData(timestampToken);
            validationDataForInclusion.addValidationData(timestampValidationData);
        }
        for (AdvancedSignature counterSignature : signature.getCounterSignatures()) {
            ValidationData counterSignatureValidationData = this.getValidationData(counterSignature);
            validationDataForInclusion.addValidationData(counterSignatureValidationData);
        }
        return validationDataForInclusion;
    }

    public ValidationData getCompleteValidationDataForSignature(AdvancedSignature signature) {
        ValidationData validationDataForInclusion = this.getAllValidationDataForSignature(signature);
        validationDataForInclusion.excludeCertificateTokens(signature.getCertificateSource().getCertificates());
        validationDataForInclusion.excludeCRLTokens(signature.getCRLSource().getAllRevocationBinaries());
        validationDataForInclusion.excludeOCSPTokens(signature.getOCSPSource().getAllRevocationBinaries());
        return validationDataForInclusion;
    }
}

