/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.revocation.crl.CRL;
import eu.europa.esig.dss.model.x509.revocation.ocsp.OCSP;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSRevocationUtils;
import eu.europa.esig.dss.spi.x509.ListCertificateSource;
import eu.europa.esig.dss.spi.x509.revocation.RevocationSource;
import eu.europa.esig.dss.spi.x509.revocation.RevocationToken;
import eu.europa.esig.dss.utils.Utils;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RevocationDataLoadingStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(RevocationDataLoadingStrategy.class);
    protected RevocationSource<CRL> crlSource;
    protected RevocationSource<OCSP> ocspSource;
    protected ListCertificateSource trustedListCertificateSource;

    void setCrlSource(RevocationSource<CRL> crlSource) {
        this.crlSource = crlSource;
    }

    void setOcspSource(RevocationSource<OCSP> ocspSource) {
        this.ocspSource = ocspSource;
    }

    void setTrustedCertificateSource(ListCertificateSource trustedListCertificateSource) {
        this.trustedListCertificateSource = trustedListCertificateSource;
    }

    protected abstract RevocationToken getRevocationToken(CertificateToken var1, CertificateToken var2);

    protected RevocationToken<CRL> checkCRL(CertificateToken certificateToken, CertificateToken issuerToken) {
        if (this.crlSource == null) {
            LOG.debug("CRLSource is null");
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("CRL request for: {} using: {}", (Object)certificateToken.getDSSIdAsString(), (Object)this.crlSource.getClass().getSimpleName());
        }
        try {
            RevocationToken revocationToken = this.crlSource.getRevocationToken(certificateToken, issuerToken);
            if (revocationToken != null && this.containsCertificateStatus(revocationToken)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("CRL for {} retrieved: {}", (Object)certificateToken.getDSSIdAsString(), (Object)revocationToken.getAbbreviation());
                }
                return revocationToken;
            }
        }
        catch (DSSException e) {
            LOG.error("CRL DSS Exception: {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("A CRL for token {} is not obtained! Return null value.", (Object)certificateToken.getDSSIdAsString());
        }
        return null;
    }

    protected RevocationToken<OCSP> checkOCSP(CertificateToken certificateToken, CertificateToken issuerToken) {
        if (this.ocspSource == null) {
            LOG.debug("OCSPSource null");
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("OCSP request for: {} using: {}", (Object)certificateToken.getDSSIdAsString(), (Object)this.ocspSource.getClass().getSimpleName());
        }
        try {
            RevocationToken revocationToken = this.ocspSource.getRevocationToken(certificateToken, issuerToken);
            if (revocationToken != null && this.containsCertificateStatus(revocationToken) && this.isAcceptable((RevocationToken<OCSP>)revocationToken) && this.isIssuerValidAtRevocationProductionTime(revocationToken)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("OCSP response for {} retrieved: {}", (Object)certificateToken.getDSSIdAsString(), (Object)revocationToken.getAbbreviation());
                    LOG.debug("OCSP Response {} status is : {}", (Object)revocationToken.getDSSIdAsString(), (Object)revocationToken.getStatus());
                }
                return revocationToken;
            }
        }
        catch (DSSException e) {
            LOG.error("OCSP DSS Exception: {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("An OCSP response for token {} is not obtained! Return null value.", (Object)certificateToken.getDSSIdAsString());
        }
        return null;
    }

    private boolean containsCertificateStatus(RevocationToken<?> revocationToken) {
        if (revocationToken.getStatus() == null) {
            LOG.warn("The obtained revocation token does not contain the certificate status. The token is skipped.");
            return false;
        }
        return true;
    }

    private boolean isAcceptable(RevocationToken<OCSP> ocspToken) {
        CertificateToken issuerCertificateToken = ocspToken.getIssuerCertificateToken();
        if (issuerCertificateToken == null) {
            LOG.warn("The issuer certificate is not found for the obtained OCSPToken. The token is skipped.");
            return false;
        }
        if (this.doesRequireRevocation(issuerCertificateToken) && !this.hasRevocationAccessPoints(issuerCertificateToken)) {
            LOG.warn("The issuer certificate of the obtained OCSPToken requires a revocation data, which is not acceptable due its configuration (no revocation access location points). The token is skipped.");
            return false;
        }
        return true;
    }

    private boolean doesRequireRevocation(CertificateToken certificateToken) {
        if (certificateToken.isSelfSigned()) {
            return false;
        }
        if (this.isTrusted(certificateToken)) {
            return false;
        }
        return !DSSASN1Utils.hasIdPkixOcspNoCheckExtension((CertificateToken)certificateToken);
    }

    private boolean isTrusted(CertificateToken certificateToken) {
        return this.trustedListCertificateSource != null && this.trustedListCertificateSource.isTrusted(certificateToken);
    }

    private boolean hasRevocationAccessPoints(CertificateToken certificateToken) {
        if (Utils.isCollectionNotEmpty((Collection)DSSASN1Utils.getOCSPAccessLocations((CertificateToken)certificateToken))) {
            return true;
        }
        return Utils.isCollectionNotEmpty((Collection)DSSASN1Utils.getCrlUrls((CertificateToken)certificateToken));
    }

    private boolean isIssuerValidAtRevocationProductionTime(RevocationToken<?> revocationToken) {
        if (!DSSRevocationUtils.checkIssuerValidAtRevocationProductionTime(revocationToken)) {
            LOG.warn("The revocation token has been produced outside the issuer certificate's validity range. The token is skipped.");
            return false;
        }
        return true;
    }
}

