/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.revocation.Revocation;
import eu.europa.esig.dss.model.x509.revocation.ocsp.OCSP;
import eu.europa.esig.dss.spi.x509.revocation.RevocationToken;
import eu.europa.esig.dss.validation.RevocationDataLoadingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OCSPFirstRevocationDataLoadingStrategy
extends RevocationDataLoadingStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(OCSPFirstRevocationDataLoadingStrategy.class);

    public RevocationToken<Revocation> getRevocationToken(CertificateToken certificateToken, CertificateToken issuerToken) {
        RevocationToken<OCSP> result = this.checkOCSP(certificateToken, issuerToken);
        if (result != null) {
            return result;
        }
        result = this.checkCRL(certificateToken, issuerToken);
        if (result != null) {
            return result;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("There is no response for {} neither from OCSP nor from CRL!", (Object)certificateToken.getDSSIdAsString());
        }
        return null;
    }
}

