/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.diagnostic.jaxb.XmlBasicSignature;
import eu.europa.esig.dss.diagnostic.jaxb.XmlCertificate;
import eu.europa.esig.dss.diagnostic.jaxb.XmlCertificatePolicy;
import eu.europa.esig.dss.diagnostic.jaxb.XmlCertificateRef;
import eu.europa.esig.dss.diagnostic.jaxb.XmlCertificateRevocation;
import eu.europa.esig.dss.diagnostic.jaxb.XmlChainItem;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDiagnosticData;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDigestAlgoAndValue;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDistinguishedName;
import eu.europa.esig.dss.diagnostic.jaxb.XmlEncapsulationType;
import eu.europa.esig.dss.diagnostic.jaxb.XmlFoundCertificates;
import eu.europa.esig.dss.diagnostic.jaxb.XmlIssuerSerial;
import eu.europa.esig.dss.diagnostic.jaxb.XmlLangAndValue;
import eu.europa.esig.dss.diagnostic.jaxb.XmlOID;
import eu.europa.esig.dss.diagnostic.jaxb.XmlOrphanCertificate;
import eu.europa.esig.dss.diagnostic.jaxb.XmlOrphanCertificateToken;
import eu.europa.esig.dss.diagnostic.jaxb.XmlOrphanRevocationToken;
import eu.europa.esig.dss.diagnostic.jaxb.XmlPSD2QcInfo;
import eu.europa.esig.dss.diagnostic.jaxb.XmlQcCompliance;
import eu.europa.esig.dss.diagnostic.jaxb.XmlQcEuLimitValue;
import eu.europa.esig.dss.diagnostic.jaxb.XmlQcSSCD;
import eu.europa.esig.dss.diagnostic.jaxb.XmlQcStatements;
import eu.europa.esig.dss.diagnostic.jaxb.XmlRelatedCertificate;
import eu.europa.esig.dss.diagnostic.jaxb.XmlRevocation;
import eu.europa.esig.dss.diagnostic.jaxb.XmlRevocationRef;
import eu.europa.esig.dss.diagnostic.jaxb.XmlRoleOfPSP;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSignerInfo;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSigningCertificate;
import eu.europa.esig.dss.diagnostic.jaxb.XmlTrustedList;
import eu.europa.esig.dss.diagnostic.jaxb.XmlTrustedService;
import eu.europa.esig.dss.diagnostic.jaxb.XmlTrustedServiceProvider;
import eu.europa.esig.dss.enumerations.CertificateOrigin;
import eu.europa.esig.dss.enumerations.CertificateRefOrigin;
import eu.europa.esig.dss.enumerations.CertificateSourceType;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.enumerations.OidDescription;
import eu.europa.esig.dss.enumerations.QCType;
import eu.europa.esig.dss.enumerations.RevocationOrigin;
import eu.europa.esig.dss.enumerations.RevocationRefOrigin;
import eu.europa.esig.dss.enumerations.RoleOfPspOid;
import eu.europa.esig.dss.enumerations.SignatureAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureValidity;
import eu.europa.esig.dss.enumerations.TokenExtractionStrategy;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.identifier.Identifier;
import eu.europa.esig.dss.model.identifier.IdentifierBasedObject;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.PSD2QcType;
import eu.europa.esig.dss.model.x509.PdsLocation;
import eu.europa.esig.dss.model.x509.QCLimitValue;
import eu.europa.esig.dss.model.x509.QcStatements;
import eu.europa.esig.dss.model.x509.RoleOfPSP;
import eu.europa.esig.dss.model.x509.Token;
import eu.europa.esig.dss.model.x509.TokenComparator;
import eu.europa.esig.dss.model.x509.X500PrincipalHelper;
import eu.europa.esig.dss.model.x509.revocation.Revocation;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.QcStatementUtils;
import eu.europa.esig.dss.spi.tsl.Condition;
import eu.europa.esig.dss.spi.tsl.ConditionForQualifiers;
import eu.europa.esig.dss.spi.tsl.DownloadInfoRecord;
import eu.europa.esig.dss.spi.tsl.LOTLInfo;
import eu.europa.esig.dss.spi.tsl.ParsingInfoRecord;
import eu.europa.esig.dss.spi.tsl.TLInfo;
import eu.europa.esig.dss.spi.tsl.TLValidationJobSummary;
import eu.europa.esig.dss.spi.tsl.TrustProperties;
import eu.europa.esig.dss.spi.tsl.TrustServiceProvider;
import eu.europa.esig.dss.spi.tsl.TrustServiceStatusAndInformationExtensions;
import eu.europa.esig.dss.spi.tsl.TrustedListsCertificateSource;
import eu.europa.esig.dss.spi.tsl.ValidationInfoRecord;
import eu.europa.esig.dss.spi.util.TimeDependentValues;
import eu.europa.esig.dss.spi.x509.CertificatePolicy;
import eu.europa.esig.dss.spi.x509.CertificateRef;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import eu.europa.esig.dss.spi.x509.CertificateTokenRefMatcher;
import eu.europa.esig.dss.spi.x509.CertificateValidity;
import eu.europa.esig.dss.spi.x509.ListCertificateSource;
import eu.europa.esig.dss.spi.x509.ResponderId;
import eu.europa.esig.dss.spi.x509.SignerIdentifier;
import eu.europa.esig.dss.spi.x509.TokenCertificateSource;
import eu.europa.esig.dss.spi.x509.revocation.RevocationRef;
import eu.europa.esig.dss.spi.x509.revocation.RevocationToken;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLRef;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPRef;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.DSSPKUtils;
import eu.europa.esig.dss.validation.OidRepository;
import eu.europa.esig.dss.validation.OriginalIdentifierProvider;
import eu.europa.esig.dss.validation.SignatureCertificateSource;
import eu.europa.esig.dss.validation.TokenIdentifierProvider;
import java.security.Key;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DiagnosticDataBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(DiagnosticDataBuilder.class);
    protected Set<CertificateToken> usedCertificates;
    protected Set<RevocationToken> usedRevocations;
    protected ListCertificateSource allCertificateSources = new ListCertificateSource();
    protected Date validationDate;
    protected TokenExtractionStrategy tokenExtractionStrategy = TokenExtractionStrategy.NONE;
    protected DigestAlgorithm defaultDigestAlgorithm = DigestAlgorithm.SHA256;
    protected TokenIdentifierProvider identifierProvider = new OriginalIdentifierProvider();
    protected Map<String, XmlCertificate> xmlCertsMap = new HashMap<String, XmlCertificate>();
    protected Map<String, XmlRevocation> xmlRevocationsMap = new HashMap<String, XmlRevocation>();
    protected Map<String, XmlTrustedList> xmlTrustedListsMap = new HashMap<String, XmlTrustedList>();
    protected Map<String, XmlOrphanCertificateToken> xmlOrphanCertificateTokensMap = new HashMap<String, XmlOrphanCertificateToken>();
    protected Map<String, XmlOrphanRevocationToken> xmlOrphanRevocationTokensMap = new HashMap<String, XmlOrphanRevocationToken>();
    protected Map<String, String> referenceMap = new HashMap<String, String>();
    protected Map<String, CertificateToken> certificateIdsMap = new HashMap<String, CertificateToken>();
    protected Map<String, CertificateToken> signingCertificateMap = new HashMap<String, CertificateToken>();

    public DiagnosticDataBuilder usedCertificates(Set<CertificateToken> usedCertificates) {
        this.usedCertificates = usedCertificates;
        return this;
    }

    public DiagnosticDataBuilder usedRevocations(Set<RevocationToken> usedRevocations) {
        this.usedRevocations = usedRevocations;
        return this;
    }

    public DiagnosticDataBuilder allCertificateSources(ListCertificateSource allCertificateSources) {
        if (allCertificateSources != null && !allCertificateSources.containsTrustedCertSources()) {
            LOG.warn("Provided CertificateSource configuration contains none of trusted sources of type TRUSTED_STORE or TRUSTED_LIST!");
        }
        this.allCertificateSources = allCertificateSources;
        return this;
    }

    public DiagnosticDataBuilder validationDate(Date validationDate) {
        this.validationDate = validationDate;
        return this;
    }

    public DiagnosticDataBuilder tokenExtractionStrategy(TokenExtractionStrategy tokenExtractionStrategy) {
        this.tokenExtractionStrategy = tokenExtractionStrategy;
        return this;
    }

    public DiagnosticDataBuilder tokenIdentifierProvider(TokenIdentifierProvider identifierProvider) {
        this.identifierProvider = identifierProvider;
        return this;
    }

    public DiagnosticDataBuilder defaultDigestAlgorithm(DigestAlgorithm digestAlgorithm) {
        this.defaultDigestAlgorithm = digestAlgorithm;
        return this;
    }

    public XmlDiagnosticData build() {
        XmlDiagnosticData diagnosticData = new XmlDiagnosticData();
        diagnosticData.setValidationDate(this.validationDate);
        Collection<XmlCertificate> xmlCertificates = this.buildXmlCertificates(this.usedCertificates);
        diagnosticData.getUsedCertificates().addAll(xmlCertificates);
        Collection<XmlRevocation> xmlRevocations = this.buildXmlRevocations(this.usedRevocations);
        diagnosticData.getUsedRevocations().addAll(xmlRevocations);
        this.linkSigningCertificateAndChains(this.usedCertificates);
        this.linkCertificatesAndRevocations(this.usedCertificates);
        if (this.isUseTrustedLists()) {
            Collection<XmlTrustedList> trustedLists = this.buildXmlTrustedLists(this.allCertificateSources);
            diagnosticData.getTrustedLists().addAll(trustedLists);
            this.linkCertificatesAndTrustServices(this.usedCertificates);
        }
        return diagnosticData;
    }

    private boolean isUseTrustedLists() {
        if (!this.allCertificateSources.isEmpty()) {
            for (CertificateSource certificateSource : this.allCertificateSources.getSources()) {
                if (!(certificateSource instanceof TrustedListsCertificateSource)) continue;
                return true;
            }
        }
        return false;
    }

    private Collection<XmlCertificate> buildXmlCertificates(Set<CertificateToken> certificates) {
        ArrayList<XmlCertificate> builtCertificates = new ArrayList<XmlCertificate>();
        if (Utils.isCollectionNotEmpty(certificates)) {
            ArrayList<CertificateToken> tokens = new ArrayList<CertificateToken>(certificates);
            tokens.sort((Comparator<CertificateToken>)new TokenComparator());
            for (CertificateToken certificateToken : tokens) {
                String id = certificateToken.getDSSIdAsString();
                XmlCertificate xmlCertificate = this.xmlCertsMap.get(id);
                if (xmlCertificate == null) {
                    xmlCertificate = this.buildDetachedXmlCertificate(certificateToken);
                    this.xmlCertsMap.put(id, xmlCertificate);
                }
                this.certificateIdsMap.put(certificateToken.getDSSIdAsString(), certificateToken);
                builtCertificates.add(xmlCertificate);
            }
        }
        return builtCertificates;
    }

    protected void linkSigningCertificateAndChains(Set<CertificateToken> certificates) {
        if (Utils.isCollectionNotEmpty(certificates)) {
            for (CertificateToken certificateToken : certificates) {
                XmlCertificate xmlCertificate = this.xmlCertsMap.get((certificateToken = this.getProcessedCertificateToken(certificateToken)).getDSSIdAsString());
                if (xmlCertificate.getSigningCertificate() != null) continue;
                xmlCertificate.setSigningCertificate(this.getXmlSigningCertificate((Token)certificateToken));
                xmlCertificate.setCertificateChain(this.getXmlForCertificateChain((Token)certificateToken));
            }
        }
    }

    private void linkCertificatesAndTrustServices(Set<CertificateToken> certificates) {
        if (Utils.isCollectionNotEmpty(certificates)) {
            for (CertificateToken certificateToken : certificates) {
                XmlCertificate xmlCertificate = this.xmlCertsMap.get(certificateToken.getDSSIdAsString());
                xmlCertificate.setTrustedServiceProviders(this.getXmlTrustedServiceProviders(certificateToken));
            }
        }
    }

    private Collection<XmlRevocation> buildXmlRevocations(Set<RevocationToken> revocations) {
        ArrayList<XmlRevocation> builtRevocations = new ArrayList<XmlRevocation>();
        if (Utils.isCollectionNotEmpty(revocations)) {
            ArrayList<RevocationToken> tokens = new ArrayList<RevocationToken>(revocations);
            tokens.sort((Comparator<RevocationToken>)new TokenComparator());
            ArrayList<String> uniqueIds = new ArrayList<String>();
            for (RevocationToken revocationToken : tokens) {
                String id = revocationToken.getDSSIdAsString();
                if (uniqueIds.contains(id)) continue;
                XmlRevocation xmlRevocation = this.xmlRevocationsMap.get(id);
                if (xmlRevocation == null) {
                    xmlRevocation = this.buildDetachedXmlRevocation((RevocationToken<Revocation>)revocationToken);
                    this.xmlRevocationsMap.put(id, xmlRevocation);
                    builtRevocations.add(xmlRevocation);
                }
                uniqueIds.add(id);
            }
        }
        return builtRevocations;
    }

    private void linkCertificatesAndRevocations(Set<CertificateToken> certificates) {
        if (Utils.isCollectionNotEmpty(certificates)) {
            for (CertificateToken certificateToken : certificates) {
                XmlCertificate xmlCertificate = this.xmlCertsMap.get(certificateToken.getDSSIdAsString());
                Set<RevocationToken<Revocation>> revocationsForCert = this.getRevocationsForCert(certificateToken);
                for (RevocationToken<Revocation> revocationToken : revocationsForCert) {
                    XmlRevocation xmlRevocation = this.xmlRevocationsMap.get(revocationToken.getDSSIdAsString());
                    XmlCertificateRevocation xmlCertificateRevocation = new XmlCertificateRevocation();
                    xmlCertificateRevocation.setRevocation(xmlRevocation);
                    xmlCertificateRevocation.setStatus(revocationToken.getStatus());
                    xmlCertificateRevocation.setRevocationDate(revocationToken.getRevocationDate());
                    xmlCertificateRevocation.setReason(revocationToken.getReason());
                    xmlCertificate.getRevocations().add(xmlCertificateRevocation);
                }
            }
        }
    }

    private Collection<XmlTrustedList> buildXmlTrustedLists(ListCertificateSource trustedCertificateSources) {
        ArrayList<XmlTrustedList> trustedLists = new ArrayList<XmlTrustedList>();
        HashMap<Identifier, XmlTrustedList> mapTrustedLists = new HashMap<Identifier, XmlTrustedList>();
        HashMap<Identifier, XmlTrustedList> mapListOfTrustedLists = new HashMap<Identifier, XmlTrustedList>();
        for (CertificateSource certificateSource : trustedCertificateSources.getSources()) {
            if (!(certificateSource instanceof TrustedListsCertificateSource)) continue;
            TrustedListsCertificateSource tlCertSource = (TrustedListsCertificateSource)certificateSource;
            TLValidationJobSummary summary = tlCertSource.getSummary();
            if (summary != null) {
                Set<Identifier> tlIdentifiers = this.getTLIdentifiers(tlCertSource);
                for (Identifier tlId : tlIdentifiers) {
                    TLInfo tlInfoById;
                    if (mapTrustedLists.containsKey(tlId) || (tlInfoById = summary.getTLInfoById(tlId)) == null) continue;
                    mapTrustedLists.put(tlId, this.getXmlTrustedList(tlInfoById));
                }
                Set<Identifier> lotlIdentifiers = this.getLOTLIdentifiers(tlCertSource);
                for (Identifier lotlId : lotlIdentifiers) {
                    LOTLInfo lotlInfoById;
                    if (mapListOfTrustedLists.containsKey(lotlId) || (lotlInfoById = summary.getLOTLInfoById(lotlId)) == null) continue;
                    mapListOfTrustedLists.put(lotlId, this.getXmlTrustedList((TLInfo)lotlInfoById));
                }
                continue;
            }
            LOG.warn("The TrustedListsCertificateSource does not contain TLValidationJobSummary. TLValidationJob is not performed!");
        }
        trustedLists.addAll(mapTrustedLists.values());
        trustedLists.addAll(mapListOfTrustedLists.values());
        return trustedLists;
    }

    private Set<Identifier> getTLIdentifiers(TrustedListsCertificateSource tlCS) {
        HashSet<Identifier> tlIdentifiers = new HashSet<Identifier>();
        for (CertificateToken certificateToken : this.usedCertificates) {
            List trustServices = tlCS.getTrustServices(certificateToken);
            for (TrustProperties trustProperties : trustServices) {
                tlIdentifiers.add(trustProperties.getTLIdentifier());
            }
        }
        return tlIdentifiers;
    }

    private Set<Identifier> getLOTLIdentifiers(TrustedListsCertificateSource tlCS) {
        HashSet<Identifier> lotlIdentifiers = new HashSet<Identifier>();
        for (CertificateToken certificateToken : this.usedCertificates) {
            List trustServices = tlCS.getTrustServices(certificateToken);
            for (TrustProperties trustProperties : trustServices) {
                Identifier lotlUrl = trustProperties.getLOTLIdentifier();
                if (lotlUrl == null) continue;
                lotlIdentifiers.add(lotlUrl);
            }
        }
        return lotlIdentifiers;
    }

    private XmlTrustedList getXmlTrustedList(TLInfo tlInfo) {
        String id = tlInfo.getDSSIdAsString();
        XmlTrustedList result = this.xmlTrustedListsMap.get(id);
        if (result == null) {
            ValidationInfoRecord validationCacheInfo;
            DownloadInfoRecord downloadCacheInfo;
            result = new XmlTrustedList();
            if (tlInfo instanceof LOTLInfo) {
                result.setLOTL(Boolean.valueOf(true));
            }
            result.setId(this.identifierProvider.getIdAsString((IdentifierBasedObject)tlInfo));
            result.setUrl(tlInfo.getUrl());
            ParsingInfoRecord parsingCacheInfo = tlInfo.getParsingCacheInfo();
            if (parsingCacheInfo != null) {
                result.setCountryCode(parsingCacheInfo.getTerritory());
                result.setIssueDate(parsingCacheInfo.getIssueDate());
                result.setNextUpdate(parsingCacheInfo.getNextUpdateDate());
                result.setSequenceNumber(parsingCacheInfo.getSequenceNumber());
                result.setVersion(parsingCacheInfo.getVersion());
            }
            if ((downloadCacheInfo = tlInfo.getDownloadCacheInfo()) != null) {
                result.setLastLoading(downloadCacheInfo.getLastSuccessSynchronizationTime());
            }
            if ((validationCacheInfo = tlInfo.getValidationCacheInfo()) != null) {
                result.setWellSigned(validationCacheInfo.isValid());
            }
            this.xmlTrustedListsMap.put(id, result);
        }
        return result;
    }

    protected XmlSignerInfo getXmlSignerInfo(SignerIdentifier signerIdentifier) {
        XmlSignerInfo xmlSignerInfo = new XmlSignerInfo();
        if (signerIdentifier.getIssuerName() != null) {
            xmlSignerInfo.setIssuerName(signerIdentifier.getIssuerName().toString());
        }
        xmlSignerInfo.setSerialNumber(signerIdentifier.getSerialNumber());
        xmlSignerInfo.setSki(signerIdentifier.getSki());
        if (signerIdentifier.isCurrent()) {
            xmlSignerInfo.setCurrent(Boolean.valueOf(signerIdentifier.isCurrent()));
        }
        return xmlSignerInfo;
    }

    private XmlSignerInfo getXmlSignerInfo(ResponderId responderId) {
        XmlSignerInfo xmlSignerInfo = new XmlSignerInfo();
        if (responderId.getX500Principal() != null) {
            xmlSignerInfo.setIssuerName(responderId.getX500Principal().toString());
        }
        xmlSignerInfo.setSki(responderId.getSki());
        return xmlSignerInfo;
    }

    protected XmlRevocation buildDetachedXmlRevocation(RevocationToken<Revocation> revocationToken) {
        XmlRevocation xmlRevocation = new XmlRevocation();
        xmlRevocation.setId(this.identifierProvider.getIdAsString((IdentifierBasedObject)revocationToken));
        if (revocationToken.isInternal()) {
            xmlRevocation.setOrigin(RevocationOrigin.INPUT_DOCUMENT);
        } else {
            xmlRevocation.setOrigin(revocationToken.getExternalOrigin());
        }
        xmlRevocation.setType(revocationToken.getRevocationType());
        xmlRevocation.setProductionDate(revocationToken.getProductionDate());
        xmlRevocation.setThisUpdate(revocationToken.getThisUpdate());
        xmlRevocation.setNextUpdate(revocationToken.getNextUpdate());
        xmlRevocation.setExpiredCertsOnCRL(revocationToken.getExpiredCertsOnCRL());
        xmlRevocation.setArchiveCutOff(revocationToken.getArchiveCutOff());
        String sourceURL = revocationToken.getSourceURL();
        if (Utils.isStringNotEmpty((String)sourceURL)) {
            xmlRevocation.setSourceAddress(sourceURL);
        }
        xmlRevocation.setBasicSignature(this.getXmlBasicSignature((Token)revocationToken));
        xmlRevocation.setSigningCertificate(this.getXmlSigningCertificate((Token)revocationToken, (CertificateSource)revocationToken.getCertificateSource()));
        xmlRevocation.setCertificateChain(this.getXmlForCertificateChain((Token)revocationToken, (CertificateSource)revocationToken.getCertificateSource()));
        xmlRevocation.setCertHashExtensionPresent(Boolean.valueOf(revocationToken.isCertHashPresent()));
        xmlRevocation.setCertHashExtensionMatch(Boolean.valueOf(revocationToken.isCertHashMatch()));
        if (revocationToken.getCertificateSource() != null) {
            xmlRevocation.setFoundCertificates(this.getXmlFoundCertificates((Identifier)revocationToken.getDSSId(), (TokenCertificateSource)revocationToken.getCertificateSource()));
        }
        if (this.tokenExtractionStrategy.isRevocationData()) {
            xmlRevocation.setBase64Encoded(revocationToken.getEncoded());
        } else {
            byte[] revocationDigest = revocationToken.getDigest(this.defaultDigestAlgorithm);
            xmlRevocation.setDigestAlgoAndValue(this.getXmlDigestAlgoAndValue(this.defaultDigestAlgorithm, revocationDigest));
        }
        return xmlRevocation;
    }

    protected <R extends Revocation> List<XmlRevocationRef> getXmlRevocationRefs(String tokenId, Map<RevocationRef<R>, Set<RevocationRefOrigin>> refsAndOrigins) {
        ArrayList<XmlRevocationRef> xmlRevocationRefs = new ArrayList<XmlRevocationRef>();
        for (Map.Entry<RevocationRef<R>, Set<RevocationRefOrigin>> entry : refsAndOrigins.entrySet()) {
            RevocationRef<R> ref = entry.getKey();
            Set<RevocationRefOrigin> origins = entry.getValue();
            XmlRevocationRef xmlRef = ref instanceof CRLRef ? this.getXmlCRLRevocationRef((CRLRef)ref, origins) : this.getXmlOCSPRevocationRef((OCSPRef)ref, origins);
            this.referenceMap.put(ref.getDSSIdAsString(), tokenId);
            xmlRevocationRefs.add(xmlRef);
        }
        return xmlRevocationRefs;
    }

    protected XmlRevocationRef getXmlCRLRevocationRef(CRLRef crlRef, Set<RevocationRefOrigin> origins) {
        XmlRevocationRef xmlRevocationRef = new XmlRevocationRef();
        xmlRevocationRef.getOrigins().addAll(origins);
        if (crlRef.getDigest() != null) {
            xmlRevocationRef.setDigestAlgoAndValue(this.getXmlDigestAlgoAndValue(crlRef.getDigest()));
        }
        return xmlRevocationRef;
    }

    protected XmlRevocationRef getXmlOCSPRevocationRef(OCSPRef ocspRef, Set<RevocationRefOrigin> origins) {
        XmlRevocationRef xmlRevocationRef = new XmlRevocationRef();
        xmlRevocationRef.getOrigins().addAll(origins);
        if (ocspRef.getDigest() != null) {
            xmlRevocationRef.setDigestAlgoAndValue(this.getXmlDigestAlgoAndValue(ocspRef.getDigest()));
        }
        xmlRevocationRef.setProducedAt(ocspRef.getProducedAt());
        ResponderId responderId = ocspRef.getResponderId();
        if (responderId != null) {
            xmlRevocationRef.setResponderId(this.getXmlSignerInfo(responderId));
        }
        return xmlRevocationRef;
    }

    protected List<XmlChainItem> getXmlForCertificateChain(Token token) {
        return this.getXmlForCertificateChain(token, null);
    }

    protected List<XmlChainItem> getXmlForCertificateChain(Token token, CertificateSource certificateSource) {
        if (token != null) {
            ArrayList<XmlChainItem> certChainTokens = new ArrayList<XmlChainItem>();
            HashSet<Object> processedTokens = new HashSet<Object>();
            processedTokens.add(token);
            CertificateToken issuerToken = this.getIssuerCertificate(token, certificateSource);
            while (issuerToken != null) {
                certChainTokens.add(this.getXmlChainItem(issuerToken));
                if (issuerToken.isSelfSigned() || processedTokens.contains(issuerToken)) break;
                processedTokens.add(issuerToken);
                issuerToken = this.getIssuerCertificate((Token)issuerToken, certificateSource);
            }
            this.ensureCertificateChain(certChainTokens);
            return certChainTokens;
        }
        return null;
    }

    private void ensureCertificateChain(List<XmlChainItem> certChain) {
        if (Utils.isCollectionNotEmpty(certChain)) {
            for (int i = 0; i < certChain.size(); ++i) {
                XmlChainItem chainItem = certChain.get(i);
                XmlCertificate certificate = chainItem.getCertificate();
                if (certificate == null || certificate.getSigningCertificate() != null || i + 1 >= certChain.size()) continue;
                certificate.setSigningCertificate(this.getXmlSigningCertificateFromXmlCertificate(certChain.get(i + 1).getCertificate()));
                certificate.setCertificateChain(this.getCertChainSinceIndex(certChain, i + 1));
            }
        }
    }

    private XmlSigningCertificate getXmlSigningCertificateFromXmlCertificate(XmlCertificate xmlCertificate) {
        XmlSigningCertificate xmlSigningCertificate = new XmlSigningCertificate();
        xmlSigningCertificate.setCertificate(xmlCertificate);
        return xmlSigningCertificate;
    }

    private List<XmlChainItem> getCertChainSinceIndex(List<XmlChainItem> certChain, int index) {
        ArrayList<XmlChainItem> result = new ArrayList<XmlChainItem>();
        for (int i = index; i < certChain.size(); ++i) {
            result.add(certChain.get(i));
        }
        return result;
    }

    protected List<XmlChainItem> getXmlForCertificateChain(CertificateValidity certificateValidity, CertificateSource certificateSource) {
        CertificateToken signingCertificate;
        if (certificateValidity != null && (signingCertificate = this.getSigningCertificate(certificateValidity)) != null) {
            ArrayList<XmlChainItem> certChainTokens = new ArrayList<XmlChainItem>();
            certChainTokens.add(this.getXmlChainItem(signingCertificate));
            List<XmlChainItem> certChain = this.getXmlForCertificateChain((Token)signingCertificate, certificateSource);
            if (Utils.isCollectionNotEmpty(certChain)) {
                for (XmlChainItem chainItem : certChain) {
                    if (signingCertificate.getDSSIdAsString().equals(chainItem.getCertificate().getId())) break;
                    certChainTokens.add(chainItem);
                }
            }
            this.ensureCertificateChain(certChainTokens);
            return certChainTokens;
        }
        return null;
    }

    private XmlChainItem getXmlChainItem(CertificateToken token) {
        XmlChainItem chainItem = new XmlChainItem();
        chainItem.setCertificate(this.xmlCertsMap.get(token.getDSSIdAsString()));
        return chainItem;
    }

    private XmlSigningCertificate getXmlSigningCertificate(Token token) {
        return this.getXmlSigningCertificate(token, null);
    }

    private XmlSigningCertificate getXmlSigningCertificate(Token token, CertificateSource certificateSource) {
        XmlSigningCertificate xmlSignCertType = new XmlSigningCertificate();
        CertificateToken certificateByPubKey = this.getIssuerCertificate(token, certificateSource);
        if (certificateByPubKey != null) {
            xmlSignCertType.setCertificate(this.xmlCertsMap.get(certificateByPubKey.getDSSIdAsString()));
            this.signingCertificateMap.put(token.getDSSIdAsString(), certificateByPubKey);
        } else if (token.getPublicKeyOfTheSigner() != null) {
            xmlSignCertType.setPublicKey(token.getPublicKeyOfTheSigner().getEncoded());
        } else {
            return null;
        }
        return xmlSignCertType;
    }

    private CertificateToken getIssuerCertificate(Token token) {
        return this.getIssuerCertificate(token, null);
    }

    private CertificateToken getIssuerCertificate(Token token, CertificateSource certificateSource) {
        if (token != null && token.getPublicKeyOfTheSigner() != null) {
            CertificateToken issuer = null;
            if (certificateSource != null) {
                issuer = this.getBestCertificateFromCandidates(token, certificateSource.getCertificates());
            }
            if (issuer == null && this.signingCertificateMap.containsKey(token.getDSSIdAsString())) {
                issuer = this.signingCertificateMap.get(token.getDSSIdAsString());
            }
            if (issuer == null) {
                issuer = this.getBestCertificateFromCandidates(token, this.usedCertificates);
            }
            if (issuer != null) {
                issuer = this.getProcessedCertificateToken(issuer);
            }
            return issuer;
        }
        return null;
    }

    private CertificateToken getBestCertificateFromCandidates(Token token, Collection<CertificateToken> candidates) {
        List<CertificateToken> issuers = this.getCertsWithPublicKey(token.getPublicKeyOfTheSigner(), candidates);
        if (Utils.isCollectionNotEmpty(issuers)) {
            ArrayList<CertificateToken> issuersBySubject = new ArrayList<CertificateToken>();
            X500Principal issuerX500Principal = token.getIssuerX500Principal();
            if (issuerX500Principal != null) {
                for (CertificateToken cert : issuers) {
                    if (!DSSASN1Utils.x500PrincipalAreEquals((X500Principal)issuerX500Principal, (X500Principal)cert.getSubject().getPrincipal())) continue;
                    issuersBySubject.add(cert);
                }
            }
            if (Utils.isCollectionNotEmpty(issuersBySubject)) {
                issuers = issuersBySubject;
            }
            for (CertificateToken cert : issuers) {
                if (!cert.isValidOn(token.getCreationDate())) continue;
                return cert;
            }
            return issuers.iterator().next();
        }
        return null;
    }

    private List<CertificateToken> getCertsWithPublicKey(PublicKey publicKey, Collection<CertificateToken> candidates) {
        ArrayList<CertificateToken> founds = new ArrayList<CertificateToken>();
        if (publicKey != null) {
            for (CertificateToken cert : candidates) {
                if (!publicKey.equals((cert = this.getProcessedCertificateToken(cert)).getPublicKey())) continue;
                founds.add(cert);
                if (!this.allCertificateSources.isTrusted(cert)) continue;
                return Arrays.asList(cert);
            }
        }
        return founds;
    }

    private CertificateToken getProcessedCertificateToken(CertificateToken certificateToken) {
        CertificateToken processedCertificateToken = this.certificateIdsMap.get(certificateToken.getDSSIdAsString());
        if (processedCertificateToken == null) {
            processedCertificateToken = certificateToken;
            this.certificateIdsMap.put(certificateToken.getDSSIdAsString(), certificateToken);
        }
        return processedCertificateToken;
    }

    protected XmlSigningCertificate getXmlSigningCertificate(Identifier tokenIdentifier, CertificateValidity certificateValidity) {
        XmlSigningCertificate xmlSignCertType = new XmlSigningCertificate();
        CertificateToken signingCertificate = this.getSigningCertificate(certificateValidity);
        if (signingCertificate != null) {
            xmlSignCertType.setCertificate(this.xmlCertsMap.get(signingCertificate.getDSSIdAsString()));
            this.signingCertificateMap.put(tokenIdentifier.asXmlId(), signingCertificate);
        } else if (certificateValidity.getPublicKey() != null) {
            xmlSignCertType.setPublicKey(certificateValidity.getPublicKey().getEncoded());
        } else if (certificateValidity.getSignerInfo() != null) {
            // empty if block
        }
        return xmlSignCertType;
    }

    private CertificateToken getSigningCertificate(CertificateValidity certificateValidity) {
        CertificateToken signingCertificateToken = certificateValidity.getCertificateToken();
        if (signingCertificateToken == null && certificateValidity.getPublicKey() != null) {
            signingCertificateToken = this.getCertificateByPubKey(certificateValidity.getPublicKey());
        }
        if (signingCertificateToken == null && certificateValidity.getSignerInfo() != null) {
            signingCertificateToken = this.getCertificateByCertificateIdentifier(certificateValidity.getSignerInfo());
        }
        if (signingCertificateToken != null) {
            signingCertificateToken = this.getProcessedCertificateToken(signingCertificateToken);
        }
        return signingCertificateToken;
    }

    private CertificateToken getCertificateByPubKey(PublicKey publicKey) {
        return this.getCertificateByPubKey(publicKey, null);
    }

    private CertificateToken getCertificateByPubKey(PublicKey publicKey, CertificateSource certificateSource) {
        if (publicKey != null) {
            List<CertificateToken> candidates = null;
            if (certificateSource != null) {
                candidates = this.getCertsWithPublicKey(publicKey, certificateSource.getCertificates());
            }
            if (Utils.isCollectionEmpty(candidates)) {
                candidates = this.getCertsWithPublicKey(publicKey, this.usedCertificates);
            }
            if (Utils.isCollectionNotEmpty(candidates)) {
                return candidates.iterator().next();
            }
        }
        return null;
    }

    private CertificateToken getCertificateByCertificateIdentifier(SignerIdentifier signerIdentifier) {
        if (signerIdentifier == null) {
            return null;
        }
        ArrayList<CertificateToken> founds = new ArrayList<CertificateToken>();
        for (CertificateToken cert : this.usedCertificates) {
            if (!signerIdentifier.isRelatedToCertificate(cert)) continue;
            founds.add(cert);
            if (!this.allCertificateSources.isTrusted(cert)) continue;
            return cert;
        }
        if (Utils.isCollectionNotEmpty(founds)) {
            return (CertificateToken)founds.iterator().next();
        }
        return null;
    }

    private XmlDistinguishedName getXmlDistinguishedName(String x500PrincipalFormat, String value) {
        XmlDistinguishedName xmlDistinguishedName = new XmlDistinguishedName();
        xmlDistinguishedName.setFormat(x500PrincipalFormat);
        xmlDistinguishedName.setValue(value);
        return xmlDistinguishedName;
    }

    private List<String> getCleanedUrls(List<String> urls) {
        ArrayList<String> cleanedUrls = new ArrayList<String>();
        for (String url : urls) {
            cleanedUrls.add(DSSUtils.removeControlCharacters((String)url));
        }
        return cleanedUrls;
    }

    protected XmlFoundCertificates getXmlFoundCertificates(Identifier tokenIdentifier, TokenCertificateSource certificateSource) {
        XmlFoundCertificates xmlFoundCertificates = new XmlFoundCertificates();
        xmlFoundCertificates.getRelatedCertificates().addAll(this.getXmlRelatedCertificates(certificateSource));
        xmlFoundCertificates.getRelatedCertificates().addAll(this.getXmlRelatedCertificateForOrphanReferences(certificateSource));
        CertificateToken signingCertificate = this.signingCertificateMap.get(tokenIdentifier.asXmlId());
        xmlFoundCertificates.getOrphanCertificates().addAll(this.getOrphanCertificates(certificateSource, signingCertificate));
        xmlFoundCertificates.getOrphanCertificates().addAll(this.getOrphanCertificateRefs(certificateSource, signingCertificate));
        return xmlFoundCertificates;
    }

    private List<XmlRelatedCertificate> getXmlRelatedCertificates(TokenCertificateSource certificateSource) {
        HashMap<String, XmlRelatedCertificate> relatedCertificatesMap = new HashMap<String, XmlRelatedCertificate>();
        if (CertificateSourceType.OCSP_RESPONSE.equals((Object)certificateSource.getCertificateSourceType())) {
            this.populateCertificateOriginMap(relatedCertificatesMap, CertificateOrigin.BASIC_OCSP_RESP, certificateSource.getCertificates(), certificateSource);
        } else {
            SignatureCertificateSource signatureCertificateSource = (SignatureCertificateSource)certificateSource;
            this.populateCertificateOriginMap(relatedCertificatesMap, CertificateOrigin.KEY_INFO, signatureCertificateSource.getKeyInfoCertificates(), certificateSource);
            this.populateCertificateOriginMap(relatedCertificatesMap, CertificateOrigin.SIGNED_DATA, signatureCertificateSource.getSignedDataCertificates(), certificateSource);
            this.populateCertificateOriginMap(relatedCertificatesMap, CertificateOrigin.CERTIFICATE_VALUES, signatureCertificateSource.getCertificateValues(), certificateSource);
            this.populateCertificateOriginMap(relatedCertificatesMap, CertificateOrigin.ATTR_AUTHORITIES_CERT_VALUES, signatureCertificateSource.getAttrAuthoritiesCertValues(), certificateSource);
            this.populateCertificateOriginMap(relatedCertificatesMap, CertificateOrigin.TIMESTAMP_VALIDATION_DATA, signatureCertificateSource.getTimeStampValidationDataCertValues(), certificateSource);
            this.populateCertificateOriginMap(relatedCertificatesMap, CertificateOrigin.DSS_DICTIONARY, signatureCertificateSource.getDSSDictionaryCertValues(), certificateSource);
            this.populateCertificateOriginMap(relatedCertificatesMap, CertificateOrigin.VRI_DICTIONARY, signatureCertificateSource.getVRIDictionaryCertValues(), certificateSource);
        }
        return new ArrayList<XmlRelatedCertificate>(relatedCertificatesMap.values());
    }

    protected void populateCertificateOriginMap(Map<String, XmlRelatedCertificate> relatedCertificatesMap, CertificateOrigin origin, List<CertificateToken> certificateTokens, TokenCertificateSource certificateSource) {
        for (CertificateToken certificateToken : certificateTokens) {
            if (!relatedCertificatesMap.containsKey(certificateToken.getDSSIdAsString())) {
                if (!this.xmlCertsMap.containsKey(certificateToken.getDSSIdAsString())) continue;
                XmlRelatedCertificate xmlFoundCertificate = this.getXmlRelatedCertificate(origin, certificateToken, certificateSource);
                relatedCertificatesMap.put(certificateToken.getDSSIdAsString(), xmlFoundCertificate);
                continue;
            }
            XmlRelatedCertificate storedFoundCertificate = relatedCertificatesMap.get(certificateToken.getDSSIdAsString());
            if (storedFoundCertificate.getOrigins().contains(origin)) continue;
            storedFoundCertificate.getOrigins().add(origin);
        }
    }

    protected XmlRelatedCertificate getXmlRelatedCertificate(CertificateOrigin origin, CertificateToken cert, TokenCertificateSource certificateSource) {
        XmlRelatedCertificate xrc = new XmlRelatedCertificate();
        xrc.getOrigins().add(origin);
        xrc.setCertificate(this.xmlCertsMap.get(cert.getDSSIdAsString()));
        List referencesForCertificateToken = certificateSource.getReferencesForCertificateToken(cert);
        for (CertificateRef certificateRef : referencesForCertificateToken) {
            for (CertificateRefOrigin refOrigin : certificateSource.getCertificateRefOrigins(certificateRef)) {
                XmlCertificateRef xmlCertificateRef = this.getXmlCertificateRef(certificateRef, refOrigin);
                if (CertificateRefOrigin.SIGNING_CERTIFICATE.equals((Object)refOrigin)) {
                    this.verifyAgainstCertificateToken(xmlCertificateRef, certificateRef, cert);
                }
                xrc.getCertificateRefs().add(xmlCertificateRef);
            }
            this.referenceMap.put(certificateRef.getDSSIdAsString(), cert.getDSSIdAsString());
        }
        return xrc;
    }

    protected XmlRelatedCertificate getXmlRelatedCertificate(TokenCertificateSource certificateSource, CertificateToken cert, CertificateRef certificateRef) {
        XmlRelatedCertificate xrc = new XmlRelatedCertificate();
        xrc.setCertificate(this.xmlCertsMap.get(cert.getDSSIdAsString()));
        for (CertificateRefOrigin refOrigin : certificateSource.getCertificateRefOrigins(certificateRef)) {
            XmlCertificateRef xmlCertificateRef = this.getXmlCertificateRef(certificateRef, refOrigin);
            if (CertificateRefOrigin.SIGNING_CERTIFICATE.equals((Object)refOrigin)) {
                this.verifyAgainstCertificateToken(xmlCertificateRef, certificateRef, cert);
            }
            xrc.getCertificateRefs().add(xmlCertificateRef);
        }
        this.referenceMap.put(certificateRef.getDSSIdAsString(), cert.getDSSIdAsString());
        return xrc;
    }

    protected XmlCertificateRef getXmlCertificateRef(CertificateRef ref, CertificateRefOrigin origin) {
        XmlCertificateRef certificateRef = new XmlCertificateRef();
        SignerIdentifier signerIdentifier = ref.getCertificateIdentifier();
        if (signerIdentifier != null) {
            certificateRef.setIssuerSerial(this.getXmlIssuerSerial(signerIdentifier));
        }
        Digest refDigest = ref.getCertDigest();
        ResponderId responderId = ref.getResponderId();
        if (refDigest != null) {
            certificateRef.setDigestAlgoAndValue(this.getXmlDigestAlgoAndValue(refDigest.getAlgorithm(), refDigest.getValue()));
        } else if (signerIdentifier != null) {
            certificateRef.setSerialInfo(this.getXmlSignerInfo(signerIdentifier));
        } else if (responderId != null) {
            certificateRef.setSerialInfo(this.getXmlSignerInfo(responderId));
        }
        certificateRef.setOrigin(origin);
        return certificateRef;
    }

    private List<XmlOrphanCertificate> getOrphanCertificates(TokenCertificateSource certificateSource, CertificateToken signingCertificate) {
        HashMap<String, XmlOrphanCertificate> orphanCertificatesMap = new HashMap<String, XmlOrphanCertificate>();
        if (CertificateSourceType.OCSP_RESPONSE.equals((Object)certificateSource.getCertificateSourceType())) {
            this.populateOrphanCertificateOriginMap(orphanCertificatesMap, CertificateOrigin.BASIC_OCSP_RESP, certificateSource.getCertificates(), certificateSource, signingCertificate);
        } else {
            SignatureCertificateSource signatureCertificateSource = (SignatureCertificateSource)certificateSource;
            this.populateOrphanCertificateOriginMap(orphanCertificatesMap, CertificateOrigin.KEY_INFO, signatureCertificateSource.getKeyInfoCertificates(), certificateSource, signingCertificate);
            this.populateOrphanCertificateOriginMap(orphanCertificatesMap, CertificateOrigin.SIGNED_DATA, signatureCertificateSource.getSignedDataCertificates(), certificateSource, signingCertificate);
            this.populateOrphanCertificateOriginMap(orphanCertificatesMap, CertificateOrigin.CERTIFICATE_VALUES, signatureCertificateSource.getCertificateValues(), certificateSource, signingCertificate);
            this.populateOrphanCertificateOriginMap(orphanCertificatesMap, CertificateOrigin.ATTR_AUTHORITIES_CERT_VALUES, signatureCertificateSource.getAttrAuthoritiesCertValues(), certificateSource, signingCertificate);
            this.populateOrphanCertificateOriginMap(orphanCertificatesMap, CertificateOrigin.TIMESTAMP_VALIDATION_DATA, signatureCertificateSource.getTimeStampValidationDataCertValues(), certificateSource, signingCertificate);
            this.populateOrphanCertificateOriginMap(orphanCertificatesMap, CertificateOrigin.DSS_DICTIONARY, signatureCertificateSource.getDSSDictionaryCertValues(), certificateSource, signingCertificate);
            this.populateOrphanCertificateOriginMap(orphanCertificatesMap, CertificateOrigin.VRI_DICTIONARY, signatureCertificateSource.getVRIDictionaryCertValues(), certificateSource, signingCertificate);
        }
        return new ArrayList<XmlOrphanCertificate>(orphanCertificatesMap.values());
    }

    protected void populateOrphanCertificateOriginMap(Map<String, XmlOrphanCertificate> orphanCertificatesMap, CertificateOrigin origin, List<CertificateToken> certificateTokens, TokenCertificateSource certificateSource, CertificateToken signingCertificate) {
        for (CertificateToken certificateToken : certificateTokens) {
            if (this.xmlCertsMap.containsKey(certificateToken.getDSSIdAsString())) continue;
            if (!orphanCertificatesMap.containsKey(certificateToken.getDSSIdAsString())) {
                XmlOrphanCertificate xmlOrphanCertificate = this.getXmlOrphanCertificate(origin, certificateToken, certificateSource, signingCertificate);
                orphanCertificatesMap.put(certificateToken.getDSSIdAsString(), xmlOrphanCertificate);
                continue;
            }
            XmlOrphanCertificate storedFoundCertificate = orphanCertificatesMap.get(certificateToken.getDSSIdAsString());
            if (storedFoundCertificate.getOrigins().contains(origin)) continue;
            storedFoundCertificate.getOrigins().add(origin);
        }
    }

    protected XmlOrphanCertificate getXmlOrphanCertificate(CertificateOrigin origin, CertificateToken certificateToken, TokenCertificateSource certificateSource, CertificateToken signingCertificate) {
        XmlOrphanCertificate xoc = new XmlOrphanCertificate();
        xoc.getOrigins().add(origin);
        xoc.setToken(this.buildXmlOrphanCertificateToken(certificateToken));
        List referencesForCertificateToken = certificateSource.getReferencesForCertificateToken(certificateToken);
        for (CertificateRef certificateRef : referencesForCertificateToken) {
            for (CertificateRefOrigin refOrigin : certificateSource.getCertificateRefOrigins(certificateRef)) {
                XmlCertificateRef xmlCertificateRef = this.getXmlCertificateRef(certificateRef, refOrigin);
                if (CertificateRefOrigin.SIGNING_CERTIFICATE.equals((Object)refOrigin)) {
                    this.verifyAgainstCertificateToken(xmlCertificateRef, certificateRef, signingCertificate);
                }
                xoc.getCertificateRefs().add(xmlCertificateRef);
            }
            this.referenceMap.put(certificateRef.getDSSIdAsString(), certificateToken.getDSSIdAsString());
        }
        return xoc;
    }

    protected XmlOrphanCertificateToken buildXmlOrphanCertificateToken(CertificateToken certificateToken) {
        XmlOrphanCertificateToken orphanToken = this.xmlOrphanCertificateTokensMap.get(certificateToken.getDSSIdAsString());
        if (orphanToken == null) {
            orphanToken = new XmlOrphanCertificateToken();
            orphanToken.setEncapsulationType(XmlEncapsulationType.BINARIES);
            orphanToken.setId(this.identifierProvider.getIdAsString((IdentifierBasedObject)certificateToken));
            X500PrincipalHelper subject = certificateToken.getSubject();
            orphanToken.getSubjectDistinguishedName().add(this.getXmlDistinguishedName("CANONICAL", subject.getCanonical()));
            orphanToken.getSubjectDistinguishedName().add(this.getXmlDistinguishedName("RFC2253", subject.getRFC2253()));
            X500PrincipalHelper issuer = certificateToken.getIssuer();
            orphanToken.getIssuerDistinguishedName().add(this.getXmlDistinguishedName("CANONICAL", issuer.getCanonical()));
            orphanToken.getIssuerDistinguishedName().add(this.getXmlDistinguishedName("RFC2253", issuer.getRFC2253()));
            orphanToken.setSerialNumber(certificateToken.getSerialNumber());
            orphanToken.setNotAfter(certificateToken.getNotAfter());
            orphanToken.setNotBefore(certificateToken.getNotBefore());
            orphanToken.setEntityKey(certificateToken.getEntityKey().asXmlId());
            orphanToken.setSelfSigned(Boolean.valueOf(certificateToken.isSelfSigned()));
            orphanToken.setTrusted(Boolean.valueOf(this.allCertificateSources.isTrusted(certificateToken)));
            if (this.tokenExtractionStrategy.isCertificate()) {
                orphanToken.setBase64Encoded(certificateToken.getEncoded());
            } else {
                byte[] certDigest = certificateToken.getDigest(this.defaultDigestAlgorithm);
                orphanToken.setDigestAlgoAndValue(this.getXmlDigestAlgoAndValue(this.defaultDigestAlgorithm, certDigest));
            }
            this.xmlOrphanCertificateTokensMap.put(certificateToken.getDSSIdAsString(), orphanToken);
        }
        return orphanToken;
    }

    private List<XmlOrphanCertificate> getOrphanCertificateRefs(TokenCertificateSource certificateSource, CertificateToken signingCertificate) {
        ArrayList<XmlOrphanCertificate> orphanCertificates = new ArrayList<XmlOrphanCertificate>();
        List orphanCertificateRefs = certificateSource.getOrphanCertificateRefs();
        for (CertificateRef orphanCertificateRef : orphanCertificateRefs) {
            if (this.getUsedCertificateByCertificateRef(orphanCertificateRef) != null) continue;
            orphanCertificates.add(this.createXmlOrphanCertificateFromRef(certificateSource, orphanCertificateRef, signingCertificate));
        }
        return orphanCertificates;
    }

    private XmlOrphanCertificate createXmlOrphanCertificateFromRef(TokenCertificateSource certificateSource, CertificateRef orphanCertificateRef, CertificateToken signingCertificate) {
        XmlOrphanCertificate orphanCertificate = new XmlOrphanCertificate();
        orphanCertificate.setToken(this.getXmlOrphanCertificateTokenFromRef(orphanCertificateRef));
        for (CertificateRefOrigin refOrigin : certificateSource.getCertificateRefOrigins(orphanCertificateRef)) {
            XmlCertificateRef xmlCertificateRef = this.getXmlCertificateRef(orphanCertificateRef, refOrigin);
            if (CertificateRefOrigin.SIGNING_CERTIFICATE.equals((Object)refOrigin)) {
                this.verifyAgainstCertificateToken(xmlCertificateRef, orphanCertificateRef, signingCertificate);
            }
            orphanCertificate.getCertificateRefs().add(xmlCertificateRef);
        }
        return orphanCertificate;
    }

    private XmlOrphanCertificateToken getXmlOrphanCertificateTokenFromRef(CertificateRef orphanCertificateRef) {
        XmlOrphanCertificateToken orphanToken = this.xmlOrphanCertificateTokensMap.get(orphanCertificateRef.getDSSIdAsString());
        if (orphanToken == null) {
            orphanToken = new XmlOrphanCertificateToken();
            orphanToken.setEncapsulationType(XmlEncapsulationType.REFERENCE);
            orphanToken.setId(this.identifierProvider.getIdAsString((IdentifierBasedObject)orphanCertificateRef));
            if (orphanCertificateRef.getCertDigest() != null) {
                orphanToken.setDigestAlgoAndValue(this.getXmlDigestAlgoAndValue(orphanCertificateRef.getCertDigest()));
            }
            this.xmlOrphanCertificateTokensMap.put(orphanCertificateRef.getDSSIdAsString(), orphanToken);
        }
        return orphanToken;
    }

    protected List<XmlRelatedCertificate> getXmlRelatedCertificateForOrphanReferences(TokenCertificateSource certificateSource) {
        ArrayList<XmlRelatedCertificate> relatedCertificates = new ArrayList<XmlRelatedCertificate>();
        for (CertificateRef certificateRef : certificateSource.getOrphanCertificateRefs()) {
            CertificateToken certificateToken = this.getUsedCertificateByCertificateRef(certificateRef);
            if (certificateToken == null) continue;
            relatedCertificates.add(this.getXmlRelatedCertificate(certificateSource, certificateToken, certificateRef));
        }
        return relatedCertificates;
    }

    protected CertificateToken getUsedCertificateByCertificateRef(CertificateRef certificateRef) {
        CertificateTokenRefMatcher matcher = new CertificateTokenRefMatcher();
        for (CertificateToken certificateToken : this.usedCertificates) {
            if (!matcher.match(certificateToken, certificateRef)) continue;
            return certificateToken;
        }
        return null;
    }

    protected void verifyAgainstCertificateToken(XmlCertificateRef xmlCertificateRef, CertificateRef ref, CertificateToken signingCertificate) {
        XmlIssuerSerial issuerSerial;
        CertificateTokenRefMatcher tokenRefMatcher = new CertificateTokenRefMatcher();
        XmlDigestAlgoAndValue digestAlgoAndValue = xmlCertificateRef.getDigestAlgoAndValue();
        if (digestAlgoAndValue != null) {
            digestAlgoAndValue.setMatch(Boolean.valueOf(signingCertificate != null && tokenRefMatcher.matchByDigest(signingCertificate, ref)));
        }
        if ((issuerSerial = xmlCertificateRef.getIssuerSerial()) != null) {
            issuerSerial.setMatch(Boolean.valueOf(signingCertificate != null && tokenRefMatcher.matchByIssuerName(signingCertificate, ref) && tokenRefMatcher.matchBySerialNumber(signingCertificate, ref)));
        }
    }

    private XmlIssuerSerial getXmlIssuerSerial(SignerIdentifier signerIdentifier) {
        XmlIssuerSerial xmlIssuerSerial = new XmlIssuerSerial();
        xmlIssuerSerial.setValue(signerIdentifier.getIssuerSerialEncoded());
        return xmlIssuerSerial;
    }

    protected XmlBasicSignature getXmlBasicSignature(Token token) {
        XmlBasicSignature xmlBasicSignatureType = new XmlBasicSignature();
        SignatureAlgorithm signatureAlgorithm = token.getSignatureAlgorithm();
        if (signatureAlgorithm != null) {
            xmlBasicSignatureType.setEncryptionAlgoUsedToSignThisToken(signatureAlgorithm.getEncryptionAlgorithm());
            xmlBasicSignatureType.setDigestAlgoUsedToSignThisToken(signatureAlgorithm.getDigestAlgorithm());
            xmlBasicSignatureType.setMaskGenerationFunctionUsedToSignThisToken(signatureAlgorithm.getMaskGenerationFunction());
        }
        xmlBasicSignatureType.setKeyLengthUsedToSignThisToken(DSSPKUtils.getStringPublicKeySize(token));
        SignatureValidity signatureValidity = token.getSignatureValidity();
        if (SignatureValidity.NOT_EVALUATED != signatureValidity) {
            boolean signatureValid = SignatureValidity.VALID == token.getSignatureValidity();
            xmlBasicSignatureType.setSignatureIntact(Boolean.valueOf(signatureValid));
            xmlBasicSignatureType.setSignatureValid(Boolean.valueOf(signatureValid));
        }
        return xmlBasicSignatureType;
    }

    protected XmlCertificate buildDetachedXmlCertificate(CertificateToken certToken) {
        XmlCertificate xmlCert = new XmlCertificate();
        xmlCert.setId(this.identifierProvider.getIdAsString((IdentifierBasedObject)certToken));
        X500PrincipalHelper subject = certToken.getSubject();
        xmlCert.getSubjectDistinguishedName().add(this.getXmlDistinguishedName("CANONICAL", subject.getCanonical()));
        xmlCert.getSubjectDistinguishedName().add(this.getXmlDistinguishedName("RFC2253", subject.getRFC2253()));
        X500PrincipalHelper issuer = certToken.getIssuer();
        xmlCert.getIssuerDistinguishedName().add(this.getXmlDistinguishedName("CANONICAL", issuer.getCanonical()));
        xmlCert.getIssuerDistinguishedName().add(this.getXmlDistinguishedName("RFC2253", issuer.getRFC2253()));
        xmlCert.setSerialNumber(certToken.getSerialNumber());
        xmlCert.setSubjectSerialNumber(DSSASN1Utils.extractAttributeFromX500Principal((ASN1ObjectIdentifier)BCStyle.SERIALNUMBER, (X500PrincipalHelper)subject));
        xmlCert.setTitle(DSSASN1Utils.extractAttributeFromX500Principal((ASN1ObjectIdentifier)BCStyle.T, (X500PrincipalHelper)subject));
        xmlCert.setCommonName(DSSASN1Utils.extractAttributeFromX500Principal((ASN1ObjectIdentifier)BCStyle.CN, (X500PrincipalHelper)subject));
        xmlCert.setLocality(DSSASN1Utils.extractAttributeFromX500Principal((ASN1ObjectIdentifier)BCStyle.L, (X500PrincipalHelper)subject));
        xmlCert.setState(DSSASN1Utils.extractAttributeFromX500Principal((ASN1ObjectIdentifier)BCStyle.ST, (X500PrincipalHelper)subject));
        xmlCert.setCountryName(DSSASN1Utils.extractAttributeFromX500Principal((ASN1ObjectIdentifier)BCStyle.C, (X500PrincipalHelper)subject));
        xmlCert.setOrganizationIdentifier(DSSASN1Utils.extractAttributeFromX500Principal((ASN1ObjectIdentifier)BCStyle.ORGANIZATION_IDENTIFIER, (X500PrincipalHelper)subject));
        xmlCert.setOrganizationName(DSSASN1Utils.extractAttributeFromX500Principal((ASN1ObjectIdentifier)BCStyle.O, (X500PrincipalHelper)subject));
        xmlCert.setOrganizationalUnit(DSSASN1Utils.extractAttributeFromX500Principal((ASN1ObjectIdentifier)BCStyle.OU, (X500PrincipalHelper)subject));
        xmlCert.setGivenName(DSSASN1Utils.extractAttributeFromX500Principal((ASN1ObjectIdentifier)BCStyle.GIVENNAME, (X500PrincipalHelper)subject));
        xmlCert.setSurname(DSSASN1Utils.extractAttributeFromX500Principal((ASN1ObjectIdentifier)BCStyle.SURNAME, (X500PrincipalHelper)subject));
        xmlCert.setPseudonym(DSSASN1Utils.extractAttributeFromX500Principal((ASN1ObjectIdentifier)BCStyle.PSEUDONYM, (X500PrincipalHelper)subject));
        xmlCert.setEmail(DSSASN1Utils.extractAttributeFromX500Principal((ASN1ObjectIdentifier)BCStyle.E, (X500PrincipalHelper)subject));
        List subjectAlternativeNames = DSSASN1Utils.getSubjectAlternativeNames((CertificateToken)certToken);
        if (Utils.isCollectionNotEmpty((Collection)subjectAlternativeNames)) {
            xmlCert.setSubjectAlternativeNames(subjectAlternativeNames);
        }
        xmlCert.setAuthorityInformationAccessUrls(this.getCleanedUrls(DSSASN1Utils.getCAAccessLocations((CertificateToken)certToken)));
        xmlCert.setOCSPAccessUrls(this.getCleanedUrls(DSSASN1Utils.getOCSPAccessLocations((CertificateToken)certToken)));
        xmlCert.setCRLDistributionPoints(this.getCleanedUrls(DSSASN1Utils.getCrlUrls((CertificateToken)certToken)));
        xmlCert.setSources(this.getXmlCertificateSources(certToken));
        xmlCert.setNotAfter(certToken.getNotAfter());
        xmlCert.setNotBefore(certToken.getNotBefore());
        PublicKey publicKey = certToken.getPublicKey();
        xmlCert.setPublicKeySize(DSSPKUtils.getPublicKeySize(publicKey));
        xmlCert.setPublicKeyEncryptionAlgo(EncryptionAlgorithm.forKey((Key)publicKey));
        xmlCert.setEntityKey(certToken.getEntityKey().asXmlId());
        xmlCert.setKeyUsageBits(certToken.getKeyUsageBits());
        xmlCert.setExtendedKeyUsages(this.getXmlOids(DSSASN1Utils.getExtendedKeyUsage((CertificateToken)certToken)));
        xmlCert.setIdPkixOcspNoCheck(Boolean.valueOf(DSSASN1Utils.hasIdPkixOcspNoCheckExtension((CertificateToken)certToken)));
        QcStatements qcStatements = QcStatementUtils.getQcStatements((CertificateToken)certToken);
        if (qcStatements != null) {
            xmlCert.setQcStatements(this.getXmlQcStatements(qcStatements));
        }
        xmlCert.setBasicSignature(this.getXmlBasicSignature((Token)certToken));
        xmlCert.setCertificatePolicies(this.getXmlCertificatePolicies(DSSASN1Utils.getCertificatePolicies((CertificateToken)certToken)));
        xmlCert.setSelfSigned(certToken.isSelfSigned());
        xmlCert.setTrusted(this.allCertificateSources.isTrusted(certToken));
        if (this.tokenExtractionStrategy.isCertificate()) {
            xmlCert.setBase64Encoded(certToken.getEncoded());
        } else {
            byte[] certDigest = certToken.getDigest(this.defaultDigestAlgorithm);
            xmlCert.setDigestAlgoAndValue(this.getXmlDigestAlgoAndValue(this.defaultDigestAlgorithm, certDigest));
        }
        return xmlCert;
    }

    private XmlQcStatements getXmlQcStatements(QcStatements qcStatements) {
        XmlQcStatements result = new XmlQcStatements();
        result.setQcCompliance(this.getXmlQcCompliance(qcStatements.isQcCompliance()));
        result.setQcSSCD(this.getXmlQcSSCD(qcStatements.isQcQSCD()));
        if (qcStatements.getQcEuRetentionPeriod() != null) {
            result.setQcEuRetentionPeriod(qcStatements.getQcEuRetentionPeriod());
        }
        if (qcStatements.getQcLimitValue() != null) {
            result.setQcEuLimitValue(this.getQcEuLimitValue(qcStatements.getQcLimitValue()));
        }
        if (Utils.isCollectionNotEmpty((Collection)qcStatements.getQcTypes())) {
            result.setQcTypes(this.getXmlQcTypes(qcStatements.getQcTypes()));
        }
        if (Utils.isCollectionNotEmpty((Collection)qcStatements.getQcEuPDS())) {
            result.setQcEuPDS(this.getXmlQcEuPSD(qcStatements.getQcEuPDS()));
        }
        if (qcStatements.getQcSemanticsIdentifier() != null) {
            result.setSemanticsIdentifier(this.getXmlOid((OidDescription)qcStatements.getQcSemanticsIdentifier()));
        }
        if (Utils.isCollectionNotEmpty((Collection)qcStatements.getQcLegislationCountryCodes())) {
            result.setQcCClegislation(qcStatements.getQcLegislationCountryCodes());
        }
        if (qcStatements.getPsd2QcType() != null) {
            result.setPSD2QcInfo(this.getPSD2QcInfo(qcStatements.getPsd2QcType()));
        }
        return result;
    }

    private List<XmlLangAndValue> getXmlQcEuPSD(List<PdsLocation> qcEuPDS) {
        ArrayList<XmlLangAndValue> result = new ArrayList<XmlLangAndValue>();
        for (PdsLocation pdsLocation : qcEuPDS) {
            XmlLangAndValue xmlPdsLocation = new XmlLangAndValue();
            xmlPdsLocation.setLang(pdsLocation.getLanguage());
            xmlPdsLocation.setValue(pdsLocation.getUrl());
            result.add(xmlPdsLocation);
        }
        return result;
    }

    private XmlQcSSCD getXmlQcSSCD(boolean present) {
        XmlQcSSCD xmlQcSSCD = new XmlQcSSCD();
        xmlQcSSCD.setPresent(present);
        return xmlQcSSCD;
    }

    private XmlQcCompliance getXmlQcCompliance(boolean present) {
        XmlQcCompliance xmlQcCompliance = new XmlQcCompliance();
        xmlQcCompliance.setPresent(present);
        return xmlQcCompliance;
    }

    private XmlOID getXmlOid(OidDescription oidDescription) {
        if (oidDescription == null) {
            return null;
        }
        XmlOID xmlOID = new XmlOID();
        xmlOID.setValue(oidDescription.getOid());
        xmlOID.setDescription(oidDescription.getDescription());
        return xmlOID;
    }

    private XmlPSD2QcInfo getPSD2QcInfo(PSD2QcType psd2QcStatement) {
        XmlPSD2QcInfo xmlInfo = new XmlPSD2QcInfo();
        xmlInfo.setNcaId(psd2QcStatement.getNcaId());
        xmlInfo.setNcaName(psd2QcStatement.getNcaName());
        List rolesOfPSP = psd2QcStatement.getRolesOfPSP();
        ArrayList<XmlRoleOfPSP> psd2Roles = new ArrayList<XmlRoleOfPSP>();
        for (RoleOfPSP roleOfPSP : rolesOfPSP) {
            XmlRoleOfPSP xmlRole = new XmlRoleOfPSP();
            RoleOfPspOid role = roleOfPSP.getPspOid();
            xmlRole.setOid(this.getXmlOid((OidDescription)role));
            xmlRole.setName(roleOfPSP.getPspName());
            psd2Roles.add(xmlRole);
        }
        xmlInfo.setRolesOfPSP(psd2Roles);
        return xmlInfo;
    }

    private XmlQcEuLimitValue getQcEuLimitValue(QCLimitValue qcLimitValue) {
        XmlQcEuLimitValue xmlQcEuLimitValue = new XmlQcEuLimitValue();
        xmlQcEuLimitValue.setCurrency(qcLimitValue.getCurrency());
        xmlQcEuLimitValue.setAmount(qcLimitValue.getAmount());
        xmlQcEuLimitValue.setExponent(qcLimitValue.getExponent());
        return xmlQcEuLimitValue;
    }

    private List<CertificateSourceType> getXmlCertificateSources(CertificateToken token) {
        Set sourceTypes;
        ArrayList<CertificateSourceType> certificateSources = new ArrayList<CertificateSourceType>();
        if (this.allCertificateSources != null && (sourceTypes = this.allCertificateSources.getCertificateSource(token)) != null) {
            certificateSources.addAll(sourceTypes);
        }
        if (Utils.isCollectionEmpty(certificateSources)) {
            certificateSources.add(CertificateSourceType.UNKNOWN);
        }
        return certificateSources;
    }

    private Set<RevocationToken<Revocation>> getRevocationsForCert(CertificateToken certToken) {
        HashSet<RevocationToken<Revocation>> revocations = new HashSet<RevocationToken<Revocation>>();
        if (Utils.isCollectionNotEmpty(this.usedRevocations)) {
            for (RevocationToken revocationToken : this.usedRevocations) {
                if (!Utils.areStringsEqual((String)certToken.getDSSIdAsString(), (String)revocationToken.getRelatedCertificateId())) continue;
                revocations.add((RevocationToken<Revocation>)revocationToken);
            }
        }
        return revocations;
    }

    private List<XmlCertificatePolicy> getXmlCertificatePolicies(List<CertificatePolicy> certificatePolicies) {
        ArrayList<XmlCertificatePolicy> result = new ArrayList<XmlCertificatePolicy>();
        for (CertificatePolicy cp : certificatePolicies) {
            XmlCertificatePolicy xmlCP = new XmlCertificatePolicy();
            xmlCP.setValue(cp.getOid());
            xmlCP.setDescription(OidRepository.getDescription(cp.getOid()));
            xmlCP.setCpsUrl(DSSUtils.removeControlCharacters((String)cp.getCpsUrl()));
            result.add(xmlCP);
        }
        return result;
    }

    private List<XmlOID> getXmlQcTypes(List<QCType> qcTypes) {
        ArrayList<XmlOID> result = new ArrayList<XmlOID>();
        if (Utils.isCollectionNotEmpty(qcTypes)) {
            for (QCType qcType : qcTypes) {
                XmlOID xmlOID = new XmlOID();
                xmlOID.setValue(qcType.getOid());
                xmlOID.setDescription(qcType.getDescription());
                result.add(xmlOID);
            }
        }
        return result;
    }

    private List<XmlOID> getXmlOids(List<String> oidList) {
        ArrayList<XmlOID> result = new ArrayList<XmlOID>();
        if (Utils.isCollectionNotEmpty(oidList)) {
            for (String oid : oidList) {
                XmlOID xmlOID = new XmlOID();
                xmlOID.setValue(oid);
                xmlOID.setDescription(OidRepository.getDescription(oid));
                result.add(xmlOID);
            }
        }
        return result;
    }

    private List<XmlTrustedServiceProvider> getXmlTrustedServiceProviders(CertificateToken certToken) {
        ArrayList<XmlTrustedServiceProvider> result = new ArrayList<XmlTrustedServiceProvider>();
        Map<CertificateToken, List<TrustProperties>> servicesByTrustedCert = this.getRelatedTrustServices(certToken);
        for (Map.Entry<CertificateToken, List<TrustProperties>> entry : servicesByTrustedCert.entrySet()) {
            CertificateToken trustedCert = entry.getKey();
            List<TrustProperties> services = entry.getValue();
            Map<TrustServiceProvider, List<TrustProperties>> servicesByProviders = this.classifyByServiceProvider(services);
            for (Map.Entry<TrustServiceProvider, List<TrustProperties>> servicesByProvider : servicesByProviders.entrySet()) {
                List<TrustProperties> trustServices = servicesByProvider.getValue();
                XmlTrustedServiceProvider serviceProvider = this.buildXmlTrustedServiceProvider(trustServices.iterator().next());
                serviceProvider.setTrustedServices(this.buildXmlTrustedServices(trustServices, certToken, trustedCert));
                result.add(serviceProvider);
            }
        }
        return Collections.unmodifiableList(result);
    }

    private XmlTrustedServiceProvider buildXmlTrustedServiceProvider(TrustProperties trustProperties) {
        XmlTrustedServiceProvider result = new XmlTrustedServiceProvider();
        if (trustProperties.getLOTLIdentifier() != null) {
            result.setLOTL(this.xmlTrustedListsMap.get(trustProperties.getLOTLIdentifier().asXmlId()));
        }
        if (trustProperties.getTLIdentifier() != null) {
            result.setTL(this.xmlTrustedListsMap.get(trustProperties.getTLIdentifier().asXmlId()));
        }
        TrustServiceProvider tsp = trustProperties.getTrustServiceProvider();
        result.setTSPNames(this.getLangAndValues(tsp.getNames()));
        result.setTSPTradeNames(this.getLangAndValues(tsp.getTradeNames()));
        result.setTSPRegistrationIdentifiers(tsp.getRegistrationIdentifiers());
        return result;
    }

    private List<XmlLangAndValue> getLangAndValues(Map<String, List<String>> map) {
        if (Utils.isMapNotEmpty(map)) {
            ArrayList<XmlLangAndValue> result = new ArrayList<XmlLangAndValue>();
            for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                String lang = entry.getKey();
                for (String value : entry.getValue()) {
                    XmlLangAndValue langAndValue = new XmlLangAndValue();
                    langAndValue.setLang(lang);
                    langAndValue.setValue(value);
                    result.add(langAndValue);
                }
            }
            return result;
        }
        return null;
    }

    private Map<CertificateToken, List<TrustProperties>> getRelatedTrustServices(CertificateToken certToken) {
        HashMap<CertificateToken, List<TrustProperties>> result = new HashMap<CertificateToken, List<TrustProperties>>();
        HashSet<CertificateToken> processedTokens = new HashSet<CertificateToken>();
        block0: for (CertificateSource trustedSource : this.allCertificateSources.getSources()) {
            if (!(trustedSource instanceof TrustedListsCertificateSource)) continue;
            TrustedListsCertificateSource trustedCertSource = (TrustedListsCertificateSource)trustedSource;
            while (certToken != null) {
                List trustServices = trustedCertSource.getTrustServices(certToken);
                if (!trustServices.isEmpty()) {
                    result.put(certToken, trustServices);
                }
                if (certToken.isSelfSigned() || processedTokens.contains(certToken)) continue block0;
                processedTokens.add(certToken);
                certToken = this.getIssuerCertificate((Token)certToken);
            }
        }
        return result;
    }

    private List<XmlTrustedService> buildXmlTrustedServices(List<TrustProperties> trustPropertiesList, CertificateToken certToken, CertificateToken trustedCert) {
        ArrayList<XmlTrustedService> result = new ArrayList<XmlTrustedService>();
        for (TrustProperties trustProperties : trustPropertiesList) {
            TimeDependentValues trustService = trustProperties.getTrustService();
            List serviceStatusAfterOfEqualsCertIssuance = trustService.getAfter(certToken.getNotBefore());
            if (!Utils.isCollectionNotEmpty((Collection)serviceStatusAfterOfEqualsCertIssuance)) continue;
            for (TrustServiceStatusAndInformationExtensions serviceInfoStatus : serviceStatusAfterOfEqualsCertIssuance) {
                List serviceSupplyPoints;
                List additionalServiceInfoUris;
                XmlTrustedService trustedService = new XmlTrustedService();
                trustedService.setServiceDigitalIdentifier(this.xmlCertsMap.get(trustedCert.getDSSIdAsString()));
                trustedService.setServiceNames(this.getLangAndValues(serviceInfoStatus.getNames()));
                trustedService.setServiceType(serviceInfoStatus.getType());
                trustedService.setStatus(serviceInfoStatus.getStatus());
                trustedService.setStartDate(serviceInfoStatus.getStartDate());
                trustedService.setEndDate(serviceInfoStatus.getEndDate());
                List<String> qualifiers = this.getQualifiers(serviceInfoStatus, certToken);
                if (Utils.isCollectionNotEmpty(qualifiers)) {
                    trustedService.setCapturedQualifiers(qualifiers);
                }
                if (Utils.isCollectionNotEmpty((Collection)(additionalServiceInfoUris = serviceInfoStatus.getAdditionalServiceInfoUris()))) {
                    trustedService.setAdditionalServiceInfoUris(additionalServiceInfoUris);
                }
                if (Utils.isCollectionNotEmpty((Collection)(serviceSupplyPoints = serviceInfoStatus.getServiceSupplyPoints()))) {
                    trustedService.setServiceSupplyPoints(serviceSupplyPoints);
                }
                trustedService.setExpiredCertsRevocationInfo(serviceInfoStatus.getExpiredCertsRevocationInfo());
                result.add(trustedService);
            }
        }
        return Collections.unmodifiableList(result);
    }

    private Map<TrustServiceProvider, List<TrustProperties>> classifyByServiceProvider(List<TrustProperties> trustPropertiesList) {
        HashMap<TrustServiceProvider, List<TrustProperties>> servicesByProviders = new HashMap<TrustServiceProvider, List<TrustProperties>>();
        if (Utils.isCollectionNotEmpty(trustPropertiesList)) {
            for (TrustProperties trustProperties : trustPropertiesList) {
                TrustServiceProvider currentTrustServiceProvider = trustProperties.getTrustServiceProvider();
                ArrayList<TrustProperties> list = (ArrayList<TrustProperties>)servicesByProviders.get(currentTrustServiceProvider);
                if (list == null) {
                    list = new ArrayList<TrustProperties>();
                    servicesByProviders.put(currentTrustServiceProvider, list);
                }
                list.add(trustProperties);
            }
        }
        return servicesByProviders;
    }

    private List<String> getQualifiers(TrustServiceStatusAndInformationExtensions serviceInfoStatus, CertificateToken certificateToken) {
        LOG.trace("--> GET_QUALIFIERS()");
        ArrayList<String> list = new ArrayList<String>();
        List conditionsForQualifiers = serviceInfoStatus.getConditionsForQualifiers();
        if (Utils.isCollectionNotEmpty((Collection)conditionsForQualifiers)) {
            for (ConditionForQualifiers conditionForQualifiers : conditionsForQualifiers) {
                Condition condition = conditionForQualifiers.getCondition();
                if (!condition.check(certificateToken)) continue;
                list.addAll(conditionForQualifiers.getQualifiers());
            }
        }
        return list;
    }

    protected XmlDigestAlgoAndValue getXmlDigestAlgoAndValue(Digest digest) {
        if (digest == null) {
            return this.getXmlDigestAlgoAndValue(null, null);
        }
        return this.getXmlDigestAlgoAndValue(digest.getAlgorithm(), digest.getValue());
    }

    protected XmlDigestAlgoAndValue getXmlDigestAlgoAndValue(DigestAlgorithm digestAlgo, byte[] digestValue) {
        XmlDigestAlgoAndValue xmlDigestAlgAndValue = new XmlDigestAlgoAndValue();
        xmlDigestAlgAndValue.setDigestMethod(digestAlgo);
        xmlDigestAlgAndValue.setDigestValue(digestValue == null ? DSSUtils.EMPTY_BYTE_ARRAY : digestValue);
        return xmlDigestAlgAndValue;
    }
}

