/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.diagnostic.jaxb.XmlDiagnosticData;
import eu.europa.esig.dss.enumerations.TokenExtractionStrategy;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.identifier.IdentifierBasedObject;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.policy.ValidationPolicy;
import eu.europa.esig.dss.policy.ValidationPolicyFacade;
import eu.europa.esig.dss.validation.CertificateDiagnosticDataBuilder;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.OriginalIdentifierProvider;
import eu.europa.esig.dss.validation.ProcessExecutorProvider;
import eu.europa.esig.dss.validation.SignatureValidationContext;
import eu.europa.esig.dss.validation.TokenIdentifierProvider;
import eu.europa.esig.dss.validation.executor.certificate.CertificateProcessExecutor;
import eu.europa.esig.dss.validation.executor.certificate.DefaultCertificateProcessExecutor;
import eu.europa.esig.dss.validation.reports.CertificateReports;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;

public class CertificateValidator
implements ProcessExecutorProvider<CertificateProcessExecutor> {
    private final CertificateToken token;
    private Date validationTime;
    private CertificateVerifier certificateVerifier;
    private TokenExtractionStrategy tokenExtractionStrategy = TokenExtractionStrategy.NONE;
    private TokenIdentifierProvider identifierProvider = new OriginalIdentifierProvider();
    private Locale locale = Locale.getDefault();
    private CertificateProcessExecutor processExecutor;

    private CertificateValidator(CertificateToken token) {
        Objects.requireNonNull(token, "The certificate is missing");
        this.token = token;
    }

    public static CertificateValidator fromCertificate(CertificateToken token) {
        return new CertificateValidator(token);
    }

    public void setCertificateVerifier(CertificateVerifier certificateVerifier) {
        this.certificateVerifier = certificateVerifier;
    }

    public void setTokenExtractionStrategy(TokenExtractionStrategy tokenExtractionStrategy) {
        Objects.requireNonNull(tokenExtractionStrategy);
        this.tokenExtractionStrategy = tokenExtractionStrategy;
    }

    public void setTokenIdentifierProvider(TokenIdentifierProvider identifierProvider) {
        Objects.requireNonNull(identifierProvider);
        this.identifierProvider = identifierProvider;
    }

    public void setValidationTime(Date validationTime) {
        this.validationTime = validationTime;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    private Date getValidationTime() {
        if (this.validationTime == null) {
            this.validationTime = new Date();
        }
        return this.validationTime;
    }

    public CertificateReports validate() {
        ValidationPolicy defaultPolicy;
        try {
            defaultPolicy = ValidationPolicyFacade.newFacade().getDefaultValidationPolicy();
        }
        catch (Exception e) {
            throw new DSSException("Unable to load the default policy", (Throwable)e);
        }
        return this.validate(defaultPolicy);
    }

    public CertificateReports validate(ValidationPolicy validationPolicy) {
        SignatureValidationContext svc = new SignatureValidationContext();
        svc.initialize(this.certificateVerifier);
        svc.addCertificateTokenForVerification(this.token);
        svc.setCurrentTime(this.getValidationTime());
        svc.validate();
        XmlDiagnosticData diagnosticData = ((CertificateDiagnosticDataBuilder)((CertificateDiagnosticDataBuilder)new CertificateDiagnosticDataBuilder().usedCertificates((Set)svc.getProcessedCertificates())).usedRevocations((Set)svc.getProcessedRevocations())).allCertificateSources(svc.getAllCertificateSources()).defaultDigestAlgorithm(this.certificateVerifier.getDefaultDigestAlgorithm()).tokenExtractionStrategy(this.tokenExtractionStrategy).tokenIdentifierProvider(this.identifierProvider).validationDate(this.getValidationTime()).build();
        CertificateProcessExecutor executor = this.provideProcessExecutorInstance();
        executor.setValidationPolicy(validationPolicy);
        executor.setDiagnosticData(diagnosticData);
        executor.setCertificateId(this.identifierProvider.getIdAsString((IdentifierBasedObject)this.token));
        executor.setLocale(this.locale);
        executor.setCurrentTime(this.getValidationTime());
        return (CertificateReports)executor.execute();
    }

    @Override
    public void setProcessExecutor(CertificateProcessExecutor processExecutor) {
        this.processExecutor = processExecutor;
    }

    public CertificateProcessExecutor provideProcessExecutorInstance() {
        if (this.processExecutor == null) {
            this.processExecutor = this.getDefaultProcessExecutor();
        }
        return this.processExecutor;
    }

    @Override
    public CertificateProcessExecutor getDefaultProcessExecutor() {
        return new DefaultCertificateProcessExecutor();
    }
}

