/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.x509.CandidatesForSigningCertificate;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import eu.europa.esig.dss.spi.x509.CertificateValidity;
import eu.europa.esig.dss.spi.x509.ListCertificateSource;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.DefaultAdvancedSignature;
import eu.europa.esig.dss.validation.SignaturePolicy;
import eu.europa.esig.dss.validation.SignatureValidationContext;
import eu.europa.esig.dss.validation.ValidationContext;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaselineRequirementsChecker<AS extends DefaultAdvancedSignature> {
    private static final Logger LOG = LoggerFactory.getLogger(BaselineRequirementsChecker.class);
    protected final AS signature;
    private final CertificateVerifier offlineCertificateVerifier;

    protected BaselineRequirementsChecker(AS signature, CertificateVerifier offlineCertificateVerifier) {
        this.signature = signature;
        this.offlineCertificateVerifier = offlineCertificateVerifier;
    }

    public abstract boolean hasBaselineBProfile();

    public abstract boolean hasBaselineTProfile();

    public abstract boolean hasBaselineLTProfile();

    public abstract boolean hasBaselineLTAProfile();

    protected boolean minimalTRequirement() {
        if (Utils.isCollectionEmpty(((DefaultAdvancedSignature)this.signature).getSignatureTimestamps())) {
            LOG.trace("SignatureTimeStamp shall be present for BASELINE-T signature (cardinality >= 1)!");
            return false;
        }
        CertificateToken signingCertificate = ((DefaultAdvancedSignature)this.signature).getSigningCertificateToken();
        if (signingCertificate != null) {
            for (TimestampToken timestampToken : ((DefaultAdvancedSignature)this.signature).getSignatureTimestamps()) {
                if (timestampToken.getCreationDate().before(signingCertificate.getNotAfter())) continue;
                LOG.warn("SignatureTimeStamp shall be generated before the signing certificate expiration for BASELINE-T signature!");
                return false;
            }
        }
        return true;
    }

    public boolean minimalLTRequirement() {
        boolean minimalLTRequirement;
        Objects.requireNonNull(this.offlineCertificateVerifier, "offlineCertificateVerifier cannot be null!");
        ListCertificateSource certificateSources = this.getCertificateSourcesExceptLastArchiveTimestamp();
        boolean certificateFound = certificateSources.getNumberOfCertificates() > 0;
        boolean allSelfSigned = certificateFound && certificateSources.isAllSelfSigned();
        boolean emptyCRLs = ((DefaultAdvancedSignature)this.signature).getCompleteCRLSource().getAllRevocationBinaries().isEmpty();
        boolean emptyOCSPs = ((DefaultAdvancedSignature)this.signature).getCompleteOCSPSource().getAllRevocationBinaries().isEmpty();
        boolean emptyRevocation = emptyCRLs && emptyOCSPs;
        boolean bl = minimalLTRequirement = !allSelfSigned && !emptyRevocation;
        if (minimalLTRequirement) {
            return this.isAllRevocationDataPresent(this.offlineCertificateVerifier);
        }
        return minimalLTRequirement;
    }

    protected ListCertificateSource getCertificateSourcesExceptLastArchiveTimestamp() {
        ListCertificateSource certificateSource = new ListCertificateSource((CertificateSource)this.signature.getCertificateSource());
        certificateSource.addAll(this.signature.getTimestampSource().getTimestampCertificateSourcesExceptLastArchiveTimestamp());
        certificateSource.addAll(((DefaultAdvancedSignature)this.signature).getCounterSignaturesCertificateSource());
        return certificateSource;
    }

    private boolean isAllRevocationDataPresent(CertificateVerifier offlineCertificateVerifier) {
        SignatureValidationContext validationContext = new SignatureValidationContext();
        validationContext.initialize(offlineCertificateVerifier);
        validationContext.addDocumentCertificateSource(((DefaultAdvancedSignature)this.signature).getCompleteCertificateSource());
        validationContext.addDocumentCRLSource(((DefaultAdvancedSignature)this.signature).getCompleteCRLSource());
        validationContext.addDocumentOCSPSource(((DefaultAdvancedSignature)this.signature).getCompleteOCSPSource());
        this.addSignatureForVerification(validationContext, (AdvancedSignature)this.signature);
        validationContext.validate();
        return validationContext.checkAllRequiredRevocationDataPresent();
    }

    private void addSignatureForVerification(ValidationContext validationContext, AdvancedSignature signature) {
        CertificateToken signingCertificate = signature.getSigningCertificateToken();
        if (signingCertificate != null) {
            validationContext.addCertificateTokenForVerification(signingCertificate);
        } else {
            CandidatesForSigningCertificate candidatesForSigningCertificate = signature.getCandidatesForSigningCertificate();
            List certificateValidities = candidatesForSigningCertificate.getCertificateValidityList();
            if (Utils.isCollectionNotEmpty((Collection)certificateValidities)) {
                for (CertificateValidity certificateValidity : certificateValidities) {
                    if (!certificateValidity.isValid() || certificateValidity.getCertificateToken() == null) continue;
                    validationContext.addCertificateTokenForVerification(certificateValidity.getCertificateToken());
                }
            }
        }
        for (TimestampToken timestampToken : signature.getTimestampSource().getAllTimestampsExceptLastArchiveTimestamp()) {
            validationContext.addTimestampTokenForVerification(timestampToken);
        }
        for (AdvancedSignature counterSignature : signature.getCounterSignatures()) {
            this.addSignatureForVerification(validationContext, counterSignature);
        }
    }

    public boolean minimalLTARequirement() {
        if (Utils.isCollectionEmpty(((DefaultAdvancedSignature)this.signature).getArchiveTimestamps())) {
            LOG.trace("ArchiveTimeStamp shall be present for BASELINE-LTA signature (cardinality >= 1)!");
            return false;
        }
        return true;
    }

    protected boolean containsSigningCertificate(Collection<CertificateToken> certificateTokens) {
        CertificateToken signingCertificate = ((DefaultAdvancedSignature)this.signature).getSigningCertificateToken();
        for (CertificateToken certificate : certificateTokens) {
            if (!certificate.equals((Object)signingCertificate)) continue;
            return true;
        }
        return false;
    }

    protected boolean isSignaturePolicyIdentifierHashPresent() {
        Digest digest;
        SignaturePolicy signaturePolicyIdentifier = ((DefaultAdvancedSignature)this.signature).getSignaturePolicy();
        return signaturePolicyIdentifier != null && (digest = signaturePolicyIdentifier.getDigest()) != null && digest.getAlgorithm() != null;
    }
}

