/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.timestamp;

import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import eu.europa.esig.dss.validation.timestamp.TimestampedReference;
import java.io.Serializable;
import java.util.Comparator;
import java.util.List;

public class TimestampTokenComparator
implements Comparator<TimestampToken>,
Serializable {
    private static final long serialVersionUID = 3404578959761631884L;

    @Override
    public int compare(TimestampToken tst1, TimestampToken tst2) {
        int result = tst1.getGenerationTime().compareTo(tst2.getGenerationTime());
        if (result == 0) {
            TimestampType tst1Type = tst1.getTimeStampType();
            TimestampType tst2Type = tst2.getTimeStampType();
            result = tst1Type.compare(tst2Type);
        }
        if (result == 0) {
            if (this.isCoveredByTimestamp(tst1, tst2)) {
                result = -1;
            } else if (this.isCoveredByTimestamp(tst2, tst1)) {
                result = 1;
            }
        }
        if (result == 0) {
            List<TimestampedReference> tst1References = tst1.getTimestampedReferences();
            List<TimestampedReference> tst2References = tst2.getTimestampedReferences();
            if (tst1References != null && tst2References != null) {
                if (tst1References.size() < tst2References.size()) {
                    result = -1;
                } else if (tst1References.size() > tst2References.size()) {
                    result = 1;
                }
            }
        }
        return result;
    }

    private boolean isCoveredByTimestamp(TimestampToken tst1, TimestampToken tst2) {
        List<TimestampedReference> tst2References = tst2.getTimestampedReferences();
        for (TimestampedReference timestampedReference : tst2References) {
            if (!tst1.getDSSIdAsString().equals(timestampedReference.getObjectId())) continue;
            return true;
        }
        return false;
    }
}

