/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.policy;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.SignaturePolicy;
import eu.europa.esig.dss.validation.policy.AbstractSignaturePolicyValidator;

public class NonASN1SignaturePolicyValidator
extends AbstractSignaturePolicyValidator {
    @Override
    public boolean canValidate() {
        SignaturePolicy policy = this.getSignaturePolicy();
        if (policy.getPolicyContent() != null) {
            byte firstByte = DSSUtils.readFirstByte((DSSDocument)policy.getPolicyContent());
            return !DSSASN1Utils.isASN1SequenceTag((byte)firstByte) && !DomUtils.startsWithXmlPreamble(policy.getPolicyContent());
        }
        return false;
    }

    @Override
    public void validate() {
        this.setIdentified(true);
        SignaturePolicy signaturePolicy = this.getSignaturePolicy();
        Digest digest = signaturePolicy.getDigest();
        if (digest != null) {
            Digest recalculatedDigest = this.getComputedDigest(digest.getAlgorithm());
            if (digest.equals((Object)recalculatedDigest)) {
                this.setStatus(true);
                this.setDigestAlgorithmsEqual(true);
            } else {
                this.addError("general", "The policy digest value (" + Utils.toBase64((byte[])digest.getValue()) + ") does not match the re-calculated digest value (" + Utils.toBase64((byte[])recalculatedDigest.getValue()) + ").");
            }
        } else {
            this.addError("general", "The policy digest value is not defined.");
        }
    }

    @Override
    public Digest getComputedDigest(DigestAlgorithm digestAlgorithm) {
        SignaturePolicy signaturePolicy = this.getSignaturePolicy();
        DSSDocument policyContent = signaturePolicy.getPolicyContent();
        return DSSUtils.getDigest((DigestAlgorithm)digestAlgorithm, (DSSDocument)policyContent);
    }
}

