/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.policy;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.SignaturePolicy;
import eu.europa.esig.dss.validation.policy.AbstractSignaturePolicyValidator;
import java.util.Arrays;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicASNSignaturePolicyValidator
extends AbstractSignaturePolicyValidator {
    private static final Logger LOG = LoggerFactory.getLogger(BasicASNSignaturePolicyValidator.class);

    @Override
    public void validate() {
        SignaturePolicy signaturePolicy = this.getSignaturePolicy();
        DSSDocument policyContent = signaturePolicy.getPolicyContent();
        byte[] policyBytes = DSSUtils.toByteArray((DSSDocument)policyContent);
        Digest digest = signaturePolicy.getDigest();
        this.setStatus(true);
        this.setIdentified(true);
        try {
            ASN1Sequence asn1Sequence = (ASN1Sequence)DSSASN1Utils.toASN1Primitive((byte[])policyBytes);
            if (asn1Sequence != null) {
                this.setAsn1Processable(true);
                ASN1Sequence signPolicyHashAlgObject = (ASN1Sequence)asn1Sequence.getObjectAt(0);
                AlgorithmIdentifier signPolicyHashAlgIdentifier = AlgorithmIdentifier.getInstance((Object)signPolicyHashAlgObject);
                DigestAlgorithm signPolicyHashAlgFromPolicy = DigestAlgorithm.forOID((String)signPolicyHashAlgIdentifier.getAlgorithm().getId());
                if (!signPolicyHashAlgFromPolicy.equals((Object)digest.getAlgorithm())) {
                    this.addError("general", "The digest algorithm indicated in the SignPolicyHashAlg from the resulting document (" + signPolicyHashAlgFromPolicy + ") is not equal to the digest algorithm (" + digest.getAlgorithm() + ").");
                    this.setDigestAlgorithmsEqual(false);
                    this.setStatus(false);
                    return;
                }
                this.setDigestAlgorithmsEqual(true);
                Digest recalculatedDigest = this.getComputedDigest(signPolicyHashAlgFromPolicy);
                boolean equal = digest.equals((Object)recalculatedDigest);
                this.setStatus(equal);
                if (!equal) {
                    this.addError("general", "The policy digest value (" + Utils.toBase64((byte[])digest.getValue()) + ") does not match the re-calculated digest value (" + Utils.toBase64((byte[])recalculatedDigest.getValue()) + ").");
                    return;
                }
                ASN1OctetString signPolicyHash = (ASN1OctetString)asn1Sequence.getObjectAt(2);
                byte[] policyDigestValueFromPolicy = signPolicyHash.getOctets();
                equal = Arrays.equals(digest.getValue(), policyDigestValueFromPolicy);
                this.setStatus(equal);
                if (!equal) {
                    this.addError("general", "The policy digest value (" + Utils.toBase64((byte[])digest.getValue()) + ") does not match the digest value from the policy file (" + Utils.toBase64((byte[])policyDigestValueFromPolicy) + ").");
                }
            }
        }
        catch (Exception e) {
            this.setStatus(false);
            this.addError("general", e.getMessage());
            LOG.warn(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public boolean canValidate() {
        SignaturePolicy policy = this.getSignaturePolicy();
        if (policy.getPolicyContent() != null) {
            byte firstByte = DSSUtils.readFirstByte((DSSDocument)policy.getPolicyContent());
            return DSSASN1Utils.isASN1SequenceTag((byte)firstByte);
        }
        return false;
    }

    @Override
    public Digest getComputedDigest(DigestAlgorithm digestAlgorithm) {
        SignaturePolicy signaturePolicy = this.getSignaturePolicy();
        DSSDocument policyContent = signaturePolicy.getPolicyContent();
        byte[] asn1SignaturePolicyDigest = DSSASN1Utils.getAsn1SignaturePolicyDigest((DigestAlgorithm)digestAlgorithm, (byte[])DSSUtils.toByteArray((DSSDocument)policyContent));
        return new Digest(digestAlgorithm, asn1SignaturePolicyDigest);
    }
}

