/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.diagnostic.jaxb.XmlDigestAlgoAndValue;
import eu.europa.esig.dss.diagnostic.jaxb.XmlPolicy;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSignaturePolicyStore;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.SignaturePolicyStore;
import eu.europa.esig.dss.model.SpDocSpecification;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.SignaturePolicy;
import eu.europa.esig.dss.validation.SignaturePolicyProvider;
import eu.europa.esig.dss.validation.policy.SignaturePolicyValidator;
import eu.europa.esig.dss.validation.policy.SignaturePolicyValidatorLoader;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlPolicyBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(XmlPolicyBuilder.class);
    private final SignaturePolicy signaturePolicy;
    private SignaturePolicyProvider signaturePolicyProvider;
    private SignaturePolicyStore signaturePolicyStore;
    private DigestAlgorithm defaultDigestAlgorithm = DigestAlgorithm.SHA256;
    private SignaturePolicyValidator validator;

    public XmlPolicyBuilder(SignaturePolicy signaturePolicy) {
        Objects.requireNonNull(signaturePolicy, "SignaturePolicy cannot be null!");
        this.signaturePolicy = signaturePolicy;
    }

    public void setSignaturePolicyProvider(SignaturePolicyProvider signaturePolicyProvider) {
        this.signaturePolicyProvider = signaturePolicyProvider;
    }

    public void setSignaturePolicyStore(SignaturePolicyStore signaturePolicyStore) {
        this.signaturePolicyStore = signaturePolicyStore;
    }

    public void setDefaultDigestAlgorithm(DigestAlgorithm digestAlgorithm) {
        this.defaultDigestAlgorithm = digestAlgorithm;
    }

    public XmlPolicy build() {
        Digest digest;
        DSSDocument policyContent = this.extractPolicyContent();
        this.signaturePolicy.setPolicyContent(policyContent);
        XmlPolicy xmlPolicy = new XmlPolicy();
        xmlPolicy.setId(this.signaturePolicy.getIdentifier());
        xmlPolicy.setUrl(DSSUtils.removeControlCharacters((String)this.signaturePolicy.getUrl()));
        xmlPolicy.setDescription(this.signaturePolicy.getDescription());
        xmlPolicy.setDocumentationReferences(this.signaturePolicy.getDocumentationReferences());
        xmlPolicy.setNotice(this.signaturePolicy.getNotice());
        xmlPolicy.setZeroHash(Boolean.valueOf(this.signaturePolicy.isZeroHash()));
        List<String> transformsDescription = this.signaturePolicy.getTransformsDescription();
        if (Utils.isCollectionNotEmpty(transformsDescription)) {
            xmlPolicy.setTransformations(transformsDescription);
        }
        if ((digest = this.signaturePolicy.getDigest()) != null) {
            xmlPolicy.setDigestAlgoAndValue(this.getXmlDigestAlgoAndValue(digest.getAlgorithm(), digest.getValue()));
        }
        try {
            SignaturePolicyValidator validator = this.getValidator(this.signaturePolicy);
            validator.validate();
            xmlPolicy.setAsn1Processable(Boolean.valueOf(validator.isAsn1Processable()));
            if (!this.signaturePolicy.isZeroHash()) {
                xmlPolicy.setDigestAlgorithmsEqual(Boolean.valueOf(validator.isDigestAlgorithmsEqual()));
            }
            xmlPolicy.setIdentified(Boolean.valueOf(validator.isIdentified()));
            xmlPolicy.setStatus(Boolean.valueOf(validator.isStatus()));
            if (Utils.isStringNotBlank((String)validator.getProcessingErrors())) {
                xmlPolicy.setProcessingError(validator.getProcessingErrors());
            }
        }
        catch (Exception e) {
            xmlPolicy.setStatus(Boolean.valueOf(false));
            xmlPolicy.setProcessingError(e.getMessage());
            String errorMessage = "An error occurred during validation a signature policy with id '{}'. Reason : [{}]";
            if (LOG.isDebugEnabled()) {
                LOG.warn(errorMessage, new Object[]{this.signaturePolicy.getIdentifier(), e.getMessage(), e});
            }
            LOG.warn(errorMessage, (Object)this.signaturePolicy.getIdentifier(), (Object)e.getMessage());
        }
        return xmlPolicy;
    }

    public DSSDocument extractPolicyContent() {
        if (this.signaturePolicyStore != null && this.signaturePolicyStore.getSignaturePolicyContent() != null) {
            return this.signaturePolicyStore.getSignaturePolicyContent();
        }
        if (this.signaturePolicyProvider != null) {
            return this.signaturePolicyProvider.getSignaturePolicy(this.signaturePolicy.getIdentifier(), this.signaturePolicy.getUrl());
        }
        throw new DSSException("Unable to extact a SignaturePolicy content. SignaturePolicyStore or SignaturePolicyProvider shall be provided.");
    }

    public XmlSignaturePolicyStore buildSignaturePolicyStore() {
        DSSDocument signaturePolicyContent;
        if (this.signaturePolicyStore == null) {
            return null;
        }
        XmlSignaturePolicyStore xmlSignaturePolicyStore = new XmlSignaturePolicyStore();
        SpDocSpecification spDocSpecification = this.signaturePolicyStore.getSpDocSpecification();
        if (spDocSpecification != null) {
            xmlSignaturePolicyStore.setId(spDocSpecification.getId());
            xmlSignaturePolicyStore.setDescription(spDocSpecification.getDescription());
            Object[] documentationReferences = spDocSpecification.getDocumentationReferences();
            if (Utils.isArrayNotEmpty((Object[])documentationReferences)) {
                xmlSignaturePolicyStore.setDocumentationReferences(Arrays.asList(documentationReferences));
            }
        }
        if ((signaturePolicyContent = this.signaturePolicyStore.getSignaturePolicyContent()) != null) {
            DigestAlgorithm digestAlgorithm = this.defaultDigestAlgorithm;
            if (this.signaturePolicy != null && this.signaturePolicy.getDigest() != null) {
                digestAlgorithm = this.signaturePolicy.getDigest().getAlgorithm();
            }
            SignaturePolicyValidator validator = this.getValidator(this.signaturePolicy);
            Digest recalculatedDigest = validator.getComputedDigest(digestAlgorithm);
            xmlSignaturePolicyStore.setDigestAlgoAndValue(this.getXmlDigestAlgoAndValue(recalculatedDigest.getAlgorithm(), recalculatedDigest.getValue()));
        }
        return xmlSignaturePolicyStore;
    }

    private SignaturePolicyValidator getValidator(SignaturePolicy signaturePolicy) {
        if (this.validator == null) {
            this.validator = new SignaturePolicyValidatorLoader(signaturePolicy).loadValidator();
        }
        return this.validator;
    }

    private XmlDigestAlgoAndValue getXmlDigestAlgoAndValue(DigestAlgorithm digestAlgo, byte[] digestValue) {
        XmlDigestAlgoAndValue xmlDigestAlgAndValue = new XmlDigestAlgoAndValue();
        xmlDigestAlgAndValue.setDigestMethod(digestAlgo);
        xmlDigestAlgAndValue.setDigestValue(digestValue == null ? DSSUtils.EMPTY_BYTE_ARRAY : digestValue);
        return xmlDigestAlgAndValue;
    }
}

