/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLToken;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPToken;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ValidationDataForInclusion {
    private Set<CertificateToken> certificateTokens;
    private List<CRLToken> crlTokens;
    private List<OCSPToken> ocspTokens;

    void setCertificateTokens(Set<CertificateToken> certificateTokens) {
        this.certificateTokens = certificateTokens;
    }

    void setCrlTokens(List<CRLToken> crlTokens) {
        this.crlTokens = crlTokens;
    }

    void setOcspTokens(List<OCSPToken> ocspTokens) {
        this.ocspTokens = ocspTokens;
    }

    public Set<CertificateToken> getCertificateTokens() {
        if (Utils.isCollectionEmpty(this.certificateTokens)) {
            this.certificateTokens = new HashSet<CertificateToken>();
        }
        return this.certificateTokens;
    }

    public List<CRLToken> getCrlTokens() {
        if (Utils.isCollectionEmpty(this.crlTokens)) {
            this.crlTokens = new ArrayList<CRLToken>();
        }
        return this.crlTokens;
    }

    public List<OCSPToken> getOcspTokens() {
        if (Utils.isCollectionEmpty(this.ocspTokens)) {
            this.ocspTokens = new ArrayList<OCSPToken>();
        }
        return this.ocspTokens;
    }

    public boolean isEmpty() {
        return Utils.isCollectionEmpty(this.certificateTokens) && Utils.isCollectionEmpty(this.crlTokens) && Utils.isCollectionEmpty(this.ocspTokens);
    }
}

