/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.CertificateReorderer;
import eu.europa.esig.dss.alert.status.Status;
import eu.europa.esig.dss.enumerations.CertificateSourceType;
import eu.europa.esig.dss.enumerations.RevocationReason;
import eu.europa.esig.dss.enumerations.RevocationType;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.Token;
import eu.europa.esig.dss.model.x509.X500PrincipalHelper;
import eu.europa.esig.dss.model.x509.revocation.Revocation;
import eu.europa.esig.dss.model.x509.revocation.crl.CRL;
import eu.europa.esig.dss.model.x509.revocation.ocsp.OCSP;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSRevocationUtils;
import eu.europa.esig.dss.spi.client.http.DataLoader;
import eu.europa.esig.dss.spi.x509.AlternateUrlsSourceAdapter;
import eu.europa.esig.dss.spi.x509.CandidatesForSigningCertificate;
import eu.europa.esig.dss.spi.x509.CertificateRef;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import eu.europa.esig.dss.spi.x509.CertificateValidity;
import eu.europa.esig.dss.spi.x509.CommonTrustedCertificateSource;
import eu.europa.esig.dss.spi.x509.ListCertificateSource;
import eu.europa.esig.dss.spi.x509.ResponderId;
import eu.europa.esig.dss.spi.x509.revocation.RevocationCertificateSource;
import eu.europa.esig.dss.spi.x509.revocation.RevocationSource;
import eu.europa.esig.dss.spi.x509.revocation.RevocationSourceAlternateUrlsSupport;
import eu.europa.esig.dss.spi.x509.revocation.RevocationToken;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPToken;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AIACertificateSource;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.ListRevocationSource;
import eu.europa.esig.dss.validation.OCSPAndCRLRevocationSource;
import eu.europa.esig.dss.validation.ValidationContext;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import eu.europa.esig.dss.validation.timestamp.TimestampedReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureValidationContext
implements ValidationContext {
    private static final Logger LOG = LoggerFactory.getLogger(SignatureValidationContext.class);
    private final Set<CertificateToken> processedCertificates = new HashSet<CertificateToken>();
    private final Set<RevocationToken<Revocation>> processedRevocations = new HashSet<RevocationToken<Revocation>>();
    private final Set<TimestampToken> processedTimestamps = new HashSet<TimestampToken>();
    private CertificateVerifier certificateVerifier;
    private DataLoader dataLoader;
    private final Map<Token, Boolean> tokensToProcess = new HashMap<Token, Boolean>();
    private final Map<CertificateToken, Date> lastTimestampCertChainDates = new HashMap<CertificateToken, Date>();
    private final Map<String, List<Date>> poeTimes = new HashMap<String, List<Date>>();
    private Map<CertificateToken, List<CertificateToken>> orderedCertificateChains;
    private RevocationSource<OCSP> ocspSource;
    private RevocationSource<CRL> crlSource;
    private ListCertificateSource trustedCertSources;
    private ListCertificateSource adjunctCertSources;
    private ListRevocationSource<CRL> signatureCRLSource;
    private ListRevocationSource<OCSP> signatureOCSPSource;
    private ListCertificateSource signatureCertificateSource;
    private ListCertificateSource aiaCertificateSources = new ListCertificateSource();
    private ListCertificateSource revocationCertificateSources = new ListCertificateSource();
    private boolean checkRevocationForUntrustedChains;
    protected Date currentTime = new Date();

    @Override
    public void initialize(CertificateVerifier certificateVerifier) {
        Objects.requireNonNull(certificateVerifier);
        this.certificateVerifier = certificateVerifier;
        this.crlSource = certificateVerifier.getCrlSource();
        this.ocspSource = certificateVerifier.getOcspSource();
        this.dataLoader = certificateVerifier.getDataLoader();
        this.signatureCRLSource = certificateVerifier.getSignatureCRLSource();
        this.signatureOCSPSource = certificateVerifier.getSignatureOCSPSource();
        this.signatureCertificateSource = certificateVerifier.getSignatureCertificateSource();
        this.adjunctCertSources = certificateVerifier.getAdjunctCertSources();
        this.trustedCertSources = certificateVerifier.getTrustedCertSources();
        this.checkRevocationForUntrustedChains = certificateVerifier.isCheckRevocationForUntrustedChains();
    }

    @Override
    public Date getCurrentTime() {
        return this.currentTime;
    }

    @Override
    public void setCurrentTime(Date currentTime) {
        Objects.requireNonNull(currentTime);
        this.currentTime = currentTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Token getNotYetVerifiedToken() {
        Map<Token, Boolean> map = this.tokensToProcess;
        synchronized (map) {
            for (Map.Entry<Token, Boolean> entry : this.tokensToProcess.entrySet()) {
                if (entry.getValue() != null) continue;
                entry.setValue(true);
                return entry.getKey();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TimestampToken getNotYetVerifiedTimestamp() {
        Map<Token, Boolean> map = this.tokensToProcess;
        synchronized (map) {
            for (Map.Entry<Token, Boolean> entry : this.tokensToProcess.entrySet()) {
                if (entry.getValue() != null || !(entry.getKey() instanceof TimestampToken)) continue;
                entry.setValue(true);
                return (TimestampToken)entry.getKey();
            }
            return null;
        }
    }

    private Map<CertificateToken, List<CertificateToken>> getOrderedCertificateChains() {
        if (this.orderedCertificateChains == null) {
            CertificateReorderer order = new CertificateReorderer(this.processedCertificates);
            this.orderedCertificateChains = order.getOrderedCertificateChains();
        }
        return this.orderedCertificateChains;
    }

    private List<Token> getCertChain(Token token) {
        LinkedList<Token> chain = new LinkedList<Token>();
        Token issuerCertificateToken = token;
        do {
            chain.add(issuerCertificateToken);
        } while ((issuerCertificateToken = this.getIssuer(issuerCertificateToken)) != null && !chain.contains(issuerCertificateToken));
        return chain;
    }

    private Token getIssuer(Token token) {
        ListCertificateSource allCertificateSources = this.getAllCertificateSources();
        Set<CertificateToken> candidates = this.getIssuersFromSources(token, allCertificateSources);
        CertificateToken issuerCertificateToken = this.getTokenIssuerFromCandidates(token, candidates);
        if (issuerCertificateToken == null && token instanceof CertificateToken && this.dataLoader != null) {
            AIACertificateSource aiaSource = new AIACertificateSource((CertificateToken)token, this.dataLoader);
            this.aiaCertificateSources.add((CertificateSource)aiaSource);
            issuerCertificateToken = aiaSource.getIssuerFromAIA();
        }
        if (issuerCertificateToken == null && token instanceof OCSPToken) {
            issuerCertificateToken = this.getOCSPIssuer((OCSPToken)token, allCertificateSources);
        }
        if (issuerCertificateToken == null && token instanceof TimestampToken) {
            issuerCertificateToken = this.getTSACertificate((TimestampToken)token, allCertificateSources);
        }
        if (issuerCertificateToken instanceof CertificateToken) {
            this.addCertificateTokenForVerification(issuerCertificateToken);
        }
        return issuerCertificateToken;
    }

    private ListCertificateSource getAllCertificateSources() {
        ListCertificateSource allCertificateSources = new ListCertificateSource();
        allCertificateSources.addAll(this.signatureCertificateSource);
        allCertificateSources.addAll(this.revocationCertificateSources);
        allCertificateSources.addAll(this.aiaCertificateSources);
        allCertificateSources.addAll(this.adjunctCertSources);
        allCertificateSources.addAll(this.trustedCertSources);
        return allCertificateSources;
    }

    private Set<CertificateToken> getIssuersFromSources(Token token, ListCertificateSource allCertificateSources) {
        if (token.getPublicKeyOfTheSigner() != null) {
            return allCertificateSources.getByPublicKey(token.getPublicKeyOfTheSigner());
        }
        if (token.getIssuerX500Principal() != null) {
            return allCertificateSources.getBySubject(new X500PrincipalHelper(token.getIssuerX500Principal()));
        }
        return Collections.emptySet();
    }

    private CertificateToken getOCSPIssuer(OCSPToken token, ListCertificateSource allCertificateSources) {
        CertificateRef signingCertificateRef;
        ResponderId responderId;
        Set signingCertificateRefs = token.getCertificateSource().getAllCertificateRefs();
        if (Utils.collectionSize((Collection)signingCertificateRefs) == 1 && (responderId = (signingCertificateRef = (CertificateRef)signingCertificateRefs.iterator().next()).getResponderId()) != null) {
            HashSet<CertificateToken> issuerCandidates = new HashSet<CertificateToken>();
            if (responderId.getSki() != null) {
                issuerCandidates.addAll(allCertificateSources.getBySki(responderId.getSki()));
            }
            if (responderId.getX500Principal() != null) {
                issuerCandidates.addAll(allCertificateSources.getBySubject(new X500PrincipalHelper(responderId.getX500Principal())));
            }
            return this.getTokenIssuerFromCandidates((Token)token, issuerCandidates);
        }
        LOG.warn("Signing certificate is not found for an OCSPToken with id '{}'.", (Object)token.getDSSIdAsString());
        return null;
    }

    private CertificateToken getTSACertificate(TimestampToken timestamp, ListCertificateSource allCertificateSources) {
        CandidatesForSigningCertificate candidatesForSigningCertificate = timestamp.getCandidatesForSigningCertificate();
        CertificateValidity theBestCandidate = candidatesForSigningCertificate.getTheBestCandidate();
        if (theBestCandidate != null) {
            HashSet<CertificateToken> issuerCandidates = new HashSet<CertificateToken>();
            CertificateToken timestampSigner = theBestCandidate.getCertificateToken();
            if (timestampSigner == null) {
                issuerCandidates.addAll(allCertificateSources.getByCertificateIdentifier(theBestCandidate.getSignerInfo()));
            } else {
                issuerCandidates.add(timestampSigner);
            }
            return this.getTokenIssuerFromCandidates(timestamp, issuerCandidates);
        }
        return null;
    }

    private CertificateToken getTokenIssuerFromCandidates(Token token, Collection<CertificateToken> candidates) {
        ArrayList<CertificateToken> issuers = new ArrayList<CertificateToken>();
        for (CertificateToken candidate : candidates) {
            if (!token.isSignedBy(candidate)) continue;
            issuers.add(candidate);
            if (!candidate.isValidOn(token.getCreationDate())) continue;
            return candidate;
        }
        if (Utils.isCollectionNotEmpty(issuers)) {
            LOG.warn("No issuer found for the token creation date. The process continues with an issuer which has the same public key.");
            return (CertificateToken)issuers.iterator().next();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean addTokenForVerification(Token token) {
        if (token == null) {
            return false;
        }
        boolean traceEnabled = LOG.isTraceEnabled();
        if (traceEnabled) {
            LOG.trace("addTokenForVerification: trying to acquire synchronized block");
        }
        Map<Token, Boolean> map = this.tokensToProcess;
        synchronized (map) {
            try {
                if (this.tokensToProcess.containsKey(token)) {
                    if (traceEnabled) {
                        LOG.trace("Token was already in the list {}:{}", (Object)token.getClass().getSimpleName(), (Object)token.getAbbreviation());
                    }
                    boolean bl2 = false;
                    return bl2;
                }
                this.tokensToProcess.put(token, null);
                this.registerPOE(token.getDSSIdAsString(), this.currentTime);
                if (traceEnabled) {
                    LOG.trace("+ New {} to check: {}", (Object)token.getClass().getSimpleName(), (Object)token.getAbbreviation());
                }
                boolean bl = true;
                return bl;
            }
            finally {
                if (traceEnabled) {
                    LOG.trace("addTokenForVerification: almost left synchronized block");
                }
            }
        }
    }

    @Override
    public void addRevocationTokenForVerification(RevocationToken<Revocation> revocationToken) {
        if (this.addTokenForVerification((Token)revocationToken)) {
            RevocationCertificateSource revocationCertificateSource = revocationToken.getCertificateSource();
            if (revocationCertificateSource != null) {
                this.revocationCertificateSources.add((CertificateSource)revocationCertificateSource);
                for (CertificateToken certificateToken : revocationCertificateSource.getCertificates()) {
                    this.addCertificateTokenForVerification(certificateToken);
                }
            }
            boolean added = this.processedRevocations.add(revocationToken);
            if (LOG.isTraceEnabled()) {
                if (added) {
                    LOG.trace("RevocationToken added to processedRevocations: {} ", revocationToken);
                } else {
                    LOG.trace("RevocationToken already present processedRevocations: {} ", revocationToken);
                }
            }
        }
    }

    @Override
    public void addCertificateTokenForVerification(CertificateToken certificateToken) {
        if (this.addTokenForVerification((Token)certificateToken)) {
            boolean added = this.processedCertificates.add(certificateToken);
            if (LOG.isTraceEnabled()) {
                if (added) {
                    LOG.trace("CertificateToken added to processedCertificates: {} ", (Object)certificateToken);
                } else {
                    LOG.trace("CertificateToken already present processedCertificates: {} ", (Object)certificateToken);
                }
            }
        }
    }

    @Override
    public void addTimestampTokenForVerification(TimestampToken timestampToken) {
        if (this.addTokenForVerification(timestampToken)) {
            for (CertificateToken certificateToken : timestampToken.getCertificates()) {
                this.addCertificateTokenForVerification(certificateToken);
            }
            boolean added = this.processedTimestamps.add(timestampToken);
            if (LOG.isTraceEnabled()) {
                if (added) {
                    LOG.trace("TimestampToken added to processedTimestamps: {} ", this.processedTimestamps);
                } else {
                    LOG.trace("TimestampToken already present processedTimestamps: {} ", this.processedTimestamps);
                }
            }
        }
    }

    private void registerUsageDate(TimestampToken timestampToken) {
        CertificateToken tsaCertificate = this.getTSACertificate(timestampToken, this.getAllCertificateSources());
        if (tsaCertificate == null) {
            LOG.warn("No Timestamp Certificate found. Chain is skipped.");
            return;
        }
        Map<CertificateToken, List<CertificateToken>> certificateChains = this.getOrderedCertificateChains();
        List<CertificateToken> tsaCertificateChain = certificateChains.get(tsaCertificate);
        if (tsaCertificateChain == null) {
            tsaCertificateChain = this.toCertificateTokenChain(this.getCertChain((Token)tsaCertificate));
            certificateChains.put(tsaCertificate, tsaCertificateChain);
        }
        Date usageDate = timestampToken.getCreationDate();
        for (CertificateToken cert : tsaCertificateChain) {
            if (this.isSelfSignedOrTrusted(cert)) break;
            Date lastUsage = this.lastTimestampCertChainDates.get(cert);
            if (lastUsage != null && !lastUsage.before(usageDate)) continue;
            this.lastTimestampCertChainDates.put(cert, usageDate);
        }
        for (TimestampedReference timestampedReference : timestampToken.getTimestampedReferences()) {
            this.registerPOE(timestampedReference.getObjectId(), usageDate);
        }
    }

    private void registerPOE(String tokenId, Date poeTime) {
        List<Date> poeTimeList = this.poeTimes.get(tokenId);
        if (Utils.isCollectionEmpty(poeTimeList)) {
            poeTimeList = new ArrayList<Date>();
            this.poeTimes.put(tokenId, poeTimeList);
        }
        poeTimeList.add(poeTime);
    }

    private List<CertificateToken> toCertificateTokenChain(List<Token> tokens) {
        LinkedList<CertificateToken> chain = new LinkedList<CertificateToken>();
        for (Token token : tokens) {
            if (!(token instanceof CertificateToken)) continue;
            chain.add((CertificateToken)token);
        }
        return chain;
    }

    @Override
    public void validate() {
        TimestampToken timestampToken = this.getNotYetVerifiedTimestamp();
        while (timestampToken != null) {
            this.getCertChain(timestampToken);
            this.registerUsageDate(timestampToken);
            timestampToken = this.getNotYetVerifiedTimestamp();
        }
        Token token = this.getNotYetVerifiedToken();
        while (token != null) {
            List<Token> certChain = this.getCertChain(token);
            if (token instanceof CertificateToken) {
                this.getRevocationData((CertificateToken)token, certChain);
            }
            token = this.getNotYetVerifiedToken();
        }
    }

    private List<RevocationToken> getRevocationData(CertificateToken certToken, List<Token> certChain) {
        List<RevocationToken<CRL>> revocationTokens;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Checking revocation data for : {}", (Object)certToken.getDSSIdAsString());
        }
        if (this.isRevocationDataNotRequired(certToken)) {
            LOG.debug("Revocation data is not required for certificate : {}", (Object)certToken.getDSSIdAsString());
            return Collections.emptyList();
        }
        CertificateToken issuerToken = (CertificateToken)this.getIssuer((Token)certToken);
        if (issuerToken == null) {
            LOG.warn("Issuer not found for certificate {}", (Object)certToken.getDSSIdAsString());
            return Collections.emptyList();
        }
        ArrayList<RevocationToken> revocations = new ArrayList<RevocationToken>();
        if (this.signatureCRLSource != null) {
            revocationTokens = this.signatureCRLSource.getRevocationTokens(certToken, issuerToken);
            for (RevocationToken<CRL> revocationToken : revocationTokens) {
                revocations.add(revocationToken);
                this.addRevocationTokenForVerification(revocationToken);
            }
        }
        if (this.signatureOCSPSource != null) {
            revocationTokens = this.signatureOCSPSource.getRevocationTokens(certToken, issuerToken);
            for (RevocationToken<CRL> revocationToken : revocationTokens) {
                revocations.add(revocationToken);
                this.addRevocationTokenForVerification(revocationToken);
            }
        }
        if (Utils.isCollectionEmpty(revocations) || this.isRevocationDataRefreshNeeded(certToken, revocations)) {
            LOG.debug("The signature does not contain relative revocation data.");
            if (this.checkRevocationForUntrustedChains || this.containsTrustAnchor(certChain)) {
                OCSPAndCRLRevocationSource onlineVerifier;
                LOG.trace("Revocation update is in progress for certificate : {}", (Object)certToken.getDSSIdAsString());
                CertificateToken trustAnchor = (CertificateToken)this.getFirstTrustAnchor(certChain);
                if (!this.trustedCertSources.isEmpty() && trustAnchor != null) {
                    LOG.trace("Initializing a revocation verifier for a trusted chain...");
                    onlineVerifier = this.instantiateWithTrustServices(trustAnchor);
                } else {
                    LOG.trace("Initializing a revocation verifier for not trusted chain...");
                    onlineVerifier = new OCSPAndCRLRevocationSource(this.crlSource, this.ocspSource);
                }
                RevocationToken<Revocation> onlineRevocationToken = onlineVerifier.getRevocationToken(certToken, issuerToken);
                if (onlineRevocationToken != null && !revocations.contains(onlineRevocationToken)) {
                    LOG.debug("Obtained a new revocation data : {}, for certificate : {}", (Object)onlineRevocationToken.getDSSIdAsString(), (Object)certToken.getDSSIdAsString());
                    revocations.add(onlineRevocationToken);
                    this.addRevocationTokenForVerification(onlineRevocationToken);
                }
            } else {
                LOG.warn("External revocation check is skipped for untrusted certificate : {}", (Object)certToken.getDSSIdAsString());
            }
        }
        if (revocations.isEmpty()) {
            LOG.warn("No revocation found for the certificate {}", (Object)certToken.getDSSIdAsString());
        }
        return revocations;
    }

    private <T extends Token> boolean containsTrustAnchor(List<T> certChain) {
        return this.getFirstTrustAnchor(certChain) != null;
    }

    private <T extends Token> Token getFirstTrustAnchor(List<T> certChain) {
        for (Token token : certChain) {
            if (!this.isTrusted(token)) continue;
            return token;
        }
        return null;
    }

    private OCSPAndCRLRevocationSource instantiateWithTrustServices(CertificateToken trustAnchor) {
        AlternateUrlsSourceAdapter currentOCSPSource = null;
        List<String> alternativeOCSPUrls = this.getAlternativeOCSPUrls(trustAnchor);
        currentOCSPSource = Utils.isCollectionNotEmpty(alternativeOCSPUrls) && this.ocspSource instanceof RevocationSourceAlternateUrlsSupport ? new AlternateUrlsSourceAdapter((RevocationSourceAlternateUrlsSupport)this.ocspSource, alternativeOCSPUrls) : this.ocspSource;
        AlternateUrlsSourceAdapter currentCRLSource = null;
        List<String> alternativeCRLUrls = this.getAlternativeCRLUrls(trustAnchor);
        currentCRLSource = Utils.isCollectionNotEmpty(alternativeCRLUrls) && this.crlSource instanceof RevocationSourceAlternateUrlsSupport ? new AlternateUrlsSourceAdapter((RevocationSourceAlternateUrlsSupport)this.crlSource, alternativeCRLUrls) : this.crlSource;
        OCSPAndCRLRevocationSource ocspAndCrlRevocationSource = new OCSPAndCRLRevocationSource((RevocationSource<CRL>)currentCRLSource, (RevocationSource<OCSP>)currentOCSPSource);
        ocspAndCrlRevocationSource.setTrustedCertificateSource(this.trustedCertSources);
        return ocspAndCrlRevocationSource;
    }

    private List<String> getAlternativeOCSPUrls(CertificateToken trustAnchor) {
        ArrayList<String> alternativeOCSPUrls = new ArrayList<String>();
        for (CertificateSource certificateSource : this.trustedCertSources.getSources()) {
            if (!(certificateSource instanceof CommonTrustedCertificateSource)) continue;
            CommonTrustedCertificateSource trustedCertSource = (CommonTrustedCertificateSource)certificateSource;
            alternativeOCSPUrls.addAll(trustedCertSource.getAlternativeOCSPUrls(trustAnchor));
        }
        return alternativeOCSPUrls;
    }

    private List<String> getAlternativeCRLUrls(CertificateToken trustAnchor) {
        ArrayList<String> alternativeCRLUrls = new ArrayList<String>();
        for (CertificateSource certificateSource : this.trustedCertSources.getSources()) {
            if (!(certificateSource instanceof CommonTrustedCertificateSource)) continue;
            CommonTrustedCertificateSource trustedCertSource = (CommonTrustedCertificateSource)certificateSource;
            alternativeCRLUrls.addAll(trustedCertSource.getAlternativeCRLUrls(trustAnchor));
        }
        return alternativeCRLUrls;
    }

    @Override
    public boolean checkAllRequiredRevocationDataPresent() {
        ArrayList<String> errors = new ArrayList<String>();
        Map<CertificateToken, List<CertificateToken>> orderedCertificateChains = this.getOrderedCertificateChains();
        for (List<CertificateToken> orderedCertChain : orderedCertificateChains.values()) {
            this.checkRevocationForCertificateChainAgainstBestSignatureTime(orderedCertChain, null, errors);
        }
        if (!errors.isEmpty()) {
            Status status = new Status("Revocation data is missing for one or more certificate(s).", errors);
            this.certificateVerifier.getAlertOnMissingRevocationData().alert((Object)status);
        }
        return errors.isEmpty();
    }

    private void checkRevocationForCertificateChainAgainstBestSignatureTime(List<CertificateToken> certificates, Date bestSignatureTime, List<String> errors) {
        for (CertificateToken certificateToken : certificates) {
            if (this.isSelfSignedOrTrusted(certificateToken)) break;
            if (this.isOCSPNoCheckExtension(certificateToken)) continue;
            boolean found = false;
            Date earliestNextUpdate = null;
            for (RevocationToken<Revocation> revocationToken : this.processedRevocations) {
                if (!Utils.areStringsEqual((String)certificateToken.getDSSIdAsString(), (String)revocationToken.getRelatedCertificateID())) continue;
                if (bestSignatureTime == null || revocationToken.getThisUpdate().after(bestSignatureTime)) {
                    found = true;
                    break;
                }
                if (revocationToken.getNextUpdate() == null || earliestNextUpdate != null && !revocationToken.getNextUpdate().before(earliestNextUpdate)) continue;
                earliestNextUpdate = revocationToken.getNextUpdate();
            }
            if (found) continue;
            if (!this.certificateVerifier.isCheckRevocationForUntrustedChains() && !this.containsTrustAnchor(certificates)) {
                errors.add(String.format("Revocation data is skipped for untrusted certificate chain for the token : '%s'", certificateToken.getDSSIdAsString()));
                continue;
            }
            if (bestSignatureTime == null) {
                errors.add(String.format("No revocation data found for certificate : %s", certificateToken.getDSSIdAsString()));
                continue;
            }
            if (earliestNextUpdate != null) {
                errors.add(String.format("No revocation data found after the best signature time [%s] for the certificate : %s. \n The nextUpdate available after : [%s]", bestSignatureTime, certificateToken.getDSSIdAsString(), earliestNextUpdate));
                continue;
            }
            errors.add(String.format("No revocation data found after the best signature time [%s] for the certificate : %s", bestSignatureTime, certificateToken.getDSSIdAsString()));
        }
    }

    @Override
    public boolean checkAllPOECoveredByRevocationData() {
        ArrayList<String> errors = new ArrayList<String>();
        for (Map.Entry<CertificateToken, Date> entry : this.lastTimestampCertChainDates.entrySet()) {
            Date lastUsage = entry.getValue();
            CertificateToken token = entry.getKey();
            if (this.isRevocationDataNotRequired(token)) continue;
            boolean foundValidRevocationDataAfterLastUsage = false;
            Date nextUpdate = null;
            for (RevocationToken<Revocation> revocationToken : this.processedRevocations) {
                if (!Utils.areStringsEqual((String)token.getDSSIdAsString(), (String)revocationToken.getRelatedCertificateID())) continue;
                Date productionDate = revocationToken.getProductionDate();
                if (productionDate.after(lastUsage)) {
                    foundValidRevocationDataAfterLastUsage = true;
                    break;
                }
                Date currentNextUpdate = revocationToken.getNextUpdate();
                if (nextUpdate != null && (currentNextUpdate == null || !nextUpdate.before(currentNextUpdate))) continue;
                nextUpdate = currentNextUpdate;
            }
            if (foundValidRevocationDataAfterLastUsage) continue;
            errors.add(String.format("POE '%s' not covered by a valid revocation data (nextUpdate : %s)", token.getDSSIdAsString(), nextUpdate));
        }
        if (!errors.isEmpty()) {
            Status status = new Status("Revocation data is missing for one or more POE(s).", errors);
            this.certificateVerifier.getAlertOnUncoveredPOE().alert((Object)status);
        }
        return errors.isEmpty();
    }

    @Override
    public boolean checkAllTimestampsValid() {
        HashSet<String> invalidTimestampIds = new HashSet<String>();
        for (TimestampToken timestampToken : this.processedTimestamps) {
            if (timestampToken.isSignatureValid() && timestampToken.isMessageImprintDataFound().booleanValue() && timestampToken.isMessageImprintDataIntact().booleanValue()) continue;
            invalidTimestampIds.add(timestampToken.getDSSIdAsString());
        }
        if (!invalidTimestampIds.isEmpty()) {
            Status status = new Status("Broken timestamp(s) detected.", invalidTimestampIds);
            this.certificateVerifier.getAlertOnInvalidTimestamp().alert((Object)status);
        }
        return invalidTimestampIds.isEmpty();
    }

    @Override
    public boolean checkAllCertificatesValid() {
        HashSet<String> invalidCertificateIds = new HashSet<String>();
        for (CertificateToken certificateToken : this.processedCertificates) {
            if (this.isRevocationDataNotRequired(certificateToken)) continue;
            for (RevocationToken<Revocation> revocationToken : this.processedRevocations) {
                if (!Utils.areStringsEqual((String)certificateToken.getDSSIdAsString(), (String)revocationToken.getRelatedCertificateID()) || revocationToken.getStatus().isGood()) continue;
                invalidCertificateIds.add(certificateToken.getDSSIdAsString());
            }
        }
        if (!invalidCertificateIds.isEmpty()) {
            Status status = new Status("Revoked/Suspended certificate(s) detected.", invalidCertificateIds);
            this.certificateVerifier.getAlertOnRevokedCertificate().alert((Object)status);
        }
        return invalidCertificateIds.isEmpty();
    }

    private boolean isRevocationDataNotRequired(CertificateToken certToken) {
        return this.isSelfSignedOrTrusted(certToken) || this.isOCSPNoCheckExtension(certToken);
    }

    private boolean isSelfSignedOrTrusted(CertificateToken certToken) {
        return certToken.isSelfSigned() || this.isTrusted(certToken);
    }

    private boolean isOCSPNoCheckExtension(CertificateToken certToken) {
        return DSSASN1Utils.hasIdPkixOcspNoCheckExtension((CertificateToken)certToken);
    }

    private boolean isRevocationDataRefreshNeeded(CertificateToken certToken, List<RevocationToken> revocations) {
        Date refreshNeededAfterTime = this.lastTimestampCertChainDates.get(certToken);
        if (refreshNeededAfterTime == null) {
            refreshNeededAfterTime = this.getLowestPOETime(certToken.getDSSIdAsString());
        }
        boolean freshRevocationDataFound = false;
        for (RevocationToken revocationToken : revocations) {
            if (refreshNeededAfterTime == null || !refreshNeededAfterTime.before(revocationToken.getProductionDate()) || RevocationReason.CERTIFICATE_HOLD == revocationToken.getReason() || !this.isConsistent((RevocationToken<Revocation>)revocationToken, certToken)) continue;
            freshRevocationDataFound = true;
            break;
        }
        if (!freshRevocationDataFound) {
            LOG.debug("Revocation data refresh is needed");
            return true;
        }
        return false;
    }

    private Date getLowestPOETime(String tokenId) {
        Date lowestPOE = null;
        List<Date> bestSignatureTimeList = this.poeTimes.get(tokenId);
        if (Utils.isCollectionNotEmpty(bestSignatureTimeList)) {
            for (Date poeTime : bestSignatureTimeList) {
                if (lowestPOE != null && !poeTime.before(lowestPOE)) continue;
                lowestPOE = poeTime;
            }
        }
        return lowestPOE;
    }

    private boolean isConsistent(RevocationToken<Revocation> revocation, CertificateToken certToken) {
        List<CertificateToken> certificateTokenChain = this.toCertificateTokenChain(this.getCertChain((Token)revocation));
        if (Utils.isCollectionEmpty(certificateTokenChain)) {
            LOG.debug("The revocation {} is not consistent! Issuer CertificateToken is not found.", (Object)revocation.getDSSIdAsString());
            return false;
        }
        if (RevocationType.OCSP.equals((Object)revocation.getRevocationType()) && !DSSRevocationUtils.checkIssuerValidAtRevocationProductionTime(revocation)) {
            LOG.debug("The revocation {} is not consistent! The revocation has been produced outside the issuer certificate's validity range!", (Object)revocation.getDSSIdAsString());
            return false;
        }
        if (RevocationType.CRL.equals((Object)revocation.getRevocationType()) && !this.isInCertificateValidityRange(revocation, certToken)) {
            LOG.debug("The revocation '{}' was not issued during the validity period of the certificate! Certificate: {}", (Object)revocation.getDSSIdAsString(), (Object)certToken.getDSSIdAsString());
            return false;
        }
        if (revocation.getNextUpdate() != null) {
            return this.hasPOEAfterProductionAndBeforeNextUpdate(revocation);
        }
        return this.hasPOEInTheValidityRange(certificateTokenChain.iterator().next());
    }

    private boolean isInCertificateValidityRange(RevocationToken<?> revocationToken, CertificateToken certificateToken) {
        Date thisUpdate = revocationToken.getThisUpdate();
        Date nextUpdate = revocationToken.getNextUpdate();
        Date notAfter = certificateToken.getNotAfter();
        Date notBefore = certificateToken.getNotBefore();
        return thisUpdate.compareTo(notAfter) <= 0 && nextUpdate != null && nextUpdate.compareTo(notBefore) >= 0;
    }

    private boolean hasPOEAfterProductionAndBeforeNextUpdate(RevocationToken<Revocation> revocation) {
        List<Date> poeTimeList = this.poeTimes.get(revocation.getDSSIdAsString());
        if (Utils.isCollectionNotEmpty(poeTimeList)) {
            for (Date poeTime : poeTimeList) {
                if (!this.isConsistentOnTime(revocation, poeTime)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasPOEInTheValidityRange(CertificateToken certificateToken) {
        List<Date> poeTimeList = this.poeTimes.get(certificateToken.getDSSIdAsString());
        if (Utils.isCollectionNotEmpty(poeTimeList)) {
            for (Date poeTime : poeTimeList) {
                if (!certificateToken.isValidOn(poeTime)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isConsistentOnTime(RevocationToken<Revocation> revocationToken, Date date) {
        Date productionDate = revocationToken.getProductionDate();
        Date nextUpdate = revocationToken.getNextUpdate();
        return date.compareTo(productionDate) >= 0 && date.compareTo(nextUpdate) <= 0;
    }

    @Override
    public boolean checkAtLeastOneRevocationDataPresentAfterBestSignatureTime(CertificateToken signingCertificate) {
        ArrayList<String> errors = new ArrayList<String>();
        Map<CertificateToken, List<CertificateToken>> orderedCertificateChains = this.getOrderedCertificateChains();
        for (Map.Entry<CertificateToken, List<CertificateToken>> entry : orderedCertificateChains.entrySet()) {
            CertificateToken firstChainCertificate = entry.getKey();
            Date bestSignatureTime = firstChainCertificate.equals((Object)signingCertificate) ? this.getEarliestTimestampTime() : this.lastTimestampCertChainDates.get(firstChainCertificate);
            this.checkRevocationForCertificateChainAgainstBestSignatureTime(entry.getValue(), bestSignatureTime, errors);
        }
        if (!errors.isEmpty()) {
            Status status = new Status("Fresh revocation data is missing for one or more certificate(s).", errors);
            this.certificateVerifier.getAlertOnNoRevocationAfterBestSignatureTime().alert((Object)status);
        }
        return errors.isEmpty();
    }

    private Date getEarliestTimestampTime() {
        Date earliestDate = null;
        for (TimestampToken timestamp : this.getProcessedTimestamps()) {
            if (!timestamp.getTimeStampType().coversSignature()) continue;
            Date timestampTime = timestamp.getCreationDate();
            if (earliestDate != null && !timestampTime.before(earliestDate)) continue;
            earliestDate = timestampTime;
        }
        return earliestDate;
    }

    @Override
    public Set<CertificateToken> getProcessedCertificates() {
        return Collections.unmodifiableSet(this.processedCertificates);
    }

    @Override
    public Map<CertificateToken, Set<CertificateSourceType>> getCertificateSourceTypes() {
        ListCertificateSource allCertificateSources = this.getAllCertificateSources();
        HashMap<CertificateToken, Set<CertificateSourceType>> result = new HashMap<CertificateToken, Set<CertificateSourceType>>();
        for (CertificateToken certificateToken : this.getProcessedCertificates()) {
            result.put(certificateToken, allCertificateSources.getCertificateSource(certificateToken));
        }
        return result;
    }

    @Override
    public Set<RevocationToken<Revocation>> getProcessedRevocations() {
        return Collections.unmodifiableSet(this.processedRevocations);
    }

    @Override
    public Set<TimestampToken> getProcessedTimestamps() {
        return Collections.unmodifiableSet(this.processedTimestamps);
    }

    private <T extends Token> boolean isTrusted(T token) {
        return token instanceof CertificateToken && this.trustedCertSources.isTrusted((CertificateToken)token);
    }
}

