/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.signature;

import eu.europa.esig.dss.enumerations.SignatureForm;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.MimeType;
import eu.europa.esig.dss.model.SerializableSignatureParameters;
import eu.europa.esig.dss.model.SerializableTimestampParameters;
import eu.europa.esig.dss.model.SignatureValue;
import eu.europa.esig.dss.model.ToBeSigned;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.signature.DocumentSignatureService;
import eu.europa.esig.dss.signature.SigningOperation;
import eu.europa.esig.dss.spi.DSSSecurityProvider;
import eu.europa.esig.dss.spi.x509.tsp.TSPSource;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.CertificateVerifier;
import java.security.GeneralSecurityException;
import java.security.Security;
import java.security.Signature;
import java.util.Date;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSignatureService<SP extends SerializableSignatureParameters, TP extends SerializableTimestampParameters>
implements DocumentSignatureService<SP, TP> {
    private static final Logger LOG;
    protected TSPSource tspSource;
    protected final CertificateVerifier certificateVerifier;

    protected AbstractSignatureService(CertificateVerifier certificateVerifier) {
        Objects.requireNonNull(certificateVerifier, "CertificateVerifier cannot be null !");
        this.certificateVerifier = certificateVerifier;
    }

    @Override
    public void setTspSource(TSPSource tspSource) {
        this.tspSource = tspSource;
    }

    protected void assertSigningDateInCertificateValidityRange(SerializableSignatureParameters parameters) {
        if (parameters.getSigningCertificate() == null) {
            if (parameters.isGenerateTBSWithoutCertificate()) {
                return;
            }
            throw new DSSException("Signing Certificate is not defined!");
        }
        if (parameters.isSignWithExpiredCertificate()) {
            return;
        }
        CertificateToken signingCertificate = parameters.getSigningCertificate();
        Date notAfter = signingCertificate.getNotAfter();
        Date notBefore = signingCertificate.getNotBefore();
        Date signingDate = parameters.bLevel().getSigningDate();
        if (signingDate.after(notAfter) || signingDate.before(notBefore)) {
            throw new DSSException(String.format("Signing Date (%s) is not in certificate validity range (%s, %s).", signingDate.toString(), notBefore.toString(), notAfter.toString()));
        }
    }

    protected String getFinalDocumentName(DSSDocument originalFile, SigningOperation operation, SignatureLevel level, MimeType containerMimeType) {
        String extension;
        StringBuilder finalName = new StringBuilder();
        String originalName = null;
        originalName = containerMimeType != null ? "container" : originalFile.getName();
        String originalExtension = "";
        if (Utils.isStringNotEmpty((String)originalName)) {
            int dotPosition = originalName.lastIndexOf(46);
            if (dotPosition > 0) {
                finalName.append(originalName.substring(0, dotPosition));
                originalExtension = originalName.substring(dotPosition + 1);
            } else {
                finalName.append(originalName);
            }
        } else {
            finalName.append("document");
        }
        switch (operation) {
            case SIGN: {
                finalName.append("-signed");
                break;
            }
            case COUNTER_SIGN: {
                finalName.append("-counter-signed");
                break;
            }
            case TIMESTAMP: {
                finalName.append("-timestamped");
                break;
            }
            case EXTEND: {
                finalName.append("-extended");
                break;
            }
            case ADD_SIG_POLICY_STORE: {
                finalName.append("-sig-policy-store");
                break;
            }
            default: {
                throw new DSSException(String.format("The following operation '%s' is not supported!", new Object[]{operation}));
            }
        }
        if (level != null) {
            finalName.append('-');
            finalName.append(Utils.lowerCase((String)level.name().replace("_", "-")));
        }
        String string = extension = Utils.isStringNotBlank((String)(extension = this.getFileExtensionString(level, containerMimeType))) ? extension : originalExtension;
        if (Utils.isStringNotBlank((String)extension)) {
            finalName.append('.');
            finalName.append(extension);
        }
        return finalName.toString();
    }

    private String getFileExtensionString(SignatureLevel level, MimeType containerMimeType) {
        if (containerMimeType != null) {
            return MimeType.getExtension((MimeType)containerMimeType);
        }
        if (level != null) {
            SignatureForm signatureForm = level.getSignatureForm();
            switch (signatureForm) {
                case XAdES: {
                    return "xml";
                }
                case CAdES: {
                    return "pkcs7";
                }
                case PAdES: {
                    return "pdf";
                }
                case JAdES: {
                    return "json";
                }
            }
            throw new DSSException("Unable to generate a full document name");
        }
        return "";
    }

    protected String getFinalFileName(DSSDocument originalFile, SigningOperation operation) {
        return this.getFinalFileName(originalFile, operation, null);
    }

    protected String getFinalFileName(DSSDocument originalFile, SigningOperation operation, SignatureLevel level) {
        return this.getFinalDocumentName(originalFile, operation, level, null);
    }

    @Override
    public DSSDocument timestamp(DSSDocument toTimestampDocument, TP parameters) {
        throw new UnsupportedOperationException("Unsupported operation for this file format");
    }

    @Override
    public boolean isValidSignatureValue(ToBeSigned toBeSigned, SignatureValue signatureValue, CertificateToken signingCertificate) {
        Objects.requireNonNull(toBeSigned, "ToBeSigned cannot be null!");
        Objects.requireNonNull(signatureValue, "SignatureValue cannot be null!");
        Objects.requireNonNull(signingCertificate, "CertificateToken cannot be null!");
        try {
            Signature signature = Signature.getInstance(signatureValue.getAlgorithm().getJCEId(), DSSSecurityProvider.getSecurityProviderName());
            signature.initVerify(signingCertificate.getPublicKey());
            signature.update(toBeSigned.getBytes());
            return signature.verify(signatureValue.getValue());
        }
        catch (GeneralSecurityException e) {
            LOG.error("Unable to verify the signature value : {}", (Object)e.getMessage());
            return false;
        }
    }

    static {
        Security.addProvider(DSSSecurityProvider.getSecurityProvider());
        LOG = LoggerFactory.getLogger(AbstractSignatureService.class);
    }
}

