/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.diagnostic.jaxb.XmlDiagnosticData;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.TimestampedObjectType;
import eu.europa.esig.dss.enumerations.TokenExtractionStategy;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.revocation.crl.CRL;
import eu.europa.esig.dss.model.x509.revocation.ocsp.OCSP;
import eu.europa.esig.dss.policy.EtsiValidationPolicy;
import eu.europa.esig.dss.policy.ValidationPolicy;
import eu.europa.esig.dss.policy.ValidationPolicyFacade;
import eu.europa.esig.dss.policy.jaxb.ConstraintsParameters;
import eu.europa.esig.dss.spi.DSSSecurityProvider;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import eu.europa.esig.dss.spi.x509.ListCertificateSource;
import eu.europa.esig.dss.spi.x509.revocation.OfflineRevocationSource;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.DiagnosticDataBuilder;
import eu.europa.esig.dss.validation.DocumentValidator;
import eu.europa.esig.dss.validation.DocumentValidatorFactory;
import eu.europa.esig.dss.validation.ListRevocationSource;
import eu.europa.esig.dss.validation.ManifestFile;
import eu.europa.esig.dss.validation.SignaturePolicyProvider;
import eu.europa.esig.dss.validation.SignatureValidationContext;
import eu.europa.esig.dss.validation.ValidationContext;
import eu.europa.esig.dss.validation.executor.DocumentProcessExecutor;
import eu.europa.esig.dss.validation.executor.ValidationLevel;
import eu.europa.esig.dss.validation.executor.signature.DefaultSignatureProcessExecutor;
import eu.europa.esig.dss.validation.reports.Reports;
import eu.europa.esig.dss.validation.scope.SignatureScope;
import eu.europa.esig.dss.validation.scope.SignatureScopeFinder;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import eu.europa.esig.dss.validation.timestamp.TimestampedReference;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.Security;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SignedDocumentValidator
implements DocumentValidator {
    private static final Logger LOG = LoggerFactory.getLogger(SignedDocumentValidator.class);
    protected DocumentProcessExecutor processExecutor = null;
    protected DSSDocument document;
    protected List<DSSDocument> detachedContents = new ArrayList<DSSDocument>();
    protected List<DSSDocument> containerContents;
    protected List<ManifestFile> manifestFiles;
    protected CertificateToken providedSigningCertificateToken = null;
    private Date validationTime;
    protected CertificateVerifier certificateVerifier;
    private TokenExtractionStategy tokenExtractionStategy = TokenExtractionStategy.NONE;
    private boolean includeSemantics = false;
    protected final SignatureScopeFinder signatureScopeFinder;
    private SignaturePolicyProvider signaturePolicyProvider;
    private ValidationLevel validationLevel = ValidationLevel.ARCHIVAL_DATA;
    private Locale locale = Locale.getDefault();
    private boolean enableEtsiValidationReport = true;
    protected boolean skipValidationContextExecution = false;

    protected SignedDocumentValidator() {
        this.signatureScopeFinder = null;
    }

    protected SignedDocumentValidator(SignatureScopeFinder signatureScopeFinder) {
        this.signatureScopeFinder = signatureScopeFinder;
    }

    protected void setSignedScopeFinderDefaultDigestAlgorithm(DigestAlgorithm digestAlgorithm) {
        if (this.signatureScopeFinder != null) {
            this.signatureScopeFinder.setDefaultDigestAlgorithm(digestAlgorithm);
        }
    }

    public static SignedDocumentValidator fromDocument(DSSDocument dssDocument) {
        Objects.requireNonNull(dssDocument, "DSSDocument is null");
        ServiceLoader<DocumentValidatorFactory> serviceLoaders = ServiceLoader.load(DocumentValidatorFactory.class);
        for (DocumentValidatorFactory factory : serviceLoaders) {
            if (!factory.isSupported(dssDocument)) continue;
            return factory.create(dssDocument);
        }
        throw new DSSException("Document format not recognized/handled");
    }

    public abstract boolean isSupported(DSSDocument var1);

    @Override
    public void defineSigningCertificate(CertificateToken token) {
        Objects.requireNonNull(token, "Token is not defined");
        this.providedSigningCertificateToken = token;
    }

    @Override
    public void setCertificateVerifier(CertificateVerifier certificateVerifier) {
        this.certificateVerifier = certificateVerifier;
    }

    @Override
    public void setTokenExtractionStategy(TokenExtractionStategy tokenExtractionStategy) {
        Objects.requireNonNull(tokenExtractionStategy);
        this.tokenExtractionStategy = tokenExtractionStategy;
    }

    @Override
    public void setIncludeSemantics(boolean include) {
        this.includeSemantics = include;
    }

    @Override
    public void setDetachedContents(List<DSSDocument> detachedContents) {
        this.detachedContents = detachedContents;
    }

    @Override
    public void setContainerContents(List<DSSDocument> containerContents) {
        this.containerContents = containerContents;
    }

    @Override
    public void setManifestFiles(List<ManifestFile> manifestFiles) {
        this.manifestFiles = manifestFiles;
    }

    protected DigestAlgorithm getDefaultDigestAlgorithm() {
        return this.certificateVerifier.getDefaultDigestAlgorithm();
    }

    @Override
    public void setValidationTime(Date validationTime) {
        this.validationTime = validationTime;
    }

    protected Date getValidationTime() {
        if (this.validationTime == null) {
            this.validationTime = new Date();
        }
        return this.validationTime;
    }

    @Override
    public void setValidationLevel(ValidationLevel validationLevel) {
        this.validationLevel = validationLevel;
    }

    @Override
    public void setEnableEtsiValidationReport(boolean enableEtsiValidationReport) {
        this.enableEtsiValidationReport = enableEtsiValidationReport;
    }

    @Override
    public Reports validateDocument() {
        return this.validateDocument((InputStream)null);
    }

    @Override
    public Reports validateDocument(URL validationPolicyURL) {
        if (validationPolicyURL == null) {
            return this.validateDocument((InputStream)null);
        }
        try {
            return this.validateDocument(validationPolicyURL.openStream());
        }
        catch (IOException e) {
            throw new DSSException((Throwable)e);
        }
    }

    @Override
    public Reports validateDocument(String policyResourcePath) {
        if (policyResourcePath == null) {
            return this.validateDocument((InputStream)null);
        }
        return this.validateDocument(this.getClass().getResourceAsStream(policyResourcePath));
    }

    @Override
    public Reports validateDocument(File policyFile) {
        if (policyFile == null || !policyFile.exists()) {
            return this.validateDocument((InputStream)null);
        }
        InputStream inputStream = DSSUtils.toByteArrayInputStream((File)policyFile);
        return this.validateDocument(inputStream);
    }

    @Override
    public Reports validateDocument(InputStream policyDataStream) {
        ValidationPolicy validationPolicy = null;
        try {
            if (policyDataStream == null) {
                LOG.debug("No provided validation policy : use the default policy");
                validationPolicy = ValidationPolicyFacade.newFacade().getDefaultValidationPolicy();
            } else {
                validationPolicy = ValidationPolicyFacade.newFacade().getValidationPolicy(policyDataStream);
            }
        }
        catch (Exception e) {
            throw new DSSException("Unable to load the policy", (Throwable)e);
        }
        return this.validateDocument(validationPolicy);
    }

    @Override
    public Reports validateDocument(ConstraintsParameters validationPolicyJaxb) {
        EtsiValidationPolicy validationPolicy = new EtsiValidationPolicy(validationPolicyJaxb);
        return this.validateDocument((ValidationPolicy)validationPolicy);
    }

    @Override
    public Reports validateDocument(ValidationPolicy validationPolicy) {
        LOG.info("Document validation...");
        this.assertConfigurationValid();
        SignatureValidationContext validationContext = new SignatureValidationContext();
        XmlDiagnosticData diagnosticData = this.prepareDiagnosticDataBuilder(validationContext).build();
        return this.processValidationPolicy(diagnosticData, validationPolicy);
    }

    protected void assertConfigurationValid() {
        Objects.requireNonNull(this.certificateVerifier, "CertificateVerifier is not defined");
        Objects.requireNonNull(this.document, "Document is not provided to the validator");
    }

    protected DiagnosticDataBuilder prepareDiagnosticDataBuilder(ValidationContext validationContext) {
        List<AdvancedSignature> allSignatures = this.getAllSignatures();
        List<TimestampToken> detachedTimestamps = this.getDetachedTimestamps();
        ListRevocationSource<CRL> listCRLSource = this.mergeCRLSources(allSignatures, detachedTimestamps);
        ListRevocationSource<OCSP> listOCSPSource = this.mergeOCSPSources(allSignatures, detachedTimestamps);
        ListCertificateSource listCertificateSource = this.mergeCertificateSource(allSignatures, detachedTimestamps);
        this.prepareCertificateVerifier(listCRLSource, listOCSPSource, listCertificateSource);
        this.prepareSignatureValidationContext(validationContext, allSignatures);
        this.prepareDetachedTimestampValidationContext(validationContext, detachedTimestamps);
        if (!this.skipValidationContextExecution) {
            this.validateContext(validationContext);
        }
        return this.getDiagnosticDataBuilderConfiguration(validationContext, allSignatures, listCRLSource, listOCSPSource);
    }

    protected DiagnosticDataBuilder getDiagnosticDataBuilderConfiguration(ValidationContext validationContext, List<AdvancedSignature> signatures, ListRevocationSource<CRL> listCRLSource, ListRevocationSource<OCSP> listOCSPSource) {
        return new DiagnosticDataBuilder().document(this.document).usedTimestamps(validationContext.getProcessedTimestamps()).usedCertificates(validationContext.getProcessedCertificates()).usedRevocations(validationContext.getProcessedRevocations()).setDefaultDigestAlgorithm(this.certificateVerifier.getDefaultDigestAlgorithm()).tokenExtractionStategy(this.tokenExtractionStategy).certificateSourceTypes(validationContext.getCertificateSourceTypes()).trustedCertificateSources(this.certificateVerifier.getTrustedCertSources()).validationDate(this.getValidationTime()).foundSignatures(signatures).completeCRLSource(listCRLSource).completeOCSPSource(listOCSPSource);
    }

    protected void prepareCertificateVerifier(ListRevocationSource<CRL> listCRLSource, ListRevocationSource<OCSP> listOCSPSource, ListCertificateSource listCertificateSource) {
        this.certificateVerifier.setSignatureCRLSource(listCRLSource);
        this.certificateVerifier.setSignatureOCSPSource(listOCSPSource);
        this.certificateVerifier.setSignatureCertificateSource(listCertificateSource);
    }

    protected ListRevocationSource<CRL> mergeCRLSources(Collection<AdvancedSignature> allSignatureList, Collection<TimestampToken> detachedTimestamps) {
        ListRevocationSource<CRL> allCrlSource = new ListRevocationSource<CRL>();
        if (Utils.isCollectionNotEmpty(allSignatureList)) {
            for (AdvancedSignature signature : allSignatureList) {
                allCrlSource.add(signature.getCRLSource());
                allCrlSource.addAll(signature.getTimestampSource().getTimestampCRLSources());
            }
        }
        if (Utils.isCollectionNotEmpty(detachedTimestamps)) {
            for (TimestampToken timestampToken : detachedTimestamps) {
                allCrlSource.add((OfflineRevocationSource<CRL>)timestampToken.getCRLSource());
            }
        }
        return allCrlSource;
    }

    protected ListRevocationSource<OCSP> mergeOCSPSources(Collection<AdvancedSignature> allSignatureList, Collection<TimestampToken> detachedTimestamps) {
        ListRevocationSource<OCSP> allOcspSource = new ListRevocationSource<OCSP>();
        if (Utils.isCollectionNotEmpty(allSignatureList)) {
            for (AdvancedSignature signature : allSignatureList) {
                allOcspSource.add(signature.getOCSPSource());
                allOcspSource.addAll(signature.getTimestampSource().getTimestampOCSPSources());
            }
        }
        if (Utils.isCollectionNotEmpty(detachedTimestamps)) {
            for (TimestampToken timestampToken : detachedTimestamps) {
                allOcspSource.add((OfflineRevocationSource<OCSP>)timestampToken.getOCSPSource());
            }
        }
        return allOcspSource;
    }

    protected ListCertificateSource mergeCertificateSource(Collection<AdvancedSignature> allSignatureList, Collection<TimestampToken> detachedTimestamps) {
        ListCertificateSource allCertificatesSource = new ListCertificateSource();
        if (Utils.isCollectionNotEmpty(allSignatureList)) {
            for (AdvancedSignature advancedSignature : allSignatureList) {
                allCertificatesSource.addAll(advancedSignature.getCompleteCertificateSource());
            }
        }
        if (Utils.isCollectionNotEmpty(detachedTimestamps)) {
            for (TimestampToken timestampToken : detachedTimestamps) {
                allCertificatesSource.add((CertificateSource)timestampToken.getCertificateSource());
            }
        }
        return allCertificatesSource;
    }

    @Override
    public void prepareSignatureValidationContext(ValidationContext validationContext, List<AdvancedSignature> allSignatureList) {
        this.prepareCertificatesAndTimestamps(validationContext, allSignatureList);
        this.processSignaturesValidation(allSignatureList);
    }

    protected void prepareCertificatesAndTimestamps(ValidationContext validationContext, List<AdvancedSignature> allSignatureList) {
        if (this.providedSigningCertificateToken != null) {
            validationContext.addCertificateTokenForVerification(this.providedSigningCertificateToken);
        }
        for (AdvancedSignature signature : allSignatureList) {
            ListCertificateSource completeCertificateSource = signature.getCompleteCertificateSource();
            for (CertificateToken certificateToken : completeCertificateSource.getAllCertificateTokens()) {
                validationContext.addCertificateTokenForVerification(certificateToken);
            }
            signature.prepareTimestamps(validationContext);
        }
    }

    @Override
    public void prepareDetachedTimestampValidationContext(ValidationContext validationContext, List<TimestampToken> timestamps) {
        for (TimestampToken timestampToken : timestamps) {
            validationContext.addTimestampTokenForVerification(timestampToken);
            this.injectReferences(timestampToken);
        }
    }

    private void injectReferences(TimestampToken timestamp) {
        for (SignatureScope scope : timestamp.getTimestampScopes()) {
            timestamp.getTimestampedReferences().add(new TimestampedReference(scope.getDSSIdAsString(), TimestampedObjectType.SIGNED_DATA));
        }
    }

    protected void validateContext(ValidationContext validationContext) {
        validationContext.initialize(this.certificateVerifier);
        validationContext.validate();
    }

    @Override
    public void setSignaturePolicyProvider(SignaturePolicyProvider signaturePolicyProvider) {
        this.signaturePolicyProvider = signaturePolicyProvider;
    }

    protected SignaturePolicyProvider getSignaturePolicyProvider() {
        if (this.signaturePolicyProvider == null) {
            this.signaturePolicyProvider = new SignaturePolicyProvider();
            this.signaturePolicyProvider.setDataLoader(this.certificateVerifier.getDataLoader());
        }
        return this.signaturePolicyProvider;
    }

    @Override
    public void setProcessExecutor(DocumentProcessExecutor processExecutor) {
        this.processExecutor = processExecutor;
    }

    protected DocumentProcessExecutor provideProcessExecutorInstance() {
        if (this.processExecutor == null) {
            this.processExecutor = this.getDefaultProcessExecutor();
        }
        return this.processExecutor;
    }

    @Override
    public DocumentProcessExecutor getDefaultProcessExecutor() {
        return new DefaultSignatureProcessExecutor();
    }

    protected final Reports processValidationPolicy(XmlDiagnosticData diagnosticData, ValidationPolicy validationPolicy) {
        DocumentProcessExecutor executor = this.provideProcessExecutorInstance();
        executor.setValidationPolicy(validationPolicy);
        executor.setValidationLevel(this.validationLevel);
        executor.setDiagnosticData(diagnosticData);
        executor.setIncludeSemantics(this.includeSemantics);
        executor.setEnableEtsiValidationReport(this.enableEtsiValidationReport);
        executor.setLocale(this.locale);
        executor.setCurrentTime(this.getValidationTime());
        return (Reports)executor.execute();
    }

    protected List<AdvancedSignature> getAllSignatures() {
        this.setSignedScopeFinderDefaultDigestAlgorithm(this.certificateVerifier.getDefaultDigestAlgorithm());
        ArrayList<AdvancedSignature> allSignatureList = new ArrayList<AdvancedSignature>();
        for (AdvancedSignature signature : this.getSignatures()) {
            allSignatureList.add(signature);
            allSignatureList.addAll(signature.getCounterSignatures());
        }
        this.findSignatureScopes(allSignatureList);
        return allSignatureList;
    }

    @Override
    public List<AdvancedSignature> getSignatures() {
        return Collections.emptyList();
    }

    @Override
    public List<TimestampToken> getDetachedTimestamps() {
        return Collections.emptyList();
    }

    @Override
    public void processSignaturesValidation(List<AdvancedSignature> allSignatureList) {
        for (AdvancedSignature signature : allSignatureList) {
            signature.checkSignatureIntegrity();
            signature.validateStructure();
            signature.checkSignaturePolicy(this.getSignaturePolicyProvider());
        }
    }

    @Override
    public void findSignatureScopes(List<AdvancedSignature> allSignatures) {
        for (AdvancedSignature signature : allSignatures) {
            signature.findSignatureScope(this.signatureScopeFinder);
        }
    }

    public void setSkipValidationContextExecution(boolean skipValidationContextExecution) {
        this.skipValidationContextExecution = skipValidationContextExecution;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    static {
        Security.addProvider(DSSSecurityProvider.getSecurityProvider());
    }
}

