/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.DigestDocument;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.revocation.crl.CRL;
import eu.europa.esig.dss.model.x509.revocation.ocsp.OCSP;
import eu.europa.esig.dss.spi.x509.CandidatesForSigningCertificate;
import eu.europa.esig.dss.spi.x509.CertificateIdentifier;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import eu.europa.esig.dss.spi.x509.CertificateValidity;
import eu.europa.esig.dss.spi.x509.ListCertificateSource;
import eu.europa.esig.dss.spi.x509.revocation.crl.OfflineCRLSource;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OfflineOCSPSource;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.CertificateVerifierBuilder;
import eu.europa.esig.dss.validation.ListRevocationSource;
import eu.europa.esig.dss.validation.ManifestEntry;
import eu.europa.esig.dss.validation.ManifestFile;
import eu.europa.esig.dss.validation.PdfRevision;
import eu.europa.esig.dss.validation.ReferenceValidation;
import eu.europa.esig.dss.validation.SignatureCertificateSource;
import eu.europa.esig.dss.validation.SignatureCryptographicVerification;
import eu.europa.esig.dss.validation.SignatureIdentifier;
import eu.europa.esig.dss.validation.SignaturePolicy;
import eu.europa.esig.dss.validation.SignatureValidationContext;
import eu.europa.esig.dss.validation.SignerRole;
import eu.europa.esig.dss.validation.ValidationContext;
import eu.europa.esig.dss.validation.scope.SignatureScope;
import eu.europa.esig.dss.validation.scope.SignatureScopeFinder;
import eu.europa.esig.dss.validation.timestamp.TimestampSource;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public abstract class DefaultAdvancedSignature
implements AdvancedSignature {
    private static final long serialVersionUID = 6452189007886779360L;
    protected CertificateToken providedSigningCertificateToken;
    protected List<DSSDocument> detachedContents;
    private List<DSSDocument> containerContents;
    protected List<ManifestFile> manifestFiles;
    protected List<ReferenceValidation> referenceValidations;
    protected SignatureCryptographicVerification signatureCryptographicVerification;
    protected String structureValidation;
    private CertificateVerifier offlineCertificateVerifier;
    protected SignatureCertificateSource offlineCertificateSource;
    protected OfflineCRLSource signatureCRLSource;
    protected OfflineOCSPSource signatureOCSPSource;
    protected TimestampSource signatureTimestampSource;
    private AdvancedSignature masterSignature;
    protected SignaturePolicy signaturePolicy;
    private List<SignatureScope> signatureScopes;
    private String signatureFilename;
    protected SignatureIdentifier signatureIdentifier;

    protected abstract SignatureIdentifier buildSignatureIdentifier();

    @Override
    public String getSignatureFilename() {
        return this.signatureFilename;
    }

    @Override
    public void setSignatureFilename(String signatureFilename) {
        this.signatureFilename = signatureFilename;
    }

    @Override
    public List<DSSDocument> getDetachedContents() {
        return this.detachedContents;
    }

    @Override
    public void setDetachedContents(List<DSSDocument> detachedContents) {
        this.detachedContents = detachedContents;
    }

    @Override
    public List<DSSDocument> getContainerContents() {
        return this.containerContents;
    }

    @Override
    public void setContainerContents(List<DSSDocument> containerContents) {
        this.containerContents = containerContents;
    }

    @Override
    public void setManifestFiles(List<ManifestFile> manifestFiles) {
        this.manifestFiles = manifestFiles;
    }

    @Override
    public SignatureIdentifier getDSSId() {
        if (this.signatureIdentifier == null) {
            this.signatureIdentifier = this.buildSignatureIdentifier();
        }
        return this.signatureIdentifier;
    }

    @Override
    public String getId() {
        return this.getDSSId().asXmlId();
    }

    @Override
    public List<DSSDocument> getManifestedDocuments() {
        if (Utils.isCollectionEmpty(this.manifestFiles) || Utils.isCollectionEmpty(this.containerContents)) {
            return Collections.emptyList();
        }
        ArrayList<DSSDocument> foundManifestedDocuments = new ArrayList<DSSDocument>();
        for (ManifestFile manifestFile : this.manifestFiles) {
            if (!Utils.areStringsEqual((String)manifestFile.getSignatureFilename(), (String)this.signatureFilename)) continue;
            for (DSSDocument document : this.containerContents) {
                for (ManifestEntry entry : manifestFile.getEntries()) {
                    if (!Utils.areStringsEqual((String)entry.getFileName(), (String)document.getName())) continue;
                    foundManifestedDocuments.add(document);
                }
            }
        }
        return foundManifestedDocuments;
    }

    @Override
    public ListCertificateSource getCompleteCertificateSource() {
        ListCertificateSource certificateSource = new ListCertificateSource((CertificateSource)this.getCertificateSource());
        certificateSource.addAll(this.getTimestampSource().getTimestampCertificateSources());
        return certificateSource;
    }

    public ListCertificateSource getCertificateSourcesExceptLastArchiveTimestamp() {
        ListCertificateSource certificateSource = new ListCertificateSource((CertificateSource)this.getCertificateSource());
        certificateSource.addAll(this.getTimestampSource().getTimestampCertificateSourcesExceptLastArchiveTimestamp());
        return certificateSource;
    }

    public ListRevocationSource getCompleteCRLSource() {
        ListRevocationSource<CRL> crlSource = new ListRevocationSource<CRL>(this.getCRLSource());
        crlSource.addAll(this.getTimestampSource().getTimestampCRLSources());
        return crlSource;
    }

    public ListRevocationSource getCompleteOCSPSource() {
        ListRevocationSource<OCSP> ocspSource = new ListRevocationSource<OCSP>(this.getOCSPSource());
        ocspSource.addAll(this.getTimestampSource().getTimestampOCSPSources());
        return ocspSource;
    }

    @Override
    public CandidatesForSigningCertificate getCandidatesForSigningCertificate() {
        return this.getCertificateSource().getCandidatesForSigningCertificate(this.providedSigningCertificateToken);
    }

    public void prepareOfflineCertificateVerifier(CertificateVerifier certificateVerifier) {
        this.offlineCertificateVerifier = new CertificateVerifierBuilder(certificateVerifier).buildOfflineAndSilentCopy();
    }

    public ValidationContext getSignatureValidationContext(CertificateVerifier certificateVerifier) {
        SignatureValidationContext validationContext = new SignatureValidationContext();
        certificateVerifier.setSignatureCRLSource(this.getCompleteCRLSource());
        certificateVerifier.setSignatureOCSPSource(this.getCompleteOCSPSource());
        certificateVerifier.setSignatureCertificateSource(this.getCompleteCertificateSource());
        validationContext.initialize(certificateVerifier);
        if (this.providedSigningCertificateToken != null) {
            validationContext.addCertificateTokenForVerification(this.providedSigningCertificateToken);
        }
        List<CertificateToken> certificates = this.getCertificates();
        for (CertificateToken certificate : certificates) {
            validationContext.addCertificateTokenForVerification(certificate);
        }
        this.prepareTimestamps(validationContext);
        validationContext.validate();
        validationContext.checkAllTimestampsValid();
        validationContext.checkAllRequiredRevocationDataPresent();
        validationContext.checkAllPOECoveredByRevocationData();
        validationContext.checkAllCertificatesValid();
        CertificateToken signingCertificateToken = this.getSigningCertificateToken();
        validationContext.checkAtLeastOneRevocationDataPresentAfterBestSignatureTime(signingCertificateToken);
        return validationContext;
    }

    @Override
    public List<CertificateToken> getCertificates() {
        return this.getCertificateSource().getCertificates();
    }

    @Override
    public void setMasterSignature(AdvancedSignature masterSignature) {
        this.masterSignature = masterSignature;
    }

    @Override
    public AdvancedSignature getMasterSignature() {
        return this.masterSignature;
    }

    @Override
    public boolean isCounterSignature() {
        return this.masterSignature != null;
    }

    @Override
    public SignatureCryptographicVerification getSignatureCryptographicVerification() {
        if (this.signatureCryptographicVerification == null) {
            this.checkSignatureIntegrity();
        }
        return this.signatureCryptographicVerification;
    }

    @Override
    public List<SignerRole> getSignerRoles() {
        List<SignerRole> signedAssertionSignerRoles;
        List<SignerRole> certifiedSignerRoles;
        ArrayList<SignerRole> signerRoles = new ArrayList<SignerRole>();
        List<SignerRole> claimedSignerRoles = this.getClaimedSignerRoles();
        if (Utils.isCollectionNotEmpty(claimedSignerRoles)) {
            signerRoles.addAll(claimedSignerRoles);
        }
        if (Utils.isCollectionNotEmpty(certifiedSignerRoles = this.getCertifiedSignerRoles())) {
            signerRoles.addAll(certifiedSignerRoles);
        }
        if (Utils.isCollectionNotEmpty(signedAssertionSignerRoles = this.getSignedAssertions())) {
            signerRoles.addAll(signedAssertionSignerRoles);
        }
        return signerRoles;
    }

    @Override
    public CertificateToken getProvidedSigningCertificateToken() {
        return this.providedSigningCertificateToken;
    }

    @Override
    public void setProvidedSigningCertificateToken(CertificateToken certificateToken) {
        this.providedSigningCertificateToken = certificateToken;
    }

    @Override
    public CertificateToken getSigningCertificateToken() {
        CandidatesForSigningCertificate candidatesForSigningCertificate = this.getCertificateSource().getCandidatesForSigningCertificate(this.providedSigningCertificateToken);
        this.signatureCryptographicVerification = this.getSignatureCryptographicVerification();
        CertificateValidity theCertificateValidity = candidatesForSigningCertificate.getTheCertificateValidity();
        if (theCertificateValidity != null && theCertificateValidity.isValid()) {
            CertificateToken signingCertificateToken = theCertificateValidity.getCertificateToken();
            return signingCertificateToken;
        }
        CertificateValidity theBestCandidate = candidatesForSigningCertificate.getTheBestCandidate();
        return theBestCandidate == null ? null : theBestCandidate.getCertificateToken();
    }

    @Override
    public void prepareTimestamps(ValidationContext validationContext) {
        for (TimestampToken timestampToken : this.getContentTimestamps()) {
            validationContext.addTimestampTokenForVerification(timestampToken);
        }
        for (TimestampToken timestampToken : this.getSignatureTimestamps()) {
            validationContext.addTimestampTokenForVerification(timestampToken);
        }
        for (TimestampToken timestampToken : this.getTimestampsX1()) {
            validationContext.addTimestampTokenForVerification(timestampToken);
        }
        for (TimestampToken timestampToken : this.getTimestampsX2()) {
            validationContext.addTimestampTokenForVerification(timestampToken);
        }
        for (TimestampToken timestampToken : this.getArchiveTimestamps()) {
            validationContext.addTimestampTokenForVerification(timestampToken);
        }
    }

    @Override
    public void validateStructure() {
    }

    @Override
    public String getStructureValidationResult() {
        return this.structureValidation;
    }

    @Override
    public SignaturePolicy getPolicyId() {
        return this.signaturePolicy;
    }

    @Override
    public void findSignatureScope(SignatureScopeFinder signatureScopeFinder) {
        this.signatureScopes = signatureScopeFinder.findSignatureScope(this);
    }

    @Override
    public List<SignatureScope> getSignatureScopes() {
        return this.signatureScopes;
    }

    @Override
    public List<TimestampToken> getContentTimestamps() {
        return this.getTimestampSource().getContentTimestamps();
    }

    @Override
    public List<TimestampToken> getSignatureTimestamps() {
        return this.getTimestampSource().getSignatureTimestamps();
    }

    @Override
    public List<TimestampToken> getTimestampsX1() {
        return this.getTimestampSource().getTimestampsX1();
    }

    @Override
    public List<TimestampToken> getTimestampsX2() {
        return this.getTimestampSource().getTimestampsX2();
    }

    @Override
    public List<TimestampToken> getArchiveTimestamps() {
        return this.getTimestampSource().getArchiveTimestamps();
    }

    @Override
    public List<TimestampToken> getDocumentTimestamps() {
        return this.getTimestampSource().getDocumentTimestamps();
    }

    @Override
    public List<TimestampToken> getAllTimestamps() {
        return this.getTimestampSource().getAllTimestamps();
    }

    @Override
    public void addExternalTimestamp(TimestampToken timestamp) {
        if (!timestamp.isProcessed()) {
            throw new DSSException("Timestamp token must be validated first !");
        }
        if (!timestamp.getTimeStampType().isArchivalTimestamp()) {
            throw new DSSException("Only archival timestamp is allowed !");
        }
        this.getTimestampSource().addExternalTimestamp(timestamp);
    }

    public boolean hasTProfile() {
        return Utils.isCollectionNotEmpty(this.getSignatureTimestamps());
    }

    public boolean hasLTProfile() {
        boolean minimalLTrequirement;
        ListCertificateSource certificateSources = this.getCertificateSourcesExceptLastArchiveTimestamp();
        boolean certificateFound = certificateSources.getNumberOfCertificates() > 0;
        boolean allSelfSigned = certificateFound && certificateSources.isAllSelfSigned();
        boolean emptyCRLs = this.getCompleteCRLSource().getAllRevocationBinaries().isEmpty();
        boolean emptyOCSPs = this.getCompleteOCSPSource().getAllRevocationBinaries().isEmpty();
        boolean emptyRevocation = emptyCRLs && emptyOCSPs;
        boolean bl = minimalLTrequirement = !allSelfSigned && !emptyRevocation;
        if (minimalLTrequirement) {
            return this.isAllRevocationDataPresent(certificateSources);
        }
        return minimalLTrequirement;
    }

    private boolean isAllRevocationDataPresent(ListCertificateSource certificateSources) {
        SignatureValidationContext validationContext = new SignatureValidationContext();
        this.offlineCertificateVerifier.setSignatureCRLSource(this.getCompleteCRLSource());
        this.offlineCertificateVerifier.setSignatureOCSPSource(this.getCompleteOCSPSource());
        this.offlineCertificateVerifier.setSignatureCertificateSource(this.getCompleteCertificateSource());
        validationContext.initialize(this.offlineCertificateVerifier);
        if (this.providedSigningCertificateToken != null) {
            validationContext.addCertificateTokenForVerification(this.providedSigningCertificateToken);
        }
        for (CertificateToken certificate : certificateSources.getAllCertificateTokens()) {
            validationContext.addCertificateTokenForVerification(certificate);
        }
        validationContext.validate();
        return validationContext.checkAllRequiredRevocationDataPresent();
    }

    @Override
    public boolean areAllSelfSignedCertificates() {
        ListCertificateSource certificateSources = this.getCompleteCertificateSource();
        boolean certificateFound = certificateSources.getNumberOfCertificates() > 0;
        return certificateFound && certificateSources.isAllSelfSigned();
    }

    public boolean hasLTAProfile() {
        return Utils.isCollectionNotEmpty(this.getArchiveTimestamps());
    }

    @Override
    public boolean isDocHashOnlyValidation() {
        if (Utils.isCollectionNotEmpty(this.detachedContents)) {
            for (DSSDocument dssDocument : this.detachedContents) {
                if (dssDocument instanceof DigestDocument) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isHashOnlyValidation() {
        return false;
    }

    @Override
    public byte[] getMessageDigestValue() {
        return null;
    }

    @Override
    public Set<CertificateIdentifier> getSignerInformationStoreInfos() {
        return Collections.emptySet();
    }

    @Override
    public PdfRevision getPdfRevision() {
        return null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof DefaultAdvancedSignature)) {
            return false;
        }
        DefaultAdvancedSignature das = (DefaultAdvancedSignature)obj;
        return this.getDSSId().equals((Object)das.getDSSId());
    }

    public int hashCode() {
        return this.getDSSId().hashCode();
    }

    public String toString() {
        return String.format("%s Signature with Id : %s", this.getSignatureForm(), this.getId());
    }
}

