/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.Token;
import eu.europa.esig.dss.utils.Utils;
import java.security.PublicKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.ECParameterSpec;
import org.bouncycastle.jcajce.interfaces.EdDSAPublicKey;
import org.bouncycastle.jcajce.interfaces.XDHPublicKey;
import org.bouncycastle.jce.provider.JCEECPublicKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DSSPKUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DSSPKUtils.class);

    private DSSPKUtils() {
    }

    public static String getPublicKeySize(Token token) {
        String keyLength = "?";
        PublicKey issuerPublicKey = null;
        if (token.getPublicKeyOfTheSigner() != null) {
            issuerPublicKey = token.getPublicKeyOfTheSigner();
        } else if (token.isSelfSigned()) {
            issuerPublicKey = ((CertificateToken)token).getPublicKey();
        }
        if (issuerPublicKey != null) {
            keyLength = String.valueOf(DSSPKUtils.getPublicKeySize(issuerPublicKey));
        }
        return keyLength;
    }

    public static int getPublicKeySize(PublicKey publicKey) {
        int publicKeySize = -1;
        if (publicKey instanceof RSAPublicKey) {
            RSAPublicKey rsaPublicKey = (RSAPublicKey)publicKey;
            publicKeySize = rsaPublicKey.getModulus().bitLength();
        } else if (publicKey instanceof JCEECPublicKey) {
            JCEECPublicKey jceecPublicKey = (JCEECPublicKey)publicKey;
            org.bouncycastle.jce.spec.ECParameterSpec spec = jceecPublicKey.getParameters();
            publicKeySize = spec != null ? spec.getN().bitLength() : 0;
        } else if (publicKey instanceof ECPublicKey) {
            ECPublicKey ecPublicKey = (ECPublicKey)publicKey;
            ECParameterSpec spec = ecPublicKey.getParams();
            publicKeySize = spec != null ? spec.getCurve().getField().getFieldSize() : 0;
        } else if (publicKey instanceof DSAPublicKey) {
            DSAPublicKey dsaPublicKey = (DSAPublicKey)publicKey;
            publicKeySize = dsaPublicKey.getParams().getP().bitLength();
        } else {
            if (publicKey instanceof EdDSAPublicKey) {
                EdDSAPublicKey eddsaPK = (EdDSAPublicKey)publicKey;
                int prefixSize = Utils.fromHex((String)"3043300506032b6571033a00").length;
                return eddsaPK.getEncoded().length - prefixSize;
            }
            if (publicKey instanceof XDHPublicKey) {
                XDHPublicKey xdhPK = (XDHPublicKey)publicKey;
                int prefixSize = Utils.fromHex((String)"3042300506032b656f033900").length;
                return xdhPK.getEncoded().length - prefixSize;
            }
            LOG.error("Unknown public key infrastructure: {}", (Object)publicKey.getClass().getName());
        }
        return publicKeySize;
    }
}

