/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.crl.CRLUtils;
import eu.europa.esig.dss.enumerations.RevocationOrigin;
import eu.europa.esig.dss.enumerations.RevocationRefOrigin;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.identifier.EncapsulatedRevocationTokenIdentifier;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.OID;
import eu.europa.esig.dss.spi.x509.revocation.RevocationRef;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLRef;
import eu.europa.esig.dss.spi.x509.revocation.crl.OfflineCRLSource;
import java.io.IOException;
import java.util.Collection;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.esf.CrlListID;
import org.bouncycastle.asn1.esf.CrlOcspRef;
import org.bouncycastle.asn1.esf.CrlValidatedID;
import org.bouncycastle.asn1.esf.RevocationValues;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.CertificateList;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.util.Store;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CMSCRLSource
extends OfflineCRLSource {
    private static final Logger LOG = LoggerFactory.getLogger(CMSCRLSource.class);
    private final transient CMSSignedData cmsSignedData;
    private final transient AttributeTable unsignedAttributes;

    public CMSCRLSource(CMSSignedData cmsSignedData, AttributeTable unsignedAttributes) {
        this.cmsSignedData = cmsSignedData;
        this.unsignedAttributes = unsignedAttributes;
        this.extract();
    }

    private void extract() {
        this.collectFromSignedData();
        if (this.unsignedAttributes != null) {
            this.collectRevocationValues(this.unsignedAttributes, PKCSObjectIdentifiers.id_aa_ets_revocationValues, RevocationOrigin.REVOCATION_VALUES);
            this.collectRevocationRefs(PKCSObjectIdentifiers.id_aa_ets_revocationRefs, RevocationRefOrigin.COMPLETE_REVOCATION_REFS);
            this.collectRevocationRefs(OID.attributeRevocationRefsOid, RevocationRefOrigin.ATTRIBUTE_REVOCATION_REFS);
        }
    }

    private void collectFromSignedData() {
        Store crLs = this.cmsSignedData.getCRLs();
        Collection collection = crLs.getMatches(null);
        for (X509CRLHolder x509CRLHolder : collection) {
            this.addX509CRLHolder(x509CRLHolder, RevocationOrigin.CMS_SIGNED_DATA);
        }
    }

    private void collectRevocationValues(AttributeTable attributes, ASN1ObjectIdentifier revocationValuesAttribute, RevocationOrigin origin) {
        ASN1Encodable attValue = DSSASN1Utils.getAsn1Encodable((AttributeTable)attributes, (ASN1ObjectIdentifier)revocationValuesAttribute);
        RevocationValues revValues = DSSASN1Utils.getRevocationValues((ASN1Encodable)attValue);
        if (revValues != null) {
            for (CertificateList revValue : revValues.getCrlVals()) {
                this.addX509CRLHolder(new X509CRLHolder(revValue), origin);
            }
        }
    }

    protected void addX509CRLHolder(X509CRLHolder crlHolder, RevocationOrigin origin) {
        try {
            this.addBinary((EncapsulatedRevocationTokenIdentifier)CRLUtils.buildCRLBinary((byte[])crlHolder.getEncoded()), origin);
        }
        catch (IOException e) {
            throw new DSSException((Throwable)e);
        }
    }

    private void collectRevocationRefs(ASN1ObjectIdentifier revocationRefsAttribute, RevocationRefOrigin origin) {
        try {
            ASN1Encodable attrValue = DSSASN1Utils.getAsn1Encodable((AttributeTable)this.unsignedAttributes, (ASN1ObjectIdentifier)revocationRefsAttribute);
            if (attrValue != null) {
                ASN1Sequence revocationRefs = (ASN1Sequence)attrValue;
                for (int ii = 0; ii < revocationRefs.size(); ++ii) {
                    CrlOcspRef crlOcspRef = CrlOcspRef.getInstance((Object)revocationRefs.getObjectAt(ii));
                    CrlListID crlIds = crlOcspRef.getCrlids();
                    if (crlIds == null) continue;
                    for (CrlValidatedID id : crlIds.getCrls()) {
                        CRLRef crlRef = new CRLRef(id);
                        this.addRevocationReference((RevocationRef)crlRef, origin);
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.warn("An error occurred during extraction of revocation references from  signature unsigned properties. Revocations for origin {} were not stored", (Object)origin.toString(), (Object)e);
        }
    }
}

