/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss;

import eu.europa.esig.dss.DSSXmlErrorListener;
import eu.europa.esig.dss.NamespaceContextMap;
import eu.europa.esig.dss.definition.DSSAttribute;
import eu.europa.esig.dss.definition.DSSElement;
import eu.europa.esig.dss.definition.DSSNamespace;
import eu.europa.esig.dss.jaxb.XmlDefinerUtils;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.model.MimeType;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public final class DomUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DomUtils.class);
    public static final int TRANSFORMER_INDENT_NUMBER = 4;
    private static final String TRANSFORMER_METHOD_VALUE = "xml";
    private static final String XP_OPEN = "xpointer(";
    private static final String XNS_OPEN = "xmlns(";
    private static DocumentBuilderFactory dbFactory;
    private static final XPathFactory factory;
    private static NamespaceContextMap namespacePrefixMapper;
    private static final Map<String, String> namespaces;

    private DomUtils() {
    }

    public static void enableFeature(String feature) throws ParserConfigurationException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Enabling DocumentBuilderFactory feature [{}]...", (Object)feature);
        }
        DomUtils.setFeature(feature, true);
    }

    public static void disableFeature(String feature) throws ParserConfigurationException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Disabling DocumentBuilderFactory feature [{}]...", (Object)feature);
        }
        DomUtils.setFeature(feature, false);
    }

    private static void setSecurityFeature(String property, boolean enable) {
        try {
            DomUtils.setFeature(property, enable);
        }
        catch (ParserConfigurationException e) {
            String message = String.format("SECURITY : unable to set feature %s = %s (more details in LOG debug)", property, enable);
            if (LOG.isDebugEnabled()) {
                LOG.debug(message, (Throwable)e);
            }
            LOG.warn(message);
        }
    }

    private static void setFeature(String property, boolean enable) throws ParserConfigurationException {
        dbFactory.setFeature(property, enable);
    }

    public static boolean registerNamespace(DSSNamespace namespace) {
        String put = namespaces.put(namespace.getPrefix(), namespace.getUri());
        namespacePrefixMapper.registerNamespace(namespace.getPrefix(), namespace.getUri());
        return put == null;
    }

    public static TransformerFactory getSecureTransformerFactory() {
        TransformerFactory transformerFactory = XmlDefinerUtils.getInstance().getSecureTransformerFactory();
        transformerFactory.setErrorListener(new DSSXmlErrorListener());
        return transformerFactory;
    }

    public static Transformer getSecureTransformer() {
        TransformerFactory transformerFactory = DomUtils.getSecureTransformerFactory();
        Transformer transformer = null;
        try {
            transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("method", TRANSFORMER_METHOD_VALUE);
        }
        catch (TransformerConfigurationException e) {
            throw new DSSException((Throwable)e);
        }
        transformer.setErrorListener(new DSSXmlErrorListener());
        return transformer;
    }

    public static Document buildDOM() {
        try {
            return dbFactory.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new DSSException((Throwable)e);
        }
    }

    public static Document buildDOM(String xmlString) {
        return DomUtils.buildDOM(xmlString.getBytes(StandardCharsets.UTF_8));
    }

    public static Document buildDOM(byte[] bytes) {
        Objects.requireNonNull(bytes, "bytes is required");
        return DomUtils.buildDOM(new ByteArrayInputStream(bytes));
    }

    public static Document buildDOM(DSSDocument dssDocument) {
        Objects.requireNonNull(dssDocument, "The document is null");
        return DomUtils.buildDOM(dssDocument.openStream());
    }

    public static boolean isDOM(byte[] bytes) {
        try {
            Document dom = DomUtils.buildDOM(bytes);
            return dom != null;
        }
        catch (DSSException e) {
            return false;
        }
    }

    public static Document buildDOM(InputStream inputStream) {
        Document document;
        block8: {
            InputStream is = inputStream;
            try {
                document = dbFactory.newDocumentBuilder().parse(is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new DSSException("Unable to parse content (XML expected)", (Throwable)e);
                }
            }
            is.close();
        }
        return document;
    }

    public static void setAttributeNS(Element element, DSSNamespace namespace, DSSAttribute attribute, String value) {
        StringBuffer sb = new StringBuffer();
        sb.append(namespace.getPrefix());
        sb.append(':');
        sb.append(attribute.getAttributeName());
        element.setAttributeNS(namespace.getUri(), sb.toString(), value);
    }

    public static Element addElement(Document document, Element parentDom, DSSNamespace namespace, DSSElement element) {
        Element dom = DomUtils.createElementNS(document, namespace, element);
        parentDom.appendChild(dom);
        return dom;
    }

    public static XPathExpression createXPathExpression(String xpathString) {
        XPath xpath = factory.newXPath();
        xpath.setNamespaceContext(namespacePrefixMapper);
        try {
            return xpath.compile(xpathString);
        }
        catch (XPathExpressionException ex) {
            throw new DSSException((Throwable)ex);
        }
    }

    public static String getValue(Node xmlNode, String xPathString) {
        try {
            XPathExpression xPathExpression = DomUtils.createXPathExpression(xPathString);
            String string = (String)xPathExpression.evaluate(xmlNode, XPathConstants.STRING);
            return string.trim();
        }
        catch (XPathExpressionException e) {
            throw new DSSException((Throwable)e);
        }
    }

    public static NodeList getNodeList(Node xmlNode, String xPathString) {
        try {
            XPathExpression expr = DomUtils.createXPathExpression(xPathString);
            return (NodeList)expr.evaluate(xmlNode, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            throw new DSSException((Throwable)e);
        }
    }

    public static Node getNode(Node xmlNode, String xPathString) {
        NodeList list = DomUtils.getNodeList(xmlNode, xPathString);
        if (list.getLength() > 1) {
            throw new DSSException("More than one result for XPath: " + xPathString);
        }
        return list.item(0);
    }

    public static Element getElement(Node xmlNode, String xPathString) {
        return (Element)DomUtils.getNode(xmlNode, xPathString);
    }

    public static boolean isNotEmpty(Node xmlNode, String xPathString) {
        NodeList nodeList = DomUtils.getNodeList(xmlNode, xPathString + "/child::node()[not(self::text())]");
        return nodeList != null && nodeList.getLength() > 0;
    }

    public static Element addTextElement(Document document, Element parentDom, DSSNamespace namespace, DSSElement element, String value) {
        Element dom = DomUtils.createElementNS(document, namespace, element);
        parentDom.appendChild(dom);
        Text valueNode = document.createTextNode(value);
        dom.appendChild(valueNode);
        return dom;
    }

    public static void setTextNode(Document document, Element parentDom, String text) {
        Text textNode = document.createTextNode(text);
        parentDom.appendChild(textNode);
    }

    public static XMLGregorianCalendar createXMLGregorianCalendar(Date date) {
        if (date == null) {
            return null;
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        try {
            XMLGregorianCalendar xmlGregorianCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(calendar);
            xmlGregorianCalendar.setFractionalSecond(null);
            return xmlGregorianCalendar.normalize();
        }
        catch (DatatypeConfigurationException e) {
            LOG.warn("Unable to properly convert a Date to an XMLGregorianCalendar : {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    public static Date getDate(String text) {
        try {
            DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();
            XMLGregorianCalendar xmlGregorianCalendar = datatypeFactory.newXMLGregorianCalendar(text);
            return xmlGregorianCalendar.toGregorianCalendar().getTime();
        }
        catch (Exception e) {
            LOG.warn("Unable to parse '{}'", (Object)text);
            return null;
        }
    }

    public static List<String> getChildrenNames(Node xmlNode, String xPathString) {
        ArrayList<String> childrenNames = new ArrayList<String>();
        Element element = DomUtils.getElement(xmlNode, xPathString);
        if (element != null) {
            NodeList unsignedProperties = element.getChildNodes();
            for (int ii = 0; ii < unsignedProperties.getLength(); ++ii) {
                Node node = unsignedProperties.item(ii);
                childrenNames.add(node.getLocalName());
            }
        }
        return childrenNames;
    }

    public static void writeDocumentTo(Document dom, OutputStream os) {
        try {
            DOMSource xmlSource = new DOMSource(dom);
            StreamResult outputTarget = new StreamResult(os);
            Transformer transformer = DomUtils.getSecureTransformer();
            transformer.transform(xmlSource, outputTarget);
        }
        catch (Exception e) {
            throw new DSSException((Throwable)e);
        }
    }

    public static DSSDocument createDssDocumentFromDomDocument(Document document, String name) {
        InMemoryDocument inMemoryDocument;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            DomUtils.writeDocumentTo(document, baos);
            inMemoryDocument = new InMemoryDocument(baos.toByteArray(), name, MimeType.XML);
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new DSSException((Throwable)e);
            }
        }
        baos.close();
        return inMemoryDocument;
    }

    public static String xmlToString(Node node) {
        try {
            DOMSource source = new DOMSource(node);
            StringWriter stringWriter = new StringWriter();
            StreamResult result = new StreamResult(stringWriter);
            Transformer transformer = DomUtils.getSecureTransformer();
            transformer.transform(source, result);
            return stringWriter.getBuffer().toString();
        }
        catch (Exception e) {
            throw new DSSException((Throwable)e);
        }
    }

    public static Map<String, String> getCurrentNamespaces() {
        return new HashMap<String, String>(namespaces);
    }

    public static String getXPathByIdAttribute(String uri) {
        String id = DomUtils.getId(uri);
        return "[@Id='" + id + "' or @id='" + id + "' or @ID='" + id + "']";
    }

    public static String getId(String uri) {
        String id = uri;
        if (DomUtils.startsFromHash(uri)) {
            id = id.substring(1);
        }
        return id;
    }

    private static boolean startsFromHash(String uri) {
        return Utils.isStringNotBlank((String)uri) && uri.startsWith("#");
    }

    public static boolean isElementReference(String uri) {
        return DomUtils.startsFromHash(uri) && !DomUtils.isXPointerQuery(uri);
    }

    public static boolean isXPointerQuery(String uriValue) {
        int ii;
        if (Utils.isStringEmpty((String)uriValue)) {
            return false;
        }
        String decodedUri = DSSUtils.decodeUrl((String)uriValue);
        if (decodedUri == null) {
            return false;
        }
        String[] parts = DomUtils.getId(decodedUri).split("\\s");
        for (ii = 0; ii < parts.length - 1; ++ii) {
            if (parts[ii].endsWith(")") && parts[ii].startsWith(XNS_OPEN)) continue;
            return false;
        }
        return parts[ii].endsWith(")") && parts[ii].startsWith(XP_OPEN);
    }

    public static Element createElementNS(Document documentDom, DSSNamespace namespace, DSSElement element) {
        StringBuffer elementSB = new StringBuffer();
        if (Utils.isStringNotEmpty((String)namespace.getPrefix())) {
            elementSB.append(namespace.getPrefix());
            elementSB.append(':');
        }
        elementSB.append(element.getTagName());
        return documentDom.createElementNS(namespace.getUri(), elementSB.toString());
    }

    public static void addNamespaceAttribute(Element element, DSSNamespace namespace) {
        StringBuffer namespaceAttribute = new StringBuffer();
        namespaceAttribute.append("xmlns:");
        namespaceAttribute.append(namespace.getPrefix());
        element.setAttribute(namespaceAttribute.toString(), namespace.getUri());
    }

    static {
        factory = XPathFactory.newInstance();
        namespacePrefixMapper = new NamespaceContextMap();
        namespaces = new HashMap<String, String>();
        dbFactory = DocumentBuilderFactory.newInstance();
        dbFactory.setNamespaceAware(true);
        dbFactory.setXIncludeAware(false);
        dbFactory.setExpandEntityReferences(false);
        DomUtils.setSecurityFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        DomUtils.setSecurityFeature("http://xml.org/sax/features/external-general-entities", false);
        DomUtils.setSecurityFeature("http://xml.org/sax/features/external-parameter-entities", false);
        DomUtils.setSecurityFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
    }
}

