/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.CertificateReorderer;
import eu.europa.esig.dss.DSSASN1Utils;
import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DSSUtils;
import eu.europa.esig.dss.client.http.DataLoader;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.OCSPAndCRLCertificateVerifier;
import eu.europa.esig.dss.validation.TimestampToken;
import eu.europa.esig.dss.validation.ValidationContext;
import eu.europa.esig.dss.x509.AlternateUrlsSourceAdapter;
import eu.europa.esig.dss.x509.CertificatePool;
import eu.europa.esig.dss.x509.CertificateSource;
import eu.europa.esig.dss.x509.CertificateSourceType;
import eu.europa.esig.dss.x509.CertificateToken;
import eu.europa.esig.dss.x509.CommonTrustedCertificateSource;
import eu.europa.esig.dss.x509.RevocationSource;
import eu.europa.esig.dss.x509.RevocationSourceAlternateUrlsSupport;
import eu.europa.esig.dss.x509.RevocationToken;
import eu.europa.esig.dss.x509.Token;
import eu.europa.esig.dss.x509.crl.CRLReasonEnum;
import eu.europa.esig.dss.x509.crl.CRLSource;
import eu.europa.esig.dss.x509.crl.CRLToken;
import eu.europa.esig.dss.x509.ocsp.OCSPSource;
import eu.europa.esig.dss.x509.ocsp.OCSPToken;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureValidationContext
implements ValidationContext {
    private static final Logger LOG = LoggerFactory.getLogger(SignatureValidationContext.class);
    private final Set<CertificateToken> processedCertificates = new HashSet<CertificateToken>();
    private final Set<RevocationToken> processedRevocations = new HashSet<RevocationToken>();
    private final Set<TimestampToken> processedTimestamps = new HashSet<TimestampToken>();
    private DataLoader dataLoader;
    protected CertificatePool validationCertificatePool;
    private final Map<Token, Boolean> tokensToProcess = new HashMap<Token, Boolean>();
    private final Map<CertificateToken, Date> lastUsageDates = new HashMap<CertificateToken, Date>();
    private OCSPSource ocspSource;
    private CRLSource crlSource;
    private CRLSource signatureCRLSource;
    private OCSPSource signatureOCSPSource;
    private CertificateSource trustedCertSource;
    private boolean checkRevocationForUntrustedChains;
    protected Date currentTime = new Date();

    public SignatureValidationContext() {
    }

    public SignatureValidationContext(CertificatePool validationCertificatePool) {
        Objects.requireNonNull(validationCertificatePool);
        this.validationCertificatePool = validationCertificatePool;
    }

    @Override
    public void initialize(CertificateVerifier certificateVerifier) {
        Objects.requireNonNull(certificateVerifier);
        if (this.validationCertificatePool == null) {
            this.validationCertificatePool = new CertificatePool();
        }
        if (certificateVerifier.getTrustedCertSource() != null) {
            this.validationCertificatePool.importCerts(certificateVerifier.getTrustedCertSource());
        }
        if (certificateVerifier.getAdjunctCertSource() != null) {
            this.validationCertificatePool.importCerts(certificateVerifier.getAdjunctCertSource());
        }
        this.crlSource = certificateVerifier.getCrlSource();
        this.ocspSource = certificateVerifier.getOcspSource();
        this.dataLoader = certificateVerifier.getDataLoader();
        this.signatureCRLSource = certificateVerifier.getSignatureCRLSource();
        this.signatureOCSPSource = certificateVerifier.getSignatureOCSPSource();
        this.trustedCertSource = certificateVerifier.getTrustedCertSource();
        this.checkRevocationForUntrustedChains = certificateVerifier.isCheckRevocationForUntrustedChains();
    }

    @Override
    public Date getCurrentTime() {
        return this.currentTime;
    }

    @Override
    public void setCurrentTime(Date currentTime) {
        Objects.requireNonNull(currentTime);
        this.currentTime = currentTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Token getNotYetVerifiedToken() {
        Map<Token, Boolean> map = this.tokensToProcess;
        synchronized (map) {
            for (Map.Entry<Token, Boolean> entry : this.tokensToProcess.entrySet()) {
                if (entry.getValue() != null) continue;
                entry.setValue(true);
                return entry.getKey();
            }
            return null;
        }
    }

    private List<Token> getCertChain(Token token) throws DSSException {
        LinkedList<Token> chain = new LinkedList<Token>();
        Token issuerCertificateToken = token;
        do {
            chain.add(issuerCertificateToken);
            if (this.isTrusted(issuerCertificateToken)) break;
            if ((issuerCertificateToken = this.validationCertificatePool.getIssuer(issuerCertificateToken)) == null && token instanceof CertificateToken) {
                issuerCertificateToken = this.getIssuerFromAIA((CertificateToken)token);
            }
            if (issuerCertificateToken == null && token instanceof TimestampToken) {
                issuerCertificateToken = this.getTSACertificate((TimestampToken)token);
            }
            if (!(issuerCertificateToken instanceof CertificateToken)) continue;
            this.addCertificateTokenForVerification((CertificateToken)issuerCertificateToken);
        } while (issuerCertificateToken != null && !chain.contains(issuerCertificateToken));
        return chain;
    }

    private CertificateToken getTSACertificate(TimestampToken timestamp) {
        List candidates = timestamp.getCertificates();
        for (CertificateToken candidate : candidates) {
            if (!timestamp.isSignedBy(candidate)) continue;
            return candidate;
        }
        LOG.info("TSA certificate not found in the token");
        candidates = this.validationCertificatePool.getBySignerId(timestamp.getSignerId());
        for (CertificateToken candidate : candidates) {
            if (!timestamp.isSignedBy(candidate)) continue;
            return candidate;
        }
        LOG.warn("TSA certificate not found in the certificate pool");
        return null;
    }

    private CertificateToken getIssuerFromAIA(CertificateToken token) {
        LOG.info("Retrieving {} certificate's issuer using AIA.", (Object)token.getAbbreviation());
        Collection candidates = DSSUtils.loadPotentialIssuerCertificates((CertificateToken)token, (DataLoader)this.dataLoader);
        if (Utils.isCollectionNotEmpty((Collection)candidates)) {
            CertificateToken bridgedIssuer = this.findBestBridgeCertificate(token, candidates);
            if (bridgedIssuer != null) {
                this.addCertificateTokenForVerification(this.validationCertificatePool.getInstance(bridgedIssuer, CertificateSourceType.AIA));
                return bridgedIssuer;
            }
            for (CertificateToken candidate : candidates) {
                this.addCertificateTokenForVerification(this.validationCertificatePool.getInstance(candidate, CertificateSourceType.AIA));
            }
            for (CertificateToken candidate : candidates) {
                if (!token.isSignedBy(candidate)) continue;
                if (!token.getIssuerX500Principal().equals(candidate.getSubjectX500Principal())) {
                    LOG.info("There is AIA extension, but the issuer subject name and subject name does not match.");
                    LOG.info("CERT ISSUER    : {}", (Object)token.getIssuerX500Principal());
                    LOG.info("ISSUER SUBJECT : {}", (Object)candidate.getSubjectX500Principal());
                }
                return candidate;
            }
            LOG.warn("The retrieved certificate(s) using AIA does not sign the certificate {}.", (Object)token.getAbbreviation());
        }
        return null;
    }

    private CertificateToken findBestBridgeCertificate(CertificateToken token, Collection<CertificateToken> candidates) {
        if (Utils.isCollectionEmpty(candidates) || candidates.size() == 1) {
            return null;
        }
        PublicKey commonPublicKey = null;
        CertificateToken bestMatch = null;
        block0: for (CertificateToken candidate : candidates) {
            PublicKey candidatePublicKey = candidate.getPublicKey();
            if (commonPublicKey == null) {
                if (!token.isSignedBy(candidate)) {
                    return null;
                }
                commonPublicKey = candidatePublicKey;
                bestMatch = candidate;
            } else {
                if (!candidatePublicKey.equals(commonPublicKey)) {
                    return null;
                }
                if (this.isTrusted((Token)bestMatch)) continue;
            }
            List list = this.validationCertificatePool.get(candidate.getSubjectX500Principal());
            for (CertificateToken pooledToken : list) {
                if (!pooledToken.getPublicKey().equals(commonPublicKey) || !this.isTrusted((Token)pooledToken)) continue;
                bestMatch = pooledToken;
                token.isSignedBy(pooledToken);
                continue block0;
            }
        }
        return bestMatch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean addTokenForVerification(Token token) {
        if (token == null) {
            return false;
        }
        boolean traceEnabled = LOG.isTraceEnabled();
        if (traceEnabled) {
            LOG.trace("addTokenForVerification: trying to acquire synchronized block");
        }
        Map<Token, Boolean> map = this.tokensToProcess;
        synchronized (map) {
            try {
                if (this.tokensToProcess.containsKey(token)) {
                    if (traceEnabled) {
                        LOG.trace("Token was already in the list {}:{}", (Object)token.getClass().getSimpleName(), (Object)token.getAbbreviation());
                    }
                    boolean bl2 = false;
                    return bl2;
                }
                this.tokensToProcess.put(token, null);
                if (traceEnabled) {
                    LOG.trace("+ New {} to check: {}", (Object)token.getClass().getSimpleName(), (Object)token.getAbbreviation());
                }
                boolean bl = true;
                return bl;
            }
            finally {
                if (traceEnabled) {
                    LOG.trace("addTokenForVerification: almost left synchronized block");
                }
            }
        }
    }

    @Override
    public void addRevocationTokensForVerification(List<RevocationToken> revocationTokens) {
        for (RevocationToken revocationToken : revocationTokens) {
            if (!this.addTokenForVerification((Token)revocationToken)) continue;
            boolean added = this.processedRevocations.add(revocationToken);
            if (!LOG.isTraceEnabled()) continue;
            if (added) {
                LOG.trace("RevocationToken added to processedRevocations: {} ", (Object)revocationToken);
                continue;
            }
            LOG.trace("RevocationToken already present processedRevocations: {} ", (Object)revocationToken);
        }
    }

    @Override
    public void addCertificateTokenForVerification(CertificateToken certificateToken) {
        if (this.addTokenForVerification((Token)certificateToken)) {
            boolean added = this.processedCertificates.add(certificateToken);
            if (LOG.isTraceEnabled()) {
                if (added) {
                    LOG.trace("CertificateToken added to processedCertificates: {} ", (Object)certificateToken);
                } else {
                    LOG.trace("CertificateToken already present processedCertificates: {} ", (Object)certificateToken);
                }
            }
        }
    }

    @Override
    public void addTimestampTokenForVerification(TimestampToken timestampToken) {
        if (this.addTokenForVerification(timestampToken)) {
            this.registerUsageDate(timestampToken.getCreationDate(), timestampToken.getCertificates());
            boolean added = this.processedTimestamps.add(timestampToken);
            if (LOG.isTraceEnabled()) {
                if (added) {
                    LOG.trace("TimestampToken added to processedTimestamps: {} ", this.processedTimestamps);
                } else {
                    LOG.trace("TimestampToken already present processedTimestamps: {} ", this.processedTimestamps);
                }
            }
        }
    }

    private void registerUsageDate(Date usageDate, List<CertificateToken> certificates) {
        if (Utils.isCollectionEmpty(certificates)) {
            LOG.warn("Empty certificate chain for timestamp");
            return;
        }
        CertificateReorderer certificateReorderer = new CertificateReorderer(certificates);
        Map<CertificateToken, List<CertificateToken>> orderedCertificateChains = certificateReorderer.getOrderedCertificateChains();
        for (Map.Entry<CertificateToken, List<CertificateToken>> entry : orderedCertificateChains.entrySet()) {
            List<CertificateToken> chain = entry.getValue();
            for (CertificateToken cert : chain) {
                if (cert.isSelfIssued() || this.isTrusted((Token)cert)) {
                    return;
                }
                Date lastUsage = this.lastUsageDates.get(cert);
                if (lastUsage != null && !lastUsage.before(usageDate)) continue;
                this.lastUsageDates.put(cert, usageDate);
            }
        }
    }

    @Override
    public void validate() throws DSSException {
        Token token = this.getNotYetVerifiedToken();
        while (token != null) {
            List<Token> certChain = this.getCertChain(token);
            if (token instanceof CertificateToken) {
                List<RevocationToken> revocationTokens = this.getRevocationData((CertificateToken)token, certChain);
                this.addRevocationTokensForVerification(revocationTokens);
            }
            token = this.getNotYetVerifiedToken();
        }
    }

    private List<RevocationToken> getRevocationData(CertificateToken certToken, List<Token> certChain) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Checking revocation data for : {}", (Object)certToken.getDSSIdAsString());
        }
        if (this.isRevocationDataNotRequired(certToken)) {
            return Collections.emptyList();
        }
        ArrayList<RevocationToken> revocations = new ArrayList<RevocationToken>();
        if (this.signatureCRLSource != null || this.signatureOCSPSource != null) {
            RevocationToken crlToken;
            OCSPAndCRLCertificateVerifier offlineVerifier = new OCSPAndCRLCertificateVerifier((RevocationSource<CRLToken>)this.signatureCRLSource, (RevocationSource<OCSPToken>)this.signatureOCSPSource, this.validationCertificatePool);
            RevocationToken ocspToken = offlineVerifier.checkOCSP(certToken);
            if (ocspToken != null) {
                revocations.add(ocspToken);
            }
            if ((crlToken = offlineVerifier.checkCRL(certToken)) != null) {
                revocations.add(crlToken);
            }
        }
        if (revocations.isEmpty() || this.isRevocationDataRefreshNeeded(certToken, revocations)) {
            if (this.checkRevocationForUntrustedChains || this.isTrustedChain(certChain)) {
                OCSPAndCRLCertificateVerifier onlineVerifier = null;
                onlineVerifier = this.trustedCertSource instanceof CommonTrustedCertificateSource ? this.instantiateWithTrustServices((CommonTrustedCertificateSource)this.trustedCertSource, certToken, certChain) : new OCSPAndCRLCertificateVerifier((RevocationSource<CRLToken>)this.crlSource, (RevocationSource<OCSPToken>)this.ocspSource, this.validationCertificatePool);
                RevocationToken onlineRevocationToken = onlineVerifier.check(certToken);
                if (onlineRevocationToken != null && !revocations.contains(onlineRevocationToken)) {
                    revocations.add(onlineRevocationToken);
                }
            } else {
                LOG.warn("External revocation check is skipped for untrusted certificate : {}", (Object)certChain.iterator().next().getDSSIdAsString());
            }
        }
        if (revocations.isEmpty()) {
            LOG.warn("No revocation found for certificate {}", (Object)certToken.getDSSIdAsString());
        }
        return revocations;
    }

    private boolean isTrustedChain(List<Token> certChain) {
        Token lastToken = certChain.get(certChain.size() - 1);
        return this.isTrusted(lastToken);
    }

    private OCSPAndCRLCertificateVerifier instantiateWithTrustServices(CommonTrustedCertificateSource trustedCertSource, CertificateToken certToken, List<Token> certChain) {
        CertificateToken trustAnchor = certToken;
        Token lastToken = certChain.get(certChain.size() - 1);
        if (lastToken instanceof CertificateToken) {
            trustAnchor = (CertificateToken)lastToken;
        }
        Object currentOCSPSource = null;
        List alternativeOCSPUrls = trustedCertSource.getAlternativeOCSPUrls(trustAnchor);
        currentOCSPSource = Utils.isCollectionNotEmpty((Collection)alternativeOCSPUrls) && this.ocspSource instanceof RevocationSourceAlternateUrlsSupport ? new AlternateUrlsSourceAdapter((RevocationSourceAlternateUrlsSupport)this.ocspSource, alternativeOCSPUrls) : this.ocspSource;
        Object currentCRLSource = null;
        List alternativeCRLUrls = trustedCertSource.getAlternativeCRLUrls(trustAnchor);
        currentCRLSource = Utils.isCollectionNotEmpty((Collection)alternativeCRLUrls) && this.crlSource instanceof RevocationSourceAlternateUrlsSupport ? new AlternateUrlsSourceAdapter((RevocationSourceAlternateUrlsSupport)this.crlSource, alternativeCRLUrls) : this.crlSource;
        return new OCSPAndCRLCertificateVerifier((RevocationSource<CRLToken>)currentCRLSource, (RevocationSource<OCSPToken>)currentOCSPSource, this.validationCertificatePool);
    }

    @Override
    public boolean isAllRequiredRevocationDataPresent() {
        CertificateReorderer order = new CertificateReorderer(this.processedCertificates);
        Map<CertificateToken, List<CertificateToken>> orderedCertificateChains = order.getOrderedCertificateChains();
        for (List<CertificateToken> orderedCertChain : orderedCertificateChains.values()) {
            for (CertificateToken certificateToken : orderedCertChain) {
                if (this.isRevocationDataNotRequired(certificateToken)) break;
                boolean found = false;
                for (RevocationToken revocationToken : this.processedRevocations) {
                    if (!Utils.areStringsEqual((String)certificateToken.getDSSIdAsString(), (String)revocationToken.getRelatedCertificateID())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                LOG.debug("No revocation data found for certificate : {}", (Object)certificateToken.getDSSIdAsString());
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isAllPOECoveredByRevocationData() {
        for (Map.Entry<CertificateToken, Date> entry : this.lastUsageDates.entrySet()) {
            Date lastUsage = entry.getValue();
            CertificateToken token = entry.getKey();
            if (this.isRevocationDataNotRequired(token)) continue;
            boolean foundValidRevocationDataAfterLastUsage = false;
            Date nextUpdate = null;
            for (RevocationToken revocationToken : this.processedRevocations) {
                if (!Utils.areStringsEqual((String)token.getDSSIdAsString(), (String)revocationToken.getRelatedCertificateID())) continue;
                Date productionDate = revocationToken.getProductionDate();
                if (productionDate.after(lastUsage)) {
                    foundValidRevocationDataAfterLastUsage = true;
                    break;
                }
                Date currentNextUpdate = revocationToken.getNextUpdate();
                if (nextUpdate != null && (currentNextUpdate == null || !nextUpdate.before(currentNextUpdate))) continue;
                nextUpdate = currentNextUpdate;
            }
            if (foundValidRevocationDataAfterLastUsage) continue;
            LOG.debug("POE {} not covered by a valid revocation data (nextUpdate : {})", (Object)token.getDSSIdAsString(), nextUpdate);
            return false;
        }
        return true;
    }

    @Override
    public boolean isAllTimestampValid() {
        for (TimestampToken timestampToken : this.processedTimestamps) {
            if (timestampToken.isSignatureValid() && timestampToken.isMessageImprintDataFound().booleanValue() && timestampToken.isMessageImprintDataIntact().booleanValue()) continue;
            LOG.debug("Invalid timestamp detected : {}", (Object)timestampToken.getDSSIdAsString());
            return false;
        }
        return true;
    }

    @Override
    public boolean isAllCertificateValid() {
        for (CertificateToken certificateToken : this.processedCertificates) {
            if (this.isRevocationDataNotRequired(certificateToken)) continue;
            for (RevocationToken revocationToken : this.processedRevocations) {
                if (!Utils.areStringsEqual((String)certificateToken.getDSSIdAsString(), (String)revocationToken.getRelatedCertificateID()) || Utils.isTrue((Boolean)revocationToken.getStatus())) continue;
                LOG.debug("Certificate {} is revoked", (Object)certificateToken.getDSSIdAsString());
                return false;
            }
        }
        return true;
    }

    private boolean isRevocationDataNotRequired(CertificateToken certToken) {
        return certToken.isSelfSigned() || this.isTrusted((Token)certToken) || DSSASN1Utils.hasIdPkixOcspNoCheckExtension((CertificateToken)certToken);
    }

    private boolean isRevocationDataRefreshNeeded(CertificateToken certToken, List<RevocationToken> revocations) {
        Date lastUsageDate = this.lastUsageDates.get(certToken);
        if (lastUsageDate != null) {
            boolean foundUpdatedRevocationData = false;
            for (RevocationToken revocationToken : revocations) {
                if (lastUsageDate.compareTo(revocationToken.getProductionDate()) > 0 || CRLReasonEnum.certificateHold == revocationToken.getReason()) continue;
                foundUpdatedRevocationData = true;
                break;
            }
            if (!foundUpdatedRevocationData) {
                LOG.debug("Revocation data refresh is needed");
                return true;
            }
        }
        return false;
    }

    @Override
    public Set<CertificateToken> getProcessedCertificates() {
        return Collections.unmodifiableSet(this.processedCertificates);
    }

    @Override
    public Map<CertificateToken, Set<CertificateSourceType>> getCertificateSourceTypes() {
        Set<CertificateToken> certs = this.getProcessedCertificates();
        HashMap<CertificateToken, Set<CertificateSourceType>> result = new HashMap<CertificateToken, Set<CertificateSourceType>>();
        for (CertificateToken certificateToken : certs) {
            result.put(certificateToken, this.validationCertificatePool.getSources(certificateToken));
        }
        return result;
    }

    @Override
    public Set<RevocationToken> getProcessedRevocations() {
        return Collections.unmodifiableSet(this.processedRevocations);
    }

    @Override
    public Set<TimestampToken> getProcessedTimestamps() {
        return Collections.unmodifiableSet(this.processedTimestamps);
    }

    private boolean isTrusted(Token token) {
        return token instanceof CertificateToken && this.validationCertificatePool.isTrusted((CertificateToken)token);
    }
}

