/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.DSSASN1Utils;
import eu.europa.esig.dss.DSSDocument;
import eu.europa.esig.dss.DSSUtils;
import eu.europa.esig.dss.DigestAlgorithm;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AbstractSignaturePolicyValidator;
import eu.europa.esig.dss.validation.SignaturePolicyValidator;
import eu.europa.esig.dss.x509.SignaturePolicy;

public class NonASN1SignaturePolicyValidator
extends AbstractSignaturePolicyValidator
implements SignaturePolicyValidator {
    @Override
    public boolean canValidate() {
        SignaturePolicy policy = this.getSignaturePolicy();
        if (policy.getPolicyContent() != null) {
            byte firstByte = DSSUtils.readFirstByte((DSSDocument)policy.getPolicyContent());
            return !DSSASN1Utils.isASN1SequenceTag((byte)firstByte);
        }
        return false;
    }

    @Override
    public void validate() {
        this.setIdentified(true);
        SignaturePolicy signaturePolicy = this.getSignaturePolicy();
        String digestValue = signaturePolicy.getDigestValue();
        DigestAlgorithm signPolicyHashAlgFromSignature = signaturePolicy.getDigestAlgorithm();
        String recalculatedDigestValue = Utils.toBase64((byte[])DSSUtils.digest((DigestAlgorithm)signPolicyHashAlgFromSignature, (DSSDocument)signaturePolicy.getPolicyContent()));
        if (Utils.areStringsEqual((String)digestValue, (String)recalculatedDigestValue)) {
            this.setStatus(true);
            this.setDigestAlgorithmsEqual(true);
        } else {
            this.addError("general", "The policy digest value (" + digestValue + ") does not match the re-calculated digest value (" + recalculatedDigestValue + ").");
        }
    }
}

