/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.CertificateReorderer;
import eu.europa.esig.dss.DSSASN1Utils;
import eu.europa.esig.dss.DSSDocument;
import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DSSRevocationUtils;
import eu.europa.esig.dss.DSSUtils;
import eu.europa.esig.dss.DigestAlgorithm;
import eu.europa.esig.dss.SignatureLevel;
import eu.europa.esig.dss.TokenIdentifier;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.CandidatesForSigningCertificate;
import eu.europa.esig.dss.validation.CertificateStatusVerifier;
import eu.europa.esig.dss.validation.CertificateValidity;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.OCSPAndCRLCertificateVerifier;
import eu.europa.esig.dss.validation.ReferenceValidation;
import eu.europa.esig.dss.validation.SignatureCryptographicVerification;
import eu.europa.esig.dss.validation.SignaturePolicyProvider;
import eu.europa.esig.dss.validation.SignatureScope;
import eu.europa.esig.dss.validation.SignatureScopeFinder;
import eu.europa.esig.dss.validation.SignatureValidationContext;
import eu.europa.esig.dss.validation.TimestampByGenerationTimeComparator;
import eu.europa.esig.dss.validation.TimestampReference;
import eu.europa.esig.dss.validation.TimestampToken;
import eu.europa.esig.dss.validation.TimestampedObjectType;
import eu.europa.esig.dss.validation.ValidationContext;
import eu.europa.esig.dss.x509.CertificatePool;
import eu.europa.esig.dss.x509.CertificateSourceType;
import eu.europa.esig.dss.x509.CertificateToken;
import eu.europa.esig.dss.x509.RevocationSource;
import eu.europa.esig.dss.x509.RevocationToken;
import eu.europa.esig.dss.x509.SignaturePolicy;
import eu.europa.esig.dss.x509.TimestampType;
import eu.europa.esig.dss.x509.crl.CRLToken;
import eu.europa.esig.dss.x509.crl.ListCRLSource;
import eu.europa.esig.dss.x509.crl.OfflineCRLSource;
import eu.europa.esig.dss.x509.ocsp.ListOCSPSource;
import eu.europa.esig.dss.x509.ocsp.OCSPToken;
import eu.europa.esig.dss.x509.ocsp.OfflineOCSPSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DefaultAdvancedSignature
implements AdvancedSignature {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultAdvancedSignature.class);
    protected final CertificatePool certPool;
    protected CertificateToken providedSigningCertificateToken;
    protected List<DSSDocument> detachedContents;
    protected List<ReferenceValidation> referenceValidations;
    protected SignatureCryptographicVerification signatureCryptographicVerification;
    protected String structureValidation;
    protected CandidatesForSigningCertificate candidatesForSigningCertificate;
    protected List<TimestampToken> contentTimestamps;
    protected transient List<TimestampToken> signatureTimestamps;
    protected List<TimestampToken> sigAndRefsTimestamps;
    protected List<TimestampToken> refsOnlyTimestamps;
    protected List<TimestampToken> archiveTimestamps;
    protected OfflineCRLSource offlineCRLSource;
    protected OfflineOCSPSource offlineOCSPSource;
    private AdvancedSignature masterSignature;
    protected SignaturePolicy signaturePolicy;
    protected Set<DigestAlgorithm> usedCertificatesDigestAlgorithms = new HashSet<DigestAlgorithm>();
    private List<SignatureScope> signatureScopes;
    private String signatureFilename;

    protected DefaultAdvancedSignature(CertificatePool certPool) {
        this.certPool = certPool;
    }

    @Override
    public String getSignatureFilename() {
        return this.signatureFilename;
    }

    @Override
    public void setSignatureFilename(String signatureFilename) {
        this.signatureFilename = signatureFilename;
    }

    @Override
    public List<DSSDocument> getDetachedContents() {
        return this.detachedContents;
    }

    @Override
    public void setDetachedContents(List<DSSDocument> detachedContents) {
        this.detachedContents = detachedContents;
    }

    @Override
    public SignatureLevel getDataFoundUpToLevel() {
        SignatureLevel[] signatureLevels = this.getSignatureLevels();
        SignatureLevel dataFoundUpToProfile = this.getDataFoundUpToProfile(signatureLevels);
        return dataFoundUpToProfile;
    }

    private SignatureLevel getDataFoundUpToProfile(SignatureLevel ... signatureLevels) {
        for (int ii = signatureLevels.length - 1; ii >= 0; --ii) {
            SignatureLevel signatureLevel = signatureLevels[ii];
            if (!this.isDataForSignatureLevelPresent(signatureLevel)) continue;
            return signatureLevel;
        }
        return null;
    }

    public ValidationContext getSignatureValidationContext(CertificateVerifier certificateVerifier) {
        SignatureValidationContext validationContext = new SignatureValidationContext(this.certPool);
        certificateVerifier.setSignatureCRLSource(new ListCRLSource(this.getCRLSource()));
        certificateVerifier.setSignatureOCSPSource(new ListOCSPSource(this.getOCSPSource()));
        validationContext.initialize(certificateVerifier);
        List<CertificateToken> certificates = this.getCertificates();
        for (CertificateToken certificate : certificates) {
            validationContext.addCertificateTokenForVerification(certificate);
        }
        this.prepareTimestamps(validationContext);
        validationContext.validate();
        this.validateTimestamps();
        this.checkTimestamp(certificateVerifier, validationContext);
        this.checkAllRevocationDataPresent(certificateVerifier, validationContext);
        this.checkAllTimestampCoveredByRevocationData(certificateVerifier, validationContext);
        this.checkAllCertificateNotRevoked(certificateVerifier, validationContext);
        return validationContext;
    }

    private void checkAllCertificateNotRevoked(CertificateVerifier certificateVerifier, ValidationContext validationContext) {
        if (!validationContext.isAllCertificateValid()) {
            String message = "Revoked certificate detected";
            if (certificateVerifier.isExceptionOnRevokedCertificate()) {
                throw new DSSException(message);
            }
            LOG.warn(message);
        }
    }

    private void checkAllTimestampCoveredByRevocationData(CertificateVerifier certificateVerifier, ValidationContext validationContext) {
        if (!validationContext.isAllPOECoveredByRevocationData()) {
            String message = "A POE is not covered by an usable revocation data";
            if (certificateVerifier.isExceptionOnUncoveredPOE()) {
                throw new DSSException(message);
            }
            LOG.warn(message);
        }
    }

    private void checkAllRevocationDataPresent(CertificateVerifier certificateVerifier, ValidationContext validationContext) {
        if (!validationContext.isAllRequiredRevocationDataPresent()) {
            String message = "Revocation data is missing";
            if (certificateVerifier.isExceptionOnMissingRevocationData()) {
                throw new DSSException(message);
            }
            LOG.warn(message);
        }
    }

    private void checkTimestamp(CertificateVerifier certificateVerifier, ValidationContext validationContext) {
        if (!validationContext.isAllTimestampValid()) {
            String message = "Broken timestamp detected";
            if (certificateVerifier.isExceptionOnInvalidTimestamp()) {
                throw new DSSException(message);
            }
            LOG.warn(message);
        }
    }

    @Override
    public List<CertificateToken> getCertificates() {
        return this.getCertificateSource().getCertificates();
    }

    public Set<CertificateToken> getCertificatesForInclusion(ValidationContext validationContext) {
        HashSet<CertificateToken> certificates = new HashSet<CertificateToken>();
        List<CertificateToken> certWithinSignatures = this.getCertificatesWithinSignatureAndTimestamps();
        for (CertificateToken certificateToken : validationContext.getProcessedCertificates()) {
            if (certWithinSignatures.contains(certificateToken)) continue;
            certificates.add(certificateToken);
        }
        return certificates;
    }

    public List<CertificateToken> getCertificatesWithinSignatureAndTimestamps() {
        ArrayList<CertificateToken> certs = new ArrayList<CertificateToken>();
        Map<String, List<CertificateToken>> certificatesWithinSignatureAndTimestamps = this.getCertificatesWithinSignatureAndTimestamps(false);
        for (List<CertificateToken> certificateTokens : certificatesWithinSignatureAndTimestamps.values()) {
            certs.addAll(certificateTokens);
        }
        return certs;
    }

    public Map<String, List<CertificateToken>> getCertificatesWithinSignatureAndTimestamps(boolean skipLastArchiveTimestamp) {
        HashMap<String, List<CertificateToken>> certificates = new HashMap<String, List<CertificateToken>>();
        List certificatesSig = this.getCertificateSource().getCertificates();
        if (Utils.isCollectionNotEmpty((Collection)certificatesSig)) {
            certificates.put(CertificateSourceType.SIGNATURE.name(), certificatesSig);
        }
        int timestampCounter = 0;
        for (TimestampToken timestampToken : this.getContentTimestamps()) {
            certificates.put(timestampToken.getTimeStampType().name() + timestampCounter++, timestampToken.getCertificates());
        }
        for (TimestampToken timestampToken : this.getTimestampsX1()) {
            certificates.put(timestampToken.getTimeStampType().name() + timestampCounter++, timestampToken.getCertificates());
        }
        for (TimestampToken timestampToken : this.getTimestampsX2()) {
            certificates.put(timestampToken.getTimeStampType().name() + timestampCounter++, timestampToken.getCertificates());
        }
        for (TimestampToken timestampToken : this.getSignatureTimestamps()) {
            certificates.put(timestampToken.getTimeStampType().name() + timestampCounter++, timestampToken.getCertificates());
        }
        List<TimestampToken> archiveTsps = this.getArchiveTimestamps();
        if (skipLastArchiveTimestamp) {
            archiveTsps = this.removeLastTimestamp(archiveTsps);
        }
        for (TimestampToken timestampToken : archiveTsps) {
            certificates.put(timestampToken.getTimeStampType().name() + timestampCounter++, timestampToken.getCertificates());
        }
        return certificates;
    }

    private List<TimestampToken> removeLastTimestamp(List<TimestampToken> timestamps) {
        ArrayList<TimestampToken> tsps = new ArrayList<TimestampToken>();
        Collections.copy(timestamps, tsps);
        if (Utils.collectionSize(tsps) > 1) {
            Collections.sort(tsps, new TimestampByGenerationTimeComparator());
            tsps.remove(tsps.size() - 1);
        }
        return tsps;
    }

    public RevocationDataForInclusion getRevocationDataForInclusion(ValidationContext validationContext) {
        Set<RevocationToken> revocationTokens = validationContext.getProcessedRevocations();
        ArrayList<CRLToken> crlTokens = new ArrayList<CRLToken>();
        ArrayList<OCSPToken> ocspTokens = new ArrayList<OCSPToken>();
        ArrayList<TokenIdentifier> revocationIds = new ArrayList<TokenIdentifier>();
        for (RevocationToken revocationToken : revocationTokens) {
            if (revocationIds.contains(revocationToken.getDSSId())) continue;
            revocationIds.add(revocationToken.getDSSId());
            if (revocationToken instanceof CRLToken) {
                CRLToken crlToken = (CRLToken)revocationToken;
                crlTokens.add(crlToken);
                continue;
            }
            if (revocationToken instanceof OCSPToken) {
                OCSPToken ocspToken = (OCSPToken)revocationToken;
                ocspTokens.add(ocspToken);
                continue;
            }
            throw new DSSException("Unknown type for revocationToken: " + revocationToken.getClass().getName());
        }
        return new RevocationDataForInclusion(crlTokens, ocspTokens);
    }

    @Override
    public void setMasterSignature(AdvancedSignature masterSignature) {
        this.masterSignature = masterSignature;
    }

    @Override
    public AdvancedSignature getMasterSignature() {
        return this.masterSignature;
    }

    @Override
    public SignatureCryptographicVerification getSignatureCryptographicVerification() {
        if (this.signatureCryptographicVerification == null) {
            this.checkSignatureIntegrity();
        }
        return this.signatureCryptographicVerification;
    }

    @Override
    public CertificateToken getProvidedSigningCertificateToken() {
        return this.providedSigningCertificateToken;
    }

    @Override
    public void setProvidedSigningCertificateToken(CertificateToken certificateToken) {
        this.providedSigningCertificateToken = certificateToken;
    }

    @Override
    public CertificateToken getSigningCertificateToken() {
        this.candidatesForSigningCertificate = this.getCandidatesForSigningCertificate();
        this.checkSignatureIntegrity();
        this.signatureCryptographicVerification = this.getSignatureCryptographicVerification();
        CertificateValidity theCertificateValidity = this.candidatesForSigningCertificate.getTheCertificateValidity();
        if (theCertificateValidity != null && theCertificateValidity.isValid()) {
            CertificateToken signingCertificateToken = theCertificateValidity.getCertificateToken();
            return signingCertificateToken;
        }
        CertificateValidity theBestCandidate = this.candidatesForSigningCertificate.getTheBestCandidate();
        return theBestCandidate == null ? null : theBestCandidate.getCertificateToken();
    }

    @Override
    public void prepareTimestamps(ValidationContext validationContext) {
        for (TimestampToken timestampToken : this.getContentTimestamps()) {
            validationContext.addTimestampTokenForVerification(timestampToken);
        }
        for (TimestampToken timestampToken : this.getSignatureTimestamps()) {
            validationContext.addTimestampTokenForVerification(timestampToken);
        }
        for (TimestampToken timestampToken : this.getTimestampsX1()) {
            validationContext.addTimestampTokenForVerification(timestampToken);
        }
        for (TimestampToken timestampToken : this.getTimestampsX2()) {
            validationContext.addTimestampTokenForVerification(timestampToken);
        }
        for (TimestampToken timestampToken : this.getArchiveTimestamps()) {
            validationContext.addTimestampTokenForVerification(timestampToken);
        }
    }

    @Override
    public void validateTimestamps() {
        byte[] timestampBytes;
        for (TimestampToken timestampToken : this.getContentTimestamps()) {
            timestampBytes = this.getContentTimestampData(timestampToken);
            timestampToken.matchData(timestampBytes);
        }
        for (TimestampToken timestampToken : this.getSignatureTimestamps()) {
            timestampBytes = this.getSignatureTimestampData(timestampToken, null);
            timestampToken.matchData(timestampBytes);
        }
        for (TimestampToken timestampToken : this.getTimestampsX1()) {
            timestampBytes = this.getTimestampX1Data(timestampToken, null);
            timestampToken.matchData(timestampBytes);
        }
        for (TimestampToken timestampToken : this.getTimestampsX2()) {
            timestampBytes = this.getTimestampX2Data(timestampToken, null);
            timestampToken.matchData(timestampBytes);
        }
        for (TimestampToken timestampToken : this.getArchiveTimestamps()) {
            if (timestampToken.isProcessed()) continue;
            byte[] timestampData = this.getArchiveTimestampData(timestampToken, null);
            timestampToken.matchData(timestampData);
        }
    }

    @Override
    public void validateStructure() {
    }

    @Override
    public String getStructureValidationResult() {
        return this.structureValidation;
    }

    protected void addReferencesFromOfflineOCSPSource(List<TimestampReference> references) {
        List containedOCSPResponses;
        OfflineOCSPSource ocspSource = this.getOCSPSource();
        if (ocspSource != null && Utils.isCollectionNotEmpty((Collection)(containedOCSPResponses = ocspSource.getContainedOCSPResponses()))) {
            this.usedCertificatesDigestAlgorithms.add(DigestAlgorithm.SHA1);
            for (BasicOCSPResp basicOCSPResp : containedOCSPResponses) {
                OCSPResp ocspResp = DSSRevocationUtils.fromBasicToResp((BasicOCSPResp)basicOCSPResp);
                byte[] digest = DSSUtils.digest((DigestAlgorithm)DigestAlgorithm.SHA1, (byte[])DSSRevocationUtils.getEncoded((OCSPResp)ocspResp));
                references.add(new TimestampReference(DigestAlgorithm.SHA1, Utils.toBase64((byte[])digest), TimestampedObjectType.REVOCATION));
            }
        }
    }

    protected void addReferencesFromOfflineCRLSource(List<TimestampReference> references) {
        Collection containedX509CRLs;
        OfflineCRLSource crlSource = this.getCRLSource();
        if (crlSource != null && Utils.isCollectionNotEmpty((Collection)(containedX509CRLs = crlSource.getContainedX509CRLs()))) {
            this.usedCertificatesDigestAlgorithms.add(DigestAlgorithm.SHA1);
            for (byte[] x509crl : containedX509CRLs) {
                byte[] digest = DSSUtils.digest((DigestAlgorithm)DigestAlgorithm.SHA1, (byte[])x509crl);
                references.add(new TimestampReference(DigestAlgorithm.SHA1, Utils.toBase64((byte[])digest), TimestampedObjectType.REVOCATION));
            }
        }
    }

    @Override
    public Set<DigestAlgorithm> getUsedCertificatesDigestAlgorithms() {
        return this.usedCertificatesDigestAlgorithms;
    }

    @Override
    public SignaturePolicy getPolicyId() {
        return this.signaturePolicy;
    }

    @Override
    public void checkSignaturePolicy(SignaturePolicyProvider signaturePolicyDetector) {
    }

    @Override
    public void findSignatureScope(SignatureScopeFinder signatureScopeFinder) {
        this.signatureScopes = signatureScopeFinder.findSignatureScope(this);
    }

    @Override
    public List<SignatureScope> getSignatureScopes() {
        return this.signatureScopes;
    }

    @Override
    public void addExternalTimestamp(TimestampToken timestamp) {
        if (!timestamp.isProcessed()) {
            throw new DSSException("Timestamp token must be validated first !");
        }
        if (TimestampType.ARCHIVE_TIMESTAMP != timestamp.getTimeStampType()) {
            throw new DSSException("Only archival timestamp is allowed !");
        }
        if (this.archiveTimestamps == null) {
            this.archiveTimestamps = new ArrayList<TimestampToken>();
        }
        this.archiveTimestamps.add(timestamp);
    }

    public boolean hasTProfile() {
        return Utils.isCollectionNotEmpty(this.getSignatureTimestamps());
    }

    public boolean hasLTProfile() {
        Map<String, List<CertificateToken>> certificateChains = this.getCertificatesWithinSignatureAndTimestamps(true);
        boolean emptyOCSPs = Utils.isCollectionEmpty((Collection)this.getOCSPSource().getContainedOCSPResponses());
        boolean emptyCRLs = Utils.isCollectionEmpty((Collection)this.getCRLSource().getContainedX509CRLs());
        if (certificateChains.isEmpty() && (emptyOCSPs || emptyCRLs)) {
            return false;
        }
        if (!this.isAllCertChainsHaveRevocationData(certificateChains)) {
            return false;
        }
        return !this.isAllSelfSignedCertificates(certificateChains) || !emptyOCSPs || !emptyCRLs;
    }

    private boolean isAllSelfSignedCertificates(Map<String, List<CertificateToken>> certificateChains) {
        for (Map.Entry<String, List<CertificateToken>> entryCertChain : certificateChains.entrySet()) {
            List<CertificateToken> chain = entryCertChain.getValue();
            if (Utils.collectionSize(chain) == 1) {
                CertificateToken certificateToken = chain.get(0);
                if (certificateToken.isSelfSigned()) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private boolean isAllCertChainsHaveRevocationData(Map<String, List<CertificateToken>> certificateChains) {
        OCSPAndCRLCertificateVerifier certificateStatusVerifier = new OCSPAndCRLCertificateVerifier((RevocationSource<CRLToken>)this.getCRLSource(), (RevocationSource<OCSPToken>)this.getOCSPSource(), this.certPool);
        for (Map.Entry<String, List<CertificateToken>> entryCertChain : certificateChains.entrySet()) {
            LOG.debug("Testing revocation data presence for certificates chain {}", (Object)entryCertChain.getKey());
            if (this.isAllCertsHaveRevocationData(certificateStatusVerifier, entryCertChain.getValue())) continue;
            LOG.debug("Revocation data missing in certificate chain {}", (Object)entryCertChain.getKey());
            return false;
        }
        return true;
    }

    private boolean isAllCertsHaveRevocationData(CertificateStatusVerifier certificateStatusVerifier, List<CertificateToken> certificates) {
        Map<CertificateToken, List<CertificateToken>> orderedCerts = this.order(certificates);
        for (List<CertificateToken> chain : orderedCerts.values()) {
            for (CertificateToken certificateToken : chain) {
                if (!this.isRevocationRequired(certificateToken)) break;
                RevocationToken revocationData = certificateStatusVerifier.check(certificateToken);
                if (revocationData != null) continue;
                return false;
            }
        }
        return true;
    }

    private Map<CertificateToken, List<CertificateToken>> order(List<CertificateToken> certificates) {
        CertificateReorderer reorderer = new CertificateReorderer(certificates);
        return reorderer.getOrderedCertificateChains();
    }

    private boolean isRevocationRequired(CertificateToken certificateToken) {
        if (this.certPool.isTrusted(certificateToken) || certificateToken.isSelfSigned()) {
            return false;
        }
        return !DSSASN1Utils.hasIdPkixOcspNoCheckExtension((CertificateToken)certificateToken);
    }

    public boolean hasLTAProfile() {
        return Utils.isCollectionNotEmpty(this.getArchiveTimestamps());
    }

    public static class RevocationDataForInclusion {
        public final List<CRLToken> crlTokens;
        public final List<OCSPToken> ocspTokens;

        public RevocationDataForInclusion(List<CRLToken> crlTokens, List<OCSPToken> ocspTokens) {
            this.crlTokens = crlTokens;
            this.ocspTokens = ocspTokens;
        }

        public boolean isEmpty() {
            return this.crlTokens.isEmpty() && this.ocspTokens.isEmpty();
        }
    }
}

