/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss;

import eu.europa.esig.dss.AbstractSerializableSignatureParameters;
import eu.europa.esig.dss.DSSDocument;
import eu.europa.esig.dss.DSSUtils;
import eu.europa.esig.dss.EncryptionAlgorithm;
import eu.europa.esig.dss.TokenIdentifier;
import eu.europa.esig.dss.validation.TimestampToken;
import eu.europa.esig.dss.x509.CertificateToken;
import java.security.Key;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractSignatureParameters
extends AbstractSerializableSignatureParameters {
    private String deterministicId;
    private List<DSSDocument> detachedContents;
    private CertificateToken signingCertificate;
    private byte[] signedData;
    private List<CertificateToken> certificateChain = new LinkedList<CertificateToken>();
    private List<TimestampToken> contentTimestamps;

    public List<TimestampToken> getContentTimestamps() {
        return this.contentTimestamps;
    }

    public void setContentTimestamps(List<TimestampToken> contentTimestamps) {
        this.contentTimestamps = contentTimestamps;
    }

    public String getDeterministicId() {
        if (this.deterministicId == null) {
            TokenIdentifier identifier = this.signingCertificate == null ? null : this.signingCertificate.getDSSId();
            this.deterministicId = DSSUtils.getDeterministicId((Date)this.bLevel().getSigningDate(), (TokenIdentifier)identifier);
        }
        return this.deterministicId;
    }

    public List<DSSDocument> getDetachedContents() {
        return this.detachedContents;
    }

    public void setDetachedContents(List<DSSDocument> detachedContents) {
        this.detachedContents = detachedContents;
    }

    public CertificateToken getSigningCertificate() {
        return this.signingCertificate;
    }

    public void setSigningCertificate(CertificateToken signingCertificate) {
        this.signingCertificate = signingCertificate;
        this.setEncryptionAlgorithm(EncryptionAlgorithm.forKey((Key)signingCertificate.getPublicKey()));
    }

    public byte[] getSignedData() {
        return this.signedData;
    }

    public void setSignedData(byte[] signedData) {
        this.signedData = signedData;
    }

    public List<CertificateToken> getCertificateChain() {
        return this.certificateChain;
    }

    public void clearCertificateChain() {
        this.certificateChain.clear();
    }

    public void setCertificateChain(List<CertificateToken> certificateChain) {
        this.certificateChain = certificateChain;
    }

    public void setCertificateChain(CertificateToken ... certificateChainArray) {
        for (CertificateToken certificate : certificateChainArray) {
            if (certificate == null || this.certificateChain.contains(certificate)) continue;
            this.certificateChain.add(certificate);
        }
    }

    public void reinitDeterministicId() {
        this.deterministicId = null;
    }

    public void setDeterministicId(String deterministicId) {
        this.deterministicId = deterministicId;
    }
}

