/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.diagnostic;

import eu.europa.esig.dss.diagnostic.OrphanRevocationWrapper;
import eu.europa.esig.dss.diagnostic.RelatedRevocationWrapper;
import eu.europa.esig.dss.diagnostic.RevocationRefWrappper;
import eu.europa.esig.dss.diagnostic.jaxb.XmlFoundRevocations;
import eu.europa.esig.dss.diagnostic.jaxb.XmlOrphanRevocation;
import eu.europa.esig.dss.diagnostic.jaxb.XmlRelatedRevocation;
import eu.europa.esig.dss.enumerations.RevocationOrigin;
import eu.europa.esig.dss.enumerations.RevocationRefOrigin;
import eu.europa.esig.dss.enumerations.RevocationType;
import java.util.ArrayList;
import java.util.List;

public class FoundRevocationsProxy {
    private XmlFoundRevocations foundRevocations;

    public FoundRevocationsProxy(XmlFoundRevocations foundRevocations) {
        this.foundRevocations = foundRevocations;
    }

    private XmlFoundRevocations getFoundRevocations() {
        if (this.foundRevocations == null) {
            this.foundRevocations = new XmlFoundRevocations();
        }
        return this.foundRevocations;
    }

    public List<RelatedRevocationWrapper> getRelatedRevocationData() {
        ArrayList<RelatedRevocationWrapper> revocationWrappers = new ArrayList<RelatedRevocationWrapper>();
        List<XmlRelatedRevocation> relatedRevocations = this.getFoundRevocations().getRelatedRevocations();
        for (XmlRelatedRevocation relatedRevocation : relatedRevocations) {
            revocationWrappers.add(new RelatedRevocationWrapper(relatedRevocation));
        }
        return revocationWrappers;
    }

    public List<OrphanRevocationWrapper> getOrphanRevocationData() {
        ArrayList<OrphanRevocationWrapper> orphanTokens = new ArrayList<OrphanRevocationWrapper>();
        List<XmlOrphanRevocation> orphanRevocations = this.getFoundRevocations().getOrphanRevocations();
        for (XmlOrphanRevocation orphanRevocation : orphanRevocations) {
            orphanTokens.add(new OrphanRevocationWrapper(orphanRevocation));
        }
        return orphanTokens;
    }

    public List<RelatedRevocationWrapper> getRelatedRevocationsByOrigin(RevocationOrigin originType) {
        ArrayList<RelatedRevocationWrapper> revocationWrappers = new ArrayList<RelatedRevocationWrapper>();
        List<RelatedRevocationWrapper> relatedRevocations = this.getRelatedRevocationData();
        for (RelatedRevocationWrapper relatedRevocation : relatedRevocations) {
            if (!relatedRevocation.getOrigins().contains(originType)) continue;
            revocationWrappers.add(relatedRevocation);
        }
        return revocationWrappers;
    }

    public List<OrphanRevocationWrapper> getOrphanRevocationsByOrigin(RevocationOrigin originType) {
        ArrayList<OrphanRevocationWrapper> revocationWrappers = new ArrayList<OrphanRevocationWrapper>();
        List<OrphanRevocationWrapper> orphanRevocationData = this.getOrphanRevocationData();
        for (OrphanRevocationWrapper orphanRevocation : orphanRevocationData) {
            if (!orphanRevocation.getOrigins().contains(originType)) continue;
            revocationWrappers.add(orphanRevocation);
        }
        return revocationWrappers;
    }

    public List<RelatedRevocationWrapper> getRelatedRevocationsByRefOrigin(RevocationRefOrigin refOrigin) {
        ArrayList<RelatedRevocationWrapper> revocationWrappers = new ArrayList<RelatedRevocationWrapper>();
        List<RelatedRevocationWrapper> relatedRevocations = this.getRelatedRevocationData();
        block0: for (RelatedRevocationWrapper relatedRevocation : relatedRevocations) {
            for (RevocationRefWrappper revocationRef : relatedRevocation.getReferences()) {
                if (!revocationRef.getOrigins().contains(refOrigin)) continue;
                revocationWrappers.add(relatedRevocation);
                continue block0;
            }
        }
        return revocationWrappers;
    }

    public List<OrphanRevocationWrapper> getOrphanRevocationsByRefOrigin(RevocationRefOrigin refOrigin) {
        ArrayList<OrphanRevocationWrapper> revocationWrappers = new ArrayList<OrphanRevocationWrapper>();
        List<OrphanRevocationWrapper> orphanRevocationData = this.getOrphanRevocationData();
        block0: for (OrphanRevocationWrapper orphanRevocation : orphanRevocationData) {
            for (RevocationRefWrappper refWrappper : orphanRevocation.getReferences()) {
                if (!refWrappper.getOrigins().contains(refOrigin)) continue;
                revocationWrappers.add(orphanRevocation);
                continue block0;
            }
        }
        return revocationWrappers;
    }

    public List<RelatedRevocationWrapper> getRelatedRevocationsByType(RevocationType type) {
        ArrayList<RelatedRevocationWrapper> revocationWrappers = new ArrayList<RelatedRevocationWrapper>();
        List<RelatedRevocationWrapper> relatedRevocationData = this.getRelatedRevocationData();
        for (RelatedRevocationWrapper relatedRevocation : relatedRevocationData) {
            if (!type.equals((Object)relatedRevocation.getRevocationType())) continue;
            revocationWrappers.add(relatedRevocation);
        }
        return revocationWrappers;
    }

    public List<OrphanRevocationWrapper> getOrphanRevocationsByType(RevocationType type) {
        ArrayList<OrphanRevocationWrapper> revocationWrappers = new ArrayList<OrphanRevocationWrapper>();
        List<OrphanRevocationWrapper> orphanRevocationData = this.getOrphanRevocationData();
        for (OrphanRevocationWrapper orphanRevocation : orphanRevocationData) {
            if (!type.equals((Object)orphanRevocation.getRevocationType())) continue;
            revocationWrappers.add(orphanRevocation);
        }
        return revocationWrappers;
    }

    public List<RevocationRefWrappper> getRelatedRevocationRefs() {
        ArrayList<RevocationRefWrappper> revocationRefs = new ArrayList<RevocationRefWrappper>();
        for (RelatedRevocationWrapper revocationWrapper : this.getRelatedRevocationData()) {
            revocationRefs.addAll(revocationWrapper.getReferences());
        }
        return revocationRefs;
    }

    public List<RevocationRefWrappper> getOrphanRevocationRefs() {
        ArrayList<RevocationRefWrappper> revocationRefs = new ArrayList<RevocationRefWrappper>();
        for (OrphanRevocationWrapper revocationWrapper : this.getOrphanRevocationData()) {
            revocationRefs.addAll(revocationWrapper.getReferences());
        }
        return revocationRefs;
    }

    public List<RelatedRevocationWrapper> getRelatedRevocationsByTypeAndOrigin(RevocationType type, RevocationOrigin origin) {
        ArrayList<RelatedRevocationWrapper> allRevocations = new ArrayList<RelatedRevocationWrapper>();
        for (RelatedRevocationWrapper revocationWrapper : this.getRelatedRevocationsByOrigin(origin)) {
            if (!type.equals((Object)revocationWrapper.getRevocationType())) continue;
            allRevocations.add(revocationWrapper);
        }
        return allRevocations;
    }

    public List<OrphanRevocationWrapper> getOrphanRevocationsByTypeAndOrigin(RevocationType type, RevocationOrigin origin) {
        ArrayList<OrphanRevocationWrapper> allRevocations = new ArrayList<OrphanRevocationWrapper>();
        for (OrphanRevocationWrapper revocationWrapper : this.getOrphanRevocationsByOrigin(origin)) {
            if (!type.equals((Object)revocationWrapper.getRevocationType())) continue;
            allRevocations.add(revocationWrapper);
        }
        return allRevocations;
    }
}

