/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.detailedreport;

import eu.europa.esig.dss.detailedreport.DetailedReport;
import eu.europa.esig.dss.detailedreport.jaxb.XmlBasicBuildingBlocks;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraint;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlName;
import eu.europa.esig.dss.detailedreport.jaxb.XmlSignature;
import eu.europa.esig.dss.detailedreport.jaxb.XmlSubXCV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlTLAnalysis;
import eu.europa.esig.dss.detailedreport.jaxb.XmlTimestamp;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationCertificateQualification;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationProcessTimestamp;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationSignatureQualification;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationTimestampQualification;
import eu.europa.esig.dss.detailedreport.jaxb.XmlXCV;
import eu.europa.esig.dss.enumerations.Indication;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class DetailedReportMessageCollector {
    private final DetailedReport detailedReport;

    DetailedReportMessageCollector(DetailedReport detailedReport) {
        Objects.requireNonNull(detailedReport, "DetailedReport cannot be null!");
        this.detailedReport = detailedReport;
    }

    Set<String> getErrors(String signatureId) {
        return this.collect(MessageType.ERROR, signatureId);
    }

    Set<String> getWarnings(String signatureId) {
        return this.collect(MessageType.WARN, signatureId);
    }

    Set<String> getInfos(String signatureId) {
        return this.collect(MessageType.INFO, signatureId);
    }

    private Set<String> collect(MessageType type, String signatureId) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        XmlSignature signatureById = this.detailedReport.getXmlSignatureById(signatureId);
        XmlValidationSignatureQualification validationSignatureQualification = signatureById.getValidationSignatureQualification();
        if (validationSignatureQualification != null) {
            List<XmlValidationCertificateQualification> validationCertificateQualifications = validationSignatureQualification.getValidationCertificateQualification();
            for (XmlValidationCertificateQualification validationCertificateQualification : validationCertificateQualifications) {
                this.collect(type, result, validationCertificateQualification);
            }
            this.collect(type, result, validationSignatureQualification);
        }
        if (MessageType.ERROR == type) {
            this.collect(type, result, this.detailedReport.getHighestConclusion(signatureId));
            this.collectTimestamps(type, result, signatureById);
        } else {
            this.collect(type, result, signatureById.getValidationProcessBasicSignature());
            this.collectTimestamps(type, result, signatureById);
            this.collect(type, result, signatureById.getValidationProcessLongTermData());
            this.collect(type, result, signatureById.getValidationProcessArchivalData());
        }
        return result;
    }

    private void collectTimestamps(MessageType type, Set<String> result, XmlSignature signatureById) {
        List<XmlTimestamp> timestamps = signatureById.getTimestamp();
        for (XmlTimestamp xmlTimestamp : timestamps) {
            XmlValidationTimestampQualification validationTimestampQualification = xmlTimestamp.getValidationTimestampQualification();
            if (validationTimestampQualification != null) {
                this.collect(type, result, validationTimestampQualification);
            }
            XmlValidationProcessTimestamp validationProcessTimestamps = xmlTimestamp.getValidationProcessTimestamp();
            if (MessageType.ERROR.equals((Object)type) && Indication.PASSED.equals((Object)this.detailedReport.getBasicBuildingBlockById(xmlTimestamp.getId()).getConclusion().getIndication())) continue;
            this.collect(type, result, validationProcessTimestamps);
        }
    }

    private void collect(MessageType type, Set<String> result, XmlConstraintsConclusion constraintConclusion) {
        this.collect(type, result, constraintConclusion, null);
    }

    private void collect(MessageType type, Set<String> result, XmlConstraintsConclusion constraintConclusion, String bbbId) {
        if (constraintConclusion != null && constraintConclusion.getConstraint() != null) {
            for (XmlConstraint constraint : constraintConclusion.getConstraint()) {
                String constraintId;
                XmlName message = this.getMessage(type, constraint);
                if (message != null) {
                    result.add(message.getValue());
                }
                if (MessageType.ERROR.equals((Object)type) && message == null || (constraintId = constraint.getId()) == null || constraintId.isEmpty() || constraintId.equals(bbbId)) continue;
                this.collect(type, result, this.detailedReport.getBasicBuildingBlockById(constraintId));
                this.collect(type, result, this.detailedReport.getTLAnalysisById(constraintId));
            }
            if (constraintConclusion.getConclusion() != null) {
                result.addAll(this.getMessages(type, constraintConclusion.getConclusion()));
            }
        }
    }

    private void collect(MessageType type, Set<String> result, XmlBasicBuildingBlocks bbb) {
        if (bbb != null) {
            this.collect(type, result, bbb.getFC());
            this.collect(type, result, bbb.getISC());
            this.collect(type, result, bbb.getCV());
            this.collect(type, result, bbb.getSAV());
            XmlXCV xcv = bbb.getXCV();
            if (xcv != null) {
                this.collect(type, result, xcv);
                List<XmlSubXCV> subXCV = xcv.getSubXCV();
                if (subXCV != null) {
                    for (XmlSubXCV xmlSubXCV : subXCV) {
                        this.collect(type, result, xmlSubXCV, bbb.getId());
                        this.collect(type, result, xmlSubXCV.getRFC());
                    }
                }
            }
            this.collect(type, result, bbb.getVCI());
        }
    }

    private void collect(MessageType type, Set<String> result, XmlTLAnalysis xmlTLAnalysis) {
        if (xmlTLAnalysis != null) {
            this.collect(type, result, (XmlConstraintsConclusion)xmlTLAnalysis);
        }
    }

    private XmlName getMessage(MessageType type, XmlConstraint constraint) {
        XmlName message = null;
        switch (type) {
            case ERROR: {
                message = constraint.getError();
                break;
            }
            case WARN: {
                message = constraint.getWarning();
                break;
            }
            case INFO: {
                message = constraint.getInfo();
                break;
            }
        }
        return message;
    }

    private Set<String> getMessages(MessageType type, XmlConclusion conclusion) {
        switch (type) {
            case ERROR: {
                return this.getMessages(conclusion.getErrors());
            }
            case WARN: {
                return this.getMessages(conclusion.getWarnings());
            }
            case INFO: {
                return this.getMessages(conclusion.getInfos());
            }
        }
        return Collections.emptySet();
    }

    private Set<String> getMessages(List<XmlName> xmlNames) {
        HashSet<String> messages = new HashSet<String>();
        if (xmlNames != null) {
            for (XmlName xmlName : xmlNames) {
                messages.add(xmlName.getValue());
            }
        }
        return messages;
    }

    private static enum MessageType {
        INFO,
        WARN,
        ERROR;

    }
}

