/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.detailedreport;

import eu.europa.esig.dss.detailedreport.DetailedReport;
import eu.europa.esig.dss.detailedreport.jaxb.XmlBasicBuildingBlocks;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlMessage;
import eu.europa.esig.dss.detailedreport.jaxb.XmlPSV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlSignature;
import eu.europa.esig.dss.detailedreport.jaxb.XmlTLAnalysis;
import eu.europa.esig.dss.detailedreport.jaxb.XmlTimestamp;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationProcessTimestamp;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.MessageType;
import eu.europa.esig.dss.jaxb.object.Message;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class DetailedReportMessageCollector {
    private final DetailedReport detailedReport;

    DetailedReportMessageCollector(DetailedReport detailedReport) {
        Objects.requireNonNull(detailedReport, "DetailedReport cannot be null!");
        this.detailedReport = detailedReport;
    }

    List<Message> getAdESValidationErrors(String tokenId) {
        return this.collectAdESValidationMessages(MessageType.ERROR, tokenId);
    }

    List<Message> getAdESValidationWarnings(String tokenId) {
        return this.collectAdESValidationMessages(MessageType.WARN, tokenId);
    }

    List<Message> getAdESValidationInfos(String tokenId) {
        return this.collectAdESValidationMessages(MessageType.INFO, tokenId);
    }

    List<Message> getQualificationErrors(String tokenId) {
        return this.collectQualificationMessages(MessageType.ERROR, tokenId);
    }

    List<Message> getQualificationWarnings(String tokenId) {
        return this.collectQualificationMessages(MessageType.WARN, tokenId);
    }

    List<Message> getQualificationInfos(String tokenId) {
        return this.collectQualificationMessages(MessageType.INFO, tokenId);
    }

    private List<Message> collectAdESValidationMessages(MessageType type, String tokenId) {
        XmlSignature signatureById = this.detailedReport.getXmlSignatureById(tokenId);
        if (signatureById != null) {
            return this.collectSignatureValidation(type, signatureById);
        }
        XmlTimestamp timestampById = this.detailedReport.getXmlTimestampById(tokenId);
        if (timestampById != null) {
            return this.collectTimestampValidation(type, timestampById);
        }
        XmlTLAnalysis tlAnalysisById = this.detailedReport.getTLAnalysisById(tokenId);
        if (tlAnalysisById != null) {
            return this.getMessages(type, tlAnalysisById.getConclusion());
        }
        XmlBasicBuildingBlocks bbbById = this.detailedReport.getBasicBuildingBlockById(tokenId);
        if (bbbById != null) {
            return this.getMessages(type, bbbById.getConclusion());
        }
        return Collections.emptyList();
    }

    private List<Message> collectQualificationMessages(MessageType type, String tokenId) {
        XmlSignature signatureById = this.detailedReport.getXmlSignatureById(tokenId);
        if (signatureById != null) {
            return this.collectSignatureQualification(type, signatureById);
        }
        XmlTimestamp timestampById = this.detailedReport.getXmlTimestampById(tokenId);
        if (timestampById != null) {
            return this.collectTimestampQualification(type, timestampById);
        }
        return Collections.emptyList();
    }

    private List<Message> collectSignatureValidation(MessageType type, XmlSignature xmlSignature) {
        ArrayList<Message> result = new ArrayList<Message>();
        XmlConstraintsConclusion highestConclusion = this.detailedReport.getHighestConclusion(xmlSignature.getId());
        if (MessageType.ERROR != type || !Indication.PASSED.equals((Object)highestConclusion.getConclusion().getIndication())) {
            this.addMessages(result, this.getMessages(type, xmlSignature.getValidationProcessBasicSignature()));
            this.addMessages(result, this.getMessages(type, xmlSignature.getValidationProcessLongTermData()));
        }
        this.addMessages(result, this.getMessages(type, highestConclusion));
        return result;
    }

    private List<Message> collectTimestampValidation(MessageType type, XmlTimestamp xmlTimestamp) {
        XmlValidationProcessTimestamp validationProcessTimestamps = xmlTimestamp.getValidationProcessTimestamp();
        XmlConclusion conclusion = new XmlConclusion();
        conclusion.getWarnings().addAll(validationProcessTimestamps.getConclusion().getWarnings());
        conclusion.getInfos().addAll(validationProcessTimestamps.getConclusion().getInfos());
        XmlBasicBuildingBlocks tstBBB = this.detailedReport.getBasicBuildingBlockById(xmlTimestamp.getId());
        XmlPSV psv = tstBBB.getPSV();
        if (psv == null || psv.getConclusion() == null || !Indication.PASSED.equals((Object)psv.getConclusion().getIndication())) {
            conclusion.getErrors().addAll(validationProcessTimestamps.getConclusion().getErrors());
        }
        return this.getMessages(type, conclusion);
    }

    private List<Message> collectSignatureQualification(MessageType type, XmlSignature xmlSignature) {
        ArrayList<Message> result = new ArrayList<Message>();
        this.addMessages(result, this.getMessages(type, xmlSignature.getValidationSignatureQualification()));
        return result;
    }

    private List<Message> collectTimestampQualification(MessageType type, XmlTimestamp xmlTimestamp) {
        return this.getMessages(type, xmlTimestamp.getValidationTimestampQualification());
    }

    private List<Message> getMessages(MessageType type, XmlConstraintsConclusion constraintsConclusion) {
        if (constraintsConclusion != null) {
            return this.getMessages(type, constraintsConclusion.getConclusion());
        }
        return Collections.emptyList();
    }

    private List<Message> getMessages(MessageType type, XmlConclusion conclusion) {
        if (conclusion != null) {
            switch (type) {
                case ERROR: {
                    return this.convert(conclusion.getErrors());
                }
                case WARN: {
                    return this.convert(conclusion.getWarnings());
                }
                case INFO: {
                    return this.convert(conclusion.getInfos());
                }
            }
        }
        return Collections.emptyList();
    }

    private Message convert(XmlMessage m) {
        if (m != null) {
            return new Message(m.getKey(), m.getValue());
        }
        return null;
    }

    private List<Message> convert(Collection<XmlMessage> messages) {
        if (messages != null) {
            return messages.stream().map(this::convert).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private void addMessage(List<Message> result, Message toAdd) {
        if (toAdd != null && !result.contains(toAdd)) {
            result.add(toAdd);
        }
    }

    private void addMessages(List<Message> result, Collection<Message> toAdd) {
        if (toAdd != null) {
            for (Message m : toAdd) {
                this.addMessage(result, m);
            }
        }
    }
}

