/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import java.util.HashMap;
import java.util.Map;

public enum SignatureQualification {
    QESIG("QESig", "Qualified Electronic Signature"),
    QESEAL("QESeal", "Qualified Electronic Seal"),
    QES("QES?", "Qualified Electronic Signature or Seal"),
    ADESIG_QC("AdESig-QC", "Advanced Electronic Signature supported by a Qualified Certificate"),
    ADESEAL_QC("AdESeal-QC", "Advanced Electronic Seal supported by a Qualified Certificate"),
    ADES_QC("AdES?-QC", "Advanced Electronic Signature or Seal supported by a Qualified Certificate"),
    ADESIG("AdESig", "Advanced Electronic Signature"),
    ADESEAL("AdESeal", "Advanced Electronic Seal"),
    ADES("AdES?", "Advanced Electronic Signature or Seal"),
    INDETERMINATE_QESIG("Indeterminate QESig", "Indeterminate Qualified Electronic Signature"),
    INDETERMINATE_QESEAL("Indeterminate QESeal", "Indeterminate Qualified Electronic Seal"),
    INDETERMINATE_QES("Indeterminate QES?", "Indeterminate Qualified Electronic Signature or Seal"),
    INDETERMINATE_ADESIG_QC("Indeterminate AdESig-QC", "Indeterminate Advanced Electronic Signature supported by a Qualified Certificate"),
    INDETERMINATE_ADESEAL_QC("Indeterminate AdESeal-QC", "Indeterminate Advanced Electronic Seal supported by a Qualified Certificate"),
    INDETERMINATE_ADES_QC("Indeterminate AdES?-QC", "Indeterminate Advanced Electronic Signature or Seal supported by a Qualified Certificate"),
    INDETERMINATE_ADESIG("Indeterminate AdESig", "Indeterminate Advanced Electronic Signature"),
    INDETERMINATE_ADESEAL("Indeterminate AdESeal", "Indeterminate Advanced Electronic Seal"),
    INDETERMINATE_ADES("Indeterminate AdES?", "Indeterminate Advanced Electronic Signature or Seal"),
    NOT_ADES_QC_QSCD("Not AdES but QC with QSCD", "Not Advanced Electronic Signature but supported by a Qualified Certificate"),
    NOT_ADES_QC("Not AdES but QC", "Not Advanced Electronic Signature but supported by a Qualified Certificate"),
    NOT_ADES("Not AdES", "Not Advanced Electronic Signature"),
    NA("N/A", "Not applicable");

    private final String readable;
    private final String label;

    private SignatureQualification(String readable, String label) {
        this.readable = readable;
        this.label = label;
    }

    public String getReadable() {
        return this.readable;
    }

    public String getLabel() {
        return this.label;
    }

    public static SignatureQualification forName(String value) {
        if (value != null && !value.isEmpty()) {
            return SignatureQualification.valueOf(value);
        }
        return null;
    }

    public static SignatureQualification fromReadable(String readable) {
        if (readable != null && !readable.isEmpty()) {
            return (SignatureQualification)((Object)Registry.QUALIFS_BY_READABLE.get(readable));
        }
        return null;
    }

    private static class Registry {
        private static final Map<String, SignatureQualification> QUALIFS_BY_READABLE = Registry.registerByReadable();

        private Registry() {
        }

        private static Map<String, SignatureQualification> registerByReadable() {
            HashMap<String, SignatureQualification> map = new HashMap<String, SignatureQualification>();
            for (SignatureQualification qualification : SignatureQualification.values()) {
                map.put(qualification.readable, qualification);
            }
            return map;
        }
    }
}

