/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.validation;

import eu.europa.esig.dss.cades.validation.CAdESDiagnosticDataBuilder;
import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.exception.IllegalInputException;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.SignedDocumentValidator;
import eu.europa.esig.dss.validation.evidencerecord.EvidenceRecordValidatorFactory;
import eu.europa.esig.dss.validation.scope.SignatureScopeFinder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMSDocumentValidator
extends SignedDocumentValidator {
    private static final Logger LOG = LoggerFactory.getLogger(CMSDocumentValidator.class);
    protected CMSSignedData cmsSignedData;

    CMSDocumentValidator() {
    }

    @Deprecated
    CMSDocumentValidator(SignatureScopeFinder<CAdESSignature> signatureScopeFinder) {
    }

    public CMSDocumentValidator(CMSSignedData cmsSignedData) {
        this.cmsSignedData = cmsSignedData;
    }

    public CMSDocumentValidator(DSSDocument document) {
        Objects.requireNonNull(document, "Document to be validated cannot be null!");
        this.document = document;
        this.cmsSignedData = this.toCMSSignedData(document);
    }

    private CMSSignedData toCMSSignedData(DSSDocument document) {
        try {
            return DSSUtils.toCMSSignedData((DSSDocument)document);
        }
        catch (Exception e) {
            throw new IllegalInputException(String.format("A CMS file is expected : %s", e.getMessage()), (Throwable)e);
        }
    }

    @Deprecated
    protected CMSDocumentValidator(DSSDocument document, SignatureScopeFinder<CAdESSignature> signatureScopeFinder) {
        this(document);
    }

    public boolean isSupported(DSSDocument dssDocument) {
        byte firstByte = DSSUtils.readFirstByte((DSSDocument)dssDocument);
        if (DSSASN1Utils.isASN1SequenceTag((byte)firstByte)) {
            return !DSSUtils.isTimestampToken((DSSDocument)dssDocument) && !EvidenceRecordValidatorFactory.isSupportedDocument((DSSDocument)dssDocument);
        }
        return false;
    }

    protected List<AdvancedSignature> buildSignatures() {
        ArrayList<AdvancedSignature> signatures = new ArrayList<AdvancedSignature>();
        if (this.cmsSignedData != null) {
            for (SignerInformation signerInformation : this.cmsSignedData.getSignerInfos().getSigners()) {
                CAdESSignature cadesSignature = new CAdESSignature(this.cmsSignedData, signerInformation);
                if (this.document != null) {
                    cadesSignature.setSignatureFilename(this.document.getName());
                }
                cadesSignature.setDetachedContents(this.detachedContents);
                cadesSignature.setContainerContents(this.containerContents);
                cadesSignature.setManifestFile(this.manifestFile);
                cadesSignature.setSigningCertificateSource(this.signingCertificateSource);
                cadesSignature.prepareOfflineCertificateVerifier(this.certificateVerifier);
                signatures.add((AdvancedSignature)cadesSignature);
            }
        }
        return signatures;
    }

    public CMSSignedData getCmsSignedData() {
        return this.cmsSignedData;
    }

    protected CAdESDiagnosticDataBuilder initializeDiagnosticDataBuilder() {
        return new CAdESDiagnosticDataBuilder();
    }

    public List<DSSDocument> getOriginalDocuments(AdvancedSignature advancedSignature) {
        CAdESSignature cadesSignature = (CAdESSignature)advancedSignature;
        try {
            return Arrays.asList(cadesSignature.getOriginalDocument());
        }
        catch (DSSException e) {
            LOG.error("Cannot retrieve a list of original documents");
            return Collections.emptyList();
        }
    }
}

