/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.signature;

import eu.europa.esig.dss.cades.CMSUtils;
import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.SignaturePolicyStore;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.OID;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.SignaturePolicy;
import eu.europa.esig.dss.validation.policy.SignaturePolicyValidator;
import eu.europa.esig.dss.validation.policy.SignaturePolicyValidatorLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CAdESSignaturePolicyStoreBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(CAdESSignaturePolicyStoreBuilder.class);

    public CMSSignedData addSignaturePolicyStore(CMSSignedData cmsSignedData, SignaturePolicyStore signaturePolicyStore) {
        Objects.requireNonNull(cmsSignedData, "CMSSignedData must be provided");
        Objects.requireNonNull(signaturePolicyStore, "SignaturePolicyStore must be provided");
        Objects.requireNonNull(signaturePolicyStore.getSpDocSpecification(), "SpDocSpecification must be provided");
        Objects.requireNonNull(signaturePolicyStore.getSpDocSpecification().getId(), "ID (OID or URI) for SpDocSpecification must be provided");
        Objects.requireNonNull(signaturePolicyStore.getSignaturePolicyContent(), "Signature policy content must be provided");
        Collection signerInformationCollection = cmsSignedData.getSignerInfos().getSigners();
        if (Utils.isCollectionEmpty((Collection)signerInformationCollection)) {
            throw new DSSException("Unable to extend the document! No signatures found.");
        }
        ArrayList<SignerInformation> newSignerInformationList = new ArrayList<SignerInformation>();
        for (SignerInformation signerInformation : signerInformationCollection) {
            this.assertSignaturePolicyStoreExtensionPossible(signerInformation);
            SignerInformation newSignerInformation = signerInformation;
            CAdESSignature cadesSignature = new CAdESSignature(cmsSignedData, signerInformation);
            SignaturePolicy signaturePolicy = cadesSignature.getSignaturePolicy();
            if (signaturePolicy != null) {
                Digest expectedDigest = signaturePolicy.getDigest();
                if (expectedDigest != null) {
                    signaturePolicy.setPolicyContent(signaturePolicyStore.getSignaturePolicyContent());
                    SignaturePolicyValidator validator = new SignaturePolicyValidatorLoader(signaturePolicy).loadValidator();
                    Digest computedDigest = validator.getComputedDigest(expectedDigest.getAlgorithm());
                    if (expectedDigest.equals((Object)computedDigest)) {
                        newSignerInformation = this.addSignaturePolicyStore(signerInformation, signaturePolicyStore);
                    } else {
                        LOG.warn("Signature policy's digest doesn't match the document {} for signature {}", (Object)expectedDigest, (Object)cadesSignature.getId());
                    }
                } else {
                    LOG.warn("SignaturePolicyIdentifier Digest is not found for a signature with id {}", (Object)cadesSignature.getId());
                }
            } else {
                LOG.warn("SignaturePolicyIdentifier is not defined for a signature with id {}", (Object)cadesSignature.getId());
            }
            newSignerInformationList.add(newSignerInformation);
        }
        SignerInformationStore newSignerStore = new SignerInformationStore(newSignerInformationList);
        return CMSSignedData.replaceSigners((CMSSignedData)cmsSignedData, (SignerInformationStore)newSignerStore);
    }

    private SignerInformation addSignaturePolicyStore(SignerInformation signerInformation, SignaturePolicyStore signaturePolicyStore) {
        AttributeTable unsignedAttributes = CMSUtils.getUnsignedAttributes(signerInformation);
        ASN1Sequence sigPolicyStore = this.getSignaturePolicyStore(signaturePolicyStore);
        AttributeTable unsignedAttributesWithPolicyStore = unsignedAttributes.add(OID.id_aa_ets_sigPolicyStore, (ASN1Encodable)sigPolicyStore);
        return SignerInformation.replaceUnsignedAttributes((SignerInformation)signerInformation, (AttributeTable)unsignedAttributesWithPolicyStore);
    }

    private ASN1Sequence getSignaturePolicyStore(SignaturePolicyStore signaturePolicyStore) {
        ASN1EncodableVector sigPolicyStore = new ASN1EncodableVector();
        sigPolicyStore.add((ASN1Encodable)this.getSPDocSpecificationId(signaturePolicyStore.getSpDocSpecification().getId()));
        sigPolicyStore.add((ASN1Encodable)new DEROctetString(DSSUtils.toByteArray((DSSDocument)signaturePolicyStore.getSignaturePolicyContent())));
        return new DERSequence(sigPolicyStore);
    }

    private ASN1Primitive getSPDocSpecificationId(String oidOrUri) {
        Object spDocSpecification = null;
        spDocSpecification = DSSUtils.isOidCode((String)oidOrUri) ? new ASN1ObjectIdentifier(oidOrUri) : new DERIA5String(oidOrUri);
        return spDocSpecification;
    }

    private void assertSignaturePolicyStoreExtensionPossible(SignerInformation signerInformation) {
        if (CMSUtils.containsATSTv2(signerInformation)) {
            throw new DSSException("Cannot add signature policy store to a CAdES containing an archiveTimestampV2");
        }
    }
}

