/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.signature;

import eu.europa.esig.dss.cades.CAdESSignatureParameters;
import eu.europa.esig.dss.cades.signature.CAdESLevelBaselineT;
import eu.europa.esig.dss.cades.signature.CMSSignedDataBuilder;
import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.spi.x509.tsp.TSPSource;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.ValidationContext;
import eu.europa.esig.dss.validation.ValidationDataForInclusion;
import eu.europa.esig.dss.validation.ValidationDataForInclusionBuilder;
import java.util.Collection;
import java.util.List;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;

public class CAdESLevelBaselineLT
extends CAdESLevelBaselineT {
    private final CertificateVerifier certificateVerifier;

    public CAdESLevelBaselineLT(TSPSource tspSource, CertificateVerifier certificateVerifier) {
        super(tspSource);
        this.certificateVerifier = certificateVerifier;
    }

    @Override
    protected SignerInformation extendSignerInformation(CMSSignedData cmsSignedData, SignerInformation signerInformation, CAdESSignatureParameters parameters) {
        CAdESSignature cadesSignature = this.newCAdESSignature(cmsSignedData, signerInformation, parameters.getDetachedContents());
        if (Utils.isCollectionEmpty((Collection)cadesSignature.getSignatureTimestamps())) {
            signerInformation = super.extendSignerInformation(cmsSignedData, signerInformation, parameters);
            cadesSignature = this.newCAdESSignature(cmsSignedData, signerInformation, parameters.getDetachedContents());
        }
        this.assertExtendSignatureLevelLTPossible(cadesSignature);
        return signerInformation;
    }

    @Override
    protected CMSSignedData extendCMSSignedData(CMSSignedData cmsSignedData, SignerInformation signerInformation, CAdESSignatureParameters parameters) {
        CAdESSignature cadesSignature = this.newCAdESSignature(cmsSignedData, signerInformation, parameters.getDetachedContents());
        ValidationDataForInclusionBuilder validationDataForInclusionBuilder = this.getValidationDataForInclusionBuilder(cadesSignature);
        ValidationDataForInclusion validationDataForInclusion = validationDataForInclusionBuilder.build();
        return this.extendWithValidationData(cmsSignedData, validationDataForInclusion, parameters.getDetachedContents());
    }

    protected ValidationDataForInclusionBuilder getValidationDataForInclusionBuilder(CAdESSignature cadesSignature) {
        ValidationContext validationContext = cadesSignature.getSignatureValidationContext(this.certificateVerifier);
        return new ValidationDataForInclusionBuilder(validationContext, cadesSignature.getCompleteCertificateSource());
    }

    protected CMSSignedData extendWithValidationData(CMSSignedData cmsSignedData, ValidationDataForInclusion validationDataForInclusion, List<DSSDocument> detachedContents) {
        CMSSignedDataBuilder cmsSignedDataBuilder = new CMSSignedDataBuilder(this.certificateVerifier);
        cmsSignedData = cmsSignedDataBuilder.extendCMSSignedData(cmsSignedData, validationDataForInclusion, detachedContents);
        return cmsSignedData;
    }

    private void assertExtendSignatureLevelLTPossible(CAdESSignature cadesSignature) {
        if (cadesSignature.areAllSelfSignedCertificates()) {
            throw new DSSException("Cannot extend the signature. The signature contains only self-signed certificate chains!");
        }
    }
}

