/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.signature;

import eu.europa.esig.dss.AbstractSignatureParameters;
import eu.europa.esig.dss.cades.CMSUtils;
import eu.europa.esig.dss.cades.signature.CAdESCounterSignatureParameters;
import eu.europa.esig.dss.cades.signature.CMSSignedDataBuilder;
import eu.europa.esig.dss.cades.signature.CMSSignedDocument;
import eu.europa.esig.dss.cades.signature.CustomContentSigner;
import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.cades.validation.CMSDocumentValidator;
import eu.europa.esig.dss.enumerations.SignatureAlgorithm;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.model.SignatureValue;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.signature.BaselineBCertificateSelector;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.ManifestFile;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.OtherRevocationInfoFormat;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.SignerInfoGeneratorBuilder;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.util.CollectionStore;
import org.bouncycastle.util.Store;

public class CAdESCounterSignatureBuilder {
    private final CertificateVerifier certificateVerifier;
    private ManifestFile manifestFile;

    public CAdESCounterSignatureBuilder(CertificateVerifier certificateVerifier) {
        this.certificateVerifier = certificateVerifier;
    }

    public void setManifestFile(ManifestFile manifestFile) {
        this.manifestFile = manifestFile;
    }

    public CMSSignedDocument addCounterSignature(CMSSignedData originalCMSSignedData, CAdESCounterSignatureParameters parameters, SignatureValue signatureValue) {
        List<SignerInformation> updatedSignerInfo = this.getUpdatedSignerInformations(originalCMSSignedData, originalCMSSignedData.getSignerInfos(), parameters, signatureValue, null);
        if (Utils.isCollectionNotEmpty(updatedSignerInfo)) {
            CMSSignedData updatedCMSSignedData = CMSSignedData.replaceSigners((CMSSignedData)originalCMSSignedData, (SignerInformationStore)new SignerInformationStore(updatedSignerInfo));
            updatedCMSSignedData = this.addNewCertificates(updatedCMSSignedData, originalCMSSignedData, parameters);
            return new CMSSignedDocument(updatedCMSSignedData);
        }
        throw new DSSException("No updated signed info");
    }

    private List<SignerInformation> getUpdatedSignerInformations(CMSSignedData originalCMSSignedData, SignerInformationStore signerInformationStore, CAdESCounterSignatureParameters parameters, SignatureValue signatureValue, CAdESSignature masterSignature) {
        LinkedList<SignerInformation> result = new LinkedList<SignerInformation>();
        for (SignerInformation signerInformation : signerInformationStore) {
            CAdESSignature cades = new CAdESSignature(originalCMSSignedData, signerInformation);
            cades.setMasterSignature((AdvancedSignature)masterSignature);
            cades.setDetachedContents(parameters.getDetachedContents());
            cades.setManifestFile(this.manifestFile);
            if (Utils.areStringsEqual((String)cades.getId(), (String)parameters.getSignatureIdToCounterSign())) {
                if (masterSignature != null) {
                    throw new UnsupportedOperationException("Cannot recursively add a counter-signature");
                }
                this.assertCounterSignaturePossible(signerInformation);
                SignerInformationStore counterSignatureSignerInfoStore = this.generateCounterSignature(signerInformation, parameters, signatureValue);
                result.add(SignerInformation.addCounterSigners((SignerInformation)signerInformation, (SignerInformationStore)counterSignatureSignerInfoStore));
                continue;
            }
            if (signerInformation.getCounterSignatures().size() > 0) {
                List<SignerInformation> updatedSignerInformations = this.getUpdatedSignerInformations(originalCMSSignedData, signerInformation.getCounterSignatures(), parameters, signatureValue, cades);
                result.add(SignerInformation.addCounterSigners((SignerInformation)signerInformation, (SignerInformationStore)new SignerInformationStore(updatedSignerInformations)));
                continue;
            }
            result.add(signerInformation);
        }
        return result;
    }

    private CMSSignedData addNewCertificates(CMSSignedData updatedCMSSignedData, CMSSignedData originalCMSSignedData, CAdESCounterSignatureParameters parameters) {
        LinkedList<Object> certificateTokens = new LinkedList<Object>();
        Store certificatesStore = originalCMSSignedData.getCertificates();
        Collection certificatesMatches = certificatesStore.getMatches(null);
        for (X509CertificateHolder certificatesMatch : certificatesMatches) {
            CertificateToken token = DSSASN1Utils.getCertificate((X509CertificateHolder)certificatesMatch);
            if (certificateTokens.contains(token)) continue;
            certificateTokens.add(token);
        }
        BaselineBCertificateSelector certificateSelectors = new BaselineBCertificateSelector(this.certificateVerifier, (AbstractSignatureParameters)parameters);
        List newCertificates = certificateSelectors.getCertificates();
        for (Object certificateToken : newCertificates) {
            if (certificateTokens.contains(certificateToken)) continue;
            certificateTokens.add(certificateToken);
        }
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        for (CertificateToken certificateToken : certificateTokens) {
            certs.add(certificateToken.getCertificate());
        }
        Store crlsStore = originalCMSSignedData.getCRLs();
        HashSet<OtherRevocationInfoFormat> hashSet = new HashSet<OtherRevocationInfoFormat>(crlsStore.getMatches(null));
        Store ocspBasicStore = originalCMSSignedData.getOtherRevocationInfo(OCSPObjectIdentifiers.id_pkix_ocsp_basic);
        for (Object ocsp : ocspBasicStore.getMatches(null)) {
            hashSet.add(new OtherRevocationInfoFormat(OCSPObjectIdentifiers.id_pkix_ocsp_basic, (ASN1Encodable)ocsp));
        }
        Store ocspResponseStore = originalCMSSignedData.getOtherRevocationInfo(CMSObjectIdentifiers.id_ri_ocsp_response);
        for (Object ocsp : ocspResponseStore.getMatches(null)) {
            hashSet.add(new OtherRevocationInfoFormat(CMSObjectIdentifiers.id_ri_ocsp_response, (ASN1Encodable)ocsp));
        }
        try {
            JcaCertStore jcaCertStore = new JcaCertStore(certs);
            return CMSSignedData.replaceCertificatesAndCRLs((CMSSignedData)updatedCMSSignedData, (Store)jcaCertStore, (Store)originalCMSSignedData.getAttributeCertificates(), (Store)new CollectionStore(hashSet));
        }
        catch (Exception e) {
            throw new DSSException("Unable to create the JcaCertStore", (Throwable)e);
        }
    }

    private SignerInformationStore generateCounterSignature(SignerInformation signerInformation, CAdESCounterSignatureParameters parameters, SignatureValue signatureValue) {
        CMSSignedDataBuilder builder = new CMSSignedDataBuilder(this.certificateVerifier);
        SignatureAlgorithm signatureAlgorithm = parameters.getSignatureAlgorithm();
        CustomContentSigner customContentSigner = new CustomContentSigner(signatureAlgorithm.getJCEId(), signatureValue.getValue());
        DigestCalculatorProvider dcp = CMSUtils.getDigestCalculatorProvider((DSSDocument)new InMemoryDocument(signerInformation.getSignature()), parameters.getReferenceDigestAlgorithm());
        SignerInfoGeneratorBuilder signerInformationGeneratorBuilder = builder.getSignerInfoGeneratorBuilder(dcp, parameters, false);
        CMSSignedDataGenerator cmsSignedDataGenerator = builder.createCMSSignedDataGenerator(parameters, customContentSigner, signerInformationGeneratorBuilder, null);
        return CMSUtils.generateCounterSigners(cmsSignedDataGenerator, signerInformation);
    }

    public SignerInformation getSignerInformationToBeCounterSigned(DSSDocument signatureDocument, CAdESCounterSignatureParameters parameters) {
        CAdESSignature cadesSignature = this.getSignatureById(signatureDocument, parameters);
        if (cadesSignature == null) {
            throw new DSSException(String.format("CAdESSignature not found with the given dss id '%s'", parameters.getSignatureIdToCounterSign()));
        }
        return cadesSignature.getSignerInformation();
    }

    private CAdESSignature getSignatureById(DSSDocument signatureDocument, CAdESCounterSignatureParameters parameters) {
        CMSDocumentValidator validator = new CMSDocumentValidator(signatureDocument);
        validator.setDetachedContents(parameters.getDetachedContents());
        validator.setManifestFile(this.manifestFile);
        List<AdvancedSignature> signatures = validator.getSignatures();
        return this.findSignatureRecursive(signatures, parameters.getSignatureIdToCounterSign());
    }

    private CAdESSignature findSignatureRecursive(List<AdvancedSignature> signatures, String signatureId) {
        if (Utils.isCollectionNotEmpty(signatures)) {
            for (AdvancedSignature advancedSignature : signatures) {
                if (signatureId.equals(advancedSignature.getId())) {
                    CAdESSignature cades = (CAdESSignature)advancedSignature;
                    this.assertCounterSignaturePossible(cades.getSignerInformation());
                    return cades;
                }
                CAdESSignature counterSignatureById = this.findSignatureRecursive(advancedSignature.getCounterSignatures(), signatureId);
                if (counterSignatureById == null) continue;
                throw new UnsupportedOperationException("Nested counter signatures are not supported with CAdES!");
            }
        }
        return null;
    }

    private void assertCounterSignaturePossible(SignerInformation signerInformation) {
        if (CMSUtils.containsATSTv2(signerInformation)) {
            throw new DSSException("Cannot add a counter signature to a CAdES containing an archiveTimestampV2");
        }
    }
}

