/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.signature;

import eu.europa.esig.dss.cades.CAdESSignatureParameters;
import eu.europa.esig.dss.cades.CMSUtils;
import eu.europa.esig.dss.cades.TimeStampTokenProductionComparator;
import eu.europa.esig.dss.cades.signature.CAdESLevelBaselineLT;
import eu.europa.esig.dss.cades.signature.CAdESSignatureExtension;
import eu.europa.esig.dss.cades.signature.CadesLevelBaselineLTATimestampExtractor;
import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.OID;
import eu.europa.esig.dss.spi.x509.tsp.TSPSource;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.ValidationDataForInclusion;
import eu.europa.esig.dss.validation.ValidationDataForInclusionBuilder;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TimeStampToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CAdESLevelBaselineLTA
extends CAdESSignatureExtension {
    private static final Logger LOG = LoggerFactory.getLogger(CAdESLevelBaselineLTA.class);
    private final CAdESLevelBaselineLT cadesProfileLT;

    public CAdESLevelBaselineLTA(TSPSource tspSource, CertificateVerifier certificateVerifier, boolean onlyLastSigner) {
        super(tspSource, onlyLastSigner);
        this.cadesProfileLT = new CAdESLevelBaselineLT(tspSource, certificateVerifier, onlyLastSigner);
    }

    @Override
    protected CMSSignedData preExtendCMSSignedData(CMSSignedData cmsSignedData, CAdESSignatureParameters parameters) {
        if (!this.includesATSv2(cmsSignedData)) {
            cmsSignedData = this.cadesProfileLT.extendCMSSignatures(cmsSignedData, parameters);
        }
        return cmsSignedData;
    }

    private boolean includesATSv2(CMSSignedData cmsSignedData) {
        Attribute[] attributes;
        SignerInformation signerInformation = (SignerInformation)cmsSignedData.getSignerInfos().iterator().next();
        AttributeTable unsignedAttributes = CMSUtils.getUnsignedAttributes(signerInformation);
        for (Attribute attribute : attributes = unsignedAttributes.toASN1Structure().getAttributes()) {
            if (!DSSASN1Utils.isAttributeOfType((Attribute)attribute, (ASN1ObjectIdentifier)OID.id_aa_ets_archiveTimestampV2)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected SignerInformation extendCMSSignature(CMSSignedData cmsSignedData, SignerInformation signerInformation, CAdESSignatureParameters parameters) throws DSSException {
        CAdESSignature cadesSignature;
        AttributeTable unsignedAttributes = CMSUtils.getUnsignedAttributes(signerInformation);
        if (this.includesATSv2(cmsSignedData)) {
            try {
                cadesSignature = this.newCAdESSignature(cmsSignedData, signerInformation, parameters.getDetachedContents());
                ValidationDataForInclusionBuilder validationDataForInclusionBuilder = this.cadesProfileLT.getValidationDataForInclusionBuilder(cadesSignature).excludeCertificateTokens((Collection)cadesSignature.getCompleteCertificateSource().getAllCertificateTokens()).excludeCRLs((Collection)cadesSignature.getCompleteCRLSource().getAllRevocationBinaries()).excludeOCSPs((Collection)cadesSignature.getCompleteOCSPSource().getAllRevocationBinaries());
                ValidationDataForInclusion validationDataForInclusion = validationDataForInclusionBuilder.build();
                unsignedAttributes = this.addValidationData(unsignedAttributes, validationDataForInclusion, parameters.getDetachedContents());
                signerInformation = SignerInformation.replaceUnsignedAttributes((SignerInformation)signerInformation, (AttributeTable)unsignedAttributes);
            }
            catch (IOException | CMSException | TSPException e) {
                LOG.warn("Validation data to a timestamp was not added due the error : {}", (Object)e.getMessage());
            }
        }
        cadesSignature = this.newCAdESSignature(cmsSignedData, signerInformation, parameters.getDetachedContents());
        unsignedAttributes = this.addArchiveTimestampV3Attribute(cadesSignature, signerInformation, parameters, unsignedAttributes);
        return SignerInformation.replaceUnsignedAttributes((SignerInformation)signerInformation, (AttributeTable)unsignedAttributes);
    }

    private AttributeTable addValidationData(AttributeTable unsignedAttributes, ValidationDataForInclusion validationDataForInclusion, List<DSSDocument> detachedContents) throws IOException, CMSException, TSPException {
        TimeStampToken timestampTokenToExtend = this.getLastArchiveTimestamp(unsignedAttributes);
        if (timestampTokenToExtend != null) {
            CMSSignedData timestampCMSSignedData = timestampTokenToExtend.toCMSSignedData();
            CMSSignedData extendedTimestampCMSSignedData = this.cadesProfileLT.extendWithValidationData(timestampCMSSignedData, validationDataForInclusion, detachedContents);
            unsignedAttributes = this.replaceTimeStampAttribute(unsignedAttributes, timestampCMSSignedData, extendedTimestampCMSSignedData);
        }
        return unsignedAttributes;
    }

    private TimeStampToken getLastArchiveTimestamp(AttributeTable unsignedAttributes) {
        TimeStampToken lastTimeStampToken = null;
        TimeStampTokenProductionComparator comparator = new TimeStampTokenProductionComparator();
        for (TimeStampToken timeStampToken : DSSASN1Utils.findArchiveTimeStampTokens((AttributeTable)unsignedAttributes)) {
            if (lastTimeStampToken != null && !comparator.after(timeStampToken, lastTimeStampToken)) continue;
            lastTimeStampToken = timeStampToken;
        }
        return lastTimeStampToken;
    }

    private AttributeTable replaceTimeStampAttribute(AttributeTable attributeTable, CMSSignedData attributeToReplace, CMSSignedData attributeToAdd) throws IOException, CMSException {
        Attribute[] attributes;
        ASN1EncodableVector newAsn1EncodableVector = new ASN1EncodableVector();
        Attribute[] attributeArray = attributes = attributeTable.toASN1Structure().getAttributes();
        int n = attributeArray.length;
        for (int i = 0; i < n; ++i) {
            Attribute attribute;
            Attribute attibuteToAdd = attribute = attributeArray[i];
            if (DSSASN1Utils.isArchiveTimeStampToken((Attribute)attribute)) {
                try {
                    CMSSignedData cmsSignedData = DSSASN1Utils.getCMSSignedData((Attribute)attribute);
                    if (CMSUtils.isCMSSignedDataEqual(attributeToReplace, cmsSignedData)) {
                        ASN1Primitive asn1Primitive = DSSASN1Utils.toASN1Primitive((byte[])attributeToAdd.getEncoded());
                        attibuteToAdd = new Attribute(attribute.getAttrType(), (ASN1Set)new DERSet((ASN1Encodable)asn1Primitive));
                    }
                }
                catch (Exception e) {
                    LOG.warn("Unable to build a CMSSignedData object from an unsigned attribute. Reason : {}", (Object)e.getMessage(), (Object)e);
                }
            }
            newAsn1EncodableVector.add((ASN1Encodable)attibuteToAdd);
        }
        return new AttributeTable(newAsn1EncodableVector);
    }

    private AttributeTable addArchiveTimestampV3Attribute(CAdESSignature cadesSignature, SignerInformation signerInformation, CAdESSignatureParameters parameters, AttributeTable unsignedAttributes) {
        CadesLevelBaselineLTATimestampExtractor timestampExtractor = new CadesLevelBaselineLTATimestampExtractor(cadesSignature);
        DigestAlgorithm timestampDigestAlgorithm = parameters.getArchiveTimestampParameters().getDigestAlgorithm();
        byte[] originalDocumentDigest = Utils.fromBase64((String)cadesSignature.getOriginalDocument().getDigest(timestampDigestAlgorithm));
        ASN1ObjectIdentifier atsHashIndexTableIdentifier = this.getAtsHashIndexTableIdentifier(parameters);
        Attribute atsHashIndexAttribute = timestampExtractor.getAtsHashIndex(signerInformation, timestampDigestAlgorithm, atsHashIndexTableIdentifier);
        byte[] encodedToTimestamp = timestampExtractor.getArchiveTimestampDataV3(signerInformation, atsHashIndexAttribute, originalDocumentDigest);
        ASN1Object timeStampAttributeValue = this.getTimeStampAttributeValue(encodedToTimestamp, timestampDigestAlgorithm, new Attribute[]{atsHashIndexAttribute});
        return unsignedAttributes.add(OID.id_aa_ets_archiveTimestampV3, (ASN1Encodable)timeStampAttributeValue);
    }

    private ASN1ObjectIdentifier getAtsHashIndexTableIdentifier(CAdESSignatureParameters signatureParameters) {
        if (!signatureParameters.isEn319122()) {
            return OID.id_aa_ATSHashIndex;
        }
        return OID.id_aa_ATSHashIndexV3;
    }
}

