/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.validation;

import eu.europa.esig.dss.DSSASN1Utils;
import eu.europa.esig.dss.DSSDocument;
import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DSSUtils;
import eu.europa.esig.dss.Digest;
import eu.europa.esig.dss.DigestAlgorithm;
import eu.europa.esig.dss.DigestDocument;
import eu.europa.esig.dss.EncryptionAlgorithm;
import eu.europa.esig.dss.InMemoryDocument;
import eu.europa.esig.dss.MaskGenerationFunction;
import eu.europa.esig.dss.OID;
import eu.europa.esig.dss.SignatureAlgorithm;
import eu.europa.esig.dss.SignatureForm;
import eu.europa.esig.dss.SignatureLevel;
import eu.europa.esig.dss.TokenIdentifier;
import eu.europa.esig.dss.cades.CMSUtils;
import eu.europa.esig.dss.cades.SignerAttributeV2;
import eu.europa.esig.dss.cades.signature.CadesLevelBaselineLTATimestampExtractor;
import eu.europa.esig.dss.cades.validation.CAdESCRLSource;
import eu.europa.esig.dss.cades.validation.CAdESOCSPSource;
import eu.europa.esig.dss.cades.validation.PrecomputedDigestCalculatorProvider;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.CAdESCertificateSource;
import eu.europa.esig.dss.validation.CRLRef;
import eu.europa.esig.dss.validation.CandidatesForSigningCertificate;
import eu.europa.esig.dss.validation.CertificateRef;
import eu.europa.esig.dss.validation.CertificateValidity;
import eu.europa.esig.dss.validation.CertifiedRole;
import eu.europa.esig.dss.validation.CommitmentType;
import eu.europa.esig.dss.validation.DefaultAdvancedSignature;
import eu.europa.esig.dss.validation.DigestMatcherType;
import eu.europa.esig.dss.validation.OCSPRef;
import eu.europa.esig.dss.validation.ReferenceValidation;
import eu.europa.esig.dss.validation.SignatureCryptographicVerification;
import eu.europa.esig.dss.validation.SignaturePolicyProvider;
import eu.europa.esig.dss.validation.SignatureProductionPlace;
import eu.europa.esig.dss.validation.TimestampReference;
import eu.europa.esig.dss.validation.TimestampToken;
import eu.europa.esig.dss.validation.TimestampedObjectType;
import eu.europa.esig.dss.x509.ArchiveTimestampType;
import eu.europa.esig.dss.x509.CertificatePool;
import eu.europa.esig.dss.x509.CertificateToken;
import eu.europa.esig.dss.x509.SignaturePolicy;
import eu.europa.esig.dss.x509.TimestampType;
import eu.europa.esig.dss.x509.crl.OfflineCRLSource;
import eu.europa.esig.dss.x509.ocsp.OfflineOCSPSource;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.ASN1UTCTime;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.esf.CommitmentTypeIndication;
import org.bouncycastle.asn1.esf.CrlListID;
import org.bouncycastle.asn1.esf.CrlOcspRef;
import org.bouncycastle.asn1.esf.CrlValidatedID;
import org.bouncycastle.asn1.esf.OcspListID;
import org.bouncycastle.asn1.esf.OcspResponsesID;
import org.bouncycastle.asn1.esf.OtherHash;
import org.bouncycastle.asn1.esf.OtherHashAlgAndValue;
import org.bouncycastle.asn1.esf.SigPolicyQualifierInfo;
import org.bouncycastle.asn1.esf.SigPolicyQualifiers;
import org.bouncycastle.asn1.esf.SignaturePolicyId;
import org.bouncycastle.asn1.esf.SignerAttribute;
import org.bouncycastle.asn1.esf.SignerLocation;
import org.bouncycastle.asn1.ess.ContentHints;
import org.bouncycastle.asn1.ess.ContentIdentifier;
import org.bouncycastle.asn1.ess.ESSCertID;
import org.bouncycastle.asn1.ess.ESSCertIDv2;
import org.bouncycastle.asn1.ess.OtherCertID;
import org.bouncycastle.asn1.ess.SigningCertificate;
import org.bouncycastle.asn1.ess.SigningCertificateV2;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.RSASSAPSSparams;
import org.bouncycastle.asn1.x500.DirectoryString;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.AttCertValidityPeriod;
import org.bouncycastle.asn1.x509.AttributeCertificate;
import org.bouncycastle.asn1.x509.AttributeCertificateInfo;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.IssuerSerial;
import org.bouncycastle.asn1.x509.RoleSyntax;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataParser;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.CMSTypedStream;
import org.bouncycastle.cms.SignerId;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationVerifier;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import org.bouncycastle.tsp.TimeStampToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CAdESSignature
extends DefaultAdvancedSignature {
    private static final Logger LOG = LoggerFactory.getLogger(CAdESSignature.class);
    private static final Date JANUARY_1950 = DSSUtils.getUtcDate((int)1950, (int)1, (int)1);
    private static final Date JANUARY_2050 = DSSUtils.getUtcDate((int)2050, (int)1, (int)1);
    private final CMSSignedData cmsSignedData;
    private final SignerInformation signerInformation;
    private CAdESCertificateSource certSource;
    private CertificateValidity signingCertificateValidity;
    private String signatureId;
    private List<TimestampReference> signingCertificateTimestampReferences;

    public CAdESSignature(byte[] data) throws CMSException {
        this(data, new CertificatePool());
    }

    public CAdESSignature(byte[] data, CertificatePool certPool) throws CMSException {
        this(new CMSSignedData(data), certPool);
    }

    public CAdESSignature(CMSSignedData cms, CertificatePool certPool) {
        this(cms, DSSASN1Utils.getFirstSignerInformation((CMSSignedData)cms), certPool);
    }

    public CAdESSignature(CMSSignedData cms, CertificatePool certPool, List<DSSDocument> detachedContents) {
        this(cms, certPool);
        this.setDetachedContents(detachedContents);
    }

    public CAdESSignature(CMSSignedData cmsSignedData, SignerInformation signerInformation) {
        this(cmsSignedData, signerInformation, new CertificatePool());
    }

    public CAdESSignature(CMSSignedData cmsSignedData, SignerInformation signerInformation, CertificatePool certPool) {
        super(certPool);
        this.cmsSignedData = cmsSignedData;
        this.signerInformation = signerInformation;
    }

    public SignatureForm getSignatureForm() {
        return SignatureForm.CAdES;
    }

    public CAdESCertificateSource getCertificateSource() {
        if (this.certSource == null) {
            this.certSource = new CAdESCertificateSource(this.cmsSignedData, this.certPool);
        }
        return this.certSource;
    }

    public OfflineCRLSource getCRLSource() {
        if (this.offlineCRLSource == null) {
            try {
                this.offlineCRLSource = new CAdESCRLSource(this.cmsSignedData, this.signerInformation);
            }
            catch (Exception e) {
                LOG.warn("Error in computing or in format of the algorithm: just continue...", (Throwable)e);
            }
        }
        return this.offlineCRLSource;
    }

    public OfflineOCSPSource getOCSPSource() {
        if (this.offlineOCSPSource == null) {
            this.offlineOCSPSource = new CAdESOCSPSource(this.cmsSignedData, this.signerInformation);
        }
        return this.offlineOCSPSource;
    }

    public CandidatesForSigningCertificate getCandidatesForSigningCertificate() {
        if (this.candidatesForSigningCertificate != null) {
            return this.candidatesForSigningCertificate;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Searching the signing certificate...");
        }
        this.candidatesForSigningCertificate = new CandidatesForSigningCertificate();
        List keyInfoCertificates = this.getCertificateSource().getKeyInfoCertificates();
        SignerId signerId = this.signerInformation.getSID();
        for (CertificateToken certificateToken : keyInfoCertificates) {
            CertificateValidity certificateValidity = new CertificateValidity(certificateToken);
            this.candidatesForSigningCertificate.add(certificateValidity);
            X509CertificateHolder x509CertificateHolder = DSSASN1Utils.getX509CertificateHolder((CertificateToken)certificateToken);
            boolean match = signerId.match((Object)x509CertificateHolder);
            certificateValidity.setSignerIdMatch(match);
            if (!match) continue;
            this.signingCertificateValidity = certificateValidity;
            break;
        }
        if (this.signingCertificateValidity == null) {
            LOG.warn("Signing certificate not found: {} {}", (Object)signerId.getIssuer(), (Object)signerId.getSerialNumber());
        } else if (!this.verifySignedReferencesToSigningCertificate()) {
            LOG.warn("There is no valid signed reference to the signing certificate: {}", (Object)this.signingCertificateValidity.getCertificateToken().getAbbreviation());
        }
        return this.candidatesForSigningCertificate;
    }

    private boolean verifySignedReferencesToSigningCertificate() {
        IssuerSerial signingTokenIssuerSerial = DSSASN1Utils.getIssuerSerial((CertificateToken)this.signingCertificateValidity.getCertificateToken());
        BigInteger signingTokenSerialNumber = signingTokenIssuerSerial.getSerial().getValue();
        GeneralNames signingTokenIssuerName = signingTokenIssuerSerial.getIssuer();
        AttributeTable signedAttributes = CMSUtils.getSignedAttributes(this.signerInformation);
        Attribute signingCertificateAttributeV1 = signedAttributes.get(PKCSObjectIdentifiers.id_aa_signingCertificate);
        if (signingCertificateAttributeV1 != null) {
            this.signingCertificateValidity.setAttributePresent(true);
            this.verifySigningCertificateV1(signingTokenSerialNumber, signingTokenIssuerName, signingCertificateAttributeV1);
            return true;
        }
        Attribute signingCertificateAttributeV2 = signedAttributes.get(PKCSObjectIdentifiers.id_aa_signingCertificateV2);
        if (signingCertificateAttributeV2 != null) {
            this.signingCertificateValidity.setAttributePresent(true);
            this.verifySigningCertificateV2(signingTokenSerialNumber, signingTokenIssuerName, signingCertificateAttributeV2);
            return true;
        }
        return false;
    }

    private void verifySigningCertificateV1(BigInteger signingTokenSerialNumber, GeneralNames signingTokenIssuerName, Attribute signingCertificateAttributeV1) {
        DigestAlgorithm digestAlgorithm = DigestAlgorithm.SHA1;
        byte[] signingTokenCertHash = this.signingCertificateValidity.getCertificateToken().getDigest(digestAlgorithm);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Candidate Certificate Hash {} with algorithm {}", (Object)Utils.toHex((byte[])signingTokenCertHash), (Object)digestAlgorithm);
        }
        ASN1Set attrValues = signingCertificateAttributeV1.getAttrValues();
        for (int ii = 0; ii < attrValues.size(); ++ii) {
            ESSCertID[] essCertIDs;
            ASN1Encodable asn1Encodable = attrValues.getObjectAt(ii);
            SigningCertificate signingCertificate = SigningCertificate.getInstance((Object)asn1Encodable);
            for (ESSCertID essCertID : essCertIDs = signingCertificate.getCerts()) {
                IssuerSerial issuerSerial;
                boolean match;
                byte[] certHash = essCertID.getCertHash();
                this.signingCertificateValidity.setDigestPresent(true);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Found Certificate Hash in signingCertificateAttributeV1 {} with algorithm {}", (Object)Utils.toHex((byte[])certHash), (Object)digestAlgorithm);
                }
                if (match = this.verifySigningCertificateReferences(signingTokenSerialNumber, signingTokenIssuerName, signingTokenCertHash, certHash, issuerSerial = essCertID.getIssuerSerial())) {
                    return;
                }
                LOG.warn("RFC 2634: The first certificate identified in the sequence of certificate identifiers MUST be the certificate used to verify the signature.");
            }
        }
    }

    private void verifySigningCertificateV2(BigInteger signingTokenSerialNumber, GeneralNames signingTokenIssuerName, Attribute signingCertificateAttributeV2) {
        ASN1Set attrValues = signingCertificateAttributeV2.getAttrValues();
        DigestAlgorithm lastDigestAlgorithm = null;
        byte[] signingTokenCertHash = null;
        for (int ii = 0; ii < attrValues.size(); ++ii) {
            ESSCertIDv2[] essCertIDv2s;
            ASN1Encodable asn1Encodable = attrValues.getObjectAt(ii);
            SigningCertificateV2 signingCertificateAttribute = SigningCertificateV2.getInstance((Object)asn1Encodable);
            if (signingCertificateAttribute == null) {
                LOG.warn("SigningCertificateV2 attribute is not well defined!");
                continue;
            }
            for (ESSCertIDv2 essCertIDv2 : essCertIDv2s = signingCertificateAttribute.getCerts()) {
                IssuerSerial issuerSerial;
                boolean match;
                String algorithmId = essCertIDv2.getHashAlgorithm().getAlgorithm().getId();
                DigestAlgorithm digestAlgorithm = DigestAlgorithm.forOID((String)algorithmId);
                if (digestAlgorithm != lastDigestAlgorithm) {
                    signingTokenCertHash = this.signingCertificateValidity.getCertificateToken().getDigest(digestAlgorithm);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Candidate Certificate Hash {} with algorithm {}", (Object)Utils.toHex((byte[])signingTokenCertHash), (Object)digestAlgorithm);
                    }
                    lastDigestAlgorithm = digestAlgorithm;
                }
                byte[] certHash = essCertIDv2.getCertHash();
                this.signingCertificateValidity.setDigestPresent(true);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Found Certificate Hash in SigningCertificateV2 {} with algorithm {}", (Object)Utils.toHex((byte[])certHash), (Object)digestAlgorithm);
                }
                if (match = this.verifySigningCertificateReferences(signingTokenSerialNumber, signingTokenIssuerName, signingTokenCertHash, certHash, issuerSerial = essCertIDv2.getIssuerSerial())) {
                    return;
                }
                LOG.warn("RFC 5035: The first certificate identified in the sequence of certificate identifiers MUST be the certificate used to verify the signature.");
            }
        }
    }

    private boolean verifySigningCertificateReferences(BigInteger signingTokenSerialNumber, GeneralNames signingTokenIssuerName, byte[] signingTokenCertHash, byte[] certHash, IssuerSerial issuerSerial) {
        boolean hashEqual = Arrays.equals(certHash, signingTokenCertHash);
        this.signingCertificateValidity.setDigestEqual(hashEqual);
        if (issuerSerial != null) {
            BigInteger serialNumber = issuerSerial.getSerial().getValue();
            boolean serialNumberEqual = serialNumber.equals(signingTokenSerialNumber);
            this.signingCertificateValidity.setSerialNumberEqual(serialNumberEqual);
            GeneralNames issuerName = issuerSerial.getIssuer();
            String canonicalizedIssuerName = DSSASN1Utils.getCanonicalizedName((GeneralNames)issuerName);
            String canonicalizedSigningTokenIssuerName = DSSASN1Utils.getCanonicalizedName((GeneralNames)signingTokenIssuerName);
            boolean issuerNameEqual = canonicalizedIssuerName.equals(canonicalizedSigningTokenIssuerName);
            this.signingCertificateValidity.setDistinguishedNameEqual(issuerNameEqual);
        }
        return hashEqual;
    }

    public void checkSignaturePolicy(SignaturePolicyProvider signaturePolicyProvider) {
        Attribute attribute = this.getSignedAttribute(PKCSObjectIdentifiers.id_aa_ets_sigPolicyId);
        if (attribute == null) {
            return;
        }
        ASN1Encodable attrValue = attribute.getAttrValues().getObjectAt(0);
        if (attrValue instanceof DERNull) {
            this.signaturePolicy = new SignaturePolicy();
            return;
        }
        SignaturePolicyId sigPolicy = SignaturePolicyId.getInstance((Object)attrValue);
        if (sigPolicy == null) {
            return;
        }
        String policyId = sigPolicy.getSigPolicyId().getId();
        this.signaturePolicy = new SignaturePolicy(policyId);
        OtherHashAlgAndValue hashAlgAndValue = sigPolicy.getSigPolicyHash();
        AlgorithmIdentifier digestAlgorithmIdentifier = hashAlgAndValue.getHashAlgorithm();
        String digestAlgorithmOID = digestAlgorithmIdentifier.getAlgorithm().getId();
        DigestAlgorithm digestAlgorithm = DigestAlgorithm.forOID((String)digestAlgorithmOID);
        this.signaturePolicy.setDigestAlgorithm(digestAlgorithm);
        ASN1OctetString digestValue = hashAlgAndValue.getHashValue();
        byte[] digestValueBytes = digestValue.getOctets();
        this.signaturePolicy.setDigestValue(Utils.toBase64((byte[])digestValueBytes));
        SigPolicyQualifiers sigPolicyQualifiers = sigPolicy.getSigPolicyQualifiers();
        if (sigPolicyQualifiers == null) {
            this.signaturePolicy.setPolicyContent(signaturePolicyProvider.getSignaturePolicyById(policyId));
        } else {
            for (int ii = 0; ii < sigPolicyQualifiers.size(); ++ii) {
                try {
                    SigPolicyQualifierInfo policyQualifierInfo = sigPolicyQualifiers.getInfoAt(ii);
                    ASN1ObjectIdentifier policyQualifierInfoId = policyQualifierInfo.getSigPolicyQualifierId();
                    String policyQualifierInfoValue = policyQualifierInfo.getSigQualifier().toString();
                    if (PKCSObjectIdentifiers.id_spq_ets_unotice.equals((Object)policyQualifierInfoId)) {
                        this.signaturePolicy.setNotice(policyQualifierInfoValue);
                        continue;
                    }
                    if (PKCSObjectIdentifiers.id_spq_ets_uri.equals((Object)policyQualifierInfoId)) {
                        this.signaturePolicy.setUrl(policyQualifierInfoValue);
                        this.signaturePolicy.setPolicyContent(signaturePolicyProvider.getSignaturePolicyByUrl(policyQualifierInfoValue));
                        continue;
                    }
                    LOG.error("Unknown signature policy qualifier id: {} with value: {}", (Object)policyQualifierInfoId, (Object)policyQualifierInfoValue);
                    continue;
                }
                catch (Exception e) {
                    LOG.error("Unable to read SigPolicyQualifierInfo " + ii, (Object)e.getMessage());
                }
            }
            if (this.signaturePolicy.getPolicyContent() != null) {
                signaturePolicyProvider.getSignaturePoliciesById().put(policyId, this.signaturePolicy.getPolicyContent());
            }
        }
    }

    public Date getSigningTime() {
        Attribute attr = this.getSignedAttribute(PKCSObjectIdentifiers.pkcs_9_at_signingTime);
        if (attr == null) {
            return null;
        }
        ASN1Set attrValues = attr.getAttrValues();
        ASN1Encodable attrValue = attrValues.getObjectAt(0);
        Date signingDate = DSSASN1Utils.getDate((ASN1Encodable)attrValue);
        if (signingDate != null) {
            if (!(signingDate.before(JANUARY_1950) && signingDate.after(JANUARY_2050) || attrValue instanceof ASN1UTCTime)) {
                LOG.error("RFC 3852 states that dates between January 1, 1950 and December 31, 2049 (inclusive) must be encoded as UTCTime. Any dates with year values before 1950 or after 2049 must be encoded as GeneralizedTime. Date found is {} encoded as {}", (Object)signingDate, attrValue.getClass());
                return null;
            }
            return signingDate;
        }
        if (LOG.isErrorEnabled()) {
            LOG.error("Error when reading signing time. Unrecognized {}", attrValue.getClass());
        }
        return null;
    }

    public CMSSignedData getCmsSignedData() {
        return this.cmsSignedData;
    }

    public SignatureProductionPlace getSignatureProductionPlace() {
        DirectoryString localityName;
        Attribute signatureProductionPlaceAttr = this.getSignedAttribute(PKCSObjectIdentifiers.id_aa_ets_signerLocation);
        if (signatureProductionPlaceAttr == null) {
            return null;
        }
        ASN1Encodable asn1Encodable = signatureProductionPlaceAttr.getAttrValues().getObjectAt(0);
        SignerLocation signerLocation = null;
        try {
            signerLocation = SignerLocation.getInstance((Object)asn1Encodable);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        if (signerLocation == null) {
            return null;
        }
        SignatureProductionPlace signatureProductionPlace = new SignatureProductionPlace();
        DirectoryString countryName = signerLocation.getCountry();
        if (countryName != null) {
            signatureProductionPlace.setCountryName(countryName.getString());
        }
        if ((localityName = signerLocation.getLocality()) != null) {
            signatureProductionPlace.setCity(localityName.getString());
        }
        StringBuilder address = new StringBuilder();
        ASN1Sequence seq = signerLocation.getPostalAddress();
        if (seq != null) {
            for (int ii = 0; ii < seq.size(); ++ii) {
                if (seq.getObjectAt(ii) instanceof DEROctetString) {
                    if (address.length() > 0) {
                        address.append(" / ");
                    }
                    address.append(new String(((DEROctetString)seq.getObjectAt(ii)).getOctets()));
                    continue;
                }
                if (!(seq.getObjectAt(ii) instanceof DERUTF8String)) continue;
                if (address.length() > 0) {
                    address.append(" / ");
                }
                DERUTF8String derutf8String = (DERUTF8String)seq.getObjectAt(ii);
                address.append(derutf8String.getString());
            }
        }
        signatureProductionPlace.setStreetAddress(address.toString());
        return signatureProductionPlace;
    }

    public CommitmentType getCommitmentTypeIndication() {
        Attribute commitmentTypeIndicationAttribute = this.getSignedAttribute(PKCSObjectIdentifiers.id_aa_ets_commitmentType);
        if (commitmentTypeIndicationAttribute == null) {
            return null;
        }
        try {
            CommitmentType commitmentType = null;
            ASN1Set attrValues = commitmentTypeIndicationAttribute.getAttrValues();
            int size = attrValues.size();
            if (size > 0) {
                commitmentType = new CommitmentType();
                for (int ii = 0; ii < size; ++ii) {
                    if (attrValues.getObjectAt(ii) instanceof DERSequence) {
                        DERSequence derSequence = (DERSequence)attrValues.getObjectAt(ii);
                        CommitmentTypeIndication commitmentTypeIndication = CommitmentTypeIndication.getInstance((Object)derSequence);
                        ASN1ObjectIdentifier commitmentTypeId = commitmentTypeIndication.getCommitmentTypeId();
                        commitmentType.addIdentifier(commitmentTypeId.getId());
                        continue;
                    }
                    LOG.warn("Unsupported type for CommitmentType : {}", attrValues.getObjectAt(ii).getClass());
                }
            }
            return commitmentType;
        }
        catch (Exception e) {
            throw new DSSException("Error when dealing with CommitmentTypeIndication!", (Throwable)e);
        }
    }

    public String[] getClaimedSignerRoles() {
        SignerAttribute signerAttr = this.getSignerAttributeV1();
        SignerAttributeV2 signerAttrV2 = this.getSignerAttributeV2();
        Object[] signerAttrValues = null;
        try {
            if (signerAttr != null) {
                signerAttrValues = signerAttr.getValues();
            } else if (signerAttrV2 != null) {
                signerAttrValues = signerAttrV2.getValues();
            }
            if (signerAttrValues == null) {
                return null;
            }
            ArrayList<String> claimedRoles = new ArrayList<String>();
            for (Object signerAttrValue : signerAttrValues) {
                org.bouncycastle.asn1.x509.Attribute[] signerAttrValueArray;
                if (!(signerAttrValue instanceof org.bouncycastle.asn1.x509.Attribute[])) continue;
                for (org.bouncycastle.asn1.x509.Attribute claimedRole : signerAttrValueArray = (org.bouncycastle.asn1.x509.Attribute[])signerAttrValue) {
                    ASN1Encodable[] attrValues1;
                    for (ASN1Encodable asn1Encodable : attrValues1 = claimedRole.getAttrValues().toArray()) {
                        if (!(asn1Encodable instanceof ASN1String)) continue;
                        ASN1String asn1String = (ASN1String)asn1Encodable;
                        String s = asn1String.getString();
                        claimedRoles.add(s);
                    }
                }
            }
            String[] strings = claimedRoles.toArray(new String[claimedRoles.size()]);
            return strings;
        }
        catch (Exception e) {
            LOG.error("Error when dealing with claimed signer roles: [" + signerAttrValues + "]", (Throwable)e);
            return null;
        }
    }

    public List<CertifiedRole> getCertifiedSignerRoles() {
        SignerAttribute signerAttr = this.getSignerAttributeV1();
        SignerAttributeV2 signerAttrV2 = this.getSignerAttributeV2();
        Object[] signerAttrValues = null;
        try {
            if (signerAttr != null) {
                signerAttrValues = signerAttr.getValues();
            } else if (signerAttrV2 != null) {
                signerAttrValues = signerAttrV2.getValues();
            }
            if (signerAttrValues == null) {
                return null;
            }
            ArrayList<CertifiedRole> roles = null;
            for (Object signerAttrValue : signerAttrValues) {
                if (!(signerAttrValue instanceof AttributeCertificate)) continue;
                if (roles == null) {
                    roles = new ArrayList<CertifiedRole>();
                }
                AttributeCertificate attributeCertificate = (AttributeCertificate)signerAttrValue;
                AttributeCertificateInfo acInfo = attributeCertificate.getAcinfo();
                AttCertValidityPeriod attrCertValidityPeriod = acInfo.getAttrCertValidityPeriod();
                ASN1Sequence attributes = acInfo.getAttributes();
                for (int ii = 0; ii < attributes.size(); ++ii) {
                    ASN1Encodable objectAt = attributes.getObjectAt(ii);
                    org.bouncycastle.asn1.x509.Attribute attribute = org.bouncycastle.asn1.x509.Attribute.getInstance((Object)objectAt);
                    ASN1Set attrValues1 = attribute.getAttrValues();
                    DERSequence derSequence = (DERSequence)attrValues1.getObjectAt(0);
                    RoleSyntax roleSyntax = RoleSyntax.getInstance((Object)derSequence);
                    CertifiedRole certifiedRole = new CertifiedRole();
                    certifiedRole.setRole(roleSyntax.getRoleNameAsString());
                    certifiedRole.setNotBefore(DSSASN1Utils.toDate((ASN1GeneralizedTime)attrCertValidityPeriod.getNotBeforeTime()));
                    certifiedRole.setNotAfter(DSSASN1Utils.toDate((ASN1GeneralizedTime)attrCertValidityPeriod.getNotAfterTime()));
                    roles.add(certifiedRole);
                }
            }
            return roles;
        }
        catch (Exception e) {
            LOG.error("Error when dealing with certified signer roles: [" + signerAttrValues + "]", (Throwable)e);
            return null;
        }
    }

    private SignerAttribute getSignerAttributeV1() {
        Attribute id_aa_ets_signerAttr = this.getSignedAttribute(PKCSObjectIdentifiers.id_aa_ets_signerAttr);
        if (id_aa_ets_signerAttr != null) {
            ASN1Set attrValues = id_aa_ets_signerAttr.getAttrValues();
            ASN1Encodable attrValue = attrValues.getObjectAt(0);
            try {
                return SignerAttribute.getInstance((Object)attrValue);
            }
            catch (Exception e) {
                LOG.warn("Unable to parse signerAttr " + Utils.toBase64((byte[])DSSASN1Utils.getDEREncoded((ASN1Encodable)attrValue)) + "", (Throwable)e);
            }
        }
        return null;
    }

    private SignerAttributeV2 getSignerAttributeV2() {
        Attribute id_aa_ets_signerAttrV2 = this.getSignedAttribute(OID.id_aa_ets_signerAttrV2);
        if (id_aa_ets_signerAttrV2 != null) {
            ASN1Set attrValues = id_aa_ets_signerAttrV2.getAttrValues();
            ASN1Encodable attrValue = attrValues.getObjectAt(0);
            try {
                return SignerAttributeV2.getInstance(attrValue);
            }
            catch (Exception e) {
                LOG.warn("Unable to parse signerAttrV2 " + Utils.toBase64((byte[])DSSASN1Utils.getDEREncoded((ASN1Encodable)attrValue)) + "", (Throwable)e);
            }
        }
        return null;
    }

    public byte[] getContentTimestampData(TimestampToken timestampToken) {
        return DSSUtils.toByteArray((DSSDocument)this.getOriginalDocument());
    }

    public List<TimestampToken> getContentTimestamps() {
        if (this.contentTimestamps == null) {
            this.makeTimestampTokens();
        }
        return this.contentTimestamps;
    }

    public List<TimestampToken> getSignatureTimestamps() {
        if (this.signatureTimestamps == null) {
            this.makeTimestampTokens();
        }
        return this.signatureTimestamps;
    }

    public List<TimestampToken> getTimestampsX1() {
        if (this.sigAndRefsTimestamps == null) {
            this.makeTimestampTokens();
        }
        return this.sigAndRefsTimestamps;
    }

    public List<TimestampToken> getTimestampsX2() {
        if (this.refsOnlyTimestamps == null) {
            this.makeTimestampTokens();
        }
        return this.refsOnlyTimestamps;
    }

    public List<TimestampToken> getArchiveTimestamps() {
        if (this.archiveTimestamps == null) {
            this.makeTimestampTokens();
        }
        return this.archiveTimestamps;
    }

    private void makeTimestampTokens() {
        this.contentTimestamps = this.createTimestamps(PKCSObjectIdentifiers.id_aa_ets_contentTimestamp, TimestampType.CONTENT_TIMESTAMP, null);
        this.signatureTimestamps = this.createTimestamps(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken, TimestampType.SIGNATURE_TIMESTAMP, null);
        this.refsOnlyTimestamps = this.createTimestamps(PKCSObjectIdentifiers.id_aa_ets_certCRLTimestamp, TimestampType.VALIDATION_DATA_REFSONLY_TIMESTAMP, null);
        this.sigAndRefsTimestamps = this.createTimestamps(PKCSObjectIdentifiers.id_aa_ets_escTimeStamp, TimestampType.VALIDATION_DATA_TIMESTAMP, null);
        this.archiveTimestamps = this.createTimestamps(OID.id_aa_ets_archiveTimestampV2, TimestampType.ARCHIVE_TIMESTAMP, ArchiveTimestampType.CAdES_V2);
        this.archiveTimestamps.addAll(this.createTimestamps(OID.id_aa_ets_archiveTimestampV3, TimestampType.ARCHIVE_TIMESTAMP, ArchiveTimestampType.CAdES_v3));
        List<TimestampToken> timestampTokenList = this.getTimestampTokenList();
        ArrayList<TimestampToken> timestampedTimestamps = new ArrayList<TimestampToken>();
        for (TimestampToken timestampToken : timestampTokenList) {
            TimestampType timestampType = timestampToken.getTimeStampType();
            switch (timestampType) {
                case CONTENT_TIMESTAMP: {
                    break;
                }
                case SIGNATURE_TIMESTAMP: {
                    timestampToken.setTimestampedReferences(this.getSignatureTimestampedReferences());
                    break;
                }
                case VALIDATION_DATA_REFSONLY_TIMESTAMP: {
                    timestampToken.setTimestampedReferences(this.getTimestampedReferences());
                    break;
                }
                case VALIDATION_DATA_TIMESTAMP: {
                    List<TimestampReference> validationDataReferences = this.getSignatureTimestampedReferences();
                    validationDataReferences.addAll(this.getTimestampedReferences());
                    timestampToken.setTimestampedReferences(validationDataReferences);
                    break;
                }
                case ARCHIVE_TIMESTAMP: {
                    timestampToken.setTimestampedReferences(this.getTimestampReferencesForArchiveTimestamp(timestampedTimestamps));
                    break;
                }
                default: {
                    throw new DSSException("TimeStampType not supported : " + timestampType);
                }
            }
            timestampedTimestamps.add(timestampToken);
        }
    }

    public List<TimestampReference> getTimestampReferencesForArchiveTimestamp(List<TimestampToken> timestampedTimestamps) {
        List<TimestampReference> archiveReferences = this.getSignatureTimestampedReferences();
        for (TimestampToken timestamp : timestampedTimestamps) {
            archiveReferences.add(new TimestampReference(timestamp.getDSSIdAsString(), TimestampedObjectType.TIMESTAMP));
        }
        archiveReferences.addAll(this.getTimestampedReferences());
        return archiveReferences;
    }

    private List<TimestampToken> getTimestampTokenList() {
        ArrayList<TimestampToken> timestampTokenList = new ArrayList<TimestampToken>();
        timestampTokenList.addAll(this.contentTimestamps);
        timestampTokenList.addAll(this.signatureTimestamps);
        timestampTokenList.addAll(this.refsOnlyTimestamps);
        timestampTokenList.addAll(this.sigAndRefsTimestamps);
        timestampTokenList.addAll(this.archiveTimestamps);
        return timestampTokenList;
    }

    private List<TimestampToken> createTimestamps(ASN1ObjectIdentifier attrType, TimestampType timestampType, ArchiveTimestampType archiveTimestampType) {
        AttributeTable attributes;
        ArrayList<TimestampToken> timestampTokenList = new ArrayList<TimestampToken>();
        AttributeTable attributeTable = attributes = attrType.equals((Object)PKCSObjectIdentifiers.id_aa_ets_contentTimestamp) ? this.signerInformation.getSignedAttributes() : this.signerInformation.getUnsignedAttributes();
        if (attributes != null) {
            ASN1EncodableVector allAttributes = attributes.getAll(attrType);
            for (int ii = 0; ii < allAttributes.size(); ++ii) {
                Attribute attribute = (Attribute)allAttributes.get(ii);
                ASN1Set attrValues = attribute.getAttrValues();
                for (ASN1Encodable value : attrValues.toArray()) {
                    if (value instanceof DEROctetString) {
                        LOG.warn("Illegal content for timestamp (OID : {}) : OCTET STRING is not allowed !", (Object)attrType);
                        continue;
                    }
                    try {
                        byte[] encoded = value.toASN1Primitive().getEncoded();
                        TimestampToken timestampToken = new TimestampToken(encoded, timestampType, this.certPool);
                        timestampToken.setArchiveTimestampType(archiveTimestampType);
                        timestampTokenList.add(timestampToken);
                    }
                    catch (Exception e) {
                        throw new DSSException((Throwable)e);
                    }
                }
            }
        }
        return timestampTokenList;
    }

    public List<TimestampReference> getSignatureTimestampedReferences() {
        ArrayList<TimestampReference> references = new ArrayList<TimestampReference>();
        TimestampReference signatureReference = this.getSignatureTimestampReference();
        references.add(signatureReference);
        List<TimestampReference> signingCertificateTimestampReferences = this.getSigningCertificateTimestampReferences();
        references.addAll(signingCertificateTimestampReferences);
        return references;
    }

    private TimestampReference getSignatureTimestampReference() {
        TimestampReference signatureReference = new TimestampReference(this.getId());
        return signatureReference;
    }

    public List<TimestampReference> getSigningCertificateTimestampReferences() {
        if (this.signingCertificateTimestampReferences == null) {
            Attribute signingCertificateAttributeV2;
            this.signingCertificateTimestampReferences = new ArrayList<TimestampReference>();
            AttributeTable signedAttributes = CMSUtils.getSignedAttributes(this.signerInformation);
            Attribute signingCertificateAttributeV1 = signedAttributes.get(PKCSObjectIdentifiers.id_aa_signingCertificate);
            if (signingCertificateAttributeV1 != null) {
                this.usedCertificatesDigestAlgorithms.add(DigestAlgorithm.SHA1);
                ASN1Set attrValues = signingCertificateAttributeV1.getAttrValues();
                for (int ii = 0; ii < attrValues.size(); ++ii) {
                    ESSCertID[] essCertIDs;
                    ASN1Encodable asn1Encodable = attrValues.getObjectAt(ii);
                    SigningCertificate signingCertificate = SigningCertificate.getInstance((Object)asn1Encodable);
                    for (ESSCertID essCertID : essCertIDs = signingCertificate.getCerts()) {
                        byte[] certHash = essCertID.getCertHash();
                        TimestampReference reference = this.createCertificateTimestampReference(DigestAlgorithm.SHA1, certHash);
                        this.signingCertificateTimestampReferences.add(reference);
                    }
                }
            }
            if ((signingCertificateAttributeV2 = signedAttributes.get(PKCSObjectIdentifiers.id_aa_signingCertificateV2)) != null) {
                ASN1Set attrValues = signingCertificateAttributeV2.getAttrValues();
                for (int ii = 0; ii < attrValues.size(); ++ii) {
                    ESSCertIDv2[] essCertIDv2s;
                    ASN1Encodable asn1Encodable = attrValues.getObjectAt(ii);
                    SigningCertificateV2 signingCertificateAttribute = SigningCertificateV2.getInstance((Object)asn1Encodable);
                    if (signingCertificateAttribute == null) continue;
                    for (ESSCertIDv2 essCertIDv2 : essCertIDv2s = signingCertificateAttribute.getCerts()) {
                        String algorithmId = essCertIDv2.getHashAlgorithm().getAlgorithm().getId();
                        DigestAlgorithm digestAlgorithm = DigestAlgorithm.forOID((String)algorithmId);
                        this.usedCertificatesDigestAlgorithms.add(digestAlgorithm);
                        byte[] certHash = essCertIDv2.getCertHash();
                        TimestampReference reference = this.createCertificateTimestampReference(digestAlgorithm, certHash);
                        this.signingCertificateTimestampReferences.add(reference);
                    }
                }
            }
        }
        return this.signingCertificateTimestampReferences;
    }

    private TimestampReference createCertificateTimestampReference(DigestAlgorithm digestAlgorithm, byte[] certHash) {
        TimestampReference reference = new TimestampReference(digestAlgorithm, Utils.toBase64((byte[])certHash));
        return reference;
    }

    public EncryptionAlgorithm getEncryptionAlgorithm() {
        String oid = this.signerInformation.getEncryptionAlgOID();
        try {
            return EncryptionAlgorithm.forOID((String)oid);
        }
        catch (DSSException dSSException) {
            SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.forOID((String)oid);
            return signatureAlgorithm.getEncryptionAlgorithm();
        }
    }

    public DigestAlgorithm getDigestAlgorithm() {
        SignatureAlgorithm signatureAlgorithm = this.getEncryptedDigestAlgo();
        if (signatureAlgorithm != null) {
            if (SignatureAlgorithm.RSA_SSA_PSS_SHA1_MGF1.equals((Object)signatureAlgorithm)) {
                return this.getPSSHashAlgorithm();
            }
            return signatureAlgorithm.getDigestAlgorithm();
        }
        try {
            String digestAlgOID = this.signerInformation.getDigestAlgOID();
            return DigestAlgorithm.forOID((String)digestAlgOID);
        }
        catch (DSSException e) {
            LOG.warn(e.getMessage());
            return null;
        }
    }

    private SignatureAlgorithm getEncryptedDigestAlgo() {
        try {
            return SignatureAlgorithm.forOID((String)this.signerInformation.getEncryptionAlgOID());
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public DigestAlgorithm getPSSHashAlgorithm() {
        try {
            byte[] encryptionAlgParams = this.signerInformation.getEncryptionAlgParams();
            if (Utils.isArrayNotEmpty((byte[])encryptionAlgParams) && !Arrays.equals(DERNull.INSTANCE.getEncoded(), encryptionAlgParams)) {
                RSASSAPSSparams param = RSASSAPSSparams.getInstance((Object)encryptionAlgParams);
                AlgorithmIdentifier pssHashAlgo = param.getHashAlgorithm();
                return DigestAlgorithm.forOID((String)pssHashAlgo.getAlgorithm().getId());
            }
        }
        catch (IOException e) {
            LOG.warn("Unable to analyze EncryptionAlgParams", (Throwable)e);
        }
        return null;
    }

    public MaskGenerationFunction getMaskGenerationFunction() {
        try {
            byte[] encryptionAlgParams;
            SignatureAlgorithm signatureAlgorithm = this.getEncryptedDigestAlgo();
            if (signatureAlgorithm != null && SignatureAlgorithm.RSA_SSA_PSS_SHA1_MGF1.equals((Object)signatureAlgorithm) && Utils.isArrayNotEmpty((byte[])(encryptionAlgParams = this.signerInformation.getEncryptionAlgParams())) && !Arrays.equals(DERNull.INSTANCE.getEncoded(), encryptionAlgParams)) {
                RSASSAPSSparams param = RSASSAPSSparams.getInstance((Object)encryptionAlgParams);
                AlgorithmIdentifier maskGenAlgorithm = param.getMaskGenAlgorithm();
                if (PKCSObjectIdentifiers.id_mgf1.equals((Object)maskGenAlgorithm.getAlgorithm())) {
                    return MaskGenerationFunction.MGF1;
                }
                LOG.warn("Unsupported mask algorithm : {}", (Object)maskGenAlgorithm.getAlgorithm());
            }
        }
        catch (IOException e) {
            LOG.warn("Unable to analyze EncryptionAlgParams", (Throwable)e);
        }
        return null;
    }

    public SignatureAlgorithm getSignatureAlgorithm() {
        return SignatureAlgorithm.getAlgorithm((EncryptionAlgorithm)this.getEncryptionAlgorithm(), (DigestAlgorithm)this.getDigestAlgorithm(), (MaskGenerationFunction)this.getMaskGenerationFunction());
    }

    public void checkSignatureIntegrity() {
        if (this.signatureCryptographicVerification != null) {
            return;
        }
        this.signatureCryptographicVerification = new SignatureCryptographicVerification();
        try {
            SignerInformation signerInformationToCheck;
            CertificateValidity bestCandidate = this.getTheBestCandidate();
            if (bestCandidate == null) {
                this.signatureCryptographicVerification.setErrorMessage("There is no signing certificate within the signature.");
                return;
            }
            boolean detachedSignature = this.isDetachedSignature();
            if (detachedSignature) {
                if (Utils.isCollectionEmpty((Collection)this.detachedContents)) {
                    this.candidatesForSigningCertificate.setTheCertificateValidity(bestCandidate);
                    this.signatureCryptographicVerification.setErrorMessage("Detached file not found!");
                    return;
                }
                signerInformationToCheck = this.recreateSignerInformation();
            } else {
                signerInformationToCheck = this.signerInformation;
            }
            boolean referenceDataFound = true;
            boolean referenceDataIntact = true;
            List<ReferenceValidation> refValidations = this.getReferenceValidations();
            for (ReferenceValidation referenceValidation : refValidations) {
                referenceDataFound = referenceDataFound && referenceValidation.isFound();
                referenceDataIntact = referenceDataIntact && referenceValidation.isIntact();
            }
            this.signatureCryptographicVerification.setReferenceDataFound(referenceDataFound);
            this.signatureCryptographicVerification.setReferenceDataIntact(referenceDataIntact);
            LOG.debug("CHECK SIGNATURE VALIDITY: ");
            if (this.signingCertificateValidity != null) {
                try {
                    this.candidatesForSigningCertificate.setTheCertificateValidity(this.signingCertificateValidity);
                    JcaSimpleSignerInfoVerifierBuilder verifier = new JcaSimpleSignerInfoVerifierBuilder();
                    verifier.setProvider("BC");
                    CertificateToken certificateToken = this.signingCertificateValidity.getCertificateToken();
                    PublicKey publicKey = certificateToken.getPublicKey();
                    SignerInformationVerifier signerInformationVerifier = verifier.build(publicKey);
                    LOG.debug(" - WITH SIGNING CERTIFICATE: {}", (Object)certificateToken.getAbbreviation());
                    boolean signatureIntact = signerInformationToCheck.verify(signerInformationVerifier);
                    this.signatureCryptographicVerification.setSignatureIntact(signatureIntact);
                }
                catch (Exception e) {
                    LOG.error("Unable to validate CMS Signature : " + e.getMessage(), (Throwable)e);
                    this.signatureCryptographicVerification.setErrorMessage(e.getMessage());
                    this.signatureCryptographicVerification.setSignatureIntact(false);
                }
            }
        }
        catch (IOException | CMSException e) {
            LOG.error(e.getMessage(), e);
            this.signatureCryptographicVerification.setErrorMessage(e.getMessage());
        }
        LOG.debug(" - RESULT: {}", (Object)this.signatureCryptographicVerification);
    }

    public List<ReferenceValidation> getReferenceValidations() {
        if (this.referenceValidations == null) {
            this.referenceValidations = new ArrayList();
            ReferenceValidation validation = new ReferenceValidation();
            validation.setType(DigestMatcherType.MESSAGE_DIGEST);
            DSSDocument originalDocument = null;
            try {
                originalDocument = this.getOriginalDocument();
            }
            catch (DSSException e) {
                validation.setFound(false);
            }
            Set<DigestAlgorithm> messageDigestAlgorithms = this.getMessageDigestAlgorithms();
            byte[] expectedMessageDigestValue = this.getMessageDigestValue();
            if (Utils.isCollectionNotEmpty(messageDigestAlgorithms) && Utils.isArrayNotEmpty((byte[])expectedMessageDigestValue) && originalDocument != null) {
                validation.setFound(true);
                Digest messageDigest = new Digest();
                messageDigest.setValue(expectedMessageDigestValue);
                for (DigestAlgorithm digestAlgorithm : messageDigestAlgorithms) {
                    String digest = originalDocument.getDigest(digestAlgorithm);
                    if (!Arrays.equals(expectedMessageDigestValue, Utils.fromBase64((String)digest))) continue;
                    messageDigest.setAlgorithm(digestAlgorithm);
                    validation.setIntact(true);
                    break;
                }
                validation.setDigest(messageDigest);
            }
            this.referenceValidations.add(validation);
        }
        return this.referenceValidations;
    }

    private SignerInformation recreateSignerInformation() throws CMSException, IOException {
        DSSDocument dssDocument = (DSSDocument)this.detachedContents.get(0);
        CMSSignedDataParser cmsSignedDataParser = null;
        if (dssDocument instanceof DigestDocument) {
            cmsSignedDataParser = new CMSSignedDataParser((DigestCalculatorProvider)new PrecomputedDigestCalculatorProvider((DigestDocument)dssDocument), this.cmsSignedData.getEncoded());
        } else {
            try (InputStream inputStream = dssDocument.openStream();){
                CMSTypedStream signedContent = new CMSTypedStream(inputStream);
                cmsSignedDataParser = new CMSSignedDataParser((DigestCalculatorProvider)new BcDigestCalculatorProvider(), signedContent, this.cmsSignedData.getEncoded());
                cmsSignedDataParser.getSignedContent().drain();
            }
        }
        SignerId signerId = this.signerInformation.getSID();
        SignerInformation signerInformationToCheck = cmsSignedDataParser.getSignerInfos().get(signerId);
        return signerInformationToCheck;
    }

    private boolean isDetachedSignature() {
        return this.cmsSignedData.isDetachedSignature();
    }

    private CertificateValidity getTheBestCandidate() {
        if (this.providedSigningCertificateToken == null) {
            this.candidatesForSigningCertificate = this.getCandidatesForSigningCertificate();
        } else {
            this.candidatesForSigningCertificate = new CandidatesForSigningCertificate();
            CertificateValidity certificateValidity = new CertificateValidity(this.providedSigningCertificateToken);
            this.candidatesForSigningCertificate.add(certificateValidity);
        }
        return this.candidatesForSigningCertificate.getTheBestCandidate();
    }

    public void checkSigningCertificate() {
    }

    public Set<DigestAlgorithm> getMessageDigestAlgorithms() {
        HashSet<DigestAlgorithm> result = new HashSet<DigestAlgorithm>();
        Set digestAlgorithmIDs = this.cmsSignedData.getDigestAlgorithmIDs();
        for (AlgorithmIdentifier algorithmIdentifier : digestAlgorithmIDs) {
            String oid = algorithmIdentifier.getAlgorithm().getId();
            try {
                result.add(DigestAlgorithm.forOID((String)oid));
            }
            catch (DSSException e) {
                LOG.warn("Not a digest algorithm {} : {}", (Object)oid, (Object)e.getMessage());
            }
        }
        return result;
    }

    public byte[] getMessageDigestValue() {
        Attribute messageDigestAttribute = this.getSignedAttribute(PKCSObjectIdentifiers.pkcs_9_at_messageDigest);
        if (messageDigestAttribute == null) {
            return null;
        }
        ASN1OctetString asn1OctetString = (ASN1OctetString)messageDigestAttribute.getAttrValues().getObjectAt(0);
        return asn1OctetString.getOctets();
    }

    public String getContentType() {
        Attribute contentTypeAttribute = this.getSignedAttribute(PKCSObjectIdentifiers.pkcs_9_at_contentType);
        if (contentTypeAttribute == null) {
            return null;
        }
        ASN1ObjectIdentifier asn1Encodable = (ASN1ObjectIdentifier)contentTypeAttribute.getAttrValues().getObjectAt(0);
        String contentType = asn1Encodable.getId();
        return contentType;
    }

    public String getContentIdentifier() {
        Attribute contentIdentifierAttribute = this.getSignedAttribute(PKCSObjectIdentifiers.id_aa_contentIdentifier);
        if (contentIdentifierAttribute == null) {
            return null;
        }
        ASN1Encodable asn1Encodable = contentIdentifierAttribute.getAttrValues().getObjectAt(0);
        ContentIdentifier contentIdentifier = ContentIdentifier.getInstance((Object)asn1Encodable);
        String contentIdentifierString = DSSASN1Utils.toString((ASN1OctetString)contentIdentifier.getValue());
        return contentIdentifierString;
    }

    public String getContentHints() {
        Attribute contentHintAttribute = this.getSignedAttribute(PKCSObjectIdentifiers.id_aa_contentHint);
        if (contentHintAttribute == null) {
            return null;
        }
        ASN1Encodable asn1Encodable = contentHintAttribute.getAttrValues().getObjectAt(0);
        ContentHints contentHints = ContentHints.getInstance((Object)asn1Encodable);
        String contentHint = null;
        if (contentHints != null) {
            contentHint = contentHints.getContentType().toString();
            if (contentHints.getContentDescription() != null) {
                contentHint = contentHint + " [" + contentHints.getContentDescription().toString() + "]";
            }
        }
        return contentHint;
    }

    public SignerInformation getSignerInformation() {
        return this.signerInformation;
    }

    public List<AdvancedSignature> getCounterSignatures() {
        ArrayList<AdvancedSignature> countersignatures = new ArrayList<AdvancedSignature>();
        for (Object signer : this.signerInformation.getCounterSignatures().getSigners()) {
            SignerInformation signerInformation = (SignerInformation)signer;
            CAdESSignature countersignature = new CAdESSignature(this.cmsSignedData, signerInformation, this.certPool);
            countersignature.setMasterSignature((AdvancedSignature)this);
            countersignatures.add((AdvancedSignature)countersignature);
        }
        return countersignatures;
    }

    public List<CertificateRef> getCertificateRefs() {
        ArrayList<CertificateRef> list = new ArrayList<CertificateRef>();
        Attribute attribute = this.getUnsignedAttribute(PKCSObjectIdentifiers.id_aa_ets_certificateRefs);
        if (attribute == null) {
            return list;
        }
        ASN1Set attrValues = attribute.getAttrValues();
        if (attrValues.size() <= 0) {
            return list;
        }
        ASN1Encodable attrValue = attrValues.getObjectAt(0);
        ASN1Sequence completeCertificateRefs = (ASN1Sequence)attrValue;
        for (int i = 0; i < completeCertificateRefs.size(); ++i) {
            OtherCertID otherCertId = OtherCertID.getInstance((Object)completeCertificateRefs.getObjectAt(i));
            CertificateRef certId = new CertificateRef();
            certId.setDigestAlgorithm(DigestAlgorithm.forOID((String)otherCertId.getAlgorithmHash().getAlgorithm().getId()));
            certId.setDigestValue(otherCertId.getCertHash());
            IssuerSerial issuer = otherCertId.getIssuerSerial();
            if (issuer != null) {
                ASN1Integer issuerSerial;
                GeneralNames issuerName = issuer.getIssuer();
                if (issuerName != null) {
                    certId.setIssuerName(issuerName.toString());
                }
                if ((issuerSerial = issuer.getSerial()) != null) {
                    certId.setIssuerSerial(issuerSerial.toString());
                }
            }
            list.add(certId);
        }
        return list;
    }

    public List<CRLRef> getCRLRefs() {
        ArrayList<CRLRef> list = new ArrayList<CRLRef>();
        try {
            Attribute attribute = this.getUnsignedAttribute(PKCSObjectIdentifiers.id_aa_ets_revocationRefs);
            if (attribute == null) {
                return list;
            }
            ASN1Set attrValues = attribute.getAttrValues();
            if (attrValues.size() <= 0) {
                return list;
            }
            ASN1Encodable attrValue = attrValues.getObjectAt(0);
            ASN1Sequence completeCertificateRefs = (ASN1Sequence)attrValue;
            for (int ii = 0; ii < completeCertificateRefs.size(); ++ii) {
                ASN1Encodable completeCertificateRef = completeCertificateRefs.getObjectAt(ii);
                CrlOcspRef otherCertId = CrlOcspRef.getInstance((Object)completeCertificateRef);
                CrlListID otherCertIds = otherCertId.getCrlids();
                if (otherCertIds == null) continue;
                for (CrlValidatedID id : otherCertIds.getCrls()) {
                    CRLRef crlRef = new CRLRef(id);
                    list.add(crlRef);
                }
            }
        }
        catch (Exception e) {
            LOG.warn("When error in computing or in format the algorithm just continue...", (Throwable)e);
        }
        return list;
    }

    public List<OCSPRef> getOCSPRefs() {
        ArrayList<OCSPRef> list = new ArrayList<OCSPRef>();
        Attribute attribute = this.getUnsignedAttribute(PKCSObjectIdentifiers.id_aa_ets_revocationRefs);
        if (attribute == null) {
            return list;
        }
        ASN1Set attrValues = attribute.getAttrValues();
        if (attrValues.size() <= 0) {
            return list;
        }
        ASN1Encodable attrValue = attrValues.getObjectAt(0);
        ASN1Sequence completeRevocationRefs = (ASN1Sequence)attrValue;
        for (int i = 0; i < completeRevocationRefs.size(); ++i) {
            CrlOcspRef otherCertId = CrlOcspRef.getInstance((Object)completeRevocationRefs.getObjectAt(i));
            OcspListID ocspListID = otherCertId.getOcspids();
            if (ocspListID == null) continue;
            for (OcspResponsesID ocspResponsesID : ocspListID.getOcspResponses()) {
                OtherHash otherHash = ocspResponsesID.getOcspRepHash();
                OCSPRef ocspRef = new OCSPRef(otherHash, true);
                list.add(ocspRef);
            }
        }
        return list;
    }

    public byte[] getSignatureTimestampData(TimestampToken timestampToken, String canonicalizationMethod) {
        return this.signerInformation.getSignature();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getTimestampX1Data(TimestampToken timestampToken, String canonicalizationMethod) {
        try (ByteArrayOutputStream data = new ByteArrayOutputStream();){
            data.write(this.signerInformation.getSignature());
            Attribute attribute = this.getUnsignedAttribute(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken);
            if (attribute != null) {
                data.write(DSSASN1Utils.getDEREncoded((ASN1Encodable)attribute.getAttrType()));
                data.write(DSSASN1Utils.getDEREncoded((ASN1Encodable)attribute.getAttrValues()));
            }
            data.write(this.getTimestampX2Data(timestampToken, null));
            byte[] byArray = data.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new DSSException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getTimestampX2Data(TimestampToken timestampToken, String canonicalizationMethod) {
        try (ByteArrayOutputStream data = new ByteArrayOutputStream();){
            Attribute certAttribute = this.getUnsignedAttribute(PKCSObjectIdentifiers.id_aa_ets_certificateRefs);
            Attribute revAttribute = this.getUnsignedAttribute(PKCSObjectIdentifiers.id_aa_ets_revocationRefs);
            if (certAttribute != null) {
                data.write(DSSASN1Utils.getDEREncoded((ASN1Encodable)certAttribute.getAttrType()));
                data.write(DSSASN1Utils.getDEREncoded((ASN1Encodable)certAttribute.getAttrValues()));
            }
            if (revAttribute != null) {
                data.write(DSSASN1Utils.getDEREncoded((ASN1Encodable)revAttribute.getAttrType()));
                data.write(DSSASN1Utils.getDEREncoded((ASN1Encodable)revAttribute.getAttrValues()));
            }
            byte[] byArray = data.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new DSSException((Throwable)e);
        }
    }

    public byte[] getArchiveTimestampData(TimestampToken timestampToken, String canonicalizationMethod) throws DSSException {
        byte[] archiveTimestampData;
        ArchiveTimestampType archiveTimestampType = timestampToken.getArchiveTimestampType();
        switch (archiveTimestampType) {
            case CAdES_V2: {
                archiveTimestampData = this.getArchiveTimestampDataV2(timestampToken);
                if (timestampToken.matchData(archiveTimestampData, true)) break;
                archiveTimestampData = this.getArchiveTimestampDataV2(timestampToken, false);
                break;
            }
            case CAdES_v3: {
                archiveTimestampData = this.getArchiveTimestampDataV3(timestampToken);
                break;
            }
            default: {
                throw new DSSException("Unsupported ArchiveTimestampType " + archiveTimestampType);
            }
        }
        return archiveTimestampData;
    }

    private byte[] getArchiveTimestampDataV3(TimestampToken timestampToken) throws DSSException {
        CadesLevelBaselineLTATimestampExtractor timestampExtractor = new CadesLevelBaselineLTATimestampExtractor(this);
        Attribute atsHashIndexAttribute = timestampExtractor.getVerifiedAtsHashIndex(this.signerInformation, timestampToken);
        DigestAlgorithm signedDataDigestAlgorithm = timestampToken.getSignedDataDigestAlgo();
        byte[] originalDocumentDigest = DSSUtils.digest((DigestAlgorithm)signedDataDigestAlgorithm, (DSSDocument)this.getOriginalDocument());
        byte[] archiveTimestampData = timestampExtractor.getArchiveTimestampDataV3(this.signerInformation, atsHashIndexAttribute, originalDocumentDigest);
        return archiveTimestampData;
    }

    public DSSDocument getOriginalDocument() throws DSSException {
        CMSTypedData signedContent = this.cmsSignedData.getSignedContent();
        if (signedContent != null) {
            return new InMemoryDocument(CMSUtils.getSignedContent(signedContent));
        }
        if (Utils.collectionSize((Collection)this.detachedContents) == 1) {
            return (DSSDocument)this.detachedContents.get(0);
        }
        throw new DSSException("Only enveloping and detached signatures are supported");
    }

    private byte[] getArchiveTimestampDataV2(TimestampToken timestampToken) throws DSSException {
        return this.getArchiveTimestampDataV2(timestampToken, true);
    }

    /*
     * Exception decompiling
     */
    private byte[] getArchiveTimestampDataV2(TimestampToken timestampToken, boolean includeUnsignedAttrsTagAndLength) throws DSSException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ASN1Sequence getSignerInfoEncoded(SignerInfo signerInfo, ASN1Sequence unauthenticatedAttributes, boolean includeUnsignedAttrsTagAndLength) {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)signerInfo.getVersion());
        v.add((ASN1Encodable)signerInfo.getSID());
        v.add((ASN1Encodable)signerInfo.getDigestAlgorithm());
        DERTaggedObject signedAttributes = CMSUtils.getDERSignedAttributes(this.signerInformation);
        if (signedAttributes != null) {
            v.add((ASN1Encodable)signedAttributes);
        }
        v.add((ASN1Encodable)signerInfo.getDigestEncryptionAlgorithm());
        v.add((ASN1Encodable)signerInfo.getEncryptedDigest());
        if (unauthenticatedAttributes != null) {
            if (includeUnsignedAttrsTagAndLength) {
                v.add((ASN1Encodable)new DERTaggedObject(false, 1, (ASN1Encodable)unauthenticatedAttributes));
            } else {
                for (int i = 0; i < unauthenticatedAttributes.size(); ++i) {
                    v.add(unauthenticatedAttributes.getObjectAt(i));
                }
            }
        }
        return new DERSequence(v);
    }

    private ASN1Sequence filterUnauthenticatedAttributes(ASN1Set unauthenticatedAttributes, TimestampToken timestampToken) {
        ASN1EncodableVector result = new ASN1EncodableVector();
        for (int ii = 0; ii < unauthenticatedAttributes.size(); ++ii) {
            Attribute attribute = Attribute.getInstance((Object)unauthenticatedAttributes.getObjectAt(ii));
            ASN1ObjectIdentifier attrType = attribute.getAttrType();
            if (OID.id_aa_ets_archiveTimestampV2.equals((Object)attrType) || OID.id_aa_ets_archiveTimestampV3.equals((Object)attrType)) {
                try {
                    TimeStampToken token = new TimeStampToken(new CMSSignedData(DSSASN1Utils.getDEREncoded((ASN1Encodable)attribute.getAttrValues().getObjectAt(0).toASN1Primitive())));
                    if (!token.getTimeStampInfo().getGenTime().before(timestampToken.getGenerationTime())) {
                        continue;
                    }
                }
                catch (Exception e) {
                    throw new DSSException((Throwable)e);
                }
            }
            result.add(unauthenticatedAttributes.getObjectAt(ii));
        }
        return new DERSequence(result);
    }

    public String getId() {
        if (this.signatureId == null) {
            CertificateToken certificateToken = this.getSigningCertificateToken();
            TokenIdentifier identifier = certificateToken == null ? null : certificateToken.getDSSId();
            Date signingTime = this.getSigningTime();
            this.signatureId = DSSUtils.getDeterministicId((Date)signingTime, (TokenIdentifier)identifier);
        }
        return this.signatureId;
    }

    public List<TimestampReference> getTimestampedReferences() {
        ArrayList<TimestampReference> references = new ArrayList<TimestampReference>();
        List<CertificateRef> certRefs = this.getCertificateRefs();
        for (CertificateRef certificateRef : certRefs) {
            String digestValue = Utils.toBase64((byte[])certificateRef.getDigestValue());
            DigestAlgorithm digestAlgorithm = certificateRef.getDigestAlgorithm();
            this.usedCertificatesDigestAlgorithms.add(digestAlgorithm);
            TimestampReference reference = new TimestampReference(digestAlgorithm, digestValue);
            references.add(reference);
        }
        this.addReferencesFromOfflineCRLSource(references);
        this.addReferencesFromOfflineOCSPSource(references);
        return references;
    }

    private Attribute getSignedAttribute(ASN1ObjectIdentifier oid) {
        AttributeTable signedAttributes = this.signerInformation.getSignedAttributes();
        if (signedAttributes == null) {
            return null;
        }
        return signedAttributes.get(oid);
    }

    private Attribute getUnsignedAttribute(ASN1ObjectIdentifier oid) {
        AttributeTable unsignedAttributes = this.signerInformation.getUnsignedAttributes();
        if (unsignedAttributes == null) {
            return null;
        }
        return unsignedAttributes.get(oid);
    }

    public boolean isDataForSignatureLevelPresent(SignatureLevel signatureLevel) {
        AttributeTable unsignedAttributes = CMSUtils.getUnsignedAttributes(this.signerInformation);
        AttributeTable signedAttributes = CMSUtils.getSignedAttributes(this.signerInformation);
        boolean dataForProfilePresent = true;
        switch (signatureLevel) {
            case CAdES_BASELINE_LTA: {
                dataForProfilePresent = this.hasLTAProfile();
                dataForProfilePresent = dataForProfilePresent && this.isDataForSignatureLevelPresent(SignatureLevel.CAdES_BASELINE_LT);
                break;
            }
            case CAdES_101733_A: {
                dataForProfilePresent = unsignedAttributes.get(OID.id_aa_ets_archiveTimestampV2) != null;
                dataForProfilePresent = dataForProfilePresent && this.isDataForSignatureLevelPresent(SignatureLevel.CAdES_BASELINE_LT);
                dataForProfilePresent = dataForProfilePresent && this.isDataForSignatureLevelPresent(SignatureLevel.CAdES_101733_X);
                break;
            }
            case CAdES_BASELINE_LT: {
                dataForProfilePresent = this.hasLTProfile();
                dataForProfilePresent = dataForProfilePresent && this.isDataForSignatureLevelPresent(SignatureLevel.CAdES_BASELINE_T);
                break;
            }
            case CAdES_101733_X: {
                dataForProfilePresent = unsignedAttributes.get(PKCSObjectIdentifiers.id_aa_ets_certCRLTimestamp) != null || unsignedAttributes.get(PKCSObjectIdentifiers.id_aa_ets_escTimeStamp) != null;
                dataForProfilePresent = dataForProfilePresent && this.isDataForSignatureLevelPresent(SignatureLevel.CAdES_101733_C);
                break;
            }
            case CAdES_101733_C: {
                dataForProfilePresent = unsignedAttributes.get(PKCSObjectIdentifiers.id_aa_ets_certificateRefs) != null;
                dataForProfilePresent = dataForProfilePresent && this.isDataForSignatureLevelPresent(SignatureLevel.CAdES_BASELINE_T);
                break;
            }
            case CAdES_BASELINE_T: {
                dataForProfilePresent = this.hasTProfile();
                dataForProfilePresent = dataForProfilePresent && this.isDataForSignatureLevelPresent(SignatureLevel.CAdES_BASELINE_B);
                break;
            }
            case CAdES_BASELINE_B: {
                dataForProfilePresent = signedAttributes.get(PKCSObjectIdentifiers.id_aa_signingCertificate) != null || signedAttributes.get(PKCSObjectIdentifiers.id_aa_signingCertificateV2) != null;
                break;
            }
            case CMS_NOT_ETSI: {
                dataForProfilePresent = true;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown level " + signatureLevel);
            }
        }
        return dataForProfilePresent;
    }

    public SignatureLevel[] getSignatureLevels() {
        return new SignatureLevel[]{SignatureLevel.CMS_NOT_ETSI, SignatureLevel.CAdES_BASELINE_B, SignatureLevel.CAdES_BASELINE_T, SignatureLevel.CAdES_101733_C, SignatureLevel.CAdES_101733_X, SignatureLevel.CAdES_BASELINE_LT, SignatureLevel.CAdES_101733_A, SignatureLevel.CAdES_BASELINE_LTA};
    }
}

