/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.validation;

import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.x509.crl.OfflineCRLSource;
import java.io.IOException;
import java.util.Collection;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.esf.RevocationValues;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.CertificateList;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.util.Store;

public class CAdESCRLSource
extends OfflineCRLSource {
    private final CMSSignedData cmsSignedData;
    private final SignerInformation signerInformation;

    public CAdESCRLSource(CMSSignedData cmsSignedData, SignerInformation signerInformation) {
        this.cmsSignedData = cmsSignedData;
        this.signerInformation = signerInformation;
        this.extract();
    }

    private void extract() {
        Attribute attribute;
        AttributeTable attributes;
        Store crLs = this.cmsSignedData.getCRLs();
        Collection collection = crLs.getMatches(null);
        for (X509CRLHolder x509CRLHolder : collection) {
            this.addX509CRLHolder(x509CRLHolder);
        }
        if (this.signerInformation != null && (attributes = this.signerInformation.getUnsignedAttributes()) != null && (attribute = attributes.get(PKCSObjectIdentifiers.id_aa_ets_revocationValues)) != null) {
            ASN1Set attrValues = attribute.getAttrValues();
            ASN1Encodable attValue = attrValues.getObjectAt(0);
            RevocationValues revValues = RevocationValues.getInstance((Object)attValue);
            for (CertificateList revValue : revValues.getCrlVals()) {
                this.addX509CRLHolder(new X509CRLHolder(revValue));
            }
        }
    }

    private void addX509CRLHolder(X509CRLHolder crlHolder) {
        try {
            this.addCRLBinary(crlHolder.getEncoded());
        }
        catch (IOException e) {
            throw new DSSException((Throwable)e);
        }
    }
}

